<?php
use LavenderFakebill\Models\Object\Render\Watermark;

if (isset($_POST['action']) && $_POST['action'] === 'sodu-mbbank1') {
    $thoigiantrendt = $_POST["thoigiantrendt"];
    $sodu = FormatNumber::PREG($_POST["sodu"]);
    $ctk = $_POST["ctk"];
    $stk = $_POST["stk"];
    $phoiBank = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/bill/so-du/mbbank1.png';
    $fontPath = $_SERVER['DOCUMENT_ROOT'].'/'.__FONTS__.'/';

    $image = imagecreatefrompng($phoiBank);
    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/bill-settings/dark.php';

    if (isset($_POST["xem-truoc"]) && $_POST["xem-truoc"] === 'yes') {
        $image = Watermark::Render($image, 1, 30, 100);
    }

    CaiDatPhuTro($image, $vachsong, $iconTinHieu, $iconPins, $_POST["tin-hieu"], $iconDynamicsIsland);

    if (!function_exists('CanSoDu')) {
        function CanSoDu($image, $text, $font, $size, $color, $vnd_font, $vnd_size, $vnd_color, $y, $x, $name) {
            if (!file_exists($font)) return;
            $image_width = imagesx($image);
            $text_bbox = imagettfbbox($size, 0, $font, $text);
            $text_width = $text_bbox[2] - $text_bbox[0];
            $text_left_margin = $x;
            if ($text_width + $x + 10 > $image_width) {
                $text_left_margin = $image_width - $text_width - 10;
            }
            imagettftext($image, $size, 0, $text_left_margin, $y, $color, $font, $text);
            if ($vnd_font && file_exists($vnd_font)) {
                $vnd_left_margin = $text_left_margin + $text_width + 5;
                imagettftext($image, $vnd_size, 0, $vnd_left_margin, $y, $vnd_color, $vnd_font, $name);
            }
        }
    }
    if (!function_exists('CanStk')) {
        function CanStk($image, $text, $font, $size, $color, $vnd_font, $vnd_size, $vnd_color, $y, $x, $name) {
            if (!file_exists($font)) return;
            $image_width = imagesx($image);
            $text_bbox = imagettfbbox($size, 0, $font, $text);
            $text_width = $text_bbox[2] - $text_bbox[0];
            $text_left_margin = $x;
            if ($text_width + $x + 10 > $image_width) {
                $text_left_margin = $image_width - $text_width - 10;
            }
            imagettftext($image, $size, 0, $text_left_margin, $y, $color, $font, $text);
            if ($vnd_font && file_exists($vnd_font)) {
                $vnd_left_margin = $text_left_margin + $text_width + 5;
                imagettftext($image, $vnd_size, 0, $vnd_left_margin, $y, $vnd_color, $vnd_font, $name);
            }
        }
    }

    if (!function_exists('CanLeTraitg')) {
        function CanLeTraitg(GdImage $image, string $text, string $fontPath, int $fontSize, int $color, int $y) {
            if (!file_exists($fontPath)) return;
            $x = 150; 
            imagettftext($image, $fontSize, 0, $x, $y, $color, $fontPath, $text);
        }
    }

    if (!function_exists('CanLeTrai')) {
        function CanLeTrai(GdImage $image, string $text, string $fontPath, int $fontSize, int $color, int $y) {
            if (!file_exists($fontPath)) return;
            $x = 118;
            imagettftext($image, $fontSize, 0, $x, $y, $color, $fontPath, $text);
        }
    }

    if (!function_exists('canchinhphai2')) {
        function canchinhphai2($image, $fontsize, $y, $textColor, $font, $text, $customX = 98) {
            if (!file_exists($font)) return;
            $textBoundingBox = imagettfbbox($fontsize, 0, $font, $text);
            $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
            $imageWidth = imagesx($image);
            $x = $imageWidth - $textWidth - $customX;
            imagettftext($image, $fontsize, 0, $x, $y, $textColor, $font, $text);
        }
    }

    $dest_img = imagecreatetruecolor(imagesx($image), imagesy($image));
    imagecopy($dest_img, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));

    $fontSodu = $fontPath . 'common/AvertaStd/AvertaStd-Regular.otf';
    $fontStk = $fontPath . 'common/San Francisco/SanFranciscoText-Regular.otf';
    $fontVND  = $fontPath . 'common/San Francisco/SanFranciscoText-Regular.otf';
    $fontTime = $fontPath . 'common/San Francisco/SanFranciscoText-Semibold.otf';
    $fontCTK  = $fontPath . 'common/San Francisco/SanFranciscoText-Regular.otf';

    CanSoDu(
        $dest_img,
        FormatNumber::TD($sodu, 2),
        $fontSodu, 75, imagecolorallocate($dest_img, 1, 1, 1),
        $fontVND, 37, imagecolorallocate($dest_img, 1, 1, 1),
        940, 75, '   VND'
    );

    CanStk(
        $dest_img,
        str_replace('.', '', $stk),
        $fontStk, 45, imagecolorallocate($dest_img, 1, 1, 1),
        '', 0, 0,
        630, 120, ''
    );

    CanLeTraitg(
        $dest_img,
        $thoigiantrendt,
        $fontTime,
        44,
        imagecolorallocate($dest_img, 0, 0, 0),
        113
    );

    CanLeTrai(
        $dest_img,
        $ctk,
        $fontCTK,
        35,
        imagecolorallocate($dest_img, 20,30,210),
        550
    );

    $currentDate   = date('d/m/Y');
    $previousDate  = date('d/m/Y', strtotime('+5 day'));
    $fontDate      = $fontPath . 'common/AvertaStd/AvertaStd-Regular.otf';

    if (file_exists($fontDate)) {
        imagettftext($dest_img, 40, 0, 120, 2510, imagecolorallocate($dest_img, 15,15,15), $fontDate, $currentDate);
        imagettftext($dest_img, 40, 0, 710, 2510, imagecolorallocate($dest_img, 15,15,15), $fontDate, $previousDate);
    }
    ob_start();
    imagepng($dest_img);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($dest_img);

    $namebill = ['MB Bank Loại 1', 'Số Dư'];
    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/checkRenderModel.php';
}
