<?php
use LavenderFakebill\Models\Object\Render\Watermark;

if (isset($_POST['action']) && $_POST['action'] === 'sodu-cake') {
    $tendem = $_POST["tendem"];
    $thoigiantrendt = $_POST["thoigiantrendt"];
    $sodu = FormatNumber::PREG($_POST["sodu"]);
    $gd = FormatNumber::PREG($_POST["gd"]);

    $convertGD = [
        1 => ['themeName' => 'cake-light', 'themeDisplay' => 'dark', 'colorMoney' => [12, 28, 46], 'colorContent' => [12, 28, 46]],
        2 => ['themeName' => 'cake-dark', 'themeDisplay' => 'dark', 'colorMoney' => [255, 255, 255], 'colorContent' => [255, 255, 255]]
    ];

    $gdData = $convertGD[$gd] ?? [
        'themeName' => 'cake-light',
        'themeDisplay' => 'dark',
        'colorMoney' => [37, 231, 255],
        'colorContent' => [255, 255, 255]
    ];

    $themeName = $gdData['themeName'];
    $themeDisplay = $gdData['themeDisplay'];
    [$rMoney, $gMoney, $bMoney] = $gdData['colorMoney'];

    $phoiBank = $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/phoi/bill/so-du/' . $themeName . '.jpeg';
    $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/' . __FONTS__ . '/';

    if (!file_exists($phoiBank)) {
        die("Tệp hình ảnh không tồn tại: $phoiBank");
    }

    $image = imagecreatefromjpeg($phoiBank);
    if (!$image) {
        die("Không thể tạo hình ảnh từ tệp: $phoiBank");
    }

    require $_SERVER['DOCUMENT_ROOT'] . '/server/models/object/global/bill-settings/dark.php';

    if (isset($_POST["xem-truoc"]) && $_POST["xem-truoc"] === 'yes') {
        $image = Watermark::Render($image);
    }

    CaiDatPhuTro($image, $vachsong, $iconTinHieu, $iconPins, $_POST["tin-hieu"], $iconDynamicsIsland);

    $dest_img = imagecreatetruecolor(imagesx($image), imagesy($image));
    imagecopy($dest_img, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));

    $fontTenDem = $fontPath . 'common/Noto Sans/NotoSans-Regular.ttf';
    $fontSoDu = $fontPath . 'common/Roboto/Roboto-Regular.ttf';
    $fontVND = $fontPath . 'common/Noto Sans/NotoSans-Regular.ttf';
    $fontTime = $fontPath . 'common/San Francisco/SanFranciscoText-Semibold.otf';

    if (!file_exists($fontTenDem) || !file_exists($fontSoDu) || !file_exists($fontVND) || !file_exists($fontTime)) {
        die("\u26d4\ufe0f Kiểm tra lại đường dẫn font.\n");
    }

    $textBox = imagettfbbox(32, 0, $fontTenDem, $tendem);
    $textWidth = $textBox[2] - $textBox[0];
    $circle_x = 80;
    $circle_y = 142;
    $textX = (int) ($circle_x - ($textWidth / 2));
    $textY = (int) ($circle_y + 14);

    imagettftext($dest_img, 25, 0, $textX, $textY, imagecolorallocate($dest_img, 56, 71, 96), $fontTenDem, $tendem);

    CanSoDuSafe($dest_img, FormatNumber::TD($sodu), $fontSoDu, 28, [$rMoney, $gMoney, $bMoney], $fontVND, 27, [6, 25, 56], 1065, 60, ' đ');

    CanThoiGian($dest_img, $thoigiantrendt, $fontTime, 26, imagecolorallocate($dest_img, 0, 1, 2), 60);

    ob_start();
    imagepng($dest_img);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($dest_img);

    $namebill = ['Cake', 'Số Dư'];
    require $_SERVER['DOCUMENT_ROOT'] . '/server/models/object/global/checkRenderModel.php';
}

function CanSoDuSafe($image, $text, $fontPath, $fontSize, array $colorRGB, $vndFontPath = null, $vndFontSize = 0, array $vndColorRGB = [0, 0, 0], $y = 0, $x = 0, $vndText = '')
{
    if (!file_exists($fontPath)) return;

    $color = imagecolorallocate($image, ...$colorRGB);
    $imageWidth = imagesx($image);
    $textBox = imagettfbbox($fontSize, 0, $fontPath, $text);
    $textWidth = $textBox[2] - $textBox[0];
    if ($x + $textWidth > $imageWidth) $x = $imageWidth - $textWidth - 10;

    imagettftext($image, $fontSize, 0, $x, $y, $color, $fontPath, $text);

    if ($vndText && $vndFontPath && file_exists($vndFontPath)) {
        $vndColor = imagecolorallocate($image, ...$vndColorRGB);
        $vndX = $x + $textWidth + 5;
        imagettftext($image, $vndFontSize, 0, $vndX, $y, $vndColor, $vndFontPath, $vndText);
    }
}

function CanThoiGian($image, $text, $font, $size, $color, $y)
{
    $fixed_left_position = 60;
    $image_width = imagesx($image);
    $text_bbox = imagettfbbox($size, 0, $font, $text);
    $text_width = $text_bbox[2] - $text_bbox[0];
    $text_left_margin = ($text_width + $fixed_left_position > $image_width) ? ($image_width - $text_width) : $fixed_left_position;
    imagettftext($image, $size, 0, $text_left_margin, $y, $color, $font, $text);
}
