<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once $_SERVER['DOCUMENT_ROOT'] . '/config/database.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/config/obj.php';

if (isset($_POST['action']) && $_POST['action'] === 'fake-truyna') {
    global $SSC;
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ này!"]));
    }

    $tenCongTyVietBangTiengViet = $_POST['tenCongTyVietBangTiengViet'] ?? '';
    $hoVaTenDaiDien = $_POST['hoVaTenDaiDien'] ?? '';
    $gioiTinhDaiDien = $_POST['gioiTinhDaiDien'] ?? '';
    $sinhNgayDaiDien = $_POST['sinhNgayDaiDien'] ?? '';
    $danTocDaiDien = $_POST['danTocDaiDien'] ?? '';
    $quocTichDaiDien = $_POST['quocTichDaiDien'] ?? '';
    $noiDangKyHoKhauThuongTru = $_POST['noiDangKyHoKhauThuongTru'] ?? '';
    $choOHienTai = $_POST['choOHienTai'] ?? '';
    $email = $_POST['email'] ?? '';
    $vonDieuLeBangChu = $_POST['vonDieuLeBangChu'] ?? '';
    $truongPhong = $_POST['truongPhong'] ?? '';

    if (empty($quocTichDaiDien) || empty($tenCongTyVietBangTiengViet) || empty($noiDangKyHoKhauThuongTru) || empty($choOHienTai)) {
        echo json_encode(["status" => -1, "msg" => "Vui lòng điền đầy đủ các thông tin bắt buộc!"]);
        exit;
    }

    $phoi_path = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/img/phoi/giay-to/truyna/phoi.png';

    if (!file_exists($phoi_path)) {
        echo json_encode(["status" => -1, "msg" => "Lỗi: File phôi ảnh Giấy phép kinh doanh không tồn tại tại: " . $phoi_path]);
        exit;
    }

    $image = imagecreatefrompng($phoi_path);
    if (!$image) {
        echo json_encode(["status" => -1, "msg" => "Lỗi GD: Không thể tạo ảnh từ phôi PNG. Đảm bảo GD extension được bật và file PNG hợp lệ."]);
        exit;
    }

    $black = imagecolorallocate($image, 94, 85, 86);

    $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/fonts/Timenew/';
    $fontPathPhuc = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/fonts/Roboto/';

    $fontTimesNewRomanRegularPhuc = $fontPathPhuc . 'Roboto-Regular.ttf';

    $fontTimesNewRomanRegular = $fontPath . 'times.ttf';
    $fontTimesNewRomanBold = $fontPath . 'timesbd.ttf';
    $fontTimesNewRomanItalic = $fontPath . 'timesi.ttf';
    $fontTimesNewRomanBoldItalic = $fontPath . 'timesbi.ttf';

    if (!file_exists($fontTimesNewRomanRegular)) $fontTimesNewRomanRegular = $fontPath . 'arial.ttf';
    if (!file_exists($fontTimesNewRomanBold)) $fontTimesNewRomanBold = $fontPath . 'arialbd.ttf';
    if (!file_exists($fontTimesNewRomanItalic)) $fontTimesNewRomanItalic = $fontPath . 'ariali.ttf';
    if (!file_exists($fontTimesNewRomanBoldItalic)) $fontTimesNewRomanBoldItalic = $fontPath . 'arialbi.ttf';

    if (!function_exists('drawText')) {
        function drawText(GdImage $image, string $text, string $fontPath, float $fontSize, int $color, int $x, int $y, bool $isCentered = false, float $angle = 0, ?int $maxWidth = null, int $lineHeight = 15, int $indentX = 0, int $maxLines = 0) {
            if (!file_exists($fontPath)) {
                error_log("Font file for drawText not found: " . $fontPath);
                imagestring($image, 5, $x, $y, $text, $color);
                return;
            }

            $fontSizeInt = (int) round($fontSize);
            $lines = [];
            $tempLines = [];

            if ($maxWidth !== null) {
                $words = explode(' ', $text);
                $currentLine = '';

                foreach ($words as $word) {
                    $testLine = $currentLine . ($currentLine == '' ? '' : ' ') . $word;
                    $bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $testLine);
                    $width = $bbox[2] - $bbox[0];

                    if ($width <= $maxWidth) {
                        $currentLine = $testLine;
                    } else {
                        $tempLines[] = $currentLine;
                        $currentLine = $word;
                    }
                }
                $tempLines[] = $currentLine;

                if ($maxLines > 0 && count($tempLines) > $maxLines) {
                    $lines[] = $tempLines[0];
                    $remainingTextWords = array_slice($words, count(explode(' ', $tempLines[0])));
                    $finalSecondLine = '';
                    foreach ($remainingTextWords as $word) {
                        $testSecondLine = $finalSecondLine . ($finalSecondLine == '' ? '' : ' ') . $word;
                        $bboxSecond = imagettfbbox($fontSizeInt, $angle, $fontPath, $testSecondLine);
                        $widthSecond = $bboxSecond[2] - $bboxSecond[0];
                        if ($widthSecond <= $maxWidth) {
                            $finalSecondLine = $testSecondLine;
                        } else {
                            break;
                        }
                    }
                    $lines[] = $finalSecondLine;
                } else {
                    $lines = $tempLines;
                }
            } else {
                $lines[] = $text;
            }

            $currentY = $y;
            $lineNum = 0;
            foreach ($lines as $line) {
                $currentX = $x + ($lineNum > 0 ? $indentX : 0);
                if ($isCentered) {
                    $text_bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $line);
                    $text_width = $text_bbox[2] - $text_bbox[0];
                    $currentX -= ($text_width / 2);
                }
                imagettftext($image, $fontSizeInt, $angle, $currentX, $currentY, $color, $fontPath, $line);
                $currentY += $lineHeight;
                $lineNum++;
            }
        }
    }

    if (!function_exists('formatDateForDisplay')) {
        function formatDateForDisplay(string $dateString): string {
            $dateString = preg_replace('/\D/', '', $dateString);
            if (strlen($dateString) === 8) {
                return substr($dateString, 0, 2) . '/' . substr($dateString, 2, 2) . '/' . substr($dateString, 4, 4);
            }
            return $dateString;
        }
    }

    $hoVaTenDaiDien = mb_strtoupper($hoVaTenDaiDien, 'UTF-8');
    $truongPhong = mb_strtoupper($truongPhong, 'UTF-8');

    drawText($image, $tenCongTyVietBangTiengViet, $fontTimesNewRomanRegular, 13, $black, 300, 364, false, 0, 540, 27, -324, 2);
    drawText($image, $tenCongTyVietBangTiengViet, $fontTimesNewRomanBold, 13, $black, 41, 480, false, 0, 540, 27, -324, 2);
    drawText($image, $gioiTinhDaiDien, $fontTimesNewRomanRegular, 15, $black, 300, 415);
    drawText($image, $sinhNgayDaiDien, $fontTimesNewRomanRegular, 15, $black, 740, 415);
    drawText($image, $danTocDaiDien, $fontTimesNewRomanRegular, 15, $black, 740, 585);
    drawText($image, $quocTichDaiDien, $fontTimesNewRomanRegular, 15, $black, 300, 585);
    drawText($image, $noiDangKyHoKhauThuongTru, $fontTimesNewRomanRegular, 13, $black, 300, 457, false, 0, 540, 27, -345, 2);
    drawText($image, $choOHienTai, $fontTimesNewRomanRegular, 13, $black, 300, 493, false, 0, 550, 27, -169, 2);
    drawText($image, $email, $fontTimesNewRomanRegular, 15, $black, 300, 620);
    drawText($image, $vonDieuLeBangChu, $fontTimesNewRomanRegular, 13, $black, 735, 610, false, 0, 70, 25, 0, 3);

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);

    echo json_encode([
        "status" => 200,
        "msg" => "Tạo đơn truy nã thành công!",
        "img" => $base64,
    ]);
}
?>
