<?php
header('Content-Type: application/json');
if (isset($_POST['action']) && $_POST['action'] === 'fake-hochieu-new') {
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ!"]));
    }
    $loai = $_POST["loai"];
    if ($loai === 'hochieu-new') {
        $hovaten = strtoupper(strtolower($_POST["hovaten"])) ?? null;
        $hovaten1 = strtoupper(strtolower($_POST["hovaten1"])) ?? null;
        $gioitinh = $_POST["gioitinh"] ?? null;
        $ngaysinh = $_POST["ngaysinh"] ?? null;
        $socccd = $_POST["socccd"] ?? null;
        $quequan = $_POST["quequan"] ?? null;
        $thuongtru = $_POST["thuongtru"] ?? null;
        $ngayhethan = $_POST["ngayhethan"] ?? null;
        $quoctich = $_POST["quoctich"] ?? null;
        $code1 = $_POST["code1"] ?? null;
        $code2 = $_POST["code2"] ?? null;
        $p = $_POST["p"] ?? null;
        $maso = $_POST["maso"] ?? null;

        $anhthe = $_POST['anhthe'] ?? null;

        if (empty($hovaten) || empty($gioitinh) || empty($ngaysinh) || empty($socccd) || empty($quequan) || empty($anhthe) || empty($thuongtru) || empty($ngayhethan) || empty($quoctich)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Không được bỏ trống mục nào!",
            ]));
        }

        if (!isDate($ngaysinh)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Ngày sinh không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm)",
            ]));
        } elseif (!isDate($ngayhethan)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Ngày hết hạn không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm).",
            ]));
        }

        if (!empty($anhthe)) {
            $phoicccd = $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/phoi/giay-to/hochieu-new/passport-new.jpg';
            if (preg_match('/^data:image\/(\w+);base64,/', $anhthe, $type)) {
                $data = substr($anhthe, strpos($anhthe, ',') + 1);
                $type = strtolower($type[1]);
                if (!in_array($type, ['jpg', 'jpeg', 'png'])) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Ảnh thẻ chỉ hỗ trợ các định dạng JPG/PNG/JPEG.",
                    ]));
                }
                $data = base64_decode($data);
                $size = strlen($data);
                if (!WsCheckIMG::SizeLimit($size, 4)) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Kích thước của ảnh không được vượt quá giới hạn cho phép (4MB).",
                    ]));
                }
                if ($data === false) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Lỗi giải mã dữ liệu ảnh thẻ.",
                    ]));
                }
                $phoicccd2 = imagecreatefromjpeg($phoicccd);
                $anhthe_img = imagecreatefromstring($data);
                imagecopyresampled($phoicccd2, $anhthe_img, 90, 478, 0, 0, 155, 207, imagesx($anhthe_img), imagesy($anhthe_img));
                // ngang - dọc - - kích cỡ ảnh in lên ngang - dọc
                imagedestroy($anhthe_img);
                $image = $phoicccd2;
            } else {
                die(JSON_FORMATTER([
                    "status" => -1,
                    "msg" => "Vui lòng upload file ảnh thẻ.",
                ]));
            }
        } else {
            $phoicccd = $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/phoi/giay-to/hochieu-new/passport-new.jpg';
            $image = imagecreatefromjpeg($phoicccd);
        }

        $qrcode = sprintf(
            'https://quickchart.io/qr?text=%s&light=0000&ecLevel=H&format=png&size=700',
            urlencode(
                sprintf('%s|%s|%s|%s|%s|%s|%s',
                    $socccd,
                    WsRandomString::Number(9),
                    $hovaten,
                    str_replace('/', '', $ngaysinh),
                    $gioitinh,
                    $thuongtru,
                    str_replace('/', '', $ngayhethan)
                )
            )
        );
        $qr_img = imagecreatefrompng($qrcode);

        $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/' . __FONTS__ . '/';

        function infocccd($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $x = $customX !== null ? $customX : 753;
            imagettftext($image, $fontSize, 0, $x, $y, $textColor, $font, $text);
        }

        function noithuongchu($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $lineX = 753;
            $firstLineX = $customX !== null ? $customX : 753;
            $maxWidth = 8;
            $words = explode(' ', $text);
            $firstLine = '';
            $D2 = '';
            foreach ($words as $word) {
                $testLine = trim($firstLine . ' ' . $word);
                $textBoundingBox = imagettfbbox($fontSize, 0, $font, $testLine);
                $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
                if (mb_strlen($firstLine) < $maxWidth && $textWidth <= imagesx($image) - $firstLineX) {
                    $firstLine = $testLine;
                } else {
                    $D2 .= ($D2 ? ' ' : '') . $word;
                }
            }
            $firstLineWithoutComma = str_replace(',', '', $firstLine);
            if (!empty($firstLineWithoutComma)) {
                imagettftext($image, $fontSize, 0, $firstLineX, $y, $textColor, $font, trim($firstLineWithoutComma));
            }
            if (!empty($D2)) {
                imagettftext($image, $fontSize, 0, $lineX, $y + ($fontSize + 12), $textColor, $font, trim($D2));
            }
        }

        //imagecopyresampled($image, $qr_img, 1540, 890, 0, 0, 222, 222, imagesx($qr_img), imagesy($qr_img)); // ngang
        infocccd($image, 14, 466, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $p, 308);
        infocccd($image, 14, 468, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $maso, 377);
        infocccd($image, 14, 470, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $quoctich, 500);
        infocccd($image, 15, 507, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $hovaten, 286);
        infocccd($image, 15, 547, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $hovaten1, 286);
        
        infocccd($image, 13, 583, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', 'VIỆT NAM /', 280);
        infocccd($image, 13, 583, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/timesi.ttf', 'VIETNAMESE', 376);
        
        infocccd($image, 15, 623, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $ngaysinh, 286);
        infocccd($image, 15, 623, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $gioitinh, 480);
        infocccd($image, 15, 663, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $socccd, 480);
        infocccd($image, 15, 661, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $quequan, 286);
        
        noithuongchu($image, 15, 702, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $thuongtru, 286);
        infocccd($image, 15, 704, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/times.ttf', $ngayhethan, 480);
        
        infocccd($image, 17, 750, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/code.otf', $code1, 75);
        infocccd($image, 17, 780, imagecolorallocate($image, 61, 53, 40), $fontPath . 'hochieu/code.otf', $code2, 75);
        // cỡ - dọc - ngang
        ob_start();
        imagepng($image);
        $imageData = ob_get_clean();
        $base64 = base64_encode($imageData);
        imagedestroy($image);

        if (!isset($user['rank']) || !in_array($user['rank'], ['admin', 'leader'])) {
            $requiredVIP = intval(preg_replace('/\D/', '', $TD->Setting('giataogiayto') ?? ''));
            $currentVIP = intval(preg_replace('/\D/', '', $plans->TD('tengoi', $taikhoan) ?? ''));
            if ($requiredVIP > 0 && $currentVIP < $requiredVIP) {
                $action = ($currentVIP === 0) ? "mua" : "tối thiểu";
                die(JSON_FORMATTER([
                    "status" => -1,
                    "msg" => "Vui lòng $action gói " . strtoupper($TD->Setting('giataogiayto')) . " để sử dụng tính năng fake cccd!",
                ]));
            }
        }

        die(JSON_FORMATTER([
            "status" => 200,
            "msg" => "Tạo passport thành công!",
            "img" => $base64,
            "info" => ['type' => [$loai], 'sex' => [$gioitinh ?? 'N/A']],
        ]));
    }
}
