<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once $_SERVER['DOCUMENT_ROOT'] . '/config/database.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/config/obj.php';

if (isset($_POST['action']) && $_POST['action'] === 'fake-business-license-new') {
    global $SSC;
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ này!"]));
    }

    $maSoDoanhNghiep = $_POST['maSoDoanhNghiep'] ?? '';
    $dangKyLanDauNgay = $_POST['dangKyLanDauNgay'] ?? '';
    $dangKyThayDoiLanThuSo = $_POST['dangKyThayDoiLanThuSo'] ?? '';
    $dangKyThayDoiLanThuNgay = $_POST['dangKyThayDoiLanThuNgay'] ?? '';
    $thanhPhoCap = $_POST['thanhPhoCap'] ?? '';
    $tenCongTyVietBangTiengViet = $_POST['tenCongTyVietBangTiengViet'] ?? '';
    $tenCongTyVietBangTiengNuocNgoai = $_POST['tenCongTyVietBangTiengNuocNgoai'] ?? '';
    $tenCongTyVietTat = $_POST['tenCongTyVietTat'] ?? '';
    $diaChiTruSoChinh = $_POST['diaChiTruSoChinh'] ?? '';
    $dienThoai = $_POST['dienThoai'] ?? '';
    $fax = $_POST['fax'] ?? '';
    $email = $_POST['email'] ?? '';
    $website = $_POST['website'] ?? '';
    $vonDieuLe = $_POST['vonDieuLe'] ?? '';
    $vonDieuLeBangChu = $_POST['vonDieuLeBangChu'] ?? '';
    $menhGiaCoPhan = $_POST['menhGiaCoPhan'] ?? '';
    $tongSoCoPhan = $_POST['tongSoCoPhan'] ?? '';
    $hoVaTenDaiDien = $_POST['hoVaTenDaiDien'] ?? '';
    $gioiTinhDaiDien = $_POST['gioiTinhDaiDien'] ?? '';
    $chucDanhDaiDien = $_POST['chucDanhDaiDien'] ?? '';
    $sinhNgayDaiDien = $_POST['sinhNgayDaiDien'] ?? '';
    $danTocDaiDien = $_POST['danTocDaiDien'] ?? '';
    $quocTichDaiDien = $_POST['quocTichDaiDien'] ?? '';
    $loaiGiayToChungThucCaNhan = $_POST['loaiGiayToChungThucCaNhan'] ?? '';
    $soGiayChungThucCaNhan = $_POST['soGiayChungThucCaNhan'] ?? '';
    $ngayCap = $_POST['ngayCap'] ?? '';
    $noiCap = $_POST['noiCap'] ?? '';
    $noiDangKyHoKhauThuongTru = $_POST['noiDangKyHoKhauThuongTru'] ?? '';
    $choOHienTai = $_POST['choOHienTai'] ?? '';
    $truongPhong = $_POST['truongPhong'] ?? '';

    if (empty($maSoDoanhNghiep) || empty($tenCongTyVietBangTiengViet) || empty($diaChiTruSoChinh) || empty($hoVaTenDaiDien)) {
        echo json_encode(["status" => -1, "msg" => "Vui lòng điền đầy đủ các thông tin bắt buộc!"]);
        exit;
    }

    $phoi_path = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/img/phoi/giay-to/giayphepkinhdoanh-new/phoi-giayphepkinhdoanh-new.png';

    if (!file_exists($phoi_path)) {
        echo json_encode(["status" => -1, "msg" => "Lỗi: File phôi ảnh Giấy phép kinh doanh không tồn tại tại: " . $phoi_path]);
        exit;
    }

    $image = imagecreatefrompng($phoi_path);
    if (!$image) {
        echo json_encode(["status" => -1, "msg" => "Lỗi GD: Không thể tạo ảnh từ phôi PNG. Đảm bảo GD extension được bật và file PNG hợp lệ."]);
        exit;
    }

    $black = imagecolorallocate($image, 0, 0, 0);

    $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/fonts/Timenew/';

    $fontTimesNewRomanRegular = $fontPath . 'times.ttf';
    $fontTimesNewRomanBold = $fontPath . 'timesbd.ttf';
    $fontTimesNewRomanItalic = $fontPath . 'timesi.ttf';
    $fontTimesNewRomanBoldItalic = $fontPath . 'timesbi.ttf';

    if (!file_exists($fontTimesNewRomanRegular)) $fontTimesNewRomanRegular = $fontPath . 'arial.ttf';
    if (!file_exists($fontTimesNewRomanBold)) $fontTimesNewRomanBold = $fontPath . 'arialbd.ttf';
    if (!file_exists($fontTimesNewRomanItalic)) $fontTimesNewRomanItalic = $fontPath . 'ariali.ttf';
    if (!file_exists($fontTimesNewRomanBoldItalic)) $fontTimesNewRomanBoldItalic = $fontPath . 'arialbi.ttf';

    if (!function_exists('drawText')) {
        function drawText(GdImage $image, string $text, string $fontPath, float $fontSize, int $color, int $x, int $y, bool $isCentered = false, float $angle = 0, ?int $maxWidth = null, int $lineHeight = 15, int $indentX = 0, int $maxLines = 0) {
            if (!file_exists($fontPath)) {
                error_log("Font file for drawText not found: " . $fontPath);
                imagestring($image, 5, $x, $y, $text, $color);
                return;
            }
            $fontSizeInt = (int) round($fontSize);
            
            $lines = [];
            $tempLines = [];

            if ($maxWidth !== null) {
                $words = explode(' ', $text);
                $currentLine = '';
                
                foreach ($words as $word) {
                    $testLine = $currentLine . ($currentLine == '' ? '' : ' ') . $word;
                    $bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $testLine);
                    $width = $bbox[2] - $bbox[0];

                    if ($width <= $maxWidth) {
                        $currentLine = $testLine;
                    } else {
                        $tempLines[] = $currentLine;
                        $currentLine = $word;
                    }
                }
                $tempLines[] = $currentLine;    

                if ($maxLines > 0 && count($tempLines) > $maxLines) {
                    $lines[] = $tempLines[0];
                    
                    $remainingTextWords = array_slice($words, count(explode(' ', $tempLines[0])));
                    $remainingText = implode(' ', $remainingTextWords);
                    
                    $finalSecondLine = '';
                    foreach ($remainingTextWords as $word) {
                        $testSecondLine = $finalSecondLine . ($finalSecondLine == '' ? '' : ' ') . $word;
                        $bboxSecond = imagettfbbox($fontSizeInt, $angle, $fontPath, $testSecondLine);
                        $widthSecond = $bboxSecond[2] - $bboxSecond[0];

                        if ($widthSecond <= $maxWidth) {
                            $finalSecondLine = $testSecondLine;
                        } else {
                            break;    
                        }
                    }
                    $lines[] = $finalSecondLine;

                } else {
                    $lines = $tempLines;    
                }

            } else {
                $lines[] = $text;
            }

            $currentY = $y;
            $lineNum = 0;
            foreach ($lines as $line) {
                $currentX = $x;
                if ($lineNum > 0) {
                    $currentX += $indentX;
                }

                if ($isCentered) {
                    $text_bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $line);
                    $text_width = $text_bbox[2] - $text_bbox[0];
                    $currentX = $currentX - ($text_width / 2);
                }
                imagettftext($image, $fontSizeInt, $angle, $currentX, $currentY, $color, $fontPath, $line);
                $currentY += $lineHeight;
                $lineNum++;
            }
        }
    }

    if (!function_exists('formatDateForDisplay')) {
        function formatDateForDisplay(string $dateString): string {
            $dateString = preg_replace('/\D/', '', $dateString);
            if (strlen($dateString) === 8) {
                return substr($dateString, 0, 2) . '/' . substr($dateString, 2, 2) . '/' . substr($dateString, 4, 4);
            }
            return $dateString;
        }
    }

    $maSoDoanhNghiep = mb_strtoupper($maSoDoanhNghiep, 'UTF-8');
    $tenCongTyVietBangTiengViet = mb_strtoupper($tenCongTyVietBangTiengViet, 'UTF-8');
    $tenCongTyVietBangTiengNuocNgoai = mb_strtoupper($tenCongTyVietBangTiengNuocNgoai, 'UTF-8');
    $tenCongTyVietTat = mb_strtoupper($tenCongTyVietTat, 'UTF-8');
    $hoVaTenDaiDien = mb_strtoupper($hoVaTenDaiDien, 'UTF-8');
    $truongPhong = mb_strtoupper($truongPhong, 'UTF-8');

    $dangKyLanDauRaw = formatDateForDisplay($dangKyLanDauNgay);
    $dangKyLanDauFormattedText = "";
    $partsDangKyLanDau = explode('/', $dangKyLanDauRaw);

    if (count($partsDangKyLanDau) === 3) {
        $day = $partsDangKyLanDau[0];
        $month = $partsDangKyLanDau[1];
        $year = $partsDangKyLanDau[2];
        $dangKyLanDauFormattedText = "ngày " . $day . " tháng " . $month . " năm " . $year;
    } else {
        $dangKyLanDauFormattedText = $dangKyLanDauRaw;
    }

    $dangKyThayDoiFormattedText = "";
    if (!empty($dangKyThayDoiLanThuSo) && !empty($dangKyThayDoiLanThuNgay)) {
        $dangKyThayDoiNgayRaw = formatDateForDisplay($dangKyThayDoiLanThuNgay);
        $partsDangKyThayDoiNgay = explode('/', $dangKyThayDoiNgayRaw);

        if (count($partsDangKyThayDoiNgay) === 3) {
            $dayChange = $partsDangKyThayDoiNgay[0];
            $monthChange = $partsDangKyThayDoiNgay[1];
            $yearChange = $partsDangKyThayDoiNgay[2];
            $dangKyThayDoiFormattedText = "" . $dangKyThayDoiLanThuSo . ", ngày " . $dayChange . " tháng " . $monthChange . " năm " . $yearChange;
        } else {
            $dangKyThayDoiFormattedText = "" . $dangKyThayDoiLanThuSo . ", ngày " . $dangKyThayDoiNgayRaw;
        }
    }

    drawText($image, $maSoDoanhNghiep, $fontTimesNewRomanBold, 17, $black, 585, 285);
    drawText($image, $dangKyLanDauFormattedText, $fontTimesNewRomanItalic, 17, $black, 485, 323);
    drawText($image, $dangKyThayDoiFormattedText, $fontTimesNewRomanItalic, 16.7, $black, 510, 358, false, 0);
    drawText($image, $thanhPhoCap, $fontTimesNewRomanRegular, 16.6, $black, 137, 126);
    
    $maxWidthTenCongTy = 540;
    $lineHeightTenCongTy = 35;
    $indentXTenCongTy = -328;
    drawText($image, $tenCongTyVietBangTiengViet, $fontTimesNewRomanRegular, 18, $black, 443, 476, false, 0, $maxWidthTenCongTy, $lineHeightTenCongTy, $indentXTenCongTy, 2);

    $maxWidthTenCongTyNN = 540;
    $lineHeightTenCongTyNN = 27;
    $indentXTenCongTyNN = -387;
    drawText($image, $tenCongTyVietBangTiengNuocNgoai, $fontTimesNewRomanRegular, 18, $black, 515, 536, false, 0, $maxWidthTenCongTyNN, $lineHeightTenCongTyNN, $indentXTenCongTyNN, 2);

    drawText($image, $tenCongTyVietTat, $fontTimesNewRomanRegular, 18, $black, 315, 569, false, 0);

    $maxWidthDiaChi = 690;
    $lineHeightDiaChi = 28;
    $indentXDiaChi = 0;
    drawText($image, $diaChiTruSoChinh, $fontTimesNewRomanItalic, 19.5, $black, 115, 645, false, 0, $maxWidthDiaChi, $lineHeightDiaChi, $indentXDiaChi, 2);

    drawText($image, $dienThoai, $fontTimesNewRomanItalic, 18, $black, 228, 707);
    drawText($image, $fax, $fontTimesNewRomanItalic, 18, $black, 710, 702);
    drawText($image, $email, $fontTimesNewRomanItalic, 18, $black, 193, 740);
    drawText($image, $website, $fontTimesNewRomanItalic, 18, $black, 658, 738);

    drawText($image, $vonDieuLe, $fontTimesNewRomanItalic, 16, $black, 300, 823);

    $maxWidthVonDieuLeBangChu = 560;
    $lineHeightVonDieuLeBangChu = 27;
    $indentXVonDieuLeBangChu = -110;
    drawText($image, $vonDieuLeBangChu, $fontTimesNewRomanItalic, 16, $black, 235, 857, false, 0, $maxWidthVonDieuLeBangChu, $lineHeightVonDieuLeBangChu, $indentXVonDieuLeBangChu, 2);

    drawText($image, $menhGiaCoPhan, $fontTimesNewRomanItalic, 16, $black, 319, 891);
    drawText($image, $tongSoCoPhan, $fontTimesNewRomanItalic, 16, $black, 325, 928);

    drawText($image, $hoVaTenDaiDien, $fontTimesNewRomanRegular, 17.5, $black, 267, 997, false, 0);

    drawText($image, $gioiTinhDaiDien, $fontTimesNewRomanRegular, 17.5, $black, 828, 990);
    drawText($image, $chucDanhDaiDien, $fontTimesNewRomanRegular, 17.4, $black, 240, 1033);
    drawText($image, formatDateForDisplay($sinhNgayDaiDien), $fontTimesNewRomanItalic, 17.5, $black, 245, 1065);
    drawText($image, $danTocDaiDien, $fontTimesNewRomanItalic, 17.4, $black, 519, 1061);
    drawText($image, $quocTichDaiDien, $fontTimesNewRomanItalic, 17.6, $black, 780, 1060);
    drawText($image, $loaiGiayToChungThucCaNhan, $fontTimesNewRomanItalic, 17.5, $black, 470, 1097);
    drawText($image, $soGiayChungThucCaNhan, $fontTimesNewRomanItalic, 17.5, $black, 445, 1129);
    drawText($image, formatDateForDisplay($ngayCap), $fontTimesNewRomanItalic, 17.5, $black, 250, 1163);
    drawText($image, $noiCap, $fontTimesNewRomanItalic, 17, $black, 546, 1158);

    $maxWidthHoKhau = 630;
    $lineHeightHoKhau = 35;
    $indentXHoKhau = -202;
    drawText($image, $noiDangKyHoKhauThuongTru, $fontTimesNewRomanItalic, 17.6, $black, 320, 1192, false, 0, $maxWidthHoKhau, $lineHeightHoKhau, $indentXHoKhau, 2);

    $maxWidthChoOHienTai = 630;
    $lineHeightChoOHienTai = 35;
    $indentXChoOHienTai = -175;
    drawText($image, $choOHienTai, $fontTimesNewRomanItalic, 17, $black, 295, 1256, false, 0, $maxWidthChoOHienTai, $lineHeightChoOHienTai, $indentXChoOHienTai, 2);

    drawText($image, $truongPhong, $fontTimesNewRomanBold, 12, $black, 606, 1929, true);

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);

    echo json_encode([
        "status" => 200,
        "msg" => "Tạo Giấy Phép Kinh Doanh New Thành Công!",
        "img" => $base64,
    ]);
}
?>