<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once $_SERVER['DOCUMENT_ROOT'] . '/config/database.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/config/obj.php';

if (isset($_POST['action']) && $_POST['action'] === 'fake-business-license-1') {
    global $SSC;
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ này!"]));
    }
    $maSoChiNhanh = $_POST['maSoChiNhanh'] ?? '';
    $dangKyLanDauNgay = $_POST['dangKyLanDauNgay'] ?? ''; 
    $tenChiNhanh = $_POST['tenChiNhanh'] ?? '';
    $tenChiNhanhVietBangTiengNuocNgoai = $_POST['tenChiNhanhVietBangTiengNuocNgoai'] ?? '';
    $tenChiNhanhVietTat = $_POST['tenChiNhanhVietTat'] ?? '';
    $diaChi = $_POST['diaChi'] ?? ''; 
    $thanhPho = $_POST['thanhPho'] ?? '';
    $dienThoai = $_POST['dienThoai'] ?? '';
    $fax = $_POST['fax'] ?? '';
    $email = $_POST['email'] ?? '';
    $website = $_POST['website'] ?? '';

    $hoVaTenDaiDien = $_POST['hoVaTenDaiDien'] ?? '';
    $gioiTinhDaiDien = $_POST['gioiTinhDaiDien'] ?? '';
    $sinhNgayDaiDien = $_POST['sinhNgayDaiDien'] ?? '';
    $danTocDaiDien = $_POST['danTocDaiDien'] ?? '';
    $quocTichDaiDien = $_POST['quocTichDaiDien'] ?? '';
    $loaiGiayToChungThucCaNhan = $_POST['loaiGiayToChungThucCaNhan'] ?? '';
    $soGiayChungThucCaNhan = $_POST['soGiayChungThucCaNhan'] ?? '';
    $ngayCap = $_POST['ngayCap'] ?? '';
    $noiCap = $_POST['noiCap'] ?? '';
    $noiDangKyHoKhauThuongTru = $_POST['noiDangKyHoKhauThuongTru'] ?? '';
    $choOHienTai = $_POST['choOHienTai'] ?? '';
    $tenDoanhNghiepMe = $_POST['tenDoanhNghiepMe'] ?? '';
    $maSoDoanhNghiepMe = $_POST['maSoDoanhNghiepMe'] ?? '';
    $diaChiTruSoChinhDoanhNghiepMe = $_POST['diaChiTruSoChinhDoanhNghiepMe'] ?? '';
if (empty($maSoChiNhanh) || empty($tenChiNhanh) || empty($diaChi) || empty($thanhPho) || empty($hoVaTenDaiDien) || empty($tenDoanhNghiepMe)) { // <--- THÊM thanhPho VÀO ĐIỀU KIỆN KIỂM TRA
        echo json_encode(["status" => -1, "msg" => "Vui lòng điền đầy đủ các thông tin bắt buộc!"]);
        exit;
    }
    if (empty($maSoChiNhanh) || empty($tenChiNhanh) || empty($diaChi) || empty($hoVaTenDaiDien) || empty($tenDoanhNghiepMe)) {
        echo json_encode(["status" => -1, "msg" => "Vui lòng điền đầy đủ các thông tin bắt buộc!"]);
        exit;
    }

    $phoi_path = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/img/phoi/giay-to/giayphepchinhanh/giayphepchinhanh.png'; // Cập nhật tên file phôi nếu bạn đã đổi

    if (!file_exists($phoi_path)) {
        echo json_encode(["status" => -1, "msg" => "Lỗi: File phôi ảnh Giấy chứng nhận chi nhánh không tồn tại tại: " . $phoi_path]);
        exit;
    }

    $image = imagecreatefrompng($phoi_path);
    if (!$image) {
        echo json_encode(["status" => -1, "msg" => "Lỗi GD: Không thể tạo ảnh từ phôi PNG. Đảm bảo GD extension được bật và file PNG hợp lệ."]);
        exit;
    }

    $black = imagecolorallocate($image, 0, 0, 0);

    $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/fonts/Timenew/';

    $fontTimesNewRomanRegular = $fontPath . 'times.ttf';
    $fontTimesNewRomanBold = $fontPath . 'timesbd.ttf';
    $fontTimesNewRomanItalic = $fontPath . 'timesi.ttf';
    $fontTimesNewRomanBoldItalic = $fontPath . 'timesbi.ttf';

    // Fallback fonts
    if (!file_exists($fontTimesNewRomanRegular)) $fontTimesNewRomanRegular = $fontPath . 'arial.ttf';
    if (!file_exists($fontTimesNewRomanBold)) $fontTimesNewRomanBold = $fontPath . 'arialbd.ttf';
    if (!file_exists($fontTimesNewRomanItalic)) $fontTimesNewRomanItalic = $fontPath . 'ariali.ttf';
    if (!file_exists($fontTimesNewRomanBoldItalic)) $fontTimesNewRomanBoldItalic = $fontPath . 'arialbi.ttf';

    if (!function_exists('drawText')) {
        function drawText(GdImage $image, string $text, string $fontPath, float $fontSize, int $color, int $x, int $y, bool $isCentered = false, float $angle = 0, ?int $maxWidth = null, int $lineHeight = 15, int $indentX = 0, int $maxLines = 0) {
            if (!file_exists($fontPath)) {
                error_log("Font file for drawText not found: " . $fontPath);
                imagestring($image, 5, $x, $y, $text, $color);
                return;
            }
            $fontSizeInt = (int) round($fontSize);
            
            $lines = [];
            $tempLines = [];

            if ($maxWidth !== null) {
                $words = explode(' ', $text);
                $currentLine = '';
                
                foreach ($words as $word) {
                    $testLine = $currentLine . ($currentLine == '' ? '' : ' ') . $word;
                    $bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $testLine);
                    $width = $bbox[2] - $bbox[0];

                    if ($width <= $maxWidth) {
                        $currentLine = $testLine;
                    } else {
                        $tempLines[] = $currentLine;
                        $currentLine = $word;
                    }
                }
                $tempLines[] = $currentLine;    

                if ($maxLines > 0 && count($tempLines) > $maxLines) {
                    $truncatedLines = [];
                    for ($i = 0; $i < $maxLines; $i++) {
                        $truncatedLines[] = $tempLines[$i];
                    }
                    $lines = $truncatedLines;
                } else {
                    $lines = $tempLines;    
                }

            } else {
                $lines[] = $text;
            }

            $currentY = $y;
            $lineNum = 0;
            foreach ($lines as $line) {
                $currentX = $x;
                if ($lineNum > 0) {
                    $currentX += $indentX;
                }

                if ($isCentered) {
                    $text_bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $line);
                    $text_width = $text_bbox[2] - $text_bbox[0];
                    $currentX = $currentX - ($text_width / 2);
                }
                imagettftext($image, $fontSizeInt, $angle, $currentX, $currentY, $color, $fontPath, $line);
                $currentY += $lineHeight;
                $lineNum++;
            }
        }
    }

    if (!function_exists('formatDateForDisplay')) {
        function formatDateForDisplay(string $dateString): string {
            $dateString = preg_replace('/\D/', '', $dateString);
            if (strlen($dateString) === 8) {
                return substr($dateString, 0, 2) . '/' . substr($dateString, 2, 2) . '/' . substr($dateString, 4, 4);
            }
            return $dateString;
        }
    }

    // Chuyển đổi sang chữ hoa
    $maSoChiNhanh = mb_strtoupper($maSoChiNhanh, 'UTF-8');
    $tenChiNhanh = mb_strtoupper($tenChiNhanh, 'UTF-8');
    $thanhPho = mb_strtoupper($thanhPho, 'UTF-8');
    $tenChiNhanhVietBangTiengNuocNgoai = mb_strtoupper($tenChiNhanhVietBangTiengNuocNgoai, 'UTF-8');
    $tenChiNhanhVietTat = mb_strtoupper($tenChiNhanhVietTat, 'UTF-8');
    $hoVaTenDaiDien = mb_strtoupper($hoVaTenDaiDien, 'UTF-8');
    $tenDoanhNghiepMe = mb_strtoupper($tenDoanhNghiepMe, 'UTF-8');
    $maSoDoanhNghiepMe = mb_strtoupper($maSoDoanhNghiepMe, 'UTF-8');
    // Format ngày đăng ký lần đầu
    $dangKyLanDauRaw = formatDateForDisplay($dangKyLanDauNgay);
    $dangKyLanDauFormattedText = "";
    $partsDangKyLanDau = explode('/', $dangKyLanDauRaw);

    if (count($partsDangKyLanDau) === 3) {
        $day = $partsDangKyLanDau[0];
        $month = $partsDangKyLanDau[1];
        $year = $partsDangKyLanDau[2];
        $dangKyLanDauFormattedText = "ngày " . $day . " tháng " . $month . " năm " . $year;
    } else {
        $dangKyLanDauFormattedText = $dangKyLanDauRaw;
    }
    drawText($image, $maSoChiNhanh, $fontTimesNewRomanBold, 17.7, $black, 535, 300); // Tăng size, dịch sang trái
    drawText($image, $dangKyLanDauFormattedText, $fontTimesNewRomanItalic, 16.5, $black, 472, 336); // Điều chỉnh vị trí Y
    // 1. Tên chi nhánh
    $maxWidthTenChiNhanh = 856; // Chiều rộng tối đa cho tên chi nhánh
    $lineHeightTenChiNhanh = 25; // Khoảng cách giữa các dòng
    drawText($image, $tenChiNhanh, $fontTimesNewRomanRegular, 17.5, $black, 100, 461, false, 0, $maxWidthTenChiNhanh, $lineHeightTenChiNhanh);
    drawText($image, $tenChiNhanhVietBangTiengNuocNgoai, $fontTimesNewRomanRegular, 17, $black, 516, 521, false, 0, $maxWidthTenChiNhanh, $lineHeightTenChiNhanh);
    drawText($image, $tenChiNhanhVietTat, $fontTimesNewRomanRegular, 17, $black, 324, 555);
    
    // 2. Địa chỉ
    $maxWidthDiaChi = 836;
    $lineHeightDiaChi = 25;
    drawText($image, $diaChi, $fontTimesNewRomanItalic, 17.5, $black, 97, 616, false, 0, $maxWidthDiaChi, $lineHeightDiaChi);
    drawText($image, $thanhPho, $fontTimesNewRomanRegular, 16.75, $black, 287, 105); 
    drawText($image, $dienThoai, $fontTimesNewRomanItalic, 16.5, $black, 210, 676);
    drawText($image, $fax, $fontTimesNewRomanItalic, 16.5, $black, 644, 677);
    drawText($image, $email, $fontTimesNewRomanItalic, 16.5, $black, 166, 703);
    drawText($image, $website, $fontTimesNewRomanItalic, 16.5, $black, 642, 704);

    // 3. Thông tin về người đứng đầu
    drawText($image, $hoVaTenDaiDien, $fontTimesNewRomanRegular, 17.5, $black, 228, 764);
    drawText($image, $gioiTinhDaiDien, $fontTimesNewRomanItalic, 17.5, $black, 768, 765);
    drawText($image, formatDateForDisplay($sinhNgayDaiDien), $fontTimesNewRomanItalic, 17.4, $black, 228, 795);
    drawText($image, $danTocDaiDien, $fontTimesNewRomanItalic, 17.5, $black, 511, 796);
    drawText($image, $quocTichDaiDien, $fontTimesNewRomanItalic, 17.5, $black, 767, 798);
    drawText($image, $loaiGiayToChungThucCaNhan, $fontTimesNewRomanItalic, 17.5, $black, 449, 827);
    drawText($image, $soGiayChungThucCaNhan, $fontTimesNewRomanItalic, 17.5, $black, 407, 859);
    drawText($image, formatDateForDisplay($ngayCap), $fontTimesNewRomanItalic, 17.5, $black, 230, 890);
    drawText($image, $noiCap, $fontTimesNewRomanItalic, 17.5, $black, 515, 892);

    $maxWidthHoKhau = 500;
    $lineHeightHoKhau = 25;
    drawText($image, $noiDangKyHoKhauThuongTru, $fontTimesNewRomanItalic, 17.5, $black, 421, 923, false, 0, $maxWidthHoKhau, $lineHeightHoKhau, -324);
    
    $maxWidthChoOHienTai = 650;
    $lineHeightChoOHienTai = 25;
    drawText($image, $choOHienTai, $fontTimesNewRomanItalic, 17.5, $black, 246, 981, false, 0, $maxWidthChoOHienTai, $lineHeightChoOHienTai, -149);


    // 4. Hoạt động theo ủy quyền của doanh nghiệp
    $maxWidthTenDNMe = 1000;
    $lineHeightTenDNMe = 24;
    drawText($image, $tenDoanhNghiepMe, $fontTimesNewRomanRegular, 17.5, $black, 284, 1079, false, 0, $maxWidthTenDNMe, $lineHeightTenDNMe);
    drawText($image, $maSoDoanhNghiepMe, $fontTimesNewRomanRegular, 17.5, $black, 307, 1112);
    $maxWidthDiaChiDNMe = 650;
    $lineHeightDiaChiDNMe = 24;
    drawText($image, $diaChiTruSoChinhDoanhNghiepMe, $fontTimesNewRomanRegular, 17.5, $black, 302, 1146, false, 0, $maxWidthDiaChiDNMe, $lineHeightDiaChiDNMe, -204);
    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);

    echo json_encode([
        "status" => 200,
        "msg" => "Tạo Giấy chứng nhận Đăng ký Hoạt động Chi nhánh thành công!",
        "img" => $base64,
    ]);
}
?>