<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once $_SERVER['DOCUMENT_ROOT'] . '/config/database.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/config/obj.php';

if (isset($_POST['action']) && $_POST['action'] === 'fake-birth-certificate-real') {
    global $SSC;
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ này!"]));
    }

    $soGiayKhaiSinh = $_POST['soGiayKhaiSinh'] ?? '';
    $quyenSo = $_POST['quyenSo'] ?? '';

    $hoVaTenTreEm = $_POST['hoVaTenTreEm'] ?? '';
    $ngayThangNamSinhTreEm = $_POST['ngayThangNamSinhTreEm'] ?? '';
    $ngayThangNamSinhTreEmChu = $_POST['ngayThangNamSinhTreEmChu'] ?? '';
    $gioiTinhTreEm = $_POST['gioiTinhTreEm'] ?? '';
    $noiSinhTreEm = $_POST['noiSinhTreEm'] ?? '';
    $danTocTreEm = $_POST['danTocTreEm'] ?? '';
    $quocTichTreEm = $_POST['quocTichTreEm'] ?? '';

    $hoVaTenCha = $_POST['hoVaTenCha'] ?? '';
    $danTocCha = $_POST['danTocCha'] ?? '';
    $quocTichCha = $_POST['quocTichCha'] ?? '';
    $namSinhCha = $_POST['namSinhCha'] ?? '';
    $noiThuongTruCha = $_POST['noiThuongTruCha'] ?? '';

    $hoVaTenMe = $_POST['hoVaTenMe'] ?? '';
    $danTocMe = $_POST['danTocMe'] ?? '';
    $quocTichMe = $_POST['quocTichMe'] ?? '';
    $namSinhMe = $_POST['namSinhMe'] ?? '';
    $noiThuongTruMe = $_POST['noiThuongTruMe'] ?? '';

    $noiDangKy = $_POST['noiDangKy'] ?? '';
    $ngayThangNamDangKy = $_POST['ngayThangNamDangKy'] ?? '';
    $hoVaTenNguoiDiKhaiSinh = $_POST['hoVaTenNguoiDiKhaiSinh'] ?? '';
    $quanHeVoiNguoiDuocKhaiSinh = $_POST['quanHeVoiNguoiDuocKhaiSinh'] ?? '';


    if (empty($hoVaTenTreEm) || empty($ngayThangNamSinhTreEm) || empty($hoVaTenCha) || empty($hoVaTenMe) || empty($noiDangKy) || empty($ngayThangNamDangKy)) {
        echo json_encode(["status" => -1, "msg" => "Vui lòng điền đầy đủ các thông tin bắt buộc của Giấy Khai Sinh!"]);
        exit;
    }

    $phoi_path = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/img/phoi/giay-to/giaykhaisinhreal/giay-khai-sinh-real-phoi.png';

    if (!file_exists($phoi_path)) {
        echo json_encode(["status" => -1, "msg" => "Lỗi: File phôi ảnh Giấy Khai Sinh không tồn tại tại: " . $phoi_path]);
        exit;
    }

    $image = imagecreatefrompng($phoi_path);
    if (!$image) {
        echo json_encode(["status" => -1, "msg" => "Lỗi GD: Không thể tạo ảnh từ phôi PNG. Đảm bảo GD extension được bật và file PNG hợp lệ."]);
        exit;
    }

    $black = imagecolorallocate($image, 0, 0, 0);

    $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/fonts/Timenew/';

    $fontTimesNewRomanRegular = $fontPath . 'times.ttf';
    $fontTimesNewRomanBold = $fontPath . 'timesbd.ttf';
    $fontTimesNewRomanItalic = $fontPath . 'timesi.ttf';
    $fontTimesNewRomanBoldItalic = $fontPath . 'timesbi.ttf';

    if (!file_exists($fontTimesNewRomanRegular)) $fontTimesNewRomanRegular = $fontPath . 'arial.ttf';
    if (!file_exists($fontTimesNewRomanBold)) $fontTimesNewRomanBold = $fontPath . 'arialbd.ttf';
    if (!file_exists($fontTimesNewRomanItalic)) $fontTimesNewRomanItalic = $fontPath . 'ariali.ttf';
    if (!file_exists($fontTimesNewRomanBoldItalic)) $fontTimesNewRomanBoldItalic = $fontPath . 'arialbi.ttf';

    if (!function_exists('drawText')) {
        function drawText(GdImage $image, string $text, string $fontPath, float $fontSize, int $color, float $x, float $y, bool $isCentered = false, float $angle = 0, ?int $maxWidth = null, int $lineHeight = 15, int $indentX = 0, int $maxLines = 0) {
            if (!file_exists($fontPath)) {
                error_log("Font file for drawText not found: " . $fontPath);
                imagestring($image, 5, (int)round($x), (int)round($y), $text, $color);
                return;
            }
            $fontSizeInt = (int) round($fontSize);

            $lines = [];
            $tempLines = [];

            if ($maxWidth !== null) {
                $words = explode(' ', $text);
                $currentLine = '';
                
                foreach ($words as $word) {
                    $testLine = $currentLine . ($currentLine == '' ? '' : ' ') . $word;
                    $bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $testLine);
                    $width = $bbox[2] - $bbox[0];

                    if ($width <= $maxWidth) {
                        $currentLine = $testLine;
                    } else {
                        $tempLines[] = $currentLine;
                        $currentLine = $word;
                    }
                }
                $tempLines[] = $currentLine;    

                if ($maxLines > 0 && count($tempLines) > $maxLines) {
                    $lines[] = $tempLines[0];
                    
                    $remainingTextWords = array_slice($words, count(explode(' ', $tempLines[0])));
                    $remainingText = implode(' ', $remainingTextWords);
                    
                    $finalSecondLine = '';
                    foreach ($remainingTextWords as $word) {
                        $testSecondLine = $finalSecondLine . ($finalSecondLine == '' ? '' : ' ') . $word;
                        $bboxSecond = imagettfbbox($fontSizeInt, $angle, $fontPath, $testSecondLine);
                        $widthSecond = $bboxSecond[2] - $bboxSecond[0];

                        if ($widthSecond <= $maxWidth) {
                            $finalSecondLine = $testSecondLine;
                        } else {
                            break;    
                        }
                    }
                    $lines[] = $finalSecondLine;

                } else {
                    $lines = $tempLines;    
                }

            } else {
                $lines[] = $text;
            }

            $currentY = $y;
            $lineNum = 0;
            foreach ($lines as $line) {
                $currentX = $x;
                if ($lineNum > 0) {
                    $currentX += $indentX;
                }

                if ($isCentered) {
                    $text_bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $line);
                    $text_width = $text_bbox[2] - $text_bbox[0];
                    $currentX = $currentX - ($text_width / 2);
                }
                
                $adjustedY = $currentY + $fontSizeInt;    
                
                imagettftext($image, $fontSizeInt, $angle, (int)round($currentX), (int)round($adjustedY), $color, $fontPath, $line);
                $currentY += $lineHeight;
                $lineNum++;
            }
        }
    }

    if (!function_exists('formatDateForDisplay')) {
        function formatDateForDisplay(string $dateString): string {
            $dateString = preg_replace('/\D/', '', $dateString);
            if (strlen($dateString) === 8) {
                return substr($dateString, 0, 2) . '/' . substr($dateString, 2, 2) . '/' . substr($dateString, 4, 4);
            }
            return $dateString;
        }
    }

    $hoVaTenTreEm = mb_strtoupper($hoVaTenTreEm, 'UTF-8');
    $hoVaTenCha = mb_strtoupper($hoVaTenCha, 'UTF-8');
    $hoVaTenMe = mb_strtoupper($hoVaTenMe, 'UTF-8');
    $hoVaTenNguoiDiKhaiSinh = mb_strtoupper($hoVaTenNguoiDiKhaiSinh, 'UTF-8');

    drawText($image, $soGiayKhaiSinh, $fontTimesNewRomanBold, 17.2, $black, 1110, 343);
    drawText($image, $quyenSo, $fontTimesNewRomanBold, 17.2, $black, 1143, 378);

    drawText($image, $hoVaTenTreEm, $fontTimesNewRomanBold, 18.4, $black, 464, 709,false, -0.3);
    drawText($image, formatDateForDisplay($ngayThangNamSinhTreEm), $fontTimesNewRomanBold, 18.3, $black, 573, 754);
    drawText($image, $ngayThangNamSinhTreEmChu, $fontTimesNewRomanBold, 18.4, $black, 449, 796.5, false, -0.49);    

    drawText($image, $gioiTinhTreEm, $fontTimesNewRomanBold, 18.4, $black, 1111, 713.5);    
    drawText($image, $noiSinhTreEm, $fontTimesNewRomanBold, 18.4, $black, 471, 841, false, -0.4);    
    drawText($image, $danTocTreEm, $fontTimesNewRomanBold, 18.4, $black, 471, 885.5,false, -0.1);    
    drawText($image, $quocTichTreEm, $fontTimesNewRomanBold, 18.4, $black, 934, 889.5);    


    drawText($image, $hoVaTenCha, $fontTimesNewRomanBold, 18.4, $black, 492, 931.6);    
    drawText($image, $danTocCha, $fontTimesNewRomanBold, 18.4, $black, 453, 975.6);    
    drawText($image, $quocTichCha, $fontTimesNewRomanBold, 18.4, $black, 804, 976.5);    
    drawText($image, $namSinhCha, $fontTimesNewRomanBold, 18.4, $black, 1102, 977);    
    $maxWidthNoiThuongTruCha = 670;
    $lineHeightNoiThuongTruCha = 43;    
    $indentXNoiThuongTruCha = -271;
    drawText($image, $noiThuongTruCha, $fontTimesNewRomanBold, 18.4, $black, 523.5, 1019, false, -0.2, $maxWidthNoiThuongTruCha, $lineHeightNoiThuongTruCha, $indentXNoiThuongTruCha);    


    drawText($image, $hoVaTenMe, $fontTimesNewRomanBold, 18.4, $black, 496, 1107.5);    
    drawText($image, $danTocMe, $fontTimesNewRomanBold, 18.4, $black, 446, 1151.5);    
    drawText($image, $quocTichMe, $fontTimesNewRomanBold, 18.4, $black, 804, 1153.5,false, -0.25);    
    drawText($image, $namSinhMe, $fontTimesNewRomanBold, 18.44, $black, 1102, 1153);    
    $maxWidthNoiThuongTruMe = 690;    
    $lineHeightNoiThuongTruMe = 44;    
    $indentXNoiThuongTruMe = -271;
    drawText($image, $noiThuongTruMe, $fontTimesNewRomanBold, 18.4, $black, 524, 1196.5, false, -0.25, $maxWidthNoiThuongTruMe, $lineHeightNoiThuongTruMe,$indentXNoiThuongTruMe);    

    $maxWidthNoiDangKy = 690;    
    $lineHeightNoiDangKy = 44;    
    $indentXNoiDangKy = -271;
    drawText($image, $noiDangKy, $fontTimesNewRomanBold, 18.44, $black, 484, 1284.5, false, -0.24, $maxWidthNoiDangKy, $lineHeightNoiDangKy, $indentXNoiDangKy);    
    drawText($image, formatDateForDisplay($ngayThangNamDangKy), $fontTimesNewRomanBold, 18.4, $black, 669, 1373.8);
    drawText($image, $hoVaTenNguoiDiKhaiSinh, $fontTimesNewRomanBold, 18.4, $black, 673, 1508.5);    
    drawText($image, $quanHeVoiNguoiDuocKhaiSinh, $fontTimesNewRomanBold, 18.4, $black, 687, 1556);    

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);

    echo json_encode([
        "status" => 200,
        "msg" => "Tạo Giấy Khai Sinh thành công!",
        "img" => $base64,
    ]);
}
?>