<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once $_SERVER['DOCUMENT_ROOT'] . '/config/database.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/config/obj.php';

if (isset($_POST['action']) && $_POST['action'] === 'fake-docthan') {
    global $SSC;
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ này!"]));
    }

    // Lấy dữ liệu từ POST
    $maSoDoanhNghiep = $_POST['maSoDoanhNghiep'] ?? '';
    $maSoDoanhNghiep1 = $_POST['maSoDoanhNghiep1'] ?? '';
    $maSoDoanhNghiep2 = $_POST['maSoDoanhNghiep2'] ?? '';
    $dangKyLanDauNgay = $_POST['dangKyLanDauNgay'] ?? '';
    $dangKyThayDoiLanThuSo = $_POST['dangKyThayDoiLanThuSo'] ?? '';
    $dangKyThayDoiLanThuNgay = $_POST['dangKyThayDoiLanThuNgay'] ?? '';
    $tenCongTyVietBangTiengViet = $_POST['tenCongTyVietBangTiengViet'] ?? '';
    $tenCongTyVietBangTiengNuocNgoai = $_POST['tenCongTyVietBangTiengNuocNgoai'] ?? '';
    $tenCongTyVietTat = $_POST['tenCongTyVietTat'] ?? '';
    $sinhNgayDaiDien = $_POST['sinhNgayDaiDien'] ?? '';
    $danTocDaiDien = $_POST['danTocDaiDien'] ?? '';
    $gioiTinhDaiDien = $_POST['gioiTinhDaiDien'] ?? '';
    $quocTichDaiDien = $_POST['quocTichDaiDien'] ?? '';
    $loaiGiayToChungThucCaNhan = $_POST['loaiGiayToChungThucCaNhan'] ?? '';
    $soGiayChungThucCaNhan = $_POST['soGiayChungThucCaNhan'] ?? '';
    $ngayCap = $_POST['ngayCap'] ?? '';
    $noiCap = $_POST['noiCap'] ?? '';
    $noiDangKyHoKhauThuongTru = $_POST['noiDangKyHoKhauThuongTru'] ?? '';
    $truongPhong = $_POST['truongPhong'] ?? '';

    // Kiểm tra bắt buộc
    if (empty($maSoDoanhNghiep) || empty($maSoDoanhNghiep1) || empty($maSoDoanhNghiep2) || empty($tenCongTyVietBangTiengNuocNgoai)) {
        echo json_encode(["status" => -1, "msg" => "Vui lòng điền đầy đủ các thông tin bắt buộc!"]);
        exit;
    }

    // Load phôi ảnh
    $phoi_path = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/img/phoi/giay-to/docthan/thanhphucvn.png';
    if (!file_exists($phoi_path)) {
        echo json_encode(["status" => -1, "msg" => "Lỗi: File phôi ảnh Giấy phép kinh doanh không tồn tại tại: " . $phoi_path]);
        exit;
    }

    $image = imagecreatefrompng($phoi_path);
    if (!$image) {
        echo json_encode(["status" => -1, "msg" => "Lỗi GD: Không thể tạo ảnh từ phôi PNG. Đảm bảo GD extension được bật và file PNG hợp lệ."]);
        exit;
    }

    $black = imagecolorallocate($image, 19, 19, 18);
    $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/public/src/vtd/fonts/Timenew/';
    $fontTimesNewRomanRegular = file_exists($fontPath . 'times.ttf') ? $fontPath . 'times.ttf' : $fontPath . 'arial.ttf';
    $fontTimesNewRomanBold = file_exists($fontPath . 'timesbd.ttf') ? $fontPath . 'timesbd.ttf' : $fontPath . 'arialbd.ttf';
    $fontTimesNewRomanItalic = file_exists($fontPath . 'timesi.ttf') ? $fontPath . 'timesi.ttf' : $fontPath . 'ariali.ttf';

    if (!function_exists('drawText')) {
        function drawText(GdImage $image, string $text, string $fontPath, float $fontSize, int $color, int $x, int $y, bool $isCentered = false, float $angle = 0, ?int $maxWidth = null, int $lineHeight = 15, int $indentX = 0, int $maxLines = 0) {
            $fontSizeInt = (int) round($fontSize);
            $lines = [];
            if ($maxWidth !== null) {
                $words = explode(' ', $text);
                $currentLine = '';
                foreach ($words as $word) {
                    $testLine = $currentLine . ($currentLine == '' ? '' : ' ') . $word;
                    $bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $testLine);
                    $width = $bbox[2] - $bbox[0];
                    if ($width <= $maxWidth) {
                        $currentLine = $testLine;
                    } else {
                        $lines[] = $currentLine;
                        $currentLine = $word;
                    }
                }
                $lines[] = $currentLine;
                if ($maxLines > 0 && count($lines) > $maxLines) {
                    $lines = array_slice($lines, 0, $maxLines);
                }
            } else {
                $lines[] = $text;
            }

            $currentY = $y;
            foreach ($lines as $i => $line) {
                $currentX = $x + ($i > 0 ? $indentX : 0);
                if ($isCentered) {
                    $text_bbox = imagettfbbox($fontSizeInt, $angle, $fontPath, $line);
                    $text_width = $text_bbox[2] - $text_bbox[0];
                    $currentX = $currentX - ($text_width / 2);
                }
                imagettftext($image, $fontSizeInt, $angle, $currentX, $currentY, $color, $fontPath, $line);
                $currentY += $lineHeight;
            }
        }
    }

    if (!function_exists('formatDateForDisplay')) {
        function formatDateForDisplay(string $dateString): string {
            $dateString = preg_replace('/\D/', '', $dateString);
            return strlen($dateString) === 8
                ? substr($dateString, 0, 2) . '/' . substr($dateString, 2, 2) . '/' . substr($dateString, 4, 4)
                : $dateString;
        }
    }

    // Xử lý dữ liệu
    $maSoDoanhNghiep = mb_strtoupper($maSoDoanhNghiep, 'UTF-8');
    $maSoDoanhNghiep1 = mb_strtoupper($maSoDoanhNghiep1, 'UTF-8');
    $maSoDoanhNghiep2 = mb_strtoupper($maSoDoanhNghiep2, 'UTF-8');
    $hoVaTenDaiDien = mb_strtoupper($_POST['hoVaTenDaiDien'] ?? '', 'UTF-8');
    $truongPhong = mb_strtoupper($truongPhong, 'UTF-8');

    $dangKyLanDauRaw = formatDateForDisplay($dangKyLanDauNgay);
    $dangKyLanDauFormattedText = "";
    $parts = explode('/', $dangKyLanDauRaw);
    if (count($parts) === 3) {
        $dangKyLanDauFormattedText = "ngày {$parts[0]} tháng {$parts[1]} năm {$parts[2]}";
    }

    $dangKyThayDoiFormattedText = "";
    if (!empty($dangKyThayDoiLanThuSo) && !empty($dangKyThayDoiLanThuNgay)) {
        $parts = explode('/', formatDateForDisplay($dangKyThayDoiLanThuNgay));
        if (count($parts) === 3) {
            $dangKyThayDoiFormattedText = "{$dangKyThayDoiLanThuSo}, ngày {$parts[0]} tháng {$parts[1]} năm {$parts[2]}";
        }
    }

    // Ghi nội dung lên ảnh
    drawText($image, $maSoDoanhNghiep, $fontTimesNewRomanRegular, 16, $black, 220, 140);
    drawText($image, $maSoDoanhNghiep1, $fontTimesNewRomanRegular, 16, $black, 210, 170);
    drawText($image, $maSoDoanhNghiep2, $fontTimesNewRomanBold, 16, $black, 190, 200);
    drawText($image, $dangKyLanDauNgay, $fontTimesNewRomanRegular, 16, $black, 220, 245);
    drawText($image, $dangKyThayDoiFormattedText, $fontTimesNewRomanItalic, 15.7, $black, 523, 245);
    drawText($image, 'Xét đề nghị của ông/bà ' . $tenCongTyVietBangTiengViet . ' là công chức Tư pháp - Hộ tịch về việc cấp Giấy xác nhận tình trạng hôn nhân cho ' . $tenCongTyVietTat . ' ' . mb_strtoupper($tenCongTyVietBangTiengNuocNgoai, 'UTF-8'), $fontTimesNewRomanRegular, 18, $black, 215, 340, false, 0, 700, 33, 0, 5);
    drawText($image, $tenCongTyVietBangTiengNuocNgoai, $fontTimesNewRomanBold, 16, $black, 380, 471);
    drawText($image, formatDateForDisplay($sinhNgayDaiDien), $fontTimesNewRomanRegular, 16, $black, 430, 507);
    drawText($image, $danTocDaiDien, $fontTimesNewRomanRegular, 16, $black, 530, 543);
    drawText($image, $gioiTinhDaiDien, $fontTimesNewRomanRegular, 16, $black, 310, 543);
    drawText($image, $quocTichDaiDien, $fontTimesNewRomanRegular, 16, $black, 740, 543);
    drawText($image, $loaiGiayToChungThucCaNhan . ': ' . $soGiayChungThucCaNhan, $fontTimesNewRomanRegular, 16, $black, 365, 578);
    drawText($image, formatDateForDisplay($ngayCap), $fontTimesNewRomanRegular, 16, $black, 307, 615);
    drawText($image, $noiCap, $fontTimesNewRomanRegular, 16, $black, 490, 615);
    drawText($image, $noiDangKyHoKhauThuongTru, $fontTimesNewRomanRegular, 16.6, $black, 215, 717, false, 0, 690, 28, 0, 5);

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);

    echo json_encode([
        "status" => 200,
        "msg" => "Tạo giấy độc thân thành công!",
        "img" => $base64,
    ]);
}
?>
