<?php
header('Content-Type: application/json');
if (isset($_POST['action']) && $_POST['action'] === 'fake-vneid') {
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ!"]));
    }
    $loai = $_POST["loai"];
    if ($loai === 'vneid') {
        $hovaten = strtoupper(strtolower($_POST["hovaten"])) ?? null;
        $gioitinh = $_POST["gioitinh"] ?? null;
        $ngaysinh = $_POST["ngaysinh"] ?? null;
        $socccd = $_POST["socccd"] ?? null;
        $quequan = $_POST["quequan"] ?? null;
        $thuongtru = $_POST["thuongtru"] ?? null;
        $ngayhethan = $_POST["ngayhethan"] ?? null;
        $quoctich = $_POST["quoctich"] ?? null;
        $code1 = $_POST["code1"] ?? null;
        $code2 = $_POST["code2"] ?? null;
        $p = $_POST["p"] ?? null;
        $maso = $_POST["maso"] ?? null;
        $noicap = $_POST["noicap"] ?? null;
        $anhthe = $_POST['anhthe'] ?? null;

        if (empty($hovaten) || empty($gioitinh) || empty($ngaysinh) || empty($socccd) || empty($quequan) || empty($anhthe) || empty($thuongtru) || empty($ngayhethan) || empty($quoctich)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Không được bỏ trống mục nào!",
            ]));
        }

        if (!isDate($ngaysinh)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Ngày sinh không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm)",
            ]));
        }
        // elseif (!isDate($ngayhethan)) {
        //    die(JSON_FORMATTER([
        //        "status" => -1,
        //        "msg" => "Ngày hết hạn không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm).",
        //    ]));
        //}

        if (!empty($anhthe)) {
            $phoicccd = $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/phoi/giay-to/cccdvneid/phoi-vneid.jpg';
            if (preg_match('/^data:image\/(\w+);base64,/', $anhthe, $type)) {
                $data = substr($anhthe, strpos($anhthe, ',') + 1);
                $type = strtolower($type[1]);
                if (!in_array($type, ['jpg', 'jpeg', 'png'])) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Ảnh thẻ chỉ hỗ trợ các định dạng JPG/PNG/JPEG.",
                    ]));
                }
                $data = base64_decode($data);
                $size = strlen($data);
                if (!WsCheckIMG::SizeLimit($size, 4)) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Kích thước của ảnh không được vượt quá giới hạn cho phép (4MB).",
                    ]));
                }
                if ($data === false) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Lỗi giải mã dữ liệu ảnh thẻ.",
                    ]));
                }
                $phoicccd2 = imagecreatefromjpeg($phoicccd);
                $anhthe_img = imagecreatefromstring($data);
                imagecopyresampled($phoicccd2, $anhthe_img, 135, 850, 0, 0, 450, 600, imagesx($anhthe_img), imagesy($anhthe_img));
                // ngang - dọc - - kích cỡ ảnh in lên ngang - dọc
                imagedestroy($anhthe_img);
                $image = $phoicccd2;
            } else {
                die(JSON_FORMATTER([
                    "status" => -1,
                    "msg" => "Vui lòng upload file ảnh thẻ.",
                ]));
            }
        } else {
            $phoicccd = $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/phoi/giay-to/cccdvneid/phoi-vneid.jpg';
            $image = imagecreatefromjpeg($phoicccd);
        }

        $qrcode = sprintf(
            'https://quickchart.io/qr?text=%s&light=0000&ecLevel=H&format=png&size=700',
            urlencode(
                sprintf('%s|%s|%s|%s|%s|%s|%s',
                    $socccd,
                    WsRandomString::Number(9),
                    $hovaten,
                    str_replace('/', '', $ngaysinh),
                    $gioitinh,
                    $thuongtru,
                    str_replace('/', '', $ngayhethan)
                )
            )
        );
        $qr_img = imagecreatefrompng($qrcode);

        $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/' . __FONTS__ . '/';

        function infocccd($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $x = $customX !== null ? $customX : 753;
            imagettftext($image, $fontSize, 0, $x, $y, $textColor, $font, $text);
        }

        function noithuongchu($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $lineX = 753;
            $firstLineX = $customX !== null ? $customX : 753;
            $maxWidth = 8;
            $words = explode(' ', $text);
            $firstLine = '';
            $D2 = '';
            foreach ($words as $word) {
                $testLine = trim($firstLine . ' ' . $word);
                $textBoundingBox = imagettfbbox($fontSize, 0, $font, $testLine);
                $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
                if (mb_strlen($firstLine) < $maxWidth && $textWidth <= imagesx($image) - $firstLineX) {
                    $firstLine = $testLine;
                } else {
                    $D2 .= ($D2 ? ' ' : '') . $word;
                }
            }
            $firstLineWithoutComma = str_replace(',', '', $firstLine);
            if (!empty($firstLineWithoutComma)) {
                imagettftext($image, $fontSize, 0, $firstLineX, $y, $textColor, $font, trim($firstLineWithoutComma));
            }
            if (!empty($D2)) {
                imagettftext($image, $fontSize, 0, $lineX, $y + ($fontSize + 12), $textColor, $font, trim($D2));
            }
        }
        
        function thanhphuc1($image, $fontSize, $y, $textColor, $font, $text, $customX = null, $secondLineIndent = 0)
{
    // X bắt đầu của dòng đầu tiên
    $firstLineX = $customX !== null ? $customX : 753;

    // Tính chiều rộng còn lại của ảnh
    $maxWidth = imagesx($image) - $firstLineX - 50;

    // Tách từ
    $words = explode(' ', $text);
    $firstLine = '';
    $secondLine = '';

    foreach ($words as $word) {
        $testLine = trim($firstLine . ' ' . $word);
        $bbox = imagettfbbox($fontSize, 0, $font, $testLine);
        $textWidth = $bbox[2] - $bbox[0];

        if ($textWidth <= $maxWidth) {
            $firstLine = $testLine;
        } else {
            $secondLine .= ($secondLine ? ' ' : '') . $word;
        }
    }

    // Vẽ dòng đầu tiên
    if (!empty($firstLine)) {
        imagettftext($image, $fontSize, 0, $firstLineX, $y, $textColor, $font, trim($firstLine));
    }

    // Vẽ dòng thứ hai với thụt lề (nếu có)
    if (!empty($secondLine)) {
        $secondLineX = $firstLineX + $secondLineIndent - 730;
        $secondLineY = $y + $fontSize + 30;
        imagettftext($image, $fontSize, 0, $secondLineX, $secondLineY, $textColor, $font, trim($secondLine));
    }
}

function thanhphuc2($image, $fontSize, $y, $textColor, $font, $text, $customX = null, $secondLineIndent = 0)
{
    $firstLineX = $customX !== null ? $customX : 753;

    $maxWidth = imagesx($image) - $firstLineX - 50;  // còn 50px thì xuống dòng

    $words = explode(' ', $text);
    $firstLine = '';
    $secondLine = '';

    foreach ($words as $word) {
        $testLine = trim($firstLine . ' ' . $word);
        $bbox = imagettfbbox($fontSize, 0, $font, $testLine);
        $textWidth = $bbox[2] - $bbox[0];

        if ($textWidth <= $maxWidth) {
            $firstLine = $testLine;
        } else {
            $secondLine .= ($secondLine ? ' ' : '') . $word;
        }
    }

    if (!empty($firstLine)) {
        imagettftext($image, $fontSize, 0, $firstLineX, $y, $textColor, $font, trim($firstLine));
    }

    if (!empty($secondLine)) {
        $secondLineX = $firstLineX + $secondLineIndent - 348; // từ dòng trên thụt xuống
        $secondLineY = $y + $fontSize + 30;  // độ rộng cách dòng
        imagettftext($image, $fontSize, 0, $secondLineX, $secondLineY, $textColor, $font, trim($secondLine));
    }
}


function thanhphuc3($image, $fontSize, $y, $textColor, $font, $text, $customX = null, $secondLineIndent = 0)
{
    $firstLineX = $customX !== null ? $customX : 753;

    $maxWidth = imagesx($image) - $firstLineX - 50;

    $words = explode(' ', $text);
    $firstLine = '';
    $secondLine = '';

    foreach ($words as $word) {
        $testLine = trim($firstLine . ' ' . $word);
        $bbox = imagettfbbox($fontSize, 0, $font, $testLine);
        $textWidth = $bbox[2] - $bbox[0];

        if ($textWidth <= $maxWidth) {
            $firstLine = $testLine;
        } else {
            $secondLine .= ($secondLine ? ' ' : '') . $word;
        }
    }

    if (!empty($firstLine)) {
        imagettftext($image, $fontSize, 0, $firstLineX, $y, $textColor, $font, trim($firstLine));
    }

    if (!empty($secondLine)) {
        $secondLineX = $firstLineX + $secondLineIndent - 510;
        $secondLineY = $y + $fontSize + 30;
        imagettftext($image, $fontSize, 0, $secondLineX, $secondLineY, $textColor, $font, trim($secondLine));
    }
}

function thanhphuc4($image, $fontSize, $y, $textColor, $font, $text, $customX = null, $secondLineIndent = 0)
{
    $firstLineX = $customX !== null ? $customX : 753;

    $maxWidth = imagesx($image) - $firstLineX - 50;

    $words = explode(' ', $text);
    $firstLine = '';
    $secondLine = '';

    foreach ($words as $word) {
        $testLine = trim($firstLine . ' ' . $word);
        $bbox = imagettfbbox($fontSize, 0, $font, $testLine);
        $textWidth = $bbox[2] - $bbox[0];

        if ($textWidth <= $maxWidth) {
            $firstLine = $testLine;
        } else {
            $secondLine .= ($secondLine ? ' ' : '') . $word;
        }
    }

    if (!empty($firstLine)) {
        imagettftext($image, $fontSize, 0, $firstLineX, $y, $textColor, $font, trim($firstLine));
    }

    if (!empty($secondLine)) {
        $secondLineX = $firstLineX + $secondLineIndent - 450;
        $secondLineY = $y + $fontSize + 30;
        imagettftext($image, $fontSize, 0, $secondLineX, $secondLineY, $textColor, $font, trim($secondLine));
    }
}

function thanhphuc5($image, $fontSize, $y, $textColor, $font, $text, $customX = null, $secondLineIndent = 0)
{
    $firstLineX = $customX !== null ? $customX : 753;

    $maxWidth = imagesx($image) - $firstLineX - 50;

    $words = explode(' ', $text);
    $firstLine = '';
    $secondLine = '';

    foreach ($words as $word) {
        $testLine = trim($firstLine . ' ' . $word);
        $bbox = imagettfbbox($fontSize, 0, $font, $testLine);
        $textWidth = $bbox[2] - $bbox[0];

        if ($textWidth <= $maxWidth) {
            $firstLine = $testLine;
        } else {
            $secondLine .= ($secondLine ? ' ' : '') . $word;
        }
    }

    if (!empty($firstLine)) {
        imagettftext($image, $fontSize, 0, $firstLineX, $y, $textColor, $font, trim($firstLine));
    }

    if (!empty($secondLine)) {
        $secondLineX = $firstLineX + $secondLineIndent - 667;
        $secondLineY = $y + $fontSize + 30;
        imagettftext($image, $fontSize, 0, $secondLineX, $secondLineY, $textColor, $font, trim($secondLine));
    }
}


        //imagecopyresampled($image, $qr_img, 1540, 890, 0, 0, 222, 222, imagesx($qr_img), imagesy($qr_img));
        //               size, dọc,                                                                                             ngang
        infocccd($image, 57, 1240, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/SF-Pro-Display-Bold.otf', $hovaten, 630);
        infocccd($image, 55, 1060, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/SF-Pro-Display-Bold.otf', $socccd, 630);
        infocccd($image, 45, 1390, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/SF-Pro-Display-Bold.otf', $ngaysinh, 630);
        infocccd($image, 45, 1318, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/SF-Pro-Display-Bold.otf', $gioitinh, 1680);
        infocccd($image, 45, 1450, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/SF-Pro-Display-Bold.otf', $quoctich, 1020);
        
        thanhphuc1($image, 53, 1901, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/static/Roboto-Bold.ttf', $quequan, 820);
        thanhphuc2($image, 53, 2112, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/static/Roboto-Bold.ttf', $thuongtru, 450);
        thanhphuc3($image, 53, 2460, imagecolorallocate($image, 32, 46, 39), $fontPath . 'vneid/static/Roboto-Bold.ttf', $ngayhethan, 590);
        infocccd($image, 53, 2752, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/static/Roboto-Bold.ttf', $p, 472);
        thanhphuc4($image, 53, 2960, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/static/Roboto-Bold.ttf', $maso, 530);
        thanhphuc5($image, 52, 3313, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/static/Roboto-Bold.ttf', $noicap, 760);
        infocccd($image, 53, 3505, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/static/Roboto-Bold.ttf', $code1, 1330);
        infocccd($image, 53, 3745, imagecolorallocate($image, 39, 39, 39), $fontPath . 'vneid/static/Roboto-Bold.ttf', $code2, 1270);
        // cỡ - dọc - ngang
        ob_start();
        imagepng($image);
        $imageData = ob_get_clean();
        $base64 = base64_encode($imageData);
        imagedestroy($image);

        if (!isset($user['rank']) || !in_array($user['rank'], ['admin', 'leader'])) {
            $requiredVIP = intval(preg_replace('/\D/', '', $TD->Setting('giataogiayto') ?? ''));
            $currentVIP = intval(preg_replace('/\D/', '', $plans->TD('tengoi', $taikhoan) ?? ''));
            if ($requiredVIP > 0 && $currentVIP < $requiredVIP) {
                $action = ($currentVIP === 0) ? "mua" : "tối thiểu";
                die(JSON_FORMATTER([
                    "status" => -1,
                    "msg" => "Vui lòng $action gói " . strtoupper($TD->Setting('giataogiayto')) . " để sử dụng tính năng fake cccd!",
                ]));
            }
        }

        die(JSON_FORMATTER([
            "status" => 200,
            "msg" => "Tạo cccd vneid thành công!",
            "img" => $base64,
            "info" => ['type' => [$loai], 'sex' => [$gioitinh ?? 'N/A']],
        ]));
    }
}
