<?php
header('Content-Type: application/json');
if (isset($_POST['action']) && $_POST['action'] === 'fake-cccd-tp-new') {
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ!"]));
    }

    $loai = $_POST["loai"];

    if ($loai === 'cccd-mat-truoc-tp-new') {
        $hovaten = strtoupper(strtolower($_POST["hovaten"]))?? null;
        $gioitinh = $_POST["gioitinh"]?? null;
        $ngaysinh = $_POST["ngaysinh"]?? null;
        $socccd = $_POST["socccd"]?? null;
        $quoctich = $_POST["quoctich"]?? null;
        $anhthe = $_POST['anhthe'] ?? null;

        if (empty($hovaten) || empty($anhthe) || empty($ngaysinh) || empty($socccd) || empty($quoctich)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Không được bỏ trống mục nào!",
            ]));
        }

        if (!isDate($ngaysinh)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Ngày sinh không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm)",
            ]));
        }

        $phoicccd = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/giay-to/cccd-tp-new/mat-truoc.jpg';

        if (!empty($anhthe)) {
            if (preg_match('/^data:image\/(\w+);base64,/', $anhthe, $type)) {
                $data = substr($anhthe, strpos($anhthe, ',') + 1);
                $type = strtolower($type[1]);

                if (!in_array($type, ['jpg', 'jpeg', 'png'])) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Ảnh thẻ chỉ hỗ trợ các định dạng JPG/PNG/JPEG.",
                    ]));
                }

                $data = base64_decode($data);
                if (!WsCheckIMG::SizeLimit(strlen($data), 4)) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Kích thước của ảnh không được vượt quá giới hạn cho phép (4MB).",
                    ]));
                }

                if ($data === false) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Lỗi giải mã dữ liệu ảnh thẻ.",
                    ]));
                }

                $phoicccd2 = imagecreatefromjpeg($phoicccd);
                $anhthe_img = imagecreatefromstring($data);
                imagecopyresampled($phoicccd2, $anhthe_img, 381, 503, 0, 0, 140, 188, imagesx($anhthe_img), imagesy($anhthe_img));
                imagedestroy($anhthe_img);
                $image = $phoicccd2;
            } else {
                die(JSON_FORMATTER([
                    "status" => -1,
                    "msg" => "Vui lòng upload file ảnh thẻ.",
                ]));
            }
        } else {
            $image = imagecreatefromjpeg($phoicccd);
        }

    } else {
        // Mặt sau giữ nguyên
        $ngaylamcccd = $_POST["ngaylam-cccd"];
        $ngayhethan = $_POST["ngayhethan"];
        $quequan = $_POST["quequan"];
        $thuongtru = $_POST["thuongtru"];
        $hovaten = $_POST["hovaten"];
        $ngaysinh = $_POST["ngaysinh"];
        $gioitinh = $_POST["gioitinh"];
        $mrz = $_POST["mrz"];
        $socccd = $_POST["socccd"]?? null;

        if (!isDate($ngaylamcccd)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Ngày làm cccd không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm)",
            ]));
        }

        $phoicccd = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/giay-to/cccd-tp-new/mat-sau.jpg';
        $image = imagecreatefromjpeg($phoicccd);
    }

    $fontPath = $_SERVER['DOCUMENT_ROOT'].'/'.__FONTS__.'/';

    function infocccd($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
    {
        $fontSize = $fontsize;
        $x = $customX !== null ? $customX : 753;
        imagettftext($image, $fontSize, 0, $x, $y, $textColor, $font, $text);
    }

    function Rn($length) {
        return substr(str_shuffle(str_repeat('0123456789', $length)), 0, $length);
    }
    
    function canlematsau($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $x = $customX !== null ? $customX : 753;
            $shadow = imagecolorallocate($image, 0, 0, 0);
            $maxChars = 25; // tối đa
            $words = explode(' ', $text);
            $lines = [];
            $currentLine = '';
            
    foreach ($words as $word) {
        if (mb_strlen($currentLine . ' ' . $word, 'UTF-8') <= $maxChars) {
            $currentLine .= ($currentLine === '' ? '' : ' ') . $word;
        } else {
            if (count($lines) >= 1) {
                $currentLine .= ' ' . $word;
            } else {
                $lines[] = $currentLine;
                $currentLine = $word;
            }
        }
    }

    if (!empty($currentLine)) {
        $lines[] = $currentLine;
    }

    if (count($lines) > 2) {
        $lines = array_slice($lines, 0, 2);
    }

    foreach ($lines as $index => $line) {
        $offsetX = $index > 0 ? -177 : 0; // dòng 2 thụt vô
        imagettftext($image, $fontSize, 0, $x + $offsetX, $y, $shadow, $font, $line);
        imagettftext($image, $fontSize, 0, round($x + $offsetX + 0.1), round($y + 0), $textColor, $font, $line);
        $y += $fontSize + 8;
    }
}

function canlematsau1($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $x = $customX !== null ? $customX : 753;
            $shadow = imagecolorallocate($image, 0, 0, 0);
            $maxChars = 18; // tối đa
            $words = explode(' ', $text);
            $lines = [];
            $currentLine = '';
            
    foreach ($words as $word) {
        if (mb_strlen($currentLine . ' ' . $word, 'UTF-8') <= $maxChars) {
            $currentLine .= ($currentLine === '' ? '' : ' ') . $word;
        } else {
            if (count($lines) >= 1) {
                $currentLine .= ' ' . $word;
            } else {
                $lines[] = $currentLine;
                $currentLine = $word;
            }
        }
    }

    if (!empty($currentLine)) {
        $lines[] = $currentLine;
    }

    if (count($lines) > 2) {
        $lines = array_slice($lines, 0, 2);
    }

    foreach ($lines as $index => $line) {
        $offsetX = $index > 0 ? -215 : 0; // dòng 2 thụt vô
        imagettftext($image, $fontSize, 0, $x + $offsetX, $y, $shadow, $font, $line);
        imagettftext($image, $fontSize, 0, round($x + $offsetX + 0.1), round($y + 0), $textColor, $font, $line);
        $y += $fontSize + 8;
    }
}

    
    function MRZ() {
        global $socccd;
        $id = 'IDVNM'.Rn(10).$socccd.'<<'.Rn(1);
        $line2 = Rn(8).'M'.Rn(8).'VNM';
        $randomNumber = Rn(1);
        $line2 .= str_repeat('<', 30 - strlen($line2) - 2);
        $line2 .= $randomNumber;
        return [$id, $line2];
    }

    function canlemrz($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
    {
        $x = $customX !== null ? $customX : 370;
        imagettftext($image, $fontsize, 0, $x, $y, $textColor, $font, $text);
    }

    if ($loai === 'cccd-mat-truoc-tp-new') {
        //              size, dọc                                                                                           ngang
        infocccd($image, 20, 565, imagecolorallocate($image, 0,1,1), $fontPath.'common/Arial/Arial Bold.ttf', $socccd, 537);
        infocccd($image, 18, 618, imagecolorallocate($image, 0,1,1), $fontPath.'common/Arial/Arial Regular.ttf', $hovaten, 537);
        infocccd($image, 13, 668, imagecolorallocate($image, 0,1,1), $fontPath.'common/Arial/Arial Regular.ttf', $ngaysinh, 537);
        infocccd($image, 13, 668, imagecolorallocate($image, 0,1,1), $fontPath.'common/Arial/Arial Regular.ttf', $gioitinh, 810);
        infocccd($image, 13, 710, imagecolorallocate($image, 0,1,1), $fontPath.'common/Arial/Arial Regular.ttf', $quoctich, 537);
    } 
    else 
    {
        [$D1, $D2] = MRZ();
        $D3 = $mrz.str_repeat('<', 30 - strlen($mrz)-4);

        $qrcode = sprintf(
            'https://quickchart.io/qr?text=%s&light=0000&ecLevel=H&format=png&size=700',
            urlencode(sprintf('%s|%s|%s|%s|%s|%s|%s',
                $socccd,
                WsRandomString::Number(9),
                                     $hovaten ?? '',
                str_replace('/', '', $ngaysinh ?? ''),
                                     $gioitinh ?? '',
                                     $thuongtru ?? '',
                str_replace('/', '', $ngayhethan ?? '')
            ))
        );

        $qr_img = imagecreatefrompng($qrcode);
        imagecopyresampled($image, $qr_img, 792, 381, 0, 0, 145, 145, imagesx($qr_img), imagesy($qr_img));
        //                  size, dọc                                                                                           ngang
        canlematsau($image, 13, 400, imagecolorallocate($image, 0,1,7), $fontPath.'common/Arial/Arial Regular.ttf', $thuongtru, 570);
        canlematsau1($image, 13, 452, imagecolorallocate($image, 0,1,7), $fontPath.'common/Arial/Arial Regular.ttf', $quequan, 610);
        infocccd($image, 13, 518, imagecolorallocate($image, 0,1,7), $fontPath.'common/Arial/Arial Regular.ttf', $ngaylamcccd, 617);
        infocccd($image, 13, 555, imagecolorallocate($image, 0,1,7), $fontPath.'common/Arial/Arial Regular.ttf', $ngayhethan, 617);
        canlemrz($image, 23, 640, imagecolorallocate($image, 28, 32, 31), $fontPath.'common/Arial/Arial Regular.ttf', $D1, 390);
        canlemrz($image, 23, 675, imagecolorallocate($image, 28, 32, 31), $fontPath.'common/Arial/Arial Regular.ttf', $D2, 390);
        canlemrz($image, 23, 710, imagecolorallocate($image, 28, 32, 31), $fontPath.'common/Arial/Arial Regular.ttf', $D3, 390);
    }

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);

    if (!isset($user['rank']) || !in_array($user['rank'], ['admin', 'leader'])) {
        $requiredVIP = intval(preg_replace('/\D/', '', $TD->Setting('giataogiayto') ?? ''));
        $currentVIP = intval(preg_replace('/\D/', '', $plans->TD('tengoi', $taikhoan) ?? ''));
        if ($requiredVIP > 0 && $currentVIP < $requiredVIP) {
            $action = ($currentVIP === 0) ? "mua" : "tối thiểu";
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Vui lòng $action gói " . strtoupper($TD->Setting('giataogiayto')) . " để sử dụng tính năng fake cccd!",
            ]));
        }
    }

    die(JSON_FORMATTER([
        "status" => 200,
        "msg" => "Tạo CCCD New Cầm Tay Thành Công!",
        "img" => $base64,
        "info" => ['type' => [$loai], 'sex' => [$gioitinh ?? 'N/A']],
    ]));
}
