<?php
header('Content-Type: application/json');
if (isset($_POST['action']) && $_POST['action'] === 'fake-cccd-new') {
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ!"]));
    }

    $loai = $_POST["loai"];

    if ($loai === 'cccd-mat-truoc-new') {
        $hovaten = strtoupper(strtolower($_POST["hovaten"]))?? null;
        $gioitinh = $_POST["gioitinh"]?? null;
        $ngaysinh = $_POST["ngaysinh"]?? null;
        $socccd = $_POST["socccd"]?? null;
        $quoctich = $_POST["quoctich"]?? null;
        $anhthe = $_POST['anhthe'] ?? null;

        if (empty($hovaten) || empty($anhthe) || empty($ngaysinh) || empty($socccd) || empty($quoctich)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Không được bỏ trống mục nào!",
            ]));
        }

        if (!isDate($ngaysinh)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Ngày sinh không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm)",
            ]));
        }

        $phoicccd = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/giay-to/cccd-new/mat-truoc.jpg';

        if (!empty($anhthe)) {
            if (preg_match('/^data:image\/(\w+);base64,/', $anhthe, $type)) {
                $data = substr($anhthe, strpos($anhthe, ',') + 1);
                $type = strtolower($type[1]);

                if (!in_array($type, ['jpg', 'jpeg', 'png'])) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Ảnh thẻ chỉ hỗ trợ các định dạng JPG/PNG/JPEG.",
                    ]));
                }

                $data = base64_decode($data);
                if (!WsCheckIMG::SizeLimit(strlen($data), 4)) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Kích thước của ảnh không được vượt quá giới hạn cho phép (4MB).",
                    ]));
                }

                if ($data === false) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Lỗi giải mã dữ liệu ảnh thẻ.",
                    ]));
                }

                $phoicccd2 = imagecreatefromjpeg($phoicccd);
                $anhthe_img = imagecreatefromstring($data);
                imagecopyresampled($phoicccd2, $anhthe_img, 105, 333, 0, 0, 275, 367, imagesx($anhthe_img), imagesy($anhthe_img));
                imagedestroy($anhthe_img);
                $image = $phoicccd2;
            } else {
                die(JSON_FORMATTER([
                    "status" => -1,
                    "msg" => "Vui lòng upload file ảnh thẻ.",
                ]));
            }
        } else {
            $image = imagecreatefromjpeg($phoicccd);
        }

    } else {
        // Mặt sau giữ nguyên
        $ngaylamcccd = $_POST["ngaylam-cccd"];
        $ngayhethan = $_POST["ngayhethan"];
        $quequan = $_POST["quequan"];
        $thuongtru = $_POST["thuongtru"];
        $hovaten = $_POST["hovaten"];
        $ngaysinh = $_POST["ngaysinh"];
        $gioitinh = $_POST["gioitinh"];
        $mrz = $_POST["mrz"];
        $socccd = $_POST["socccd"]?? null;

        if (!isDate($ngaylamcccd)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Ngày làm cccd không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm)",
            ]));
        }

        $phoicccd = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/giay-to/cccd-new/mat-sau.jpg';
        $image = imagecreatefromjpeg($phoicccd);
    }

    $fontPath = $_SERVER['DOCUMENT_ROOT'].'/'.__FONTS__.'/';

    function infocccd($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
    {
        $fontSize = $fontsize;
        $x = $customX !== null ? $customX : 753;
        imagettftext($image, $fontSize, 0, $x, $y, $textColor, $font, $text);
    }

    function Rn($length) {
        return substr(str_shuffle(str_repeat('0123456789', $length)), 0, $length);
    }
    
    function canlematsau($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $x = $customX !== null ? $customX : 753;
            $shadow = imagecolorallocate($image, 0, 0, 0);
            $maxChars = 25; // tối đa
            $words = explode(' ', $text);
            $lines = [];
            $currentLine = '';
            
    foreach ($words as $word) {
        if (mb_strlen($currentLine . ' ' . $word, 'UTF-8') <= $maxChars) {
            $currentLine .= ($currentLine === '' ? '' : ' ') . $word;
        } else {
            if (count($lines) >= 1) {
                $currentLine .= ' ' . $word;
            } else {
                $lines[] = $currentLine;
                $currentLine = $word;
            }
        }
    }

    if (!empty($currentLine)) {
        $lines[] = $currentLine;
    }

    if (count($lines) > 2) {
        $lines = array_slice($lines, 0, 2);
    }

    foreach ($lines as $index => $line) {
        $offsetX = $index > 0 ? -350 : 0; // dòng 2 thụt vô
        imagettftext($image, $fontSize, 0, $x + $offsetX, $y, $shadow, $font, $line);
        imagettftext($image, $fontSize, 0, round($x + $offsetX + 0.1), round($y + 0), $textColor, $font, $line);
        $y += $fontSize + 8;
    }
}

function canlematsau1($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $x = $customX !== null ? $customX : 753;
            $shadow = imagecolorallocate($image, 0, 0, 0);
            $maxChars = 18; // tối đa
            $words = explode(' ', $text);
            $lines = [];
            $currentLine = '';
            
    foreach ($words as $word) {
        if (mb_strlen($currentLine . ' ' . $word, 'UTF-8') <= $maxChars) {
            $currentLine .= ($currentLine === '' ? '' : ' ') . $word;
        } else {
            if (count($lines) >= 1) {
                $currentLine .= ' ' . $word;
            } else {
                $lines[] = $currentLine;
                $currentLine = $word;
            }
        }
    }

    if (!empty($currentLine)) {
        $lines[] = $currentLine;
    }

    if (count($lines) > 2) {
        $lines = array_slice($lines, 0, 2);
    }

    foreach ($lines as $index => $line) {
        $offsetX = $index > 0 ? -440 : 0; // dòng 2 thụt vô
        imagettftext($image, $fontSize, 0, $x + $offsetX, $y, $shadow, $font, $line);
        imagettftext($image, $fontSize, 0, round($x + $offsetX + 0.1), round($y + 0), $textColor, $font, $line);
        $y += $fontSize + 8;
    }
}

    
    function MRZ() {
        global $socccd;
        $id = 'IDVNM'.Rn(10).$socccd.'<<'.Rn(1);
        $line2 = Rn(8).'M'.Rn(8).'VNM';
        $randomNumber = Rn(1);
        $line2 .= str_repeat('<', 30 - strlen($line2) - 2);
        $line2 .= $randomNumber;
        return [$id, $line2];
    }

    function canlemrz($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
    {
        $x = $customX !== null ? $customX : 370;
        imagettftext($image, $fontsize, 0, $x, $y, $textColor, $font, $text);
    }

    if ($loai === 'cccd-mat-truoc-new') {
        //              size, dọc                                                                                           ngang
        infocccd($image, 40, 455, imagecolorallocate($image, 39, 39, 39), $fontPath.'common/Arial/Arial Bold.ttf', $socccd, 420);
        infocccd($image, 35, 560, imagecolorallocate($image, 39, 39, 39), $fontPath.'common/Arial/Arial Regular.ttf', $hovaten, 420);
        infocccd($image, 30, 660, imagecolorallocate($image, 39, 39, 39), $fontPath.'common/Arial/Arial Regular.ttf', $ngaysinh, 420);
        infocccd($image, 30, 660, imagecolorallocate($image, 39, 39, 39), $fontPath.'common/Arial/Arial Regular.ttf', $gioitinh, 970);
        infocccd($image, 30, 742, imagecolorallocate($image, 39, 39, 39), $fontPath.'common/Arial/Arial Regular.ttf', $quoctich, 450);
    } 
    else 
    {
        [$D1, $D2] = MRZ();
        $D3 = $mrz.str_repeat('<', 30 - strlen($mrz)-3);

        $qrcode = sprintf(
            'https://quickchart.io/qr?text=%s&light=0000&ecLevel=H&format=png&size=700',
            urlencode(sprintf('%s|%s|%s|%s|%s|%s|%s',
                $socccd,
                WsRandomString::Number(9),
                                     $hovaten ?? '',
                str_replace('/', '', $ngaysinh ?? ''),
                                     $gioitinh ?? '',
                                     $thuongtru ?? '',
                str_replace('/', '', $ngayhethan ?? '')
            ))
        );

        $qr_img = imagecreatefrompng($qrcode);
        imagecopyresampled($image, $qr_img, 895, 40, 0, 0, 333, 333, imagesx($qr_img), imagesy($qr_img));
        //                  size, dọc                                                                                           ngang
        canlematsau($image, 30, 100, imagecolorallocate($image, 39, 39, 39), $fontPath.'common/Arial/Arial Regular.ttf', $thuongtru, 450);
        canlematsau1($image, 30, 205, imagecolorallocate($image, 39, 39, 39), $fontPath.'common/Arial/Arial Regular.ttf', $quequan, 540);
        infocccd($image, 30, 340, imagecolorallocate($image, 39, 39, 39), $fontPath.'common/Arial/Arial Regular.ttf', $ngaylamcccd, 565);
        infocccd($image, 30, 420, imagecolorallocate($image, 39, 39, 39), $fontPath.'common/Arial/Arial Regular.ttf', $ngayhethan, 565);
        canlemrz($image, 46, 600, imagecolorallocate($image, 28, 32, 31), $fontPath.'common/Arial/Arial Regular.ttf', $D1, 100);
        canlemrz($image, 46, 670, imagecolorallocate($image, 28, 32, 31), $fontPath.'common/Arial/Arial Regular.ttf', $D2, 100);
        canlemrz($image, 46, 740, imagecolorallocate($image, 28, 32, 31), $fontPath.'common/Arial/Arial Regular.ttf', $D3, 100);
    }

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);

    if (!isset($user['rank']) || !in_array($user['rank'], ['admin', 'leader'])) {
        $requiredVIP = intval(preg_replace('/\D/', '', $TD->Setting('giataogiayto') ?? ''));
        $currentVIP = intval(preg_replace('/\D/', '', $plans->TD('tengoi', $taikhoan) ?? ''));
        if ($requiredVIP > 0 && $currentVIP < $requiredVIP) {
            $action = ($currentVIP === 0) ? "mua" : "tối thiểu";
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Vui lòng $action gói " . strtoupper($TD->Setting('giataogiayto')) . " để sử dụng tính năng fake cccd!",
            ]));
        }
    }

    die(JSON_FORMATTER([
        "status" => 200,
        "msg" => "Tạo CCCD New thành công!",
        "img" => $base64,
        "info" => ['type' => [$loai], 'sex' => [$gioitinh ?? 'N/A']],
    ]));
}
