<?php
header('Content-Type: application/json');
if (isset($_POST['action']) && $_POST['action'] === 'fake-caopho') {
    if ($SSC->check()) {
        exit(JSON_FORMATTER(["status" => -1, 'msg' => "Vui lòng đăng nhập để sử dụng dịch vụ!"]));
    }
    $loai = $_POST["loai"];
    if ($loai === 'caopho') {
        $hovaten = strtoupper(strtolower($_POST["hovaten"])) ?? null;
        $gioitinh = $_POST["gioitinh"] ?? null;
        $ngaysinh = $_POST["ngaysinh"] ?? null;
        $socccd = $_POST["socccd"] ?? null;
        $quequan = $_POST["quequan"] ?? null;
        $thuongtru = $_POST["thuongtru"] ?? null;
        $ngayhethan = $_POST["ngayhethan"] ?? null;
        $quoctich = $_POST["quoctich"] ?? null;
        $code1 = $_POST["code1"] ?? null;
        $code2 = $_POST["code2"] ?? null;
        $p = $_POST["p"] ?? null;
        $maso = $_POST["maso"] ?? null;
        $noicap = $_POST["noicap"] ?? null;
        $dchi = $_POST["dchi"] ?? null;
        $noichon = $_POST["noichon"] ?? null;
        $gionhapquan = $_POST["gionhapquan"] ?? null;
        $ngaynhapquan = $_POST["ngaynhapquan"] ?? null;
        $giodongquan = $_POST["giodongquan"] ?? null;
        $ngaydongquan = $_POST["ngaydongquan"] ?? null;
        $anhthe = $_POST['anhthe'] ?? null;

        if (empty($hovaten) || empty($ngaysinh) || empty($socccd) || empty($quequan) || empty($noicap) || empty($thuongtru) || empty($ngayhethan) || empty($quoctich)) {
            die(JSON_FORMATTER([
                "status" => -1,
                "msg" => "Không được bỏ trống mục nào!",
            ]));
        }

        //if (!isDate($ngaysinh)) {
        //    die(JSON_FORMATTER([
        //        "status" => -1,
        //        "msg" => "Ngày sinh không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm)",
        //    ]));
        //} elseif (!isDate($ngayhethan)) {
        //    die(JSON_FORMATTER([
        //        "status" => -1,
        //        "msg" => "Ngày hết hạn không hợp lệ, định dạng phải là dd/mm/yyyy (ngày/tháng/năm).",
        //    ]));
        //}

        if (!empty($anhthe)) {
            $phoicccd = $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/phoi/giay-to/caopho/caopho.jpg';
            if (preg_match('/^data:image\/(\w+);base64,/', $anhthe, $type)) {
                $data = substr($anhthe, strpos($anhthe, ',') + 1);
                $type = strtolower($type[1]);
                if (!in_array($type, ['jpg', 'jpeg', 'png'])) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Ảnh thẻ chỉ hỗ trợ các định dạng JPG/PNG/JPEG.",
                    ]));
                }
                $data = base64_decode($data);
                $size = strlen($data);
                if (!WsCheckIMG::SizeLimit($size, 4)) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Kích thước của ảnh không được vượt quá giới hạn cho phép (4MB).",
                    ]));
                }
                if ($data === false) {
                    die(JSON_FORMATTER([
                        "status" => -1,
                        "msg" => "Lỗi giải mã dữ liệu ảnh thẻ.",
                    ]));
                }
                $phoicccd2 = imagecreatefromjpeg($phoicccd);
                $anhthe_img = imagecreatefromstring($data);
                imagecopyresampled($phoicccd2, $anhthe_img, 790, 146, 0, 0, 415, 515, imagesx($anhthe_img), imagesy($anhthe_img));
                // ngang - dọc - - kích cỡ ảnh in lên ngang - dọc
                imagedestroy($anhthe_img);
                $image = $phoicccd2;
            } else {
                die(JSON_FORMATTER([
                    "status" => -1,
                    "msg" => "Vui lòng upload file ảnh thẻ.",
                ]));
            }
        } else {
            $phoicccd = $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/phoi/giay-to/caopho/caopho.jpg';
            $image = imagecreatefromjpeg($phoicccd);
        }

        $qrcode = sprintf(
            'https://quickchart.io/qr?text=%s&light=0000&ecLevel=H&format=png&size=700',
            urlencode(
                sprintf('%s|%s|%s|%s|%s|%s|%s',
                    $socccd,
                    WsRandomString::Number(9),
                    $hovaten,
                    str_replace('/', '', $ngaysinh),
                    $gioitinh,
                    $thuongtru,
                    str_replace('/', '', $ngayhethan)
                )
            )
        );
        $qr_img = imagecreatefrompng($qrcode);

        $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/' . __FONTS__ . '/';

        function infocccd($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $x = $customX !== null ? $customX : 753;
            imagettftext($image, $fontSize, 0, $x, $y, $textColor, $font, $text);
        }

        function noithuongchu($image, $fontsize, $y, $textColor, $font, $text, $customX = null)
        {
            $fontSize = $fontsize;
            $lineX = 753;
            $firstLineX = $customX !== null ? $customX : 753;
            $maxWidth = 8;
            $words = explode(' ', $text);
            $firstLine = '';
            $D2 = '';
            foreach ($words as $word) {
                $testLine = trim($firstLine . ' ' . $word);
                $textBoundingBox = imagettfbbox($fontSize, 0, $font, $testLine);
                $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
                if (mb_strlen($firstLine) < $maxWidth && $textWidth <= imagesx($image) - $firstLineX) {
                    $firstLine = $testLine;
                } else {
                    $D2 .= ($D2 ? ' ' : '') . $word;
                }
            }
            $firstLineWithoutComma = str_replace(',', '', $firstLine);
            if (!empty($firstLineWithoutComma)) {
                imagettftext($image, $fontSize, 0, $firstLineX, $y, $textColor, $font, trim($firstLineWithoutComma));
            }
            if (!empty($D2)) {
                imagettftext($image, $fontSize, 0, $lineX, $y + ($fontSize + 12), $textColor, $font, trim($D2));
            }
        }

        //imagecopyresampled($image, $qr_img, 1540, 890, 0, 0, 222, 222, imagesx($qr_img), imagesy($qr_img));
        //               cỡ, dọc                                                                                                    ngang
        infocccd($image, 55, 1270, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $hovaten, 550);
        infocccd($image, 70, 1390, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $ngaysinh, 950);
        
        infocccd($image, 48, 1505, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $p, 730);
        infocccd($image, 48, 1505, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $maso, 930);
        infocccd($image, 45, 1505, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $quequan, 1368);
        infocccd($image, 45, 1505, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $socccd, 1471);
        infocccd($image, 45, 1505, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $thuongtru, 1670);
        
        infocccd($image, 43, 1605, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $ngayhethan, 795);
        infocccd($image, 43, 1605, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $quoctich, 1010);
        infocccd($image, 43, 1605, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $noicap, 1295);
        
        infocccd($image, 65, 1730, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $code1, 1020);
        infocccd($image, 45, 2310, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $code2, 930);
        infocccd($image, 45, 2390, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $dchi, 700);
        infocccd($image, 35, 2547, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $noichon, 500);
        
        infocccd($image, 45, 1970, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $gionhapquan, 825);
        infocccd($image, 45, 1970, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $ngaynhapquan, 1230);
        infocccd($image, 45, 2136, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $giodongquan, 825);
        infocccd($image, 45, 2136, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $ngaydongquan, 1230);
        //infocccd($image, 42, 2053, imagecolorallocate($image, 255, 255, 255), $fontPath . 'common/Arial/Arial Bold.ttf', $gioitinh, 753);
        
        ob_start();
        imagepng($image);
        $imageData = ob_get_clean();
        $base64 = base64_encode($imageData);
        imagedestroy($image);

        if (!isset($user['rank']) || !in_array($user['rank'], ['admin', 'leader'])) {
            $requiredVIP = intval(preg_replace('/\D/', '', $TD->Setting('giataogiayto') ?? ''));
            $currentVIP = intval(preg_replace('/\D/', '', $plans->TD('tengoi', $taikhoan) ?? ''));
            if ($requiredVIP > 0 && $currentVIP < $requiredVIP) {
                $action = ($currentVIP === 0) ? "mua" : "tối thiểu";
                die(JSON_FORMATTER([
                    "status" => -1,
                    "msg" => "Vui lòng $action gói " . strtoupper($TD->Setting('giataogiayto')) . " để sử dụng tính năng fake giấy tờ!",
                ]));
            }
        }

        die(JSON_FORMATTER([
            "status" => 200,
            "msg" => "Tạo cáo phó thành công!",
            "img" => $base64,
            "info" => ['type' => [$loai], 'sex' => [$gioitinh ?? 'N/A']],
        ]));
    }
}
