<?php

use LavenderFakebill\Models\Object\Render\Watermark;

if (isset($_POST['action']) && $_POST['action'] === 'vietcombank-priority-new') {
    $tennguoinhan = $_POST["tennguoinhan"];
    $stk = $_POST["stk"];
    $sotienchuyen = FormatNumber::PREG($_POST["sotienchuyen"]);
    $nganhangnhan = $_POST["nganhangnhan"];
    $thoigianchuyen = $_POST["thoigianchuyen"];
    $thoigiantrendt = $_POST["thoigiantrendt"];
    $magiaodich = $_POST["magiaodich"];
    $noidungchuyen = $_POST["noidungchuyen"];
    $kieuchuyen = $_POST["kieuchuyen"];
    $mathamchieu = $_POST["mathamchieu"];

    $phoiBank = $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/phoi/bill/vcbprinew.png';
    $fontPath = $_SERVER['DOCUMENT_ROOT'] . '/' . __FONTS__ . '/';
    $image = imagecreatefrompng($phoiBank);

    $iconBankPath = $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/icon/bank/' . $nganhangnhan . '.png';
    $iconBankPath = $kieuchuyen === 'trongbank' ? $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/icon/bank/vcb-vip.png' : $_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/icon/bank/' . $nganhangnhan . '.png';

    require $_SERVER['DOCUMENT_ROOT'] . '/server/models/object/global/bill-settings/light.php';

    $statusBarTextColor = imagecolorallocate($image, 255, 255, 255);
    $vachsongColor = imagecolorallocate($image, 255, 255, 255);
    $iconTinHieuColor = imagecolorallocate($image, 255, 255, 255);
    $iconPinsColor = imagecolorallocate($image, 255, 255, 255);

    if (isset($_POST["xem-truoc"]) && $_POST["xem-truoc"] === 'yes') {
        $image = Watermark::Render($image);
    }

    function canchinhphai($image, $fontsize, $y, $textColor, $font, $text, $customX = 98)
    {
        $fontSize = $fontsize;
        $textBoundingBox = imagettfbbox($fontSize, 0, $font, $text);
        $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
        $imageWidth = imagesx($image);
        $x = $imageWidth - $textWidth - $customX;
        imagettftext($image, $fontSize, 0, $x, $y, $textColor, $font, $text);
    }

    function canchinhgiua($image, $fontsize, $y, $textColor, $font, $text)
    {
        $fontSize = (int)$fontsize;
        $textBoundingBox = imagettfbbox($fontSize, 0, $font, $text);
        $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
        $imageWidth = imagesx($image);
        $x = (int)(($imageWidth - $textWidth) / 2);
        $y = (int)$y;
        imagettftext($image, $fontSize, 0, $x, $y, $textColor, $font, $text);
    }

    function canletrai($image, $fontsize, $y, $textColor, $font, $text, $x_tcb)
    {
        $fontSize = (int)$fontsize;
        $x = (int)$x_tcb;
        $y = (int)$y;
        imagettftext($image, $fontSize, 0, $x, $y, $textColor, $font, $text);
    }

    function canlephai_banks($image, $y, $textColor, $font, $iconBankPath, $nganhang_stk, $fullname, $fontSize, $fullnameFont, $fullnameColor, $iconOffsetY = 5, $iconWidth = 40, $iconHeight = 40, $vtBankWidth = 80, $vtBankHeight = 80, $rightOffset = 68)
    {
        global $kieuchuyen;
        $iconVtBank = imagecreatefrompng($_SERVER['DOCUMENT_ROOT'] . '/' . __IMG__ . '/phoi/vt-bank.png');
        $iconVtBankResized = imagecreatetruecolor($vtBankWidth, $vtBankHeight);
        $transparent = imagecolorallocatealpha($iconVtBankResized, 0, 0, 0, 127);
        imagefill($iconVtBankResized, 0, 0, $transparent);
        imagecopyresampled($iconVtBankResized, $iconVtBank, 0, 0, 0, 0, $vtBankWidth, $vtBankHeight, imagesx($iconVtBank), imagesy($iconVtBank));
        $icon = imagecreatefrompng($iconBankPath);
        $resizedIcon = imagecreatetruecolor($iconWidth, $iconHeight);
        $transparent = imagecolorallocatealpha($resizedIcon, 0, 0, 0, 127);
        imagefill($resizedIcon, 0, 0, $transparent);
        imagecopyresampled($resizedIcon, $icon, 0, 0, 0, 0, $iconWidth, $iconHeight, imagesx($icon), imagesy($icon));
        $iconBankX = ($vtBankWidth - $iconWidth) / 2;
        $iconBankY = ($vtBankHeight - $iconHeight) / 2;
        imagecopy($iconVtBankResized, $resizedIcon, (int)$iconBankX, (int)$iconBankY, 0, 0, (int)$iconWidth, (int)$iconHeight);
        $textBoundingBox = imagettfbbox($fontSize, 0, $font, $nganhang_stk);
        $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
        $imageWidth = imagesx($image);
        $totalWidth = $vtBankWidth + 10 + $textWidth;
        $x = $imageWidth - $totalWidth - $rightOffset;
        $iconY = $y - $vtBankHeight + $iconOffsetY;
        imagecopy($image, $iconVtBankResized, $x, $iconY, 0, 0, $vtBankWidth, $vtBankHeight);
        imagettftext($image, $fontSize, 0, $x + $vtBankWidth + 10, $y, $textColor, $font, $nganhang_stk);
        $fullnameFontSize = $fontSize - ($kieuchuyen === 'trongbank' ? 7 : 6);
        $fullnameBoundingBox = imagettfbbox($fullnameFontSize, 0, $fullnameFont, $fullname);
        $fullnameWidth = $fullnameBoundingBox[2] - $fullnameBoundingBox[0];
        $fullnameX = $imageWidth - $fullnameWidth - $rightOffset;
        $fullnameY = $y + 50;
        imagettftext($image, $fullnameFontSize, 0, $fullnameX, $fullnameY, $fullnameColor, $fullnameFont, $fullname);
        imagedestroy($icon);
        imagedestroy($resizedIcon);
        imagedestroy($iconVtBank);
        imagedestroy($iconVtBankResized);
    }

    function canchinhphai_noidung($image, $fontSize, $y, $textColor, $font, $text, $lineHeight = 1.2, $defaultMaxCharsPerLine = 15, $rightOffset = 68)
    {
        $imageWidth = imagesx($image);
        $textLength = strlen($text);
        if ($textLength > 27) {
            $maxCharsPerLine = 25;
        } else {
            $maxCharsPerLine = $defaultMaxCharsPerLine;
        }
        $lines = explode("\n", wordwrap($text, $maxCharsPerLine, "\n"));
        for ($index = 0; $index < min(2, count($lines)); $index++) {
            $line = $lines[$index];
            $textBoundingBox = imagettfbbox($fontSize, 0, $font, $line);
            $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
            $x = $imageWidth - $textWidth - $rightOffset;
            imagettftext($image, (int)$fontSize, 0, (int)$x, (int)($y + ($index * $fontSize * $lineHeight)), $textColor, $font, $line);
        }
    }

    function canlephai($image, $fontsize, $y, $textColor, $font, $text, $rightOffset = 100)
    {
        $fontSize = $fontsize;
        $textBoundingBox = imagettfbbox($fontSize, 0, $font, $text);
        $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
        $x = imagesx($image) - $rightOffset - $textWidth;
        imagettftext($image, $fontSize, 0, $x, $y, $textColor, $font, $text);
    }

    if ($kieuchuyen === 'ngoaibank') {
        $vcbbank = [
            'vietinbank' => ['name' => 'Vietinbank', 'fullname' => 'Ngân hàng Công Thương Việt Nam'],
            'techcombank' => ['name' => 'Techcombank', 'fullname' => 'Ngân hàng Kỹ Thương Việt Nam'],
            'acbbank' => ['name' => 'ACB', 'fullname' => 'Ngân hàng TMCP Á Châu'],
            'agribank' => ['name' => 'Agribank', 'fullname' => 'Ngân hàng Nông thôn Việt Nam'],
            'bidv' => ['name' => 'BIDV', 'fullname' => 'Ngân hàng Đầu tư và phát triển Việt Nam'],
            'msb' => ['name' => 'MSB', 'fullname' => 'Ngân hàng TMCP Hàng Hải Việt Nam'],
            'sacombank' => ['name' => 'Sacombank', 'fullname' => 'Ngân hàng Sài Gòn Thương Tín'],
            'mbbank' => ['name' => 'MB', 'fullname' => 'Ngân hàng Quân đội'],
            'namabank' => ['name' => 'Nam Á Bank', 'fullname' => 'Ngân hàng thương mại cổ phần Nam Á'],
            'ocb' => ['name' => 'OCB', 'fullname' => 'Ngân Hàng TMCP Phương Đông'],
            'tpbank' => ['name' => 'TP Bank', 'fullname' => 'Ngân hàng Cổ phần Tiên Phong'],
            'vpbank' => ['name' => 'VP Bank', 'fullname' => 'Ngân hàng Việt Nam Thịnh Vượng'],
            'shb' => ['name' => 'SHB', 'fullname' => 'Ngân hàng TMCP Sài Gòn Hà Nội'],
            'sgb' => ['name' => 'MSB', 'fullname' => 'Ngân hàng Sài Gòn Công Thương'],
            'oceanbank' => ['name' => 'OceanBank', 'fullname' => 'Ngân hàng Đại Dương'],
        ];
        $nganhang_stk = isset($vcbbank[$nganhangnhan]) ? strtoupper($vcbbank[$nganhangnhan]['name']) : strtoupper($nganhangnhan);
        $fullnamebank = isset($vcbbank[$nganhangnhan]) ? $vcbbank[$nganhangnhan]['fullname'] : '';
    } else {
        $nganhang_stk = 'Vietcombank';
        $fullnamebank = 'Ngân hàng TMCP Ngoại thương Việt Nam';
    }

    $stc = FormatNumber::TD($sotienchuyen, 2);
    $vnd = 'VND';
    $textBox = imagettfbbox(45, 0, $fontPath . 'vietcombank/Manrope-Bold.ttf', $stc);
    $textWidth = $textBox[2] - $textBox[0];
    $vndBox = imagettfbbox(22, 0, $fontPath . 'vietcombank/SVN-Arial 3.ttf', $vnd);
    $vndWidth = $vndBox[2] - $vndBox[0];
    $imageWidth = imagesx($image);
    $padding = 22;
    $xAmount = ($imageWidth - $textWidth - $vndWidth - $padding) / 2;
    $yAmount = 541;
    $xVND = $xAmount + $textWidth + $padding;
    $yVND = 513;
    $xAmount = round($xAmount);
    $yAmount = round($yAmount);
    $xVND = round($xVND);
    $yVND = round($yVND);

    imagettftext($image, 46, 0, $xAmount, $yAmount, imagecolorallocate($image, 233, 202, 156), $fontPath . 'vietcombank/Manrope-Bold.ttf', $stc);
    imagettftext($image, 25, 0, $xVND, $yVND, imagecolorallocate($image, 235, 202, 156), $fontPath . 'vietcombank/SVN-Arial 3.ttf', $vnd);

    canlephai($image, 28, 719, imagecolorallocate($image, 255, 255, 255), $fontPath . 'vietcombank/UTM HelveBold.ttf', $stk, 75);

    canlephai($image, 28, 833, imagecolorallocate($image, 255, 255, 255), $fontPath . 'vietcombank/UTM HelveBold.ttf', $tennguoinhan, 75);

    canchinhgiua($image, 25, 607, imagecolorallocate($image, 128, 128, 128), $fontPath . 'common/Helvetica/Helvetica.ttf', $thoigianchuyen);
    imagettftext($image, 32, 0, 105, 63, $statusBarTextColor, $fontPath . 'common/San Francisco/SanFranciscoDisplay-Semibold.otf', $thoigiantrendt);

    canlephai_banks($image, 935, imagecolorallocate($image, 255, 255, 255), $fontPath . 'vietcombank/UTM HelveBold.ttf', $iconBankPath, $nganhang_stk, $fullnamebank, 28, $fontPath . 'vietcombank/SVN-Arial 3.ttf', imagecolorallocate($image, 255, 255, 255), 17, 35, 35, 60, 60, 79);

    canchinhphai_noidung($image, 28, 1075, imagecolorallocate($image, 255, 255, 255), $fontPath . 'vietcombank/UTM HelveBold.ttf', $noidungchuyen, 1.9, 15, 77);

    canlephai($image, 29, 1520, imagecolorallocate($image, 255, 255, 255), $fontPath . 'vietcombank/UTM HelveBold.ttf',
        $kieuchuyen === 'trongbank'
    );

    canlephai($image, 28, 1230, imagecolorallocate($image, 255, 255, 255), $fontPath . 'vietcombank/UTM HelveBold.ttf', $mathamchieu, 120);

    canlephai($image, 29, 1590, imagecolorallocate($image, 255, 255, 255), $fontPath . 'vietcombank/UTM HelveBold.ttf', $magiaodich, 79);

    CaiDatPhuTro($image, $vachsong, $iconTinHieu, $iconPins, $_POST["tin-hieu"], $iconDynamicsIsland);

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);
    $namebill = ['Vietcombank-Priority-New', 'Chuyển Khoản'];
    require($_SERVER['DOCUMENT_ROOT'] . '/server/models/object/global/checkRenderModel.php');
}