<?php
use LavenderFakebill\Models\Object\Render\Watermark;
if (isset($_POST['action']) && $_POST['action'] === 'mbbank-private-donluu') {
    $tennguoinhan = $_POST["tennguoinhan"];
    $stk = $_POST["stk"];
    $sotienchuyen = FormatNumber::PREG($_POST["sotienchuyen"]);
    $gd = FormatNumber::PREG($_POST["gd"]);
    $nganhangnhan = $_POST["nganhangnhan"];
    $thoigianchuyen = $_POST["thoigianchuyen"];
    $thoigiantrendt = $_POST["thoigiantrendt"];
    $noidungchuyen = $_POST["noidungchuyen"];
    $convertGD = [
        1 => ['themeName' => 'mb-private', 'colorTime' => '214,207,199', 'themeDisplay' => 'light', 'colorMoney' => '203,182,151', 'colorContent' => '249,249,246'],
    ];
    $gdData = $convertGD[$gd] ?? [
        'themeName' => 'mb-private',
        'colorTime' => '255,255,255',
        'themeDisplay' => 'light',
        'colorMoney' => '37,231,255',
        'colorContent' => '255,255,255'
    ];
    $themeName = $gdData['themeName'];
    $themeDisplay = $gdData['themeDisplay'];
    list($rTime, $gTime, $bTime) = explode(',', $gdData['colorTime']);
    list($rMoney, $gMoney, $bMoney) = explode(',', $gdData['colorMoney']);
    list($rContent, $gContent, $bContent) = explode(',', $gdData['colorContent']);
    $phoiBank = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/bill/don-luu/'.$themeName.'.jpeg';
    $fontPath = $_SERVER['DOCUMENT_ROOT'].'/'.__FONTS__.'/';
    $iconBank = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/icon/bank/'.$nganhangnhan.'.png';
    $image = imagecreatefromjpeg($phoiBank);
    if (isset($_POST["xem-truoc"]) && $_POST["xem-truoc"] === 'yes') {
        $image = Watermark::Render($image,1,30,100);
    }    

    // ============= CÁC HÀM CŨ =============
    function canchinhphai($image, $fontsize, $y, $textColor, $font, $text, $customX = 98) {
        $textBoundingBox = imagettfbbox($fontsize, 0, $font, $text);
        $textWidth = $textBoundingBox[2] - $textBoundingBox[0];
        $imageWidth = imagesx($image);
        $x = $imageWidth - $textWidth - $customX;
        imagettftext($image, $fontsize, 0, $x, $y, $textColor, $font, $text);
    }

    function canchinhgiua($image, $fontsize, $y, $textColor, $font, $text) {
        $textBoundingBox = imagettfbbox($fontsize, 0, $font, $text);
        $textWidth = (int) ($textBoundingBox[2] - $textBoundingBox[0]);
        $imageWidth = imagesx($image);
        $x = (int) (($imageWidth - $textWidth) / 2);
        imagettftext($image, $fontsize, 0, $x, $y, $textColor, $font, $text);
    }

    function canletrai($image, $fontsize, $y, $textColor, $font, $text, $x_tcb) {
        imagettftext($image, $fontsize, 0, $x_tcb, $y, $textColor, $font, $text);
    }

    // ============= HÀM MỚI: VẼ [icon + bank + stk] =============
    function cangiua_nganhang_stk($image, $y, $textColor, $font, $iconBankPath, $name_bank, $stk, $fontSize, $stkSize, $iconOffsetY = 5) {
        $icon = imagecreatefrompng($iconBankPath);
        list($iconWidth, $iconHeight) = ($name_bank === 'ACB') ? [64, 64] : [49, 49];

        $resizedIcon = imagecreatetruecolor($iconWidth, $iconHeight);
        imagealphablending($resizedIcon, false);
        imagesavealpha($resizedIcon, true);
        imagecopyresampled($resizedIcon, $icon, 0, 0, 0, 0, $iconWidth, $iconHeight, imagesx($icon), imagesy($icon));

        // text: "TênBank - STK"
        $fullText = $name_bank . ' - ' . $stk;

        $textBoundingBox = imagettfbbox($fontSize, 0, $font, $fullText);
        $textWidth = $textBoundingBox[2] - $textBoundingBox[0];

        $imageWidth = imagesx($image);
        $totalWidth = $iconWidth + 20 + $textWidth;
        $x = ($imageWidth - $totalWidth) / 2;
        $iconY = $y - $iconHeight + $iconOffsetY;

        // vẽ icon
        imagecopy($image, $resizedIcon, round($x), round($iconY), 0, 0, $iconWidth, $iconHeight);

        // vẽ text
        imagettftext($image, $fontSize, 0, round($x + $iconWidth + 18), $y, $textColor, $font, $fullText);

        imagedestroy($icon);
        imagedestroy($resizedIcon);
    }

    // ============= MAPPING BANK =============
    $mbbank = [
        'vietinbank' => 'Vietinbank (CTG)',
        'vietcombank' => 'Vietcombank (VCB)',
        'techcombank' => 'Techcombank (TCB)',
        'acbbank' => 'ACB',
        'agribank' => 'Agribank (ARB)',
        'bidv' => 'BIDV (BIDV)',
        'sacombank' => 'Sacombank (STB)',
        'mbbank' => 'MBBank (MB)',
        'namabank' => 'NamABank',
        'dongabank' => 'DongABank',
        'ocb' => 'OCB',
        'tpbank' => 'TP Bank (TPB)',
        'vpbank' => 'VP Bank (VPB)',
        'sgb' => 'Saigonbank (SGB)',
        'vib' => 'VIB',
        'seabank' => 'SeAbank',
    ];
    $name_bank = $mbbank[$nganhangnhan];

    $width = imagesx($image);
    $height = imagesy($image);
    $dest_img = imagecreatetruecolor($width, $height);
    imagecopy($dest_img, $image, 0, 0, 0, 0, $width, $height);

    // ============= VẼ =============
    canchinhgiua($dest_img, 47, 630, imagecolorallocate($image, $rMoney, $gMoney, $bMoney), $fontPath.'common/San Francisco/SanFranciscoDisplay-Semibold.otf', FormatNumber::TD($sotienchuyen, 2).' VND');
    canchinhgiua($dest_img, 22, 690, imagecolorallocate($image, $rTime, $gTime, $bTime), $fontPath.'common/AvertaStd/AvertaStd-Regular.otf', $thoigianchuyen);
    canchinhgiua($dest_img, 29, 820, imagecolorallocate($image, $rContent, $gContent, $bContent), $fontPath.'common/AvertaStd/AvertaStd-Semibold.otf', $tennguoinhan);

    // CHỈ GỌI 1 HÀM: [iconBank + tênBank - stk]
    cangiua_nganhang_stk(
        $dest_img,
        880,
        imagecolorallocate($image, $rContent, $gContent, $bContent),
        $fontPath.'common/AvertaStd/AvertaStd-Regular.otf',
        $iconBank,
        $name_bank,
        $stk,
        25,
        25,
        $name_bank === 'ACB' ? 18 : 12
    );

    canchinhgiua($dest_img, 25, 940, imagecolorallocate($image, $rContent, $gContent, $bContent), $fontPath.'common/AvertaStd/AvertaStd-Regular.otf', $noidungchuyen);

    ob_start();
    imagepng($dest_img);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($dest_img);
    $namebill = ['MB Bank','Đơn Lưu'];
    require($_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/checkRenderModel.php');
}
