<?php
use LavenderFakebill\Models\Object\Render\Watermark;

if (isset($_POST['action']) && $_POST['action'] === 'hanmuc-vcb') {
    $stk            = $_POST["stk"];
    $sotienchuyen   = FormatNumber::PREG($_POST["sotienchuyen"]);
    $thoigiantrendt = $_POST["thoigiantrendt"];
    $magiaodich     = $_POST["magiaodich"];
    $noidungchuyen  = $_POST["noidungchuyen"];

    $phoiBank = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/bill/hanmuc-vcb.png';
    $fontPath = $_SERVER['DOCUMENT_ROOT'].'/'.__FONTS__.'/';
    $image    = imagecreatefrompng($phoiBank);

    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/bill-settings/light.php';

    if (empty($iconPins) || !file_exists($iconPins)) {
        exit(JSON_FORMATTER(["status" => -1, "msg" => "Hãy chọn dung lượng pin ở cài đặt thông số."]));
    }

    // Xem trước → thêm watermark
    if (!empty($_POST["xem-truoc"]) && $_POST["xem-truoc"] === 'yes') {
        $image = Watermark::Render($image);
    } else {
        // ===== HÀM HỖ TRỢ =====
        function thanhphuc($image, $fontsize, $y, $color, $font, $text, $customX = 150) {
            $box  = imagettfbbox($fontsize, 0, $font, $text);
            $textWidth  = $box[2] - $box[0];
            $imageWidth = imagesx($image);
            $x = $imageWidth - $textWidth - $customX;
            imagettftext($image, $fontsize, 0, $x, $y, $color, $font, $text);
        }
        function canletrai($image, $fontsize, $y, $color, $font, $text, $x = 100) {
            imagettftext($image, $fontsize, 0, $x, $y, $color, $font, $text);
        }

        // ===== XỬ LÝ DỮ LIỆU =====
        $stc       = FormatNumber::TD($sotienchuyen, 2);
        $magiaodich= FormatNumber::TD($magiaodich, 2);
        $vnd       = 'VND';

        // Số tiền + VND
        thanhphuc($image, 45, 485, imagecolorallocate($image, 127,127,127), $fontPath.'vietcombank/Manrope-Bold.ttf', $stc, 270);
        thanhphuc($image, 33, 480, imagecolorallocate($image, 76,94,87),  $fontPath.'vietcombank/SVN-Arial 3.ttf', $vnd);

        // STK
        thanhphuc($image, 34, 385, imagecolorallocate($image, 127,127,127), $fontPath.'vietcombank/UTM HelveBold.ttf', $stk);

        // Thời gian
        canletrai($image, 36, 83, imagecolorallocate($image, 254,254,254), $fontPath.'common/San Francisco/SanFranciscoDisplay-Semibold.otf', $thoigiantrendt, 110);

        // Nội dung CK
        canletrai($image, 33, 1980, imagecolorallocate($image, 20,20,20), $fontPath.'vietcombank/UTM HelveBold.ttf', $noidungchuyen, 95);

        // Mã GD
        canletrai($image, 34, 1770, imagecolorallocate($image, 19,19,19), $fontPath.'vietcombank/Manrope-Bold.ttf', $magiaodich, 100);

        // Icon hệ thống
        CaiDatPhuTro($image, $vachsong, $iconTinHieu, $iconPins, $_POST["tin-hieu"], $iconDynamicsIsland);
    }

    // ===== XUẤT ẢNH =====
    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64    = base64_encode($imageData);
    imagedestroy($image);

    $namebill = ['Vietcombank','Hạn Mức'];
    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/checkRenderModel.php';
}
