<?php
use LavenderFakebill\Models\Object\Render\Watermark;

if (isset($_POST['action']) && $_POST['action'] === 'hanmuc-mb') {
    $stk            = $_POST["stk"];
    $sotienchuyen   = FormatNumber::PREG($_POST["sotienchuyen"]);
    $thoigiantrendt = $_POST["thoigiantrendt"];
    $magiaodich     = $_POST["magiaodich"];
    $noidungchuyen  = $_POST["noidungchuyen"];

    $phoiBank = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/bill/hanmuc-mb.png';
    $fontPath = $_SERVER['DOCUMENT_ROOT'].'/'.__FONTS__.'/';

    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/bill-settings/light.php';

    if (empty($iconPins) || !file_exists($iconPins)) {
        exit(JSON_FORMATTER(["status" => -1, "msg" => "Hãy chọn dung lượng pin ở cài đặt thông số."]));
    }

    $image = imagecreatefrompng($phoiBank);

    // === Hàm hỗ trợ ===
    function canletrai($image, $size, $y, $color, $font, $text, $x = 100) {
        imagettftext($image, (int)$size, 0, (int)$x, (int)$y, $color, $font, $text);
    }

    if (!empty($_POST["xem-truoc"]) && $_POST["xem-truoc"] === 'yes') {
        $image = Watermark::Render($image);
    } else {
        $stc = FormatNumber::TD($sotienchuyen, 2);

        // Số tiền + VND
        canletrai($image, 45, 650, imagecolorallocate($image, 6,8,12), $fontPath.'common/AvertaStd/AvertaStd-Regular.otf', $stc.' VND', 110);

        // STK
        canletrai($image, 29, 570, imagecolorallocate($image, 10,12,43), $fontPath.'common/San Francisco/SanFranciscoDisplay-Semibold.otf', $stk, 580);

        // Nội dung CK
        canletrai($image, 35, 1950, imagecolorallocate($image, 20,20,20), $fontPath.'common/AvertaStd/AvertaStd-Regular.otf', $noidungchuyen, 105);

        // Mã GD
        canletrai($image, 33, 1760, imagecolorallocate($image, 34,35,40), $fontPath.'common/AvertaStd/AvertaStd-Regular.otf', $magiaodich, 100);

        // Thời gian
        canletrai($image, 36, 83, imagecolorallocate($image, 254,254,254), $fontPath.'common/San Francisco/SanFranciscoDisplay-Semibold.otf', $thoigiantrendt, 110);

        // Icon phụ trợ
        CaiDatPhuTro($image, $vachsong, $iconTinHieu, $iconPins, $_POST["tin-hieu"], $iconDynamicsIsland);
    }

    // === Xuất ảnh ===
    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64    = base64_encode($imageData);
    imagedestroy($image);

    $namebill = ['MB Bank','Hạn Mức'];
    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/checkRenderModel.php';
}
