<?php
use LavenderFakebill\Models\Object\Render\Watermark;

if (isset($_POST['action']) && $_POST['action'] === 'hanmuc-bidv') {
    $stk            = $_POST["stk"];
    $sotienchuyen   = FormatNumber::PREG($_POST["sotienchuyen"]);
    $thoigiantrendt = $_POST["thoigiantrendt"];
    $noidungchuyen  = $_POST["noidungchuyen"];

    $phoiBank = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/bill/hanmuc-bidv.png';
    $fontPath = $_SERVER['DOCUMENT_ROOT'].'/'.__FONTS__.'/';

    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/bill-settings/light.php';

    if (empty($iconPins) || !file_exists($iconPins)) {
        exit(JSON_FORMATTER(["status" => -1, "msg" => "Hãy chọn dung lượng pin ở cài đặt thông số."]));
    }

    $image = imagecreatefrompng($phoiBank);

    // === Hàm hỗ trợ ===
    function canletrai($image, $size, $y, $color, $font, $text, $x = 100) {
        imagettftext($image, (int)$size, 0, (int)$x, (int)$y, $color, $font, $text);
    }

    if (!empty($_POST["xem-truoc"]) && $_POST["xem-truoc"] === 'yes') {
        $image = Watermark::Render($image);
    } else {
        $stc = FormatNumber::TD($sotienchuyen, 2);

        // Số tiền + VND
        canletrai($image, 32, 535, imagecolorallocate($image, 45,46,46), $fontPath.'common/Mulish/chuan.ttf', $stc.' VND', 400);

        // STK
        canletrai($image, 30, 468, imagecolorallocate($image, 45,46,46), $fontPath.'common/Mulish/chuan.ttf', $stk, 475);

        // Thời gian
        canletrai($image, 36, 83, imagecolorallocate($image, 254,254,254), $fontPath.'common/San Francisco/SanFranciscoDisplay-Semibold.otf', $thoigiantrendt, 110);

        // Nội dung CK
        canletrai($image, 36, 1750, imagecolorallocate($image, 25,25,25), $fontPath.'vietcombank/UTM HelveBold.ttf', $noidungchuyen, 95);

        // Icon phụ trợ
        CaiDatPhuTro($image, $vachsong, $iconTinHieu, $iconPins, $_POST["tin-hieu"], $iconDynamicsIsland);
    }

    // === Xuất ảnh ===
    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64    = base64_encode($imageData);
    imagedestroy($image);

    $namebill = ['BIDV','Hạn Mức'];
    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/checkRenderModel.php';
}
