<?php
use LavenderFakebill\Models\Object\Render\Watermark;

if (isset($_POST['action']) && $_POST['action'] === 'bdsd-agribank') {
    $stk = FormatNumber::PREG($_POST["stk"]);
    $thoigiantrendt = $_POST["thoigiantrendt"];

    // === BDSD 1 === //
    $sotiengd = FormatNumber::PREG($_POST["sotiengd"]);
    $soduchinh = $_POST["soduchinh"];
    $phuongthuc = $_POST["phuongthuc"];
    $noidungchuyen = $_POST["noidungchuyen"];
    $time = $_POST["time"];

    // === BDSD 2 === //
    $sotiengd2 = FormatNumber::PREG($_POST["sotiengd2"]);
    $soduchinh2 = $_POST["soduchinh2"];
    $phuongthuc2 = $_POST["phuongthuc2"];
    $noidungchuyen2 = $_POST["noidungchuyen2"];
    $time2 = $_POST["time2"];

    // === BDSD 3 === //
    $sotiengd3 = FormatNumber::PREG($_POST["sotiengd3"]);
    $soduchinh3 = $_POST["soduchinh3"];
    $phuongthuc3 = $_POST["phuongthuc3"];
    $noidungchuyen3 = $_POST["noidungchuyen3"];
    $time3 = $_POST["time3"];

    // === BDSD 4 === //
    $sotiengd4 = FormatNumber::PREG($_POST["sotiengd4"]);
    $soduchinh4 = $_POST["soduchinh4"];
    $phuongthuc4 = $_POST["phuongthuc4"];
    $noidungchuyen4 = $_POST["noidungchuyen4"];
    $time4 = $_POST["time4"];

    $phoiBank = $_SERVER['DOCUMENT_ROOT'].'/'.__IMG__.'/phoi/bill/bdsd/agribank.png';
    $fontPath = $_SERVER['DOCUMENT_ROOT'].'/'.__FONTS__.'/';
    $image = imagecreatefrompng($phoiBank);

    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/bill-settings/light.php';

    // ==== Hàm kiểm tra font ====
    function safeFont($path, $fallback) {
        if (file_exists($path)) {
            return $path;
        } else {
            error_log("Font not found: ".$path.", fallback to ".$fallback);
            return $fallback;
        }
    }

    // ==== Hàm viết chữ căn trái ====
    function canletraibdsdvcb($image, $fontsize, $y, $textColor, $font, $text, $x_tcb) {
        $fontSize = $fontsize;
        $lines = explode('<br>', $text);
        $lineHeight = $fontsize * 1.5;
        foreach ($lines as $i => $line) {
            $yOffset = $y + ($i * $lineHeight);
            imagettftext($image, $fontSize, 0, $x_tcb, $yOffset, $textColor, $font, $line);
        }
    }

    // ==== Hàm in BDSD ====
    // ==== Hàm in BDSD (sửa: nhận dạng phuongthuc bằng substring, case-insensitive) ====
function in_bdsd($image, $stk, $sotien, $soduchinh, $noidung, $time, $y, $phuongthuc, $fontPath) {
    // Màu
    $black = imagecolorallocate($image, 50,58,62);
    $red   = imagecolorallocate($image, 220,0,0);
    $green = imagecolorallocate($image, 0,160,0);
    $gray  = imagecolorallocate($image, 131,131,131);

    // Font (dùng safeFont như bạn đã có)
    $fontRegular = safeFont($fontPath.'common/San Francisco/SanFranciscoText-Medium.otf', $fontPath.'common/Noto Sans/NotoSans-Regular.ttf');
    $fontBold    = safeFont($fontPath.'common/San Francisco/SanFranciscoText-Bold.otf', $fontPath.'common/Noto Sans/NotoSans-Bold.ttf');

    $x = 90;

    // Chuẩn hóa phuongthuc để so sánh
    $method = strtolower(trim((string)$phuongthuc));

    // Xác định là chuyển tiền (debit) hay nhận/nạp (credit)
    $isDebit = false;
    if ($method !== '') {
        if (strpos($method, 'chuyentien') !== false) {
            $isDebit = true;
        } elseif (strpos($method, 'nhantien') !== false || strpos($method, 'naptien') !== false) {
            $isDebit = false;
        } else {
            // fallback: nếu không rõ, thử nhìn vào dấu ở trước số tiền (nếu có)
            $raw = trim((string)$sotien);
            if (strlen($raw) > 0 && ($raw[0] === '-')) {
                $isDebit = true;
            } else {
                $isDebit = false;
            }
            error_log("in_bdsd(): unknown phuongthuc='$phuongthuc' -> assumed " . ($isDebit ? "chuyentien" : "nhantien"));
        }
    }

    // STK in đậm
    imagettftext($image, 35, 0, $x, $y, $black, $fontRegular, "Tài khoản: ");
    imagettftext($image, 35, 0, $x + 230, $y, $black, $fontBold, $stk);

    // Số tiền GD
    $soTienText = FormatNumber::TD($sotien,2)." VND";

    imagettftext($image, 35, 0, $x, $y + 50, $black, $fontRegular, "Số tiền GD: ");

    // in dấu + / - và số tiền (màu tùy debit/credit)
    if ($isDebit) {
        imagettftext($image, 35, 0, $x + 250, $y + 50, $red, $fontBold, "-");
        imagettftext($image, 35, 0, $x + 280, $y + 50, $red, $fontRegular, $soTienText);
    } else {
        imagettftext($image, 35, 0, $x + 250, $y + 50, $green, $fontBold, "+");
        imagettftext($image, 35, 0, $x + 280, $y + 50, $green, $fontRegular, $soTienText);
    }

    // Số dư cuối
    imagettftext($image, 35, 0, $x, $y + 100, $black, $fontRegular, "Số dư cuối: ".$soduchinh." VND");

    // Nội dung
    imagettftext($image, 35, 0, $x, $y + 150, $black, $fontRegular, "Nội dung: ".$noidung);

    // Thời gian (bên trái nhỏ)
    canletraibdsdvcb($image, 26, $y - 70, $gray, $fontRegular, $time, 90);
}


    // ==== In 4 dòng BDSD ====
    in_bdsd($image, $stk, $sotiengd,  $soduchinh,  $noidungchuyen,  $time,  800,  $phuongthuc,  $fontPath);
    in_bdsd($image, $stk, $sotiengd2, $soduchinh2, $noidungchuyen2, $time2, 1240, $phuongthuc2, $fontPath);
    in_bdsd($image, $stk, $sotiengd3, $soduchinh3, $noidungchuyen3, $time3, 1680, $phuongthuc3, $fontPath);
    in_bdsd($image, $stk, $sotiengd4, $soduchinh4, $noidungchuyen4, $time4, 2120, $phuongthuc4, $fontPath);

    // Thời gian trên điện thoại
    $fontSemiBold = safeFont($fontPath.'common/San Francisco/SanFranciscoDisplay-Semibold.otf', $fontPath.'common/Noto Sans/NotoSans-Bold.ttf');
    imagettftext($image, 31, 0, 90, 73, imagecolorallocate($image, 251,252,253), $fontSemiBold, $thoigiantrendt);

    // Render các icon phụ
    CaiDatPhuTro($image, $vachsong, $iconTinHieu, $iconPins, $_POST["tin-hieu"], $iconDynamicsIsland);

    // Xem trước có watermark
    if (isset($_POST["xem-truoc"]) && $_POST["xem-truoc"] === 'yes') {
        $image = Watermark::Render($image,0.8,20,120);
    }

    // Xuất ảnh base64
    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);

    $namebill = ['Agribank','Biến Động'];
    require($_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/checkRenderModel.php');
}
