<?php
use LavenderFakebill\Models\Object\Render\Watermark;


if (isset($_POST['action']) && $_POST['action'] === 'bdsd-acb') {
    require_once($_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/bill-settings/func.php');

    $stk_chinh = FormatNumber::PREG($_POST["stk"]);
    $sotiengd_arr = $_POST["sotiengd"];
    $soduchinh_arr = $_POST["soduchinh"];
    $phuongthuc_arr = $_POST["phuongthuc"];
    $thoigianchuyen_arr = $_POST["thoigianchuyen"];
    $noidungchuyen_arr = $_POST["noidungchuyen"];

    $thoigiantrendt = $_POST["thoigiantrendt"];

    $_POST['action'] = 'bdsd-acb';
    $GLOBALS['billType'] = 'bdsd-acb';

    $GLOBALS['pin'] = isset($_POST['pin']) ? $_POST['pin'] : 83;
    $GLOBALS['vachsong'] = isset($_POST['vachsong']) ? $_POST['vachsong'] : '3';
    $GLOBALS['tin-hieu'] = isset($_POST['tin-hieu']) ? $_POST['tin-hieu'] : 'wifi-3';
    $GLOBALS['dynamics'] = isset($_POST['dynamics']) ? $_POST['dynamics'] : '2';
    $GLOBALS['control_dynamic'] = isset($_POST['control-dynamic']) && $_POST['control-dynamic'] === 'on';
    $GLOBALS['percent_pin'] = isset($_POST['percent-pin']) && $_POST['percent-pin'] === 'on';

    $GLOBALS['fontPath'] = $_SERVER['DOCUMENT_ROOT'].'/public/src/vtd/fonts/';

    $baseIconPath = $_SERVER['DOCUMENT_ROOT'].'/public/src/vtd/img/';
    $displayNetworkType = $configDefault[$GLOBALS['billType']]['displayTinHieu'];
    $networkPath = $baseIconPath.'phoi/networks/'.$displayNetworkType.'/';

    $GLOBALS['DynamicsIsland'] = $GLOBALS['control_dynamic'] ? ($GLOBALS['dynamics'] ?? '') : '';
    $GLOBALS['vachsong'] = $networkPath.'nw-'.($GLOBALS['vachsong'] ?? null).'.png';
    $GLOBALS['iconTinHieu'] = $networkPath.($GLOBALS['tin-hieu'] ?? null).'.png';

    $batteryType = ($GLOBALS['percent_pin'] === true) ? 'battery-x' : 'battery-z';
    $GLOBALS['iconPins'] = $baseIconPath.'phoi/'.$batteryType.'/'.$displayNetworkType.'/'.$GLOBALS['pin'].'.png';
    $GLOBALS['iconDynamicsIsland'] = $baseIconPath.'phoi/dynamics/'.$GLOBALS['DynamicsIsland'].'.png';


    $phoiBank = $_SERVER['DOCUMENT_ROOT'].'/public/src/vtd/img/phoi/bill/bdsd/acb-bdsd.png';
    $dotImagePath = $_SERVER['DOCUMENT_ROOT'].'/public/src/vtd/img/icon/dot_green-removebg.png';
    if (!file_exists($dotImagePath)) {
        exit(JSON_FORMATTER(["status" => -1, "msg" => "Không tìm thấy icon dot tại: " . $dotImagePath]));
    }
    $dotImage = imagecreatefrompng($dotImagePath);
    imagealphablending($dotImage, true);
    imagesavealpha($dotImage, true);
    $dotWidth = imagesx($dotImage);
    $dotHeight = imagesy($dotImage);

    if (!file_exists($phoiBank)) {
        exit(JSON_FORMATTER(["status" => -1, "msg" => "Không tìm thấy ảnh phôi ACB tại: " . $phoiBank]));
    }
    $image = imagecreatefrompng($phoiBank);

    $textColorBlack = imagecolorallocate($image, 50, 50, 50);
    $textColorLightGray = imagecolorallocate($image, 62, 62, 62);
    $dotColor = imagecolorallocate($image, 76, 217, 100);
    $whiteColor = imagecolorallocate($image, 255, 255, 255);

    $fontSanFranciscoPath = $GLOBALS['fontPath'] . 'common/San Francisco/';
    $fontRegular = $fontSanFranciscoPath . 'SanFranciscoText-Regular.otf';
    $fontSemibold = $fontSanFranciscoPath . 'SanFranciscoDisplay-Medium.otf';
    $fontDisplaySemibold = $fontSanFranciscoPath . 'SanFranciscoDisplay-Semibold.otf';

    if (!file_exists($fontRegular) || !file_exists($fontSemibold) || !file_exists($fontDisplaySemibold)) {
        exit(JSON_FORMATTER(["status" => -1, "msg" => "Không tìm thấy đủ các file font San Francisco."]));
    }
function drawSpacedText($image, $fontSize, $x, $y, $color, $fontFile, $text, $letterSpacing = 2) {
    $chars = preg_split('//u', $text, -1, PREG_SPLIT_NO_EMPTY);
    foreach ($chars as $char) {
        $bbox = imagettfbbox($fontSize, 0, $fontFile, $char);
        $width = $bbox[2] - $bbox[0];

        imagettftext($image, $fontSize, 0, $x, $y, $color, $fontFile, $char);
        $x += $width + $letterSpacing;
    }
}

function drawRoundedRectangle($img, $x1, $y1, $x2, $y2, $radius, $color) {
    $x1 = (int)$x1;
    $y1 = (int)$y1;
    $x2 = (int)$x2;
    $y2 = (int)$y2;
    $radius = (int)$radius;

    imagefilledrectangle($img, $x1 + $radius, $y1, $x2 - $radius, $y2, $color);
    imagefilledrectangle($img, $x1, $y1 + $radius, $x2, $y2 - $radius, $color);

    imagefilledellipse($img, $x1 + $radius, $y1 + $radius, $radius * 2, $radius * 2, $color);
    imagefilledellipse($img, $x2 - $radius, $y1 + $radius, $radius * 2, $radius * 2, $color);
    imagefilledellipse($img, $x1 + $radius, $y2 - $radius, $radius * 2, $radius * 2, $color);
    imagefilledellipse($img, $x2 - $radius, $y2 - $radius, $radius * 2, $radius * 2, $color);
}

    function drawTextLeft($image, $fontSize, $y, $color, $font, $text, $x) {
        imagettftext($image, $fontSize, 0, $x, $y, $color, $font, $text);
    }

    function drawNotificationText($image, $text, $x, $y, $fontSize, $fontFile, $color, $maxWidth, $lineHeightMultiplier) {
        $lines = [];
        $currentLine = '';
        $words = explode(' ', $text);
        foreach ($words as $word) {
            $testLine = ($currentLine === '' ? '' : $currentLine . ' ') . $word;
            $textBox = imagettfbbox($fontSize, 0, $fontFile, $testLine);
            $textWidth = $textBox[2] - $textBox[0];
            if ($textWidth > $maxWidth && $currentLine !== '') {
                $lines[] = trim($currentLine);
                $currentLine = $word;
            } else {
                $currentLine = $testLine;
            }
        }
        $lines[] = trim($currentLine);
        foreach ($lines as $line) {
            drawSpacedText($image, $fontSize, intval($x), intval($y), $color, $fontFile, $line, 3);

            $y += intval($fontSize * $lineHeightMultiplier);
        }
        return $y;
    }

    if (isset($_POST["xem-truoc"]) && $_POST["xem-truoc"] === 'yes') {
        $image = Watermark::Render($image, 0.8, 20, 120);
    }

    $startYNotifications = 470;
    $currentY = $startYNotifications;

    $notificationBlockWidth = 1066;
    $fixedBlockHeight = 427;
    $notificationBlockPadding = 30;
    $notificationBlockMarginBottom = 50;

    $notificationBlockX = 50;


    for ($i = 0; $i < count($sotiengd_arr); $i++) {
        $cornerRadius = 36;
        drawRoundedRectangle(
            $image,
            $notificationBlockX,
            $currentY,
            $notificationBlockX + $notificationBlockWidth,
            $currentY + $fixedBlockHeight,
            $cornerRadius,
            $whiteColor
        );


        $sotiengd = FormatNumber::PREG($sotiengd_arr[$i]);
        $raw_soduchinh = $soduchinh_arr[$i];
        $cleaned_soduchinh = str_replace(['.', ','], '', $raw_soduchinh);
        $soduchinh_float = (float)$cleaned_soduchinh;
        $soduchinh = FormatNumber::TD($soduchinh_float, 2);

        $phuongthuc = $phuongthuc_arr[$i];
        $thoigianchuyen = $thoigianchuyen_arr[$i];
        $noidungchuyen = $noidungchuyen_arr[$i];

        list($timeHHMM, $dateDDMMYYYY) = explode(' - ', $thoigianchuyen);

        $line1Text = $timeHHMM . ' - ' . $dateDDMMYYYY;
        drawTextLeft($image, 38, $currentY + $notificationBlockPadding + 52, $textColorLightGray, $fontRegular, $line1Text, $notificationBlockX + $notificationBlockPadding + 19);

        $line2Text = "Thong bao thay doi so du tai khoan";
        drawTextLeft($image, 40, $currentY + $notificationBlockPadding + 124, $textColorBlack, $fontSemibold, $line2Text, $notificationBlockX + $notificationBlockPadding + 19);

        $textStartX = $notificationBlockX + $notificationBlockPadding + 19;
        $fontSizeContent = 36.5;
        $lineHeightMultiplier = 1.5;
        $lineMaxWidth = $notificationBlockWidth - (2 * $notificationBlockPadding);

        $currentTextY = $currentY + $notificationBlockPadding + 154;
        $spacingAfterTitle = 0;


        $msg_type = ($phuongthuc === 'chuyentien') ? "-" : "+";
        $line2Text = "ACB: TK {$stk_chinh}(VND) {$msg_type} ".FormatNumber::TD($sotiengd, 2);
        $line2Y = $currentTextY + $fontSizeContent + $spacingAfterTitle;
        $lastDrawnY = drawNotificationText(
            $image,
            $line2Text,
            $textStartX,
            $line2Y,
            $fontSizeContent,
            $fontSemibold,
            $textColorBlack,
            $lineMaxWidth,
            $lineHeightMultiplier
        );

        $line3Text = "luc {$timeHHMM}  {$dateDDMMYYYY}. So du {$soduchinh}";
        $line3Y = $lastDrawnY + $spacingAfterTitle;
        $lastDrawnY = drawNotificationText(
            $image,
            $line3Text,
            $textStartX,
            $line3Y,
            $fontSizeContent,
            $fontSemibold,
            $textColorBlack,
            $lineMaxWidth,
            $lineHeightMultiplier
        );

        $line4Text = "GD: {$noidungchuyen}";
        $line4Y = $lastDrawnY + $spacingAfterTitle;
        drawNotificationText(
            $image,
            $line4Text,
            $textStartX,
            $line4Y,
            $fontSizeContent,
            $fontSemibold,
            $textColorBlack,
            $lineMaxWidth,
            $lineHeightMultiplier
        );

        $targetDotWidth = 28;
        $targetDotHeight = 26;

        $resizedDot = imagecreatetruecolor($targetDotWidth, $targetDotHeight);
        imagealphablending($resizedDot, false);
        imagesavealpha($resizedDot, true);
        $transparent = imagecolorallocatealpha($resizedDot, 0, 0, 0, 127);
        imagefill($resizedDot, 0, 0, $transparent);

        imagecopyresampled(
            $resizedDot, $dotImage,
            0, 0, 0, 0,
            $targetDotWidth, $targetDotHeight,
            $dotWidth, $dotHeight
        );

        $dotX = $notificationBlockX + $notificationBlockWidth - $notificationBlockPadding - ($targetDotWidth / 2) - 11;
        $dotY = $currentY + $notificationBlockPadding + 3 - (37 / 2) + ($targetDotHeight / 2);

        imagecopy($image, $resizedDot, (int)$dotX, (int)$dotY, 0, 0, $targetDotWidth, $targetDotHeight);
        imagedestroy($resizedDot);

        $currentY += $fixedBlockHeight + $notificationBlockMarginBottom;
    }

    imagedestroy($dotImage);


    drawTextLeft($image, 39.5, 93, $textColorBlack, $fontDisplaySemibold, $thoigiantrendt, 90);

    require $_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/bill-settings/main.php';

    CaiDatPhuTro(
        $image,
        $GLOBALS['vachsong'],
        $GLOBALS['iconTinHieu'],
        $GLOBALS['pin'],
        $GLOBALS['tin-hieu'],
        $GLOBALS['DynamicsIsland']
    );

    ob_start();
    imagepng($image);
    $imageData = ob_get_clean();
    $base64 = base64_encode($imageData);
    imagedestroy($image);

    $namebill = ['ACB Bank','Biến Động'];
    require($_SERVER['DOCUMENT_ROOT'].'/server/models/object/global/checkRenderModel.php');
}
?>