<?php
/**
 * QRCore: Simple core QR matrix generator (only alphanumeric mode, version 1, error correction H).
 * Dùng cho QRCode generator đơn giản thuần PHP (dành cho fakebill, vé máy bay...)
 * Không hỗ trợ toàn bộ specs, chỉ đủ cho demo hiển thị QR nhỏ.
 */
class QRCore {
    public static function generate($data, $ecLevel = 'H') {
        $data = strtoupper($data);
        $length = strlen($data);
        $maxLength = 25; // Version 1, ECC H, Alphanumeric = max 17 chars (cho an toàn)
        if ($length > $maxLength) {
            $data = substr($data, 0, $maxLength);
        }

        // Dummy matrix 21x21 (version 1)
        $size = 21;
        $matrix = array_fill(0, $size, array_fill(0, $size, false));

        // Position detection patterns (top-left, top-right, bottom-left)
        self::placeFinder($matrix, 0, 0);
        self::placeFinder($matrix, $size - 7, 0);
        self::placeFinder($matrix, 0, $size - 7);

        // Dummy data encoding: just fill in alternating black/white diagonals
        $bit = true;
        for ($y = 8; $y < $size; $y++) {
            for ($x = 8; $x < $size; $x++) {
                if ($matrix[$y][$x] === false) {
                    $matrix[$y][$x] = $bit;
                    $bit = !$bit;
                }
            }
        }

        return $matrix;
    }

    private static function placeFinder(&$matrix, $x, $y) {
        for ($dy = 0; $dy < 7; $dy++) {
            for ($dx = 0; $dx < 7; $dx++) {
                $matrix[$y + $dy][$x + $dx] = (
                    $dx == 0 || $dx == 6 || $dy == 0 || $dy == 6 || 
                    ($dx >= 2 && $dx <= 4 && $dy >= 2 && $dy <= 4)
                );
            }
        }
    }
}
