
<?php
// Simple QR Code Generator using PHP GD (no Composer)

class QRCode {
    protected $data;
    protected $errorCorrectLevel = 'L';

    public function setErrorCorrectLevel($level) {
        $this->errorCorrectLevel = $level;
    }

    public function addData($data) {
        $this->data = $data;
    }

    public function make() {
        // No-op: this would normally encode the data; simplified for file-based QR lib.
    }

    public function createImage($scale = 4, $padding = 2) {
        $tmpfile = tempnam(sys_get_temp_dir(), 'qr_') . '.png';
        $urlData = urlencode($this->data);
        $url = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . $urlData;

        $qr = imagecreatefrompng($url);
        if (!$qr) return false;

        $width = imagesx($qr);
        $height = imagesy($qr);
        $image = imagecreatetruecolor($width, $height);
        $white = imagecolorallocate($image, 255, 255, 255);
        imagefill($image, 0, 0, $white);
        imagecopy($image, $qr, 0, 0, 0, 0, $width, $height);
        imagedestroy($qr);
        return $image;
    }
}
?>
