<head>
    <style>
.stat-card {
  text-align: center;
  padding: 1rem;
  position: relative;
  overflow: hidden;
  background-color: #1e293b;
}

.stat-card::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 5px;
  height: 100%;
  background: linear-gradient(to bottom, var(--primary), var(--secondary));
}
.card {
  background-color: #1e293b;
  border-radius: 12px;
  padding: 1.5rem;
  margin-bottom: 1.5rem;
  box-shadow: var(--shadow);
  transition: all 0.3s ease;
  border: 1px solid var(--border);
}

.card:hover {
  box-shadow: var(--shadow-hover);
  transform: translateY(-3px);
}
:root {
  --primary: #2563eb;
  --primary-dark: #1e40af;
  --secondary: #10b981;
  --accent: #f59e0b;
  --danger: #ef4444;
  --dark: #1e293b;
  --darker: #0f172a;
  --light: #f8fafc;
  --gray: #64748b;
  --card-bg: #ffffff;
  --text-primary: #1e293b;
  --text-secondary: #64748b;
  --border: #e2e8f0;
  --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
  --shadow-hover: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
}
    </style>
</head>
<div class="flex flex-col items-center justify-between gap-6 sm:flex-row">
    <div>
        <h3
            class="nui-heading nui-heading-lg nui-weight-semibold nui-lead-tight text-muted-800 dark:text-muted-100 mb-1">
            <span>
                <?php
                if (strpos($current_url, 'fake-bill-chuyen-khoan')!==false) 
                {?>
                Tạo Bill Chuyển Khoản
                <?php } elseif (strpos($current_url, 'fake-so-du')!==false) 
                {?>
                Tạo Bill Số Dư
                <?php } elseif (strpos($current_url, 'fake-bdsd')!==false) 
                {?>
                Tạo Bill Biến Động
                <?php }
                ?>
            </span>
        </h3>
    </div>
    <div class="flex gap-2 sm:justify-end">
        <button type="button" target="bill-chuyen-khoan"
            class="nui-button-action <?=(strpos($current_url, 'fake-bill-chuyen-khoan')!==false) ? 'nui-button-primary' : 'nui-button-default';?> nui-button-rounded-lg bill-transfer">
            <?php if (strpos($current_url, 'fake-bill-chuyen-khoan')!==false): ?>
            <i class="ri-arrow-left-s-line me-1"></i>
            <?php endif;?>
            Bill chuyển khoản
        </button>
        <button type="button" target="bill-so-du"
            class="nui-button-action <?=(strpos($current_url, 'fake-so-du')!==false) ? 'nui-button-primary' : 'nui-button-default';?> nui-button-rounded-lg bill-transfer">
            <?php if (strpos($current_url, 'fake-so-du')!==false): ?>
            <i class="ri-arrow-left-s-line me-1"></i>
            <?php endif;?>
            Bill số dư
        </button>
        <button type="button" target="bill-bien-dong"
            class="nui-button-action <?=(strpos($current_url, 'fake-bdsd')!==false) ? 'nui-button-primary' : 'nui-button-default';?> nui-button-rounded-lg bill-transfer">
            <?php if (strpos($current_url, 'fake-bdsd')!==false): ?>
            <i class="ri-arrow-left-s-line me-1"></i>
            <?php endif;?>
            Bill biến động
        </button>
    </div>
</div>
<!-- / Bill Chuyển Khoản / -->

<div class="col-bank">
    <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
        <a href="javascript:;" data-target-href="/fake-bill/mb-bank-nam-moi-2026">
            <div class="flex flex-col">
                <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                    <div class="nui-avatar-inner">
                        <img src="https://play-lh.googleusercontent.com/7p-i_6pa2-9ZlAIkLuRxk3kSn49df9OsmgP1FK2FmlynAy57ErHqUHQiJFuTuuvj1Amd0YG6fws6E0q06cF6=w480-h960-rw" 
                             alt="Logo Mbbank Năm Mới 2026" 
                             class="nui-avatar-img rounded-lg">
                    </div>
                </div>
                <div class="text-center">
                    <h4 class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                        <span>MB Bank - Năm Mới Thịnh Vượng - 2026</span>
                        <span class="ms-2 bg-danger text-white fs-12px fw-bold px-2 py-1 rounded" style="border: 2px solid #dc2626; box-shadow: 0 0 5px rgba(220, 38, 38, 0.8);">NEW</span>
                    </h4>
                    <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                        <span class="text-muted-400">Ngân hàng TMCP Quân Đội - Chủ đề 2026</span>
                    </p>
                </div>
            </div>
        </a>
    </div>
</div>
<div class="grid lg:grid-cols-5 md:grid-cols-1 gap-6 mt-6 select-none mb-6 <?php if (strpos($current_url, 'fake-bill-chuyen-khoan')===false): ?>hidden<?php endif;?>"
    id="bill-chuyen-khoan">
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/mb-bank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/mbbank2.png" alt="Logo Mbbank" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>MB Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 1097 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Quân Đội</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/mb-bank-don-luu">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/mbbank.png" alt="Logo Mbbank" class="nui-avatar-img rounded-lg">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>MB Bank (Đơn Lưu)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 74 bill</p>-->
                     <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Theme mới được cập nhật liên tục</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/mb-bank-tet">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/mb-tet.png" alt="Logo Mbbank" class="nui-avatar-img rounded-lg">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>MB Bank (Nền Tết)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 7 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Quân Đội</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="fake-bill/mb-bank-2-9">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/public/src/vtd/img/icon/bank/mbbank2.png" alt="Logo Mbbank" class="nui-avatar-img rounded-lg">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>MB Bank (Nền 2/9)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 4 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Quân Đội</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="fake-bill/mb-duyen-dang">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/public/src/vtd/img/icon/bank/mbbank2.png" alt="Logo Mbbank" class="nui-avatar-img rounded-lg">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>MB Bank (Duyên Dáng)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 4 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Quân Đội</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vietcombank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietcombank.png" alt="Logo Vietcombank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietcombank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 197 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Ngoại Thương</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vietcombank-new">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietcombank.png" alt="Logo Vietcombank New"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietcombank (NEW)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 75 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Ngoại Thương</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vietcombank-new-dn">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietcombank.png" alt="Logo Vietcombank New"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietcombank CK Cho Công Ty</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 9 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Ngoại Thương</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/thanhtoanvcb">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietcombank.png" alt="Logo Vietcombank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Thanh Toán Vietcombank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Ngoại Thương</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/techcombank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/techcombank.png" alt="Logo Techcombank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Techcombank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 517 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Kỹ Thương</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vietinbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietinbank.png" alt="Logo Vietinbank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietinbank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 217 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Công Thương</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vietinbank-1">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietinbank.png" alt="Logo Vietinbank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietinbank (Nền Đỏ)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 8 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Công Thương</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vietinbank-2thang9">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietinbank.png" alt="Logo Vietinbank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietinbank (Nền 2/9)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Công Thương</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/acb">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/acb.png" alt="Logo Acb" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>ACB</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 22 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Á Châu</span>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/acb-new">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/acbbank.png" alt="Logo Acb" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>ACB (NEW)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 18 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Á Châu</span>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/momo">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/momo.png" alt="Logo Momo" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Ví Momo (Liên Bank)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 22 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ví điện tử Momo</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/zalopay">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/zalopay.png" alt="Logo Zalo Pay" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>ZaloPay</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 6 bill</p>-->
                         <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ví điện tử ZaloPay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/agribank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/agribank.png" alt="Logo Agribank" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Agribank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 227 bill</p>-->
                       <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng NN&PTNT</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/agribank-dn">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/public/src/vtd/img/icon/bank/agribank.png" alt="Logo Agribank" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Agribank CK Cho Công Ty</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 37 bill</p>-->
                       <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng NN&PTNT</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/msb">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/msb.png" alt="Logo MSB" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>MSB</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 86 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Hàng Hải</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/tp-bank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/tpbank2.jpg" alt="Logo TP Bank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>TP Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 15 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Tiên Phong</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
     <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/tp-bank-new">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/tpbank2.jpg" alt="Logo TP Bank New"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>TP Bank (NEW)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 22 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Tiên Phong</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vp-bank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vpbank-neo.png" alt="Logo VP Bank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>VP Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 68 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Việt Nam Thịnh Vượng</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/cake">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/cake.png" alt="Logo Cake"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>CAKE</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 6 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng số CAKE by VPBank</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/bvbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://www.saokim.com.vn/wp-content/uploads/2023/02/Bieu-Tuong-Logo-Ngan-Hang-Ban-Viet.png" alt="Logo BVBank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>BV Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 2 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Bản Việt</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/seabank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="//i.ibb.co/vvJBHDrS/unnamed.png" alt="Logo Seabank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Sea Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 3 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Đông Nam Á</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/bacabank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="//i.ibb.co/YTFQV6mR/bacabank.png" alt="Logo BacABank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Bắc Á Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 1 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Bắc Á</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/bacabank-new">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="//i.ibb.co/YTFQV6mR/bacabank.png" alt="Logo BacABank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Bắc Á Bank (NEW)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 4 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Bắc Á</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/bacabank-donluu-new">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="//i.ibb.co/YTFQV6mR/bacabank.png" alt="Logo BacABank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Bắc Á Bank (Đơn Lưu)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Bắc Á</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/viettel-money">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/viettel-money.png" alt="Logo Viettelmoney"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Viettel Money</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 11 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ví điện tử Viettel Money</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/hdbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/hdbank.png" alt="Logo HDBank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>HD Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 7 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Phát triển TPHCM</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vibbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vib.png" alt="Logo VibBank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>VIB</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 27 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Quốc Tế</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vietbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietbank.png" alt="Logo VietBank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>VietBank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Việt Nam Thương Tín</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/bidv">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/bidv2.png" alt="Logo BIDV"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>BIDV</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 56 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Đầu tư và Phát triển</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/bidv-new">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/bidv2.png" alt="Logo BIDV"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>BIDV (NEW)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 119 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Đầu tư và Phát triển</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/bidv-don-luu">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/bidv2.png" alt="Logo BIDV"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>BIDV (Đơn Lưu)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 3 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Đầu tư và Phát triển</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/liobank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="//i.ibb.co/jk5BR9G7/unnamed.png" alt="Logo Liobank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Liobank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng số Lio by OCB</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/shinhanbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/shinhanbank.png" alt="Logo Shinhanbank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Shinhanbank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 6 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TNHH MTV Shinhan</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/pgbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/pgb.png" alt="Logo Pg Bank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>PGBank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 4 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Thịnh vượng và Phát triển</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/sacombank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/sacombank.png" alt="Logo Sacombank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Sacombank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 1 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Sài Gòn Thương Tín</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/worri">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="//i.ibb.co/sdCb1cS6/simbolo-woori-bank-Prancheta-1.webp" alt="Logo Worri"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Woori Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 5 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TNHH MTV Woori</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/namabank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTlHAw1TeRU4c26xEYLyunjIK1PI1Y1mTAuJg&s" alt="Logo Nam Á Bank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Nam Á Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 3 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Nam Á</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/namabank-new">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTlHAw1TeRU4c26xEYLyunjIK1PI1Y1mTAuJg&s" alt="Logo Nam Á Bank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Nam Á Bank (NEW)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 1 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Nam Á</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/pvbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://wikiland.vn/wp-content/uploads/ngan-hang/pvcombank/icon-pvcombank.png" alt="Logo PV Bank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>PV Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Đại Chúng</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/pvbank-new">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://wikiland.vn/wp-content/uploads/ngan-hang/pvcombank/icon-pvcombank.png" alt="Logo PV Bank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>PV Bank (NEW)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 19 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Đại Chúng</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/ocb">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/ocb.png" alt="Logo OCB"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>OCB</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 6 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Phương Đông</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/chinhsachxahoi">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://cdn.haitrieu.com/wp-content/uploads/2021/12/Logo-Ngan-hang-Chinh-sach-xa-hoi-VBSP.png" alt="Logo Chính sách xã hội"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Chính Sách Xã Hội</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng CSXH</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/eximbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://svtech.com.vn/wp-content/uploads/2020/09/Eximbank.png" alt="Logo Eximbank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Eximbank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Xuất Nhập Khẩu</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/saigonbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/sg-bank.png" alt="Logo Saigonbank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Saigonbank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Sài Gòn Thương Tín</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/abbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://play-lh.googleusercontent.com/DPT0tkkufSaDOyToT-tA3GVKj1b6_b7fWBt27NHebdVhkqTemHJKOntP5sIKkb6zFN8" alt="Logo ABBank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>ABBank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP An Bình</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/ncb">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/ncb-bank.png" alt="Logo NCB"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>NCB</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Quốc Dân</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/lpbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://cdn6.aptoide.com/imgs/f/f/8/ff8fd642bcd571a2fa6f9b308a463658_icon.png" alt="Logo LP Bank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Liên Việt Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 2 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng Bưu điện Liên Việt</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/kienlongbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://kienlongbank.com/Data/Sites/1/media/logo-klb/logo-kienlongbank-favicon.png" alt="Logo Kiên Long Bank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Kiên Long Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Kiên Long</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/shb">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://play-lh.googleusercontent.com/v5oiUb9OH80qpTRgcKPpXHkqmkO5MAZfxldamoCPCbdUMOruCabujukSJmXF2FK3hco" alt="Logo SHB"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>SHB</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Sài Gòn – Hà Nội</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/shb-new">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://play-lh.googleusercontent.com/v5oiUb9OH80qpTRgcKPpXHkqmkO5MAZfxldamoCPCbdUMOruCabujukSJmXF2FK3hco" alt="Logo SHB"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>SHB (NEW)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 1 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng TMCP Sài Gòn – Hà Nội</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/timo">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://cdn.haitrieu.com/wp-content/uploads/2022/10/Icon-App-timo.png" alt="Logo Timo"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Timo</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng số Timo by Bản Việt</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/coopbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://i.postimg.cc/DyvzfDMY/Co-opbank-1.webp" alt="Logo Coop Bank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Coop Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng hợp tác xã</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bill/vietabank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR6ATOZ2ziulivMXahCYf2Jjfciuv89lGXMsA&s" alt="Logo Việt Á Bank"
                                class="nui-avatar-img rounded-md">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Việt Á Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Ngân hàng hợp tác xã</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <!-- / End Col -->
</div>
</div>
<!-- / Bill Số Dư / -->
<div class="grid lg:grid-cols-5 md:grid-cols-1 gap-6 mt-6 select-none mb-6 <?php if (strpos($current_url, 'fake-so-du')===false): ?>hidden<?php endif;?>"
    id="bill-so-du">
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/vietinbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietinbank.png" alt="Logo Vietinbank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietinbank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 19 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/vietinbank-2thang9">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietinbank.png" alt="Logo Vietinbank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietinbank (Nền 2/9)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/techcombank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/techcombank.png" alt="Logo Techcombank" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Techcombank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 32 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/momo">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/momo.png" alt="Logo Momo" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Ví Momo</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 1 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/mb-bank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/mbbank2.png" alt="Logo Momo" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>MB Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 67 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/zalopay">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/zalopay.png" alt="Logo Momo" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>ZaloPay</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/acb">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/acb.png" alt="Logo Acb" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>ACB</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 1 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/cake">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="//i.ibb.co/jksKBzC3/unnamed.png" alt="Logo Cake"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>CAKE</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
<p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/agribank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/agribank.png" alt="Logo Agribank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Agribank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 6 bill</p>-->
<p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/tpbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/tpbank.png" alt="Logo Tpbank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>TP Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 8 bill</p>-->
<p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/vpbank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vpbank.png" alt="Logo Vpbank"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>VP Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 6 bill</p>-->
<p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/vietcombank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietcombank.png" alt="Logo vcb"
                                class="nui-avatar-img rounded-full">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietcombank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 56 bill</p>-->
<p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/mb-bank-1">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/mbbank2.png" alt="Logo Momo" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>MB Bank (Loại 1)</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 7 bill</p>-->
                       <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-so-du/bac-a-bank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/bacabank.png" alt="Logo Logo Bac A Bank" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Bắc Á Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                       <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
</div>
<!-- / Bill Biến Động / -->
<div class="grid lg:grid-cols-5 md:grid-cols-1 gap-6 mt-6 select-none mb-6 <?php if (strpos($current_url, 'fake-bdsd')===false): ?>hidden<?php endif;?>"
    id="bill-bien-dong">
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bdsd/mb-bank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/mbbank2.png" alt="Logo Mbbank" class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>MB Bank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 51 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bdsd/techcombank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/techcombank.png" alt="Logo Techcombank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Techcombank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 21 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bdsd/vietcombank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/vietcombank.png" alt="Logo vietcombank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Vietcombank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 0 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bdsd/acb">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/acb.png" alt="Logo Acb"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>ACB</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 7 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-bank">
        <div class="card stat-card nui-card nui-card-rounded-lg nui-card-default p-6 shadow-lg border-none">
            <a href="javascript:;" data-target-href="/fake-bdsd/agribank">
                <div class="flex flex-col">
                    <div class="nui-avatar nui-avatar-md mx-auto mb-4">
                        <div class="nui-avatar-inner">
                            <img src="/<?=__IMG__?>/icon/bank/agribank.png" alt="Logo Agribank"
                                class="nui-avatar-img">
                        </div>
                    </div>
                    <div class="text-center">
                        <h4
                            class="nui-heading nui-heading-md nui-weight-bold nui-lead-tight text-muted-800 dark:text-muted-100">
                            <span>Agribank</span>
                        </h4>
                        <!--<p class="text-muted-400 font-sans fs-14px mt-1">Đã tạo: 40 bill</p>-->
                        <p class="nui-paragraph nui-paragraph-xs nui-weight-normal nui-lead-normal p-1">
                            <span class="text-muted-400">Tạo ngay</span>
                        </p>
                    </div>
                </div>
            </a>
        </div>
    </div>
</div>