<style>
    /* ===== REGISTER PAGE - NEW UI ===== */
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');

    .reg-page-wrap {
        display: flex;
        min-height: 100vh;
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        -webkit-font-smoothing: antialiased;
    }

    /* ===== LEFT PANEL - DECORATION ===== */
    .reg-panel-left {
        flex: 0 0 50%;
        max-width: 50%;
        background: linear-gradient(155deg, #0c0a1d 0%, #1a1145 30%, #2d1b69 60%, #1e1b4b 100%);
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 60px 70px;
        position: relative;
        overflow: hidden;
    }

    .reg-panel-left::before {
        content: '';
        position: absolute;
        width: 600px;
        height: 600px;
        border-radius: 50%;
        background: radial-gradient(circle, rgba(139, 92, 246, 0.14) 0%, transparent 70%);
        top: -180px;
        left: -120px;
        animation: regOrb1 10s ease-in-out infinite;
    }

    .reg-panel-left::after {
        content: '';
        position: absolute;
        width: 500px;
        height: 500px;
        border-radius: 50%;
        background: radial-gradient(circle, rgba(59, 130, 246, 0.1) 0%, transparent 70%);
        bottom: -120px;
        right: -100px;
        animation: regOrb1 7s ease-in-out infinite reverse;
    }

    @keyframes regOrb1 {

        0%,
        100% {
            transform: translate(0, 0) scale(1);
        }

        33% {
            transform: translate(15px, -25px) scale(1.06);
        }

        66% {
            transform: translate(-10px, 15px) scale(0.97);
        }
    }

    /* Floating shapes */
    .reg-shape {
        position: absolute;
        border-radius: 50%;
        z-index: 0;
    }

    .reg-shape-1 {
        width: 120px;
        height: 120px;
        border: 1px solid rgba(139, 92, 246, 0.15);
        top: 12%;
        right: 15%;
        animation: regShapeSpin 20s linear infinite;
    }

    .reg-shape-2 {
        width: 80px;
        height: 80px;
        background: rgba(99, 102, 241, 0.06);
        bottom: 20%;
        left: 10%;
        animation: regShapeSpin 15s linear infinite reverse;
    }

    .reg-shape-3 {
        width: 200px;
        height: 200px;
        border: 1px solid rgba(59, 130, 246, 0.08);
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        animation: regShapePulse 6s ease-in-out infinite;
    }

    @keyframes regShapeSpin {
        from {
            transform: rotate(0deg);
        }

        to {
            transform: rotate(360deg);
        }
    }

    @keyframes regShapePulse {

        0%,
        100% {
            transform: translate(-50%, -50%) scale(1);
            opacity: 0.5;
        }

        50% {
            transform: translate(-50%, -50%) scale(1.15);
            opacity: 1;
        }
    }

    .reg-left-inner {
        position: relative;
        z-index: 1;
        text-align: center;
        max-width: 460px;
    }

    .reg-left-img {
        max-width: 340px;
        width: 100%;
        margin: 0 auto 44px;
        display: block;
        filter: drop-shadow(0 25px 50px rgba(0, 0, 0, 0.35));
        animation: regImgFloat 6s ease-in-out infinite;
    }

    @keyframes regImgFloat {

        0%,
        100% {
            transform: translateY(0);
        }

        50% {
            transform: translateY(-12px);
        }
    }

    .reg-left-text {
        animation: regSlideUp 1s ease-out 0.2s both;
    }

    .reg-left-text h2 {
        font-size: 28px;
        font-weight: 700;
        color: #f1f5f9;
        margin: 0 0 8px;
        line-height: 1.25;
        font-family: 'Inter', sans-serif;
    }

    .reg-left-text .reg-gradient-txt {
        font-size: 28px;
        font-weight: 800;
        background: linear-gradient(135deg, #a78bfa, #818cf8, #c084fc);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        margin-bottom: 16px;
        display: inline-block;
        line-height: 1.3;
        font-family: 'Inter', sans-serif;
    }

    .reg-left-text p {
        font-size: 14px;
        color: #94a3b8;
        line-height: 1.7;
        margin: 0;
        font-family: 'Inter', sans-serif;
    }

    /* Features list */
    .reg-features {
        margin-top: 32px;
        display: flex;
        flex-direction: column;
        gap: 14px;
        text-align: left;
    }

    .reg-feat-item {
        display: flex;
        align-items: center;
        gap: 12px;
        animation: regSlideUp 0.6s ease-out both;
    }

    .reg-feat-item:nth-child(1) {
        animation-delay: 0.3s;
    }

    .reg-feat-item:nth-child(2) {
        animation-delay: 0.4s;
    }

    .reg-feat-item:nth-child(3) {
        animation-delay: 0.5s;
    }

    .reg-feat-icon {
        width: 36px;
        height: 36px;
        border-radius: 10px;
        background: rgba(139, 92, 246, 0.15);
        border: 1px solid rgba(139, 92, 246, 0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .reg-feat-icon svg {
        width: 18px;
        height: 18px;
        color: #a78bfa;
    }

    .reg-feat-text {
        font-size: 13px;
        color: #cbd5e1;
        font-weight: 500;
        font-family: 'Inter', sans-serif;
    }

    @keyframes regSlideUp {
        from {
            opacity: 0;
            transform: translateY(24px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Grid & particles */
    .reg-grid {
        position: absolute;
        inset: 0;
        background-image: radial-gradient(rgba(139, 92, 246, 0.06) 1px, transparent 1px);
        background-size: 32px 32px;
        pointer-events: none;
        z-index: 0;
    }

    .reg-particles {
        position: absolute;
        inset: 0;
        pointer-events: none;
        z-index: 0;
    }

    .reg-dot {
        position: absolute;
        width: 3px;
        height: 3px;
        background: rgba(139, 92, 246, 0.45);
        border-radius: 50%;
        animation: regTwinkle var(--dur) ease-in-out infinite;
    }

    @keyframes regTwinkle {

        0%,
        100% {
            opacity: 0;
            transform: scale(0.5);
        }

        50% {
            opacity: 1;
            transform: scale(1.3);
        }
    }

    /* ===== RIGHT PANEL - FORM ===== */
    .reg-panel-right {
        flex: 0 0 50%;
        max-width: 50%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 32px 50px;
        background: #ffffff;
        overflow-y: auto;
    }

    .dark .reg-panel-right {
        background: #1e2235;
    }

    .reg-form-box {
        width: 100%;
        max-width: 440px;
    }

    /* Top bar */
    .reg-topbar {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 24px;
    }

    .reg-topbar .reg-back {
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 13px;
        font-weight: 500;
        color: #94a3b8;
        text-decoration: none;
        transition: color 0.3s ease;
        font-family: 'Inter', sans-serif;
    }

    .reg-topbar .reg-back:hover {
        color: #8b5cf6;
    }

    .reg-topbar .reg-back svg {
        width: 18px;
        height: 18px;
    }

    /* Step indicator */
    .reg-step-bar {
        display: flex;
        gap: 6px;
        margin-bottom: 28px;
    }

    .reg-step-dot {
        flex: 1;
        height: 4px;
        border-radius: 4px;
        background: #e2e8f0;
        transition: all 0.5s ease;
    }

    .dark .reg-step-dot {
        background: #3b4263;
    }

    .reg-step-dot.active {
        background: linear-gradient(90deg, #8b5cf6, #6366f1);
    }

    /* Heading */
    .reg-heading {
        margin-bottom: 4px;
    }

    .reg-heading h2 {
        font-size: 24px;
        font-weight: 700;
        color: #1e293b;
        line-height: 1.4;
        letter-spacing: -0.02em;
        margin: 0;
        font-family: 'Inter', sans-serif;
    }

    .dark .reg-heading h2 {
        color: #f1f5f9;
    }

    .reg-heading .reg-sub {
        font-size: 13.5px;
        color: #94a3b8;
        margin-top: 4px;
        margin-bottom: 0;
        font-weight: 400;
        line-height: 1.5;
    }

    /* Google button */
    .reg-oauth-section {
        margin-top: 20px;
    }

    .reg-google-btn {
        width: 100%;
        height: 48px;
        overflow: visible;
        border: 1.5px solid #e2e8f0;
        border-radius: 12px;
        background: #ffffff;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 12px;
        font-size: 14px;
        font-weight: 500;
        color: #1e293b;
        font-family: 'Inter', sans-serif;
        transition: all 0.3s ease;
    }

    .dark .reg-google-btn {
        background: #262c45;
        border-color: #3b4263;
        color: #f1f5f9;
    }

    .reg-google-btn:hover {
        border-color: #94a3b8;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        transform: translateY(-1px);
    }

    .reg-google-btn img {
        height: 56px;
        width: auto;
        object-fit: contain;
    }

    /* Divider */
    .reg-divider {
        display: flex;
        align-items: center;
        margin: 20px 0;
    }

    .reg-divider hr {
        flex: 1;
        border: none;
        border-top: 1.5px solid #e2e8f0;
        margin: 0;
    }

    .dark .reg-divider hr {
        border-color: #3b4263;
    }

    .reg-divider span {
        padding: 0 14px;
        font-size: 12px;
        color: #94a3b8;
        white-space: nowrap;
        max-width: 180px;
        font-family: 'Inter', sans-serif;
    }

    /* Form fields */
    .reg-field {
        margin-bottom: 16px;
    }

    .reg-field-top {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 6px;
    }

    .reg-field-top label {
        font-size: 13px;
        font-weight: 500;
        color: #1e293b;
        font-family: 'Inter', sans-serif;
    }

    .dark .reg-field-top label {
        color: #cbd5e1;
    }

    .reg-input-outer {
        position: relative;
        display: flex;
        align-items: center;
    }

    .reg-input-outer .reg-icon-left {
        position: absolute;
        left: 14px;
        width: 18px;
        height: 18px;
        color: #94a3b8;
        pointer-events: none;
        z-index: 2;
        transition: color 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .reg-input-outer .reg-icon-left svg {
        width: 18px;
        height: 18px;
    }

    .reg-input-outer .reg-txt-input {
        width: 100%;
        height: 46px;
        padding: 0 44px 0 44px;
        border: 1.5px solid #e2e8f0;
        border-radius: 10px;
        font-size: 13.5px;
        font-family: 'Inter', sans-serif;
        color: #1e293b;
        background: #ffffff;
        transition: all 0.3s ease;
        outline: none;
    }

    .dark .reg-input-outer .reg-txt-input {
        background: #262c45;
        border-color: #3b4263;
        color: #f1f5f9;
    }

    .reg-input-outer .reg-txt-input::placeholder {
        color: #cbd5e1;
        font-weight: 400;
    }

    .dark .reg-input-outer .reg-txt-input::placeholder {
        color: #64748b;
    }

    .reg-input-outer .reg-txt-input:focus {
        border-color: #8b5cf6;
        box-shadow: 0 0 0 3px rgba(139, 92, 246, 0.1);
    }

    .reg-input-outer .reg-txt-input:focus~.reg-icon-left {
        color: #8b5cf6;
    }

    /* Eye toggle */
    .reg-input-outer .reg-eye-btn {
        position: absolute;
        right: 10px;
        background: none;
        border: none;
        cursor: pointer;
        color: #94a3b8;
        padding: 4px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: color 0.3s ease;
        z-index: 2;
        width: 32px;
        height: 32px;
    }

    .reg-input-outer .reg-eye-btn:hover {
        color: #8b5cf6;
    }

    .reg-input-outer .reg-eye-btn svg {
        width: 18px;
        height: 18px;
    }

    /* Password strength tooltip - override positioning */
    .reg-pw-strength-wrap {
        position: relative;
    }

    .reg-pw-strength-wrap .reg-pw-tooltip {
        position: absolute;
        bottom: -4px;
        left: 0;
        right: 0;
        z-index: 20;
        transform: translateY(100%);
        background: #ffffff;
        border: 1px solid #e2e8f0;
        border-radius: 12px;
        padding: 16px 18px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease;
    }

    .dark .reg-pw-strength-wrap .reg-pw-tooltip {
        background: #262c45;
        border-color: #3b4263;
    }

    .reg-pw-strength-wrap:focus-within .reg-pw-tooltip {
        opacity: 1;
        pointer-events: auto;
    }

    .reg-pw-tip {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 10px;
    }

    .reg-pw-tip:last-child {
        margin-bottom: 0;
    }

    .reg-pw-tip svg {
        width: 14px;
        height: 14px;
        color: #94a3b8;
        flex-shrink: 0;
    }

    .reg-pw-tip span {
        font-size: 12px;
        color: #64748b;
        font-weight: 500;
    }

    .dark .reg-pw-tip span {
        color: #94a3b8;
    }

    /* Terms checkbox */
    .reg-terms-row {
        margin-top: 8px;
        margin-bottom: 20px;
    }

    /* Submit */
    .reg-submit-wrap {
        margin-top: 0;
    }

    .reg-submit-wrap .reg-btn-go {
        width: 100%;
        height: 48px;
        border: none;
        border-radius: 10px;
        background: linear-gradient(135deg, #8b5cf6, #7c3aed);
        color: white;
        font-size: 14.5px;
        font-weight: 600;
        font-family: 'Inter', sans-serif;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(139, 92, 246, 0.35);
        position: relative;
        overflow: hidden;
    }

    .reg-submit-wrap .reg-btn-go::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.15), transparent);
        transition: left 0.5s ease;
    }

    .reg-submit-wrap .reg-btn-go:hover::before {
        left: 100%;
    }

    .reg-submit-wrap .reg-btn-go:hover {
        background: linear-gradient(135deg, #7c3aed, #6d28d9);
        box-shadow: 0 6px 20px rgba(139, 92, 246, 0.45);
        transform: translateY(-1px);
    }

    .reg-submit-wrap .reg-btn-go:active {
        transform: translateY(0);
    }

    /* Login row */
    .reg-login-row {
        margin-top: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 13px;
        color: #94a3b8;
        font-family: 'Inter', sans-serif;
    }

    .reg-login-row a {
        color: #8b5cf6;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .reg-login-row a:hover {
        color: #7c3aed;
        text-decoration: underline;
    }

    /* Captcha wrapper */
    .reg-captcha-area {
        margin-bottom: 4px;
    }

    /* Field animations */
    .reg-field {
        animation: regFadeUp 0.4s ease-out both;
    }

    .reg-field:nth-child(1) {
        animation-delay: 0.05s;
    }

    .reg-field:nth-child(2) {
        animation-delay: 0.1s;
    }

    .reg-field:nth-child(3) {
        animation-delay: 0.15s;
    }

    .reg-field:nth-child(4) {
        animation-delay: 0.2s;
    }

    .reg-field:nth-child(5) {
        animation-delay: 0.25s;
    }

    @keyframes regFadeUp {
        from {
            opacity: 0;
            transform: translateY(10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Responsive */
    @media (max-width: 1200px) {
        .reg-panel-left {
            padding: 40px 40px;
        }

        .reg-panel-right {
            padding: 32px 36px;
        }
    }

    @media (max-width: 1024px) {
        .reg-page-wrap {
            flex-direction: column;
        }

        .reg-panel-left,
        .reg-panel-right {
            flex: 1;
            max-width: 100%;
        }

        .reg-panel-left {
            display: none;
        }

        .reg-panel-right {
            padding: 32px 24px;
        }
    }

    /* Captcha Bolder Stylings */
    .ws-captcha {
        width: 100% !important;
    }

    /* Stronger popup container */
    div[style*="position: fixed"][style*="z-index: 999999"],
    .captcha-popup-container,
    .slider_captcha {
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5) !important;
        border: 2px solid #e2e8f0 !important;
        border-radius: 16px !important;
    }

    .dark div[style*="position: fixed"][style*="z-index: 999999"],
    .dark .captcha-popup-container,
    .dark .slider_captcha {
        border-color: #3b4263 !important;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.8) !important;
    }

    /* Bolder Text */
    div[style*="font-size: 18px"],
    .captcha-title,
    .slider_captcha .title {
        font-weight: 800 !important;
        color: #1e293b !important;
    }

    .dark div[style*="font-size: 18px"],
    .dark .captcha-title,
    .dark .slider_captcha .title {
        color: #f1f5f9 !important;
    }

    /* Stronger slider bar */
    .slider_captcha .slider_bar {
        background: #f1f5f9 !important;
        border: 2px solid #e2e8f0 !important;
        height: 44px !important;
        opacity: 0.9 !important;
    }

    /* Prominent Slider Handle */
    .slider_captcha .slider_button {
        background: linear-gradient(135deg, #8b5cf6, #6366f1) !important;
        box-shadow: 0 4px 12px rgba(99, 102, 241, 0.4) !important;
        width: 50px !important;
        height: 50px !important;
        border: 2px solid #ffffff !important;
    }

    /* Bottom icons */
    .slider_captcha .bottom_icons i,
    .captcha-footer svg {
        font-size: 20px !important;
        color: #64748b !important;
        transition: color 0.3s ease;
    }

    .slider_captcha .bottom_icons i:hover {
        color: #8b5cf6 !important;
    }
</style>

<div class="reg-page-wrap select-none">
    <!-- ===== LEFT PANEL - DECORATION ===== -->
    <div class="reg-panel-left">
        <div class="reg-grid"></div>
        <div class="reg-particles" id="regParticles"></div>
        <div class="reg-shape reg-shape-1"></div>
        <div class="reg-shape reg-shape-2"></div>
        <div class="reg-shape reg-shape-3"></div>

        <div class="reg-left-inner">
            <!-- Banner image (GIỮ NGUYÊN ảnh gốc) -->
            <img class="reg-left-img pointer-events-none" src="/<?= __IMG__ ?>/svg/log-in-girl.svg"
                alt="<?=$TD->Setting('name-site')?> Banner" width="719" height="594">

            <div class="reg-left-text">
                <h2>Tham gia cộng đồng</h2>
                <div class="reg-gradient-txt">Hàng nghìn người dùng</div>
                <p>Đăng ký miễn phí và bắt đầu sử dụng các dịch vụ nhanh chóng, chính xác.</p>
            </div>

            <!-- Features -->
            <div class="reg-features">
                <div class="reg-feat-item">
                    <div class="reg-feat-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round">
                            <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14" />
                            <polyline points="22 4 12 14.01 9 11.01" />
                        </svg>
                    </div>
                    <span class="reg-feat-text">Đăng ký nhanh chóng, miễn phí 100%</span>
                </div>
                <div class="reg-feat-item">
                    <div class="reg-feat-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round">
                            <rect x="3" y="11" width="18" height="11" rx="2" ry="2" />
                            <path d="M7 11V7a5 5 0 0 1 10 0v4" />
                        </svg>
                    </div>
                    <span class="reg-feat-text">Bảo mật đa lớp, an toàn tuyệt đối</span>
                </div>
                <div class="reg-feat-item">
                    <div class="reg-feat-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round">
                            <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z" />
                        </svg>
                    </div>
                    <span class="reg-feat-text">Hỗ trợ kỹ thuật 24/7</span>
                </div>
            </div>
        </div>
    </div>

    <!-- ===== RIGHT PANEL - FORM ===== -->
    <div class="reg-panel-right">
        <div class="reg-form-box">

            <!-- Top bar: back + theme toggle (GIỮ NGUYÊN) -->
            <div class="reg-topbar">
                <a href="<?=Redirect::Login()?>"
                    class="reg-back text-muted-400 hover:text-primary-500 font-sans font-medium transition-colors duration-300">
                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" viewBox="0 0 24 24">
                        <path fill="currentColor"
                            d="m1.027 11.993l4.235 4.25L6.68 14.83l-1.821-1.828L22.974 13v-2l-18.12.002L6.69 9.174L5.277 7.757z">
                        </path>
                    </svg>
                    <span>Về trang đăng nhập</span>
                </a>
                <label class="nui-theme-toggle" for="theme-toggle-input">
                    <input type="checkbox" class="nui-theme-toggle-input" id="theme-toggle-input">
                    <span class="nui-theme-toggle-inner">
                        <svg aria-hidden="true" viewBox="0 0 24 24" class="nui-sun">
                            <g fill="currentColor" stroke="currentColor" class="stroke-2">
                                <circle cx="12" cy="12" r="5"></circle>
                                <path
                                    d="M12 1v2m0 18v2M4.22 4.22l1.42 1.42m12.72 12.72 1.42 1.42M1 12h2m18 0h2M4.22 19.78l1.42-1.42M18.36 5.64l1.42-1.42">
                                </path>
                            </g>
                        </svg>
                        <svg aria-hidden="true" viewBox="0 0 24 24" class="nui-moon">
                            <path fill="currentColor" stroke="currentColor"
                                d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z" class="stroke-2"></path>
                        </svg>
                    </span>
                </label>
            </div>

            <!-- Step indicator -->
            <div class="reg-step-bar">
                <div class="reg-step-dot active"></div>
                <div class="reg-step-dot active"></div>
                <div class="reg-step-dot active"></div>
                <div class="reg-step-dot"></div>
            </div>

            <!-- Heading (GIỮ NGUYÊN nội dung + class) -->
            <div class="reg-heading">
                <h2 class="nui-heading nui-heading-3xl nui-weight-medium nui-lead-relaxed novalidate">
                    Cùng bắt đầu nào 😎
                </h2>
                <p class="reg-sub nui-paragraph nui-paragraph-sm nui-weight-normal nui-lead-normal text-muted-400">
                    Bắt đầu sử dụng dịch vụ bằng cách đăng ký tài khoản mới
                </p>
            </div>

            <!-- OAuth Banner (GIỮ NGUYÊN class oauth-google-lavender) -->
            <div class="reg-oauth-section lg:block hidden">
                <button
                    class="reg-google-btn oauth-google-lavender dark:bg-muted-700 text-muted-800 border-muted-300 dark:border-muted-600 nui-focus dark:text-white">
                    <img src="/unnamed (37) (1).png" alt="2026">
                    <div>CHÚC MỪNG NĂM MỚI - 2026</div>
                </button>

                <!-- Divider marquee (GIỮ NGUYÊN) -->
                <div class="reg-divider">
                    <hr class="border-muted-200 dark:border-muted-700">
                    <span class="text-muted-400 font-sans font-light">
                        <marquee>MIỀN CHÍNH: <?=$TD->Setting('name-site')?></marquee>
                    </span>
                    <hr class="border-muted-200 dark:border-muted-700">
                </div>
            </div>

            <!-- FORM (GIỮ NGUYÊN 100% logic backend) -->
            <form class="user-auth-register">
                <input type="hidden" name="auth" value="user-auth-register">

                <div class="mb-4 space-y-4">
                    <!-- Email -->
                    <div
                        class="reg-field nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm nui-has-icon">
                        <div class="reg-field-top">
                            <label class="nui-input-label" for="email">Địa chỉ Email</label>
                        </div>
                        <div class="nui-input-outer">
                            <div class="reg-input-outer">
                                <div class="reg-icon-left">
                                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                        viewBox="0 0 24 24">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="2">
                                            <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                                            <path d="m22 7l-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                                        </g>
                                    </svg>
                                </div>
                                <input type="email" class="reg-txt-input nui-input h-12 !ps-12"
                                    placeholder="Nhập địa chỉ email" name="email" autofocus="" data-field="Email"
                                    required>
                            </div>
                        </div>
                    </div>

                    <!-- Username -->
                    <div
                        class="reg-field nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm nui-has-icon">
                        <div class="reg-field-top">
                            <label class="nui-input-label" for="username">Tài Khoản</label>
                        </div>
                        <div class="nui-input-outer">
                            <div class="reg-input-outer">
                                <div class="reg-icon-left">
                                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                        viewBox="0 0 256 256">
                                        <g fill="currentColor">
                                            <path d="M192 96a64 64 0 1 1-64-64a64 64 0 0 1 64 64" opacity=".2"></path>
                                            <path
                                                d="M230.92 212c-15.23-26.33-38.7-45.21-66.09-54.16a72 72 0 1 0-73.66 0c-27.39 8.94-50.86 27.82-66.09 54.16a8 8 0 1 0 13.85 8c18.84-32.56 52.14-52 89.07-52s70.23 19.44 89.07 52a8 8 0 1 0 13.85-8M72 96a56 56 0 1 1 56 56a56.06 56.06 0 0 1-56-56">
                                            </path>
                                        </g>
                                    </svg>
                                </div>
                                <input type="text" class="reg-txt-input nui-input h-12 !ps-12 is-tk"
                                    placeholder="Nhập tên tài khoản" name="username" minlength="6" maxlength="27"
                                    data-field="Tài Khoản" required>
                            </div>
                        </div>
                    </div>

                    <!-- Password (GIỮ NGUYÊN password strength tooltip + wt-pw-eye) -->
                    <div class="reg-field group/password-strength relative">
                        <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm nui-has-icon">
                            <div class="reg-field-top">
                                <label class="nui-input-label nui-input-eye" for="password">Mật Khẩu</label>
                            </div>
                            <div class="nui-input-outer">
                                <div class="reg-input-outer">
                                    <div class="reg-icon-left">
                                        <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                            viewBox="0 0 24 24">
                                            <g fill="none" stroke="currentColor" stroke-linecap="round"
                                                stroke-linejoin="round" stroke-width="2">
                                                <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <input type="password" class="reg-txt-input nui-input h-12 !ps-12 is-pw"
                                        placeholder="••••••••••" name="password" minlength="6" maxlength="27"
                                        data-field="Mật Khẩu" required>
                                    <button
                                        class="reg-eye-btn wt-pw-eye leading-0 text-muted-400 peer-focus-within:text-primary-500 nui-focus absolute right-0 top-0 flex size-10 items-center justify-center text-center text-xl disabled:cursor-not-allowed"
                                        type="button" tabindex="0" data-nui-tooltip="Hiện mật khẩu">
                                        <div class="relative flex size-full items-center justify-center">
                                            <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                                class="icon size-5" width="1em" height="1em" viewBox="0 0 24 24">
                                                <path fill="currentColor"
                                                    d="M2 5.27L3.28 4L20 20.72L18.73 22l-3.08-3.08c-1.15.38-2.37.58-3.65.58c-5 0-9.27-3.11-11-7.5c.69-1.76 1.79-3.31 3.19-4.54zM12 9a3 3 0 0 1 3 3a3 3 0 0 1-.17 1L11 9.17A3 3 0 0 1 12 9m0-4.5c5 0 9.27 3.11 11 7.5a11.8 11.8 0 0 1-4 5.19l-1.42-1.43A9.86 9.86 0 0 0 20.82 12A9.82 9.82 0 0 0 12 6.5c-1.09 0-2.16.18-3.16.5L7.3 5.47c1.44-.62 3.03-.97 4.7-.97M3.18 12A9.82 9.82 0 0 0 12 17.5c.69 0 1.37-.07 2-.21L11.72 15A3.064 3.064 0 0 1 9 12.28L5.6 8.87c-.99.85-1.82 1.91-2.42 3.13">
                                                </path>
                                            </svg>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <!-- Password strength tooltip (GIỮ NGUYÊN 100%) -->
                        <div
                            class="border-muted-200 dark:border-muted-700 shadow-muted-300/30 dark:shadow-muted-800/20 dark:bg-muted-800 pointer-events-none absolute -bottom-1 start-0 z-20 translate-y-full rounded-lg border bg-white p-6 opacity-0 shadow-xl transition-opacity duration-300 group-focus-within/password-strength:pointer-events-auto group-focus-within/password-strength:opacity-100">
                            <ul class="flex flex-col gap-4">
                                <li class="flex items-center justify-between gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                        class="icon text-muted-400 dark:text-muted-500 size-4 shrink-0" width="1em"
                                        height="1em" viewBox="0 0 24 24">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="2">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3m.08 4h.01"></path>
                                        </g>
                                    </svg>
                                    <span class="grow text-xs dark:text-slate-400 dark:text-slate-350 font-semibold">Tối
                                        thiểu 6 ký tự, càng nhiều càng tốt.</span>
                                </li>
                                <li class="flex items-center justify-between gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                        class="icon text-muted-400 dark:text-muted-500 size-4 shrink-0" width="1em"
                                        height="1em" viewBox="0 0 24 24">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="2">
                                            <circle cx="12" cy="12" r="10"></circle>
                                            <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3m.08 4h.01"></path>
                                        </g>
                                    </svg>
                                    <span class="grow text-xs dark:text-slate-400 dark:text-slate-350 font-semibold">Hãy
                                        sử dụng mật khẩu có chữ cái và kèm theo số (hoặc chữ in hoa).</span>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <!-- Repeat Password (GIỮ NGUYÊN) -->
                    <div
                        class="reg-field nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm nui-has-icon">
                        <div class="reg-field-top">
                            <label class="nui-input-label nui-input-eye" for="repeat-password">Nhập Lại Mật Khẩu</label>
                        </div>
                        <div class="nui-input-outer">
                            <div class="reg-input-outer">
                                <div class="reg-icon-left">
                                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                        viewBox="0 0 24 24">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="2">
                                            <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                            <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                        </g>
                                    </svg>
                                </div>
                                <input type="password" class="reg-txt-input nui-input h-12 !ps-12 is-pw" minlength="6"
                                    maxlength="27" placeholder="••••••••••" name="repeat-password"
                                    data-field="Nhập Lại Mật Khẩu" required>
                                <button
                                    class="reg-eye-btn wt-pw-eye leading-0 text-muted-400 peer-focus-within:text-primary-500 nui-focus absolute right-0 top-0 flex size-10 items-center justify-center text-center text-xl disabled:cursor-not-allowed"
                                    type="button" tabindex="0" data-nui-tooltip="Hiện mật khẩu">
                                    <div class="relative flex size-full items-center justify-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                            class="icon size-5" width="1em" height="1em" viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M2 5.27L3.28 4L20 20.72L18.73 22l-3.08-3.08c-1.15.38-2.37.58-3.65.58c-5 0-9.27-3.11-11-7.5c.69-1.76 1.79-3.31 3.19-4.54zM12 9a3 3 0 0 1 3 3a3 3 0 0 1-.17 1L11 9.17A3 3 0 0 1 12 9m0-4.5c5 0 9.27 3.11 11 7.5a11.8 11.8 0 0 1-4 5.19l-1.42-1.43A9.86 9.86 0 0 0 20.82 12A9.82 9.82 0 0 0 12 6.5c-1.09 0-2.16.18-3.16.5L7.3 5.47c1.44-.62 3.03-.97 4.7-.97M3.18 12A9.82 9.82 0 0 0 12 17.5c.69 0 1.37-.07 2-.21L11.72 15A3.064 3.064 0 0 1 9 12.28L5.6 8.87c-.99.85-1.82 1.91-2.42 3.13">
                                            </path>
                                        </svg>
                                    </div>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Captcha (GIỮ NGUYÊN class ws-captcha) -->
                    <div
                        class="reg-field reg-captcha-area nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm nui-has-icon">
                        <div class="nui-input-outer">
                            <div class="flex w-full items-center gap-3 text-start ws-captcha"></div>
                        </div>
                    </div>

                    <!-- Terms checkbox (GIỮ NGUYÊN 100%) -->
                    <div class="reg-terms-row">
                        <div class="nui-checkbox nui-checkbox-rounded-lg nui-checkbox-primary">
                            <div class="nui-checkbox-outer">
                                <input class="nui-checkbox-input" type="checkbox" name="terms">
                                <div class="nui-checkbox-inner"></div>
                                <svg aria-hidden="true" viewBox="0 0 17 12" class="nui-icon-check">
                                    <path fill="currentColor"
                                        d="M16.576.414a1.386 1.386 0 0 1 0 1.996l-9.404 9.176A1.461 1.461 0 0 1 6.149 12c-.37 0-.74-.139-1.023-.414L.424 6.998a1.386 1.386 0 0 1 0-1.996 1.47 1.47 0 0 1 2.046 0l3.68 3.59L14.53.414a1.47 1.47 0 0 1 2.046 0z">
                                    </path>
                                </svg>
                                <svg aria-hidden="true" viewBox="0 0 24 24" class="nui-icon-indeterminate">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="4" d="M2 12h20"></path>
                                </svg>
                            </div>
                            <div class="nui-checkbox-label-wrapper">
                                <label class="nui-checkbox-label-text" for="terms">
                                    Tôi đồng ý với <a href="#!null"
                                        class="text-primary-500 hover:underline focus:underline">Chính sách & Điều
                                        khoản</a>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Submit button (GIỮ NGUYÊN class + logic) -->
                <div class="reg-submit-wrap">
                    <div class="block w-full rounded-md shadow-sm">
                        <button type="submit"
                            class="reg-btn-go nui-button nui-button-md nui-button-rounded-lg nui-button-solid nui-button-primary !h-11 w-full">
                            <i class="ri-user-add-line me-2 mt-03"></i> Đăng Ký
                        </button>
                    </div>
                </div>
            </form>

            <!-- Login link (GIỮ NGUYÊN) -->
            <p class="reg-login-row text-muted-400 font-sans text-xs leading-5">
                <span>Đã có tài khoản?</span>
                <a href="<?=Redirect::Login()?>"
                    class="text-primary-600 hover:text-primary-500 font-medium underline-offset-4 transition duration-150 ease-in-out hover:underline">
                    Đăng Nhập Ngay
                </a>
            </p>
        </div>
    </div>
</div>

<script>
    (function () {
        // Particles
        var box = document.getElementById('regParticles');
        if (box) {
            for (var i = 0; i < 25; i++) {
                var d = document.createElement('div');
                d.className = 'reg-dot';
                d.style.left = Math.random() * 100 + '%';
                d.style.top = Math.random() * 100 + '%';
                d.style.setProperty('--dur', (2 + Math.random() * 4) + 's');
                d.style.animationDelay = Math.random() * 3 + 's';
                box.appendChild(d);
            }
        }
    })();
</script>