<style>
    /* ===== LOGIN PAGE - NEW UI ===== */
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');

    .login-page-wrap {
        display: flex;
        min-height: 100vh;
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        -webkit-font-smoothing: antialiased;
    }

    /* ===== LEFT PANEL - FORM ===== */
    .login-panel-left {
        flex: 0 0 45%;
        max-width: 45%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 40px 60px;
        background: #ffffff;
    }

    .dark .login-panel-left {
        background: #1e2235;
    }

    .login-inner-box {
        width: 100%;
        max-width: 420px;
    }

    /* Top bar */
    .login-topbar {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 32px;
    }

    .login-topbar .login-back {
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 13px;
        font-weight: 500;
        color: #94a3b8;
        text-decoration: none;
        transition: color 0.3s ease;
        font-family: 'Inter', sans-serif;
    }

    .login-topbar .login-back:hover {
        color: #6366f1;
    }

    .login-topbar .login-back svg {
        width: 18px;
        height: 18px;
    }

    /* Heading */
    .login-heading-section h2 {
        font-size: 26px;
        font-weight: 700;
        color: #1e293b;
        line-height: 1.4;
        letter-spacing: -0.02em;
        margin: 0;
        font-family: 'Inter', sans-serif;
    }

    .dark .login-heading-section h2 {
        color: #f1f5f9;
    }

    .login-heading-section .login-sub {
        font-size: 14px;
        color: #94a3b8;
        margin-top: 4px;
        margin-bottom: 0;
        font-weight: 400;
        line-height: 1.5;
    }

    /* Divider with marquee */
    .login-marquee-divider {
        display: flex;
        align-items: center;
        margin: 24px 0;
    }

    .login-marquee-divider hr {
        flex: 1;
        border: none;
        border-top: 1.5px solid #e2e8f0;
        margin: 0;
    }

    .dark .login-marquee-divider hr {
        border-color: #3b4263;
    }

    .login-marquee-divider span {
        padding: 0 16px;
        font-size: 12px;
        color: #94a3b8;
        font-family: 'Inter', sans-serif;
        white-space: nowrap;
        max-width: 180px;
    }

    /* Form fields */
    .login-field {
        margin-bottom: 18px;
    }

    .login-field-top {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 8px;
    }

    .login-field-top label {
        font-size: 13px;
        font-weight: 500;
        color: #1e293b;
        font-family: 'Inter', sans-serif;
    }

    .dark .login-field-top label {
        color: #cbd5e1;
    }

    .login-input-outer {
        position: relative;
        display: flex;
        align-items: center;
    }

    .login-input-outer .login-icon-left {
        position: absolute;
        left: 14px;
        width: 18px;
        height: 18px;
        color: #94a3b8;
        pointer-events: none;
        z-index: 2;
        transition: color 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .login-input-outer .login-icon-left svg {
        width: 18px;
        height: 18px;
    }

    .login-input-outer .login-txt-input {
        width: 100%;
        height: 48px;
        padding: 0 44px 0 44px;
        border: 1.5px solid #e2e8f0;
        border-radius: 10px;
        font-size: 14px;
        font-family: 'Inter', sans-serif;
        color: #1e293b;
        background: #ffffff;
        transition: all 0.3s ease;
        outline: none;
    }

    .dark .login-input-outer .login-txt-input {
        background: #262c45;
        border-color: #3b4263;
        color: #f1f5f9;
    }

    .login-input-outer .login-txt-input::placeholder {
        color: #cbd5e1;
        font-weight: 400;
    }

    .dark .login-input-outer .login-txt-input::placeholder {
        color: #64748b;
    }

    .login-input-outer .login-txt-input:focus {
        border-color: #6366f1;
        box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
    }

    .login-input-outer .login-txt-input:focus~.login-icon-left {
        color: #6366f1;
    }

    /* Password eye toggle - keeps wt-pw-eye class */
    .login-input-outer .login-eye-btn {
        position: absolute;
        right: 10px;
        background: none;
        border: none;
        cursor: pointer;
        color: #94a3b8;
        padding: 4px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: color 0.3s ease;
        z-index: 2;
        width: 32px;
        height: 32px;
    }

    .login-input-outer .login-eye-btn:hover {
        color: #6366f1;
    }

    .login-input-outer .login-eye-btn svg {
        width: 18px;
        height: 18px;
    }

    /* Remember me row */
    .login-actions-row {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-top: 6px;
        margin-bottom: 22px;
    }

    .login-actions-row .text-primary-600 {
        font-size: 12.5px;
        color: #6366f1;
        text-decoration: none;
        font-weight: 500;
        font-family: 'Inter', sans-serif;
        transition: all 0.3s ease;
    }

    .login-actions-row .text-primary-600:hover {
        color: #4338ca;
        text-decoration: underline;
    }

    /* Submit button override */
    .login-submit-wrap {
        margin-top: 0;
    }

    .login-submit-wrap .login-btn-go {
        width: 100%;
        height: 48px;
        border: none;
        border-radius: 10px;
        background: linear-gradient(135deg, #6366f1, #4f46e5);
        color: white;
        font-size: 14.5px;
        font-weight: 600;
        font-family: 'Inter', sans-serif;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(99, 102, 241, 0.35);
        position: relative;
        overflow: hidden;
    }

    .login-submit-wrap .login-btn-go::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.15), transparent);
        transition: left 0.5s ease;
    }

    .login-submit-wrap .login-btn-go:hover::before {
        left: 100%;
    }

    .login-submit-wrap .login-btn-go:hover {
        background: linear-gradient(135deg, #4f46e5, #4338ca);
        box-shadow: 0 6px 20px rgba(99, 102, 241, 0.45);
        transform: translateY(-1px);
    }

    .login-submit-wrap .login-btn-go:active {
        transform: translateY(0);
    }

    /* Register row */
    .login-register-row {
        margin-top: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 13px;
        color: #94a3b8;
        font-family: 'Inter', sans-serif;
    }

    .login-register-row a {
        color: #6366f1;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .login-register-row a:hover {
        color: #4338ca;
        text-decoration: underline;
    }

    /* Footer */
    .login-footer-section {
        margin-top: 40px;
        text-align: center;
    }

    .login-footer-section p {
        font-size: 11px;
        color: #94a3b8;
        line-height: 1.6;
        margin: 0;
    }

    .login-footer-section .login-ft-links {
        margin-top: 6px;
        display: flex;
        justify-content: center;
        gap: 6px;
        font-size: 11px;
    }

    .login-footer-section .login-ft-links a {
        color: #6366f1;
        text-decoration: none;
        font-weight: 500;
    }

    .login-footer-section .login-ft-links a:hover {
        text-decoration: underline;
    }

    .login-footer-section .login-ft-links span {
        color: #cbd5e1;
    }

    /* ===== RIGHT PANEL - DECORATION ===== */
    .login-panel-right {
        flex: 0 0 55%;
        max-width: 55%;
        background: linear-gradient(145deg, #0f172a 0%, #1e1b4b 40%, #1e293b 100%);
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 60px 80px;
        position: relative;
        overflow: hidden;
    }

    .login-panel-right::before {
        content: '';
        position: absolute;
        width: 600px;
        height: 600px;
        border-radius: 50%;
        background: radial-gradient(circle, rgba(99, 102, 241, 0.12) 0%, transparent 70%);
        top: -150px;
        right: -150px;
        animation: lpFloat 8s ease-in-out infinite;
    }

    .login-panel-right::after {
        content: '';
        position: absolute;
        width: 450px;
        height: 450px;
        border-radius: 50%;
        background: radial-gradient(circle, rgba(6, 182, 212, 0.08) 0%, transparent 70%);
        bottom: -100px;
        left: -100px;
        animation: lpFloat 6s ease-in-out infinite reverse;
    }

    @keyframes lpFloat {

        0%,
        100% {
            transform: translate(0, 0) scale(1);
        }

        50% {
            transform: translate(20px, -20px) scale(1.05);
        }
    }

    .login-right-inner {
        position: relative;
        z-index: 1;
        text-align: center;
        max-width: 500px;
    }

    /* Right panel image */
    .login-right-img {
        max-width: 100%;
        width: 100%;
        margin: 40px auto 4px;
        display: block;
        filter: drop-shadow(0 20px 40px rgba(0, 0, 0, 0.3));
        animation: lpSlideUp 0.8s ease-out;
    }

    @keyframes lpImgFloat {

        0%,
        100% {
            transform: translateY(0);
        }

        50% {
            transform: translateY(-14px);
        }
    }

    @keyframes lpSlideUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .login-right-text {
        animation: lpSlideUp 1s ease-out 0.2s both;
    }

    .login-right-text h2 {
        font-size: 30px;
        font-weight: 700;
        color: #f1f5f9;
        margin: 0 0 6px;
        line-height: 1.2;
        font-family: 'Inter', sans-serif;
    }

    .login-right-text .lp-gradient {
        font-size: 30px;
        font-weight: 800;
        background: linear-gradient(135deg, #818cf8, #6366f1, #a78bfa);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        margin-bottom: 16px;
        display: inline-block;
        line-height: 1.3;
        font-family: 'Inter', sans-serif;
    }

    .login-right-text p {
        font-size: 14.5px;
        color: #94a3b8;
        line-height: 1.7;
        margin: 0;
        font-family: 'Inter', sans-serif;
    }

    /* Grid & particles */
    .lp-grid {
        position: absolute;
        inset: 0;
        background-image: radial-gradient(rgba(99, 102, 241, 0.08) 1px, transparent 1px);
        background-size: 30px 30px;
        pointer-events: none;
        z-index: 0;
    }

    .lp-particles {
        position: absolute;
        inset: 0;
        pointer-events: none;
        z-index: 0;
    }

    .lp-dot {
        position: absolute;
        width: 3px;
        height: 3px;
        background: rgba(99, 102, 241, 0.4);
        border-radius: 50%;
        animation: lpTwinkle var(--dur) ease-in-out infinite;
    }

    @keyframes lpTwinkle {

        0%,
        100% {
            opacity: 0;
            transform: scale(0.5);
        }

        50% {
            opacity: 1;
            transform: scale(1.2);
        }
    }

    /* Field animations */
    .login-field {
        animation: lpFadeUp 0.5s ease-out both;
    }

    .login-field:nth-child(2) {
        animation-delay: 0.05s;
    }

    .login-field:nth-child(3) {
        animation-delay: 0.1s;
    }

    @keyframes lpFadeUp {
        from {
            opacity: 0;
            transform: translateY(12px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Responsive */
    @media (max-width: 1200px) {
        .login-panel-left {
            padding: 40px 40px;
        }

        .login-panel-right {
            padding: 40px 50px;
        }
    }

    @media (max-width: 1024px) {
        .login-page-wrap {
            flex-direction: column;
        }

        .login-panel-left,
        .login-panel-right {
            flex: 1;
            max-width: 100%;
        }

        .login-panel-right {
            display: none;
        }

        .login-panel-left {
            padding: 40px 24px;
        }
    }
</style>

<div class="login-page-wrap select-none">
    <!-- ===== LEFT PANEL - FORM ===== -->
    <div class="login-panel-left">
        <div class="login-inner-box">

            <!-- Top bar: back link + theme toggle (GIỮ NGUYÊN) -->
            <div class="login-topbar">
                <a href="/trang-chu"
                    class="login-back text-muted-400 hover:text-primary-500 font-sans font-medium transition-colors duration-300">
                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" viewBox="0 0 24 24">
                        <path fill="currentColor"
                            d="m1.027 11.993l4.235 4.25L6.68 14.83l-1.821-1.828L22.974 13v-2l-18.12.002L6.69 9.174L5.277 7.757z">
                        </path>
                    </svg>
                    <span>Về trang chủ</span>
                </a>
                <label class="nui-theme-toggle" for="theme-toggle-input">
                    <input type="checkbox" class="nui-theme-toggle-input" id="theme-toggle-input">
                    <span class="nui-theme-toggle-inner">
                        <svg aria-hidden="true" viewBox="0 0 24 24" class="nui-sun">
                            <g fill="currentColor" stroke="currentColor" class="stroke-2">
                                <circle cx="12" cy="12" r="5"></circle>
                                <path
                                    d="M12 1v2m0 18v2M4.22 4.22l1.42 1.42m12.72 12.72 1.42 1.42M1 12h2m18 0h2M4.22 19.78l1.42-1.42M18.36 5.64l1.42-1.42">
                                </path>
                            </g>
                        </svg>
                        <svg aria-hidden="true" viewBox="0 0 24 24" class="nui-moon">
                            <path fill="currentColor" stroke="currentColor"
                                d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z" class="stroke-2"></path>
                        </svg>
                    </span>
                </label>
            </div>

            <!-- Heading (GIỮ NGUYÊN nội dung + class) -->
            <div class="login-heading-section">
                <h2 class="nui-heading nui-heading-3xl nui-weight-medium nui-lead-relaxed novalidate">
                    Chào mừng trở lại 👋
                </h2>
                <p class="login-sub nui-paragraph nui-paragraph-sm nui-weight-normal nui-lead-normal text-muted-400">
                    Vui lòng đăng nhập để sử dụng dịch vụ
                </p>
            </div>

            <!-- Divider marquee (GIỮ NGUYÊN) -->
            <div class="login-marquee-divider">
                <hr class="border-muted-200 dark:border-muted-700">
                <span class="text-muted-400 font-sans font-light">
                    <marquee>MIỀN CHÍNH: <?=$TD->Setting('name-site')?></marquee>
                </span>
                <hr class="border-muted-200 dark:border-muted-700">
            </div>

            <!-- FORM (GIỮ NGUYÊN 100% logic backend) -->
            <form class="user-auth-login">
                <input type="hidden" name="auth" value="user-auth-login">

                <div class="space-y-4">
                    <!-- Username -->
                    <div class="login-field">
                        <div class="login-field-top">
                            <label class="nui-input-label" for="username">Tài Khoản</label>
                        </div>
                        <div class="login-input-outer">
                            <div class="login-icon-left">
                                <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                    viewBox="0 0 256 256">
                                    <g fill="currentColor">
                                        <path d="M192 96a64 64 0 1 1-64-64a64 64 0 0 1 64 64" opacity=".2"></path>
                                        <path
                                            d="M230.92 212c-15.23-26.33-38.7-45.21-66.09-54.16a72 72 0 1 0-73.66 0c-27.39 8.94-50.86 27.82-66.09 54.16a8 8 0 1 0 13.85 8c18.84-32.56 52.14-52 89.07-52s70.23 19.44 89.07 52a8 8 0 1 0 13.85-8M72 96a56 56 0 1 1 56 56a56.06 56.06 0 0 1-56-56">
                                        </path>
                                    </g>
                                </svg>
                            </div>
                            <input type="text" autofocus="" class="login-txt-input nui-input"
                                placeholder="Nhập email hoặc tài khoản" name="username" minlength="6" maxlength="27"
                                data-field="Tài Khoản" required>
                        </div>
                    </div>

                    <!-- Password -->
                    <div class="login-field">
                        <div class="login-field-top">
                            <label class="nui-input-label" for="password">Mật Khẩu</label>
                        </div>
                        <div class="login-input-outer">
                            <div class="login-icon-left">
                                <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                    viewBox="0 0 24 24">
                                    <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2">
                                        <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                                        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                    </g>
                                </svg>
                            </div>
                            <input type="password" class="login-txt-input nui-input" placeholder="••••••••••"
                                name="password" minlength="6" maxlength="27" data-field="Mật Khẩu" required>
                            <button
                                class="login-eye-btn wt-pw-eye leading-0 text-muted-400 peer-focus-within:text-primary-500 nui-focus"
                                type="button" tabindex="0" data-nui-tooltip="Hiện mật khẩu">
                                <div class="relative flex size-full items-center justify-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img"
                                        class="icon size-5" width="1em" height="1em" viewBox="0 0 24 24">
                                        <path fill="currentColor"
                                            d="M2 5.27L3.28 4L20 20.72L18.73 22l-3.08-3.08c-1.15.38-2.37.58-3.65.58c-5 0-9.27-3.11-11-7.5c.69-1.76 1.79-3.31 3.19-4.54zM12 9a3 3 0 0 1 3 3a3 3 0 0 1-.17 1L11 9.17A3 3 0 0 1 12 9m0-4.5c5 0 9.27 3.11 11 7.5a11.8 11.8 0 0 1-4 5.19l-1.42-1.43A9.86 9.86 0 0 0 20.82 12A9.82 9.82 0 0 0 12 6.5c-1.09 0-2.16.18-3.16.5L7.3 5.47c1.44-.62 3.03-.97 4.7-.97M3.18 12A9.82 9.82 0 0 0 12 17.5c.69 0 1.37-.07 2-.21L11.72 15A3.064 3.064 0 0 1 9 12.28L5.6 8.87c-.99.85-1.82 1.91-2.42 3.13">
                                        </path>
                                    </svg>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Remember me + Forgot password (GIỮ NGUYÊN 100%) -->
                <div class="login-actions-row">
                    <div class="nui-checkbox nui-checkbox-rounded-lg nui-checkbox-primary">
                        <div class="nui-checkbox-outer">
                            <input class="nui-checkbox-input" type="checkbox" id="remember-me" name="remember-me">
                            <div class="nui-checkbox-inner"></div>
                            <svg aria-hidden="true" viewBox="0 0 17 12" class="nui-icon-check">
                                <path fill="currentColor"
                                    d="M16.576.414a1.386 1.386 0 0 1 0 1.996l-9.404 9.176A1.461 1.461 0 0 1 6.149 12c-.37 0-.74-.139-1.023-.414L.424 6.998a1.386 1.386 0 0 1 0-1.996 1.47 1.47 0 0 1 2.046 0l3.68 3.59L14.53.414a1.47 1.47 0 0 1 2.046 0z">
                                </path>
                            </svg>
                            <svg aria-hidden="true" viewBox="0 0 24 24" class="nui-icon-indeterminate">
                                <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="4" d="M2 12h20"></path>
                            </svg>
                        </div>
                        <div class="nui-checkbox-label-wrapper">
                            <label class="nui-checkbox-label-text" for="remember-me">
                                Lưu đăng nhập
                            </label>
                        </div>
                    </div>
                    <div class="text-xs leading-5">
                        <a href="recover-password"
                            class="text-primary-600 hover:text-primary-500 font-sans font-medium underline-offset-4 transition duration-150 ease-in-out hover:underline">
                            Quên mật khẩu?
                        </a>
                    </div>
                </div>

                <!-- Submit button (GIỮ NGUYÊN class + logic) -->
                <div class="login-submit-wrap">
                    <div class="block w-full rounded-md shadow-sm">
                        <button type="submit"
                            class="login-btn-go nui-button nui-button-md nui-button-rounded-lg nui-button-solid nui-button-primary !h-11 w-full">
                            <i class="ri-arrow-right-line me-2 mt-03"></i> Đăng Nhập
                        </button>
                    </div>
                </div>
            </form>

            <!-- Register link (GIỮ NGUYÊN) -->
            <p class="login-register-row text-muted-400 font-sans text-xs leading-5">
                <span>Chưa có tài khoản?</span>
                <a href="<?=Redirect::Register()?>"
                    class="text-primary-600 hover:text-primary-500 font-medium underline-offset-4 transition duration-150 ease-in-out hover:underline">
                    Đăng Ký Ngay
                </a>
            </p>

            <!-- Footer -->
            <div class="login-footer-section">
                <p>© 2026 <?=$TD->Setting('name-site')?> - All rights reserved.</p>
                <div class="login-ft-links">
                    <a href="#">Điều khoản</a>
                    <span>•</span>
                    <a href="#">Bảo mật</a>
                </div>
            </div>
        </div>
    </div>

    <!-- ===== RIGHT PANEL - DECORATION ===== -->
    <div class="login-panel-right">
        <div class="lp-grid"></div>
        <div class="lp-particles" id="lpParticles"></div>

        <div class="login-right-inner">
            <!-- Banner image -->
            <img class="login-right-img pointer-events-none"
                src="/<?= __IMG__ ?>/unnamed (37) (1).png"
                alt="<?=$TD->Setting('name-site')?> Banner">

            <div class="login-right-text">
                <h2>Nâng tầm bản thân</h2>
                <div class="lp-gradient">Dễ dàng & Bảo mật</div>
                <p>Hệ thống cập nhật nhanh chóng. Tự động hóa quy trình, bảo mật đa lớp và hỗ trợ kỹ thuật 24/7.
                </p>
            </div>
        </div>
    </div>
</div>

<script>
    (function () {
        // Particles animation
        var box = document.getElementById('lpParticles');
        if (box) {
            for (var i = 0; i < 20; i++) {
                var d = document.createElement('div');
                d.className = 'lp-dot';
                d.style.left = Math.random() * 100 + '%';
                d.style.top = Math.random() * 100 + '%';
                d.style.setProperty('--dur', (2 + Math.random() * 4) + 's');
                d.style.animationDelay = Math.random() * 3 + 's';
                box.appendChild(d);
            }
        }
    })();
</script>