<?php
/**
 * Device Check Management
 * 
 * This class handles device checking and updating in the database.
 */
class DeviceCheck extends DatabaseConnection 
{
    /**
     * Constructor
     * 
     * Initialize the DeviceCheck class
     */
    public function __construct() 
    {
        // parent::__construct();
    }
    /**
     * Update device information
     * 
     * Updates or inserts device information in the database
     * and sets a device-id cookie
     * 
     * @return bool True if successful, false otherwise
     */
    public function update($username) 
    {
        extract($GLOBALS);
        $stmt = self::ThanhDieuDB()->prepare("SELECT * FROM ws_devices WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $ooo = $stmt->get_result();
        if ($ooo->num_rows > 0) 
        {
            $vtd = self::ThanhDieuDB()->prepare("UPDATE ws_devices SET 
                ua = ?, 
                os = ?, 
                ip = ?, 
                browser = ?
                WHERE username = ?");
            $vtd->bind_param("sssss", 
                $userAgent, 
                $device_name, 
                $ip, 
                $browser_name,
                $username
            );
            $vtd->execute();
            $vtd->close();
        } else {
            $vtd = self::ThanhDieuDB()->prepare("INSERT INTO ws_devices 
            (username, ua, os, ip, browser) 
            VALUES (?, ?, ?, ?, ?)");
            $vtd->bind_param("sssss", 
                $username,
                $userAgent, 
                $device_name, 
                $ip, 
                $browser_name,
            );
            $vtd->execute();
            $vtd->close();
        }
        setcookie('device-id', $wtSecurity->encrypt($userAgent.'|'.$device_name.'|'.$ip.'|'.$browser_name), time() + (30 * 24 * 60 * 60), '/', '', true, true);
        return true;
    }
}
$deviceCheck = new DeviceCheck();