<?php
header('Content-Type: application/json');
require $_SERVER['DOCUMENT_ROOT'].'/config/database.php';
require __DIR__.'/DeviceManager.php';
/**
 * Device ID Check and Management
 * 
 * This file contains functions to check, validate and manage device IDs
 * through cookies and database tracking.
 */
ThanhDieuPOST(function($payload) 
{
    extract($GLOBALS);
    if (!isset($payload['action']) || $payload['action'] != 'device-check') 
    {
        exit(JSON_FORMATTER(['status' => -97, 'msg' => 'Unauthorized access denied']));
    }
    function destroy() 
    {
        setcookie("ssk", "", time() - WsRandomString::Number(10), "/");
        setcookie("device-id", "", time() - WsRandomString::Number(10), "/");
    }
    if (isset($_COOKIE['device-id'])) 
    {
        $deviceData = $wtSecurity->decrypt($_COOKIE['device-id']);
        if ($deviceData !== false && $deviceData !== null) 
        {
            list($UserAgent, $DeviceName, $IP, $BrowserName) = explode('|', $deviceData);
            if (
                $UserAgent !== $userAgent ||
                $DeviceName !== $device_info->name ||
                $IP !== $ip ||
                $BrowserName !== $browser_name
            ) {
                destroy();
                exit(JSON_FORMATTER(['status' => -99, 'msg' => 'Hệ thống phát hiện lần đăng nhập đáng ngờ, vui lòng đăng nhập lại!']));
            }        
            if (!$SSC->check()) 
            {
                $vtd = $thanhdieudb->prepare("SELECT * FROM ws_devices WHERE username = ?");
                $vtd->bind_param("s", $taikhoan);
                $vtd->execute();
                $ooo = $vtd->get_result();
                if ($ooo->num_rows == 0) 
                {            
                    destroy();
                }
                $_data = $ooo->fetch_assoc();
                if (!$_data || 
                $_data['ua'] != $userAgent || 
                $_data['os'] != $device_info->name || 
                $_data['browser'] != $browser_name || 
                $_data['ip'] != $ip
                ) {
                    destroy();
                    exit(JSON_FORMATTER(['status' => -99, 'msg' => 'Tài khoản của bạn đã được đăng nhập trên thiết bị khác, vui lòng đăng nhập lại!']));
                }                
            }
        } else 
        {
            exit(JSON_FORMATTER(['status' => -98, 'msg' => 'Unauthorized access denied']));
        }
    } else {
        destroy();
    }
    exit(JSON_FORMATTER(['status' => 'OK']));
});