<?php
namespace Database;
class Installer
{
    private $lock = '/install.lock';
    private $config = '/config.ini';
    private $robots = '/robots.txt';
    // private $db = '/function/connect/config.ini.php';

    public function __construct()
    {
        $this->lock = $_SERVER['DOCUMENT_ROOT'].$this->lock;
        $this->config = $_SERVER['DOCUMENT_ROOT'].$this->config;
        $this->robots = $_SERVER['DOCUMENT_ROOT'].$this->robots;
        // $this->db = $_SERVER['DOCUMENT_ROOT'].$this->db;
    }

    /**
     * Get current domain (without protocol and path)
     *
     * @return string
     */
    private function domain()
    {
        $cd = $_SERVER['HTTP_HOST'];
        return strtolower($cd);
    }

    /**
     * Check PHP version and MySQLi support
     *
     * @return bool
     */
    private function server()
    {
        // if (version_compare(phpversion(), '8.0', '<'))
        // {
        //     return false;
        // }

        // if (!function_exists('mysqli_connect'))
        // {
        //     return false;
        // }
        return (version_compare(PHP_VERSION, '8.0.0', '>=') && function_exists('mysqli_connect'));
    }

    /**
     * Check if install.lock file exists and contains the current domain
     *
     * @return bool
     */
    private function installed()
    {
        if (file_exists($this->lock)) 
        {
            $content = file_get_contents($this->lock);
            if ($this->similar($content, $this->domain())) 
            {
                return true;
            }
        }
        return false;
    }

    /**
     * Check install & config
     *
     * @return bool
     */
    public function check()
    {
    if ($this->installed()) {
        if (!file_exists($this->config)) {
            $this->create($this->domain());
        } else {
            $this->robots();
        }
        return true;
    }
    $domains = [];
    if (file_exists($this->lock)) {
        $domains = array_map('trim', file($this->lock));
    }

    $current_domain = $this->domain();
    foreach ($domains as $domain) {
        if ($this->similar($domain, $current_domain)) {
            file_put_contents($this->lock, implode(PHP_EOL, $domains));
            return true;
        }
    }
    $domains[] = $current_domain;
    file_put_contents($this->lock, implode(PHP_EOL, $domains));
    if (!file_exists($this->config)) {
        $this->create($current_domain);
    } else {
        $this->robots();
    }

    return true;
    }
    /**
     * Method to check if current domain matches locked domain or is a subdomain
     *
     * @param string $current_domain
     * @param string $locked_domain
     * @return bool
     */
    private function similar($current_domain, $locked_domain)
    {
        return strpos($current_domain, $locked_domain) !== false || strpos($locked_domain, $current_domain) !== false;
    }

    /**
     * Create config file with current domain
     *
     * @param string $domain
     * @return void
     */
    private function create($domain)
    {
        $data = "[config]\ndomain = ".$domain;
        file_put_contents($this->config, $data);
    }

    /**
     * Make file config & update install
     *
     * @return void
     */
    public function config()
    {
        file_put_contents($this->lock, $this->domain());
        if (!file_exists($this->config)) 
        {
            $this->create($this->domain());
        } else 
        {
            $content = file_get_contents($this->config);
            if (strpos($content, $this->domain()) === false) 
            {
                $data = "\ndomain = ".$this->domain();
                file_put_contents($this->config, $data);
            }
        }
    }
    /**
     * Check if robots.txt exists, and if not, create it with default content
    *
    * @return void
    */
    public function robots()
    {
        if (!file_exists($this->robots)) 
        {
            $content = <<<ROBOTS
            #
            # robots.txt file automatically generated by system
            #
            User-agent: *
            Disallow: /admin
            Disallow: /install
            Disallow: /public
            Disallow: /function
            Disallow: /server
            Disallow: /app
            ROBOTS;
            file_put_contents($this->robots, $content);
        }
    }

    /**
     * Redirect to page install or unsupported
     *
     * @param string $redirect
     *
     * @return void
     */
    public function redirect($redirect)
    {

        if (strpos($_SERVER['REQUEST_URI'], 'install') === false) 
        {

            if (!$this->check()) 
            {
                header('Location: '.$redirect);
                exit;
            } else 
            {
                $this->config();
            }
        } else 
        {
            if ($this->installed()) 
            {
                header('Location: /');
                exit;
            }
        }
    }
}
$load = new Installer();
$load->redirect('/install/');