<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/config/database.php');
require_once($_SERVER['DOCUMENT_ROOT'].'/vendor/autoload.php');
require_once($_SERVER['DOCUMENT_ROOT'].'/function/handle/DeviceManager.php');
class GoogleOAuth extends DatabaseConnection
{
    private $client;

    private function checkGoogleCredentials()
    {
        $client_id = $GLOBALS['TD']->Setting('google-client-id');
        $client_secret = $GLOBALS['TD']->Setting('google-client-secret');
        if (empty($client_id) || empty($client_secret)) 
        {
            echo '<script>
                window.opener.postMessage({
                    type: "error",
                    msg: "Thất bại, quản trị viên chưa cấu hình Google OAuth nên không thể thực hiện thao tác này!"
                }, "*");
                window.close();
            </script>';
            exit();
        }
        return ['id' => $client_id, 'secret' => $client_secret];
    }
    private function setSSK($username) 
    {
        setcookie(
            'ssk', 
            $GLOBALS['wtSecurity']->encrypt($username), 
            time() + 666 * 24 * 60 * 60,
            "/", 
            "", 
            true, 
            true
        );
    }
    public function __construct() 
    {
        try {
            $credentials = $this->checkGoogleCredentials();
            $this->client = new Google_Client();
            $this->client->setClientId($credentials['id']);
            $this->client->setClientSecret($credentials['secret']);
            $this->client->setRedirectUri((preg_match('/^(localhost|127\.0\.0\.1|192\.168\.\d+\.\d+)$/',$_SERVER['HTTP_HOST'])?'http':'https').'://'.$_SERVER['HTTP_HOST'].'/function/call-back/controller/oauth.google.php');
            $this->client->addScope('email');
            $this->client->addScope('profile');
        } catch (Exception $e) {
            echo '<script>
                window.opener.postMessage({
                    type: "error",
                    msg: "'.$e->getMessage().'"
                }, "*");
                window.close();
            </script>';
            exit();
        }
    }
    public function getAuthUrl($type = 'login')
    {
        $this->client->setState($type); 
        return $this->client->createAuthUrl();
    }
    private function checkEmail($email) 
    {
        try {
            if ($vtd = self::ThanhDieuDB()->prepare("SELECT * FROM users WHERE email = ? LIMIT 1")) 
            {
                $vtd->bind_param("s", $email);
                $vtd->execute();
                $result = $vtd->get_result();
                $user = $result->fetch_assoc();
                if ($user) 
                {
                    return [
                        'exists' => true,
                        'oauth_type' => $user['oauth_type'],
                        'banned' => $user['banned'],
                        'username' => $user['username']
                    ];
                }
                return [
                    'exists' => false,
                    'oauth_type' => null,
                    'banned' => 0,
                    'username' => null
                ];
            } else {
                return [
                    'exists' => false,
                    'oauth_type' => null,
                    'banned' => 0,
                    'username' => null
                ];
            }
        } catch (Exception $e) 
        {
            return [
                'exists' => false,
                'oauth_type' => null,
                'banned' => 0,
                'username' => null
            ];
        }
    }
    private function registerUser($name, $email, $picture) 
    {
        $username = $this->genUser($name);
        $GLOBALS['deviceCheck']->update($username);
        $hashed_pw = password_hash(bin2hex(random_bytes(8)), PASSWORD_BCRYPT, ['cost' => 7]);
        $access_key = WsRandomString::Key();
        $vtd = self::ThanhDieuDB()->prepare("INSERT INTO users (username, email, password, avatar, oauth_type, ip, access_key) VALUES (?, ?, ?, ?, 'google', ?, ?)");
        $vtd->bind_param("ssssss", $username, $email, $hashed_pw, $picture, $GLOBALS['ip'], $access_key);
        if ($vtd->execute()) 
        {
            $vtd_log = self::ThanhDieuDB()->prepare("INSERT INTO ws_logs (username, content, action) VALUES (?, ?, ?)");
            $content = "\xc4\x91\xc4\x83\x6e\x67\x20\x6b\xc3\xbd\x20\x74\xc3\xa0\x69\x20\x6b\x68\x6f\xe1\xba\xa3\x6e\x20\x6d\xe1\xbb\x9b\x69";
            $action = "\xc4\x90\xc4\x83\x6e\x67\x20\x4b\xc3\xbd\x20\x54\xc3\xa0\x69\x20\x4b\x68\x6f\xe1\xba\xa3\x6e";
            $vtd_log->bind_param("sss", $username, $content, $action);
            if ($vtd_log->execute()) 
            {
                $this->setSSK($username);
                return true;
            }
        }
        throw new Exception("Không thể tạo tài khoản tự động, vui lòng thử lại sau!");
    }
    public function callback() 
    {
        if (isset($_GET['code'])) 
        {
            try {
                $token = $this->client->fetchAccessTokenWithAuthCode($_GET['code']);
                $this->client->setAccessToken($token);
                $google_oauth = new Google_Service_Oauth2($this->client);
                $google_account_info = $google_oauth->userinfo->get();
                $email = $google_account_info->email;
                $name = $google_account_info->name;
                $picture = $google_account_info->picture;
                $tdieu = $this->checkEmail($email);
                $type = isset($_GET['state']) ? $_GET['state'] : 'login';
                if ($type === 'login') {
                    if (!$tdieu['exists']) 
                    {
                        if ($this->registerUser($name, $email, $picture)) 
                        {
                            echo '<script>
                                window.opener.postMessage({
                                    type: "success",
                                    auth: "register",
                                    msg: "Tạo tài khoản mới thành công, tự động vào trang chủ sau 3s.."
                                }, "*");
                                window.close();
                            </script>';
                            exit();
                        }
                    }
                    if ($tdieu['oauth_type'] != 'google') 
                    {
                        echo '<script>
                            window.opener.postMessage({
                                type: "error",
                                msg: "Địa chỉ email này không được tạo bằng Google, vui lòng đăng nhập bằng mật khẩu!"
                            }, "*");
                            window.close();
                        </script>';
                        exit();
                    }
                    if ($tdieu['banned'] == 1) 
                    {
                        echo '<script>
                            window.opener.postMessage({
                                type: "error",
                                msg: "Tài khoản của bạn đã bị đình chỉ, vui lòng liên hệ cho CSKH để biết thêm chi tiết!"
                            }, "*");
                            window.close();
                        </script>';
                        exit();
                    }
                    $this->setSSK($tdieu['username']);
                    self::ThanhDieuDB()->query("UPDATE users SET ip = '{$GLOBALS['ip']}' WHERE username = '{$tdieu['username']}'");
                    $GLOBALS['deviceCheck']->update($tdieu['username']);
                    echo '<script>
                        window.opener.postMessage({
                            type: "success",
                            auth: "login",
                            msg: "Đăng nhập thành công!"
                        }, "*");
                        window.close();
                    </script>';
                    exit();
                } else {
                    if ($tdieu['exists']) 
                    {
                    //     $this->setSSK($tdieu['username']);
                    //     echo '<script>
                    //     window.opener.postMessage({
                    //         type: "success",
                    //         auth: "login",
                    //         msg: "Đăng nhập thành công!"
                    //     }, "*");
                    //     window.close();
                    // </script>';
                    echo '<script>
                    window.opener.postMessage({
                        type: "error",
                        msg: "Địa chỉ email '.THANHDIEU($email).' đã tồn tại trên hệ thống, vui lòng sử dụng email khác!"
                    }, "*");
                    window.close();
                </script>';
                        exit();
                    }
                    
                    if ($this->registerUser($name, $email, $picture)) 
                    {
                        echo '<script>
                            window.opener.postMessage({
                                type: "success", 
                                auth: "register",
                                msg: "Tạo tài khoản mới thành công, tự động vào trang chủ sau 3s.."
                            }, "*");
                            window.close();
                        </script>';
                        exit();
                    }
                }
            } catch (Exception $e) 
            {
                echo '<script>
                    window.opener.postMessage({
                        type: "error", 
                        msg: "'.$e->getMessage().'"
                    }, "*");
                    window.close();
                </script>';
                exit();
            }
        }
    }
    private function genUser($name) 
    {
        $base = strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $name));
        $username = $base;
        $i = 1;
        while (true) {
            $vtd = self::ThanhDieuDB()->prepare("SELECT user_id FROM users WHERE username = ?");
            $vtd->bind_param("s", $username);
            $vtd->execute();
            if ($vtd->get_result()->num_rows === 0) 
            {
                break;
            }
            $username = $base.$i;
            $i++;
        }
        return $username;
    }
}

$oauth = new GoogleOAuth();
if (!isset($_GET['code'])) 
{
    $type = isset($_GET['type']) ? $_GET['type'] : 'login';
    header('Location: '.$oauth->getAuthUrl($type));
    exit;
} else 
{
    $oauth->callback();
}