<?php
/**
 * Kết Nối CSDL
 */
require_once($_SERVER['DOCUMENT_ROOT'] . '/config/database.php');

// Ép kiểu trả về là JSON và chặn mọi HTML thừa từ file config (nếu có)
ob_clean(); 
header('Content-Type: application/json');

function writeLog($message) {
    $logDir = $_SERVER['DOCUMENT_ROOT'] . '/logs';
    if (!is_dir($logDir)) mkdir($logDir, 0755, true);
    $log = "[" . date('Y-m-d H:i:s') . "] " . $message . PHP_EOL;
    file_put_contents($logDir . '/card5s_callback.log', $log, FILE_APPEND);
}

// 1. LẤY DỮ LIỆU TỪ CARD5S GỬI VỀ (POST)
$data = $_POST;
if (empty($data)) {
    die(json_encode(["status" => "error", "message" => "No data received"]));
}

writeLog("Nhận callback: " . json_encode($data));

// Các biến Card5s thường gửi về: status, prices_real, request_id, content...
$status = $data['status'] ?? '';
$amount_real = intval($data['prices_real'] ?? 0); // MỆNH GIÁ THỰC TẾ
$request_id = $data['content'] ?? ''; // Thường là ID hoặc mã nội dung bạn gửi đi
$declared_value = intval($data['prices_value'] ?? 0); // Mệnh giá bạn gửi lên

if (!$request_id) {
    die(json_encode(["status" => "error", "message" => "Missing request_id"]));
}

try {
    // 2. KIỂM TRA THẺ TRONG DATABASE
    $stmt = $thanhdieudb->prepare("SELECT * FROM ws_history_card WHERE request_id = ? AND trangthai = 'choxuly' LIMIT 1");
    $stmt->bind_param("s", $request_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $card = $result->fetch_assoc();

    if (!$card) {
        writeLog("Thẻ không tồn tại hoặc đã xử lý: $request_id");
        die(json_encode(["status" => "error", "message" => "Card not found or processed"]));
    }

    $card_id = $card['card_id'];
    $username = $card['taikhoan'];

    // 3. XỬ LÝ LOGIC CỘNG TIỀN
    if ($status == '1') { // THÀNH CÔNG
        // Kiểm tra sai mệnh giá
        $is_wrong_amount = ($amount_real != $declared_value);
        
        // Lấy số dư hiện tại
        $u_stmt = $thanhdieudb->prepare("SELECT sodu FROM users WHERE username = ?");
        $u_stmt->bind_param("s", $username);
        $u_stmt->execute();
        $userData = $u_stmt->get_result()->fetch_assoc();

        if ($userData) {
            // TÍNH TOÁN: 
            // Nếu sai mệnh giá: 50% của mệnh giá thực (amount_real)
            // Nếu đúng mệnh giá: 90% của mệnh giá thực (amount_real)
            $chietkhau = $is_wrong_amount ? 0.5 : 0.9;
            $money_add = $amount_real * $chietkhau;
            
            $new_balance = $userData['sodu'] + $money_add;

            // Cập nhật số dư user
            $up_user = $thanhdieudb->prepare("UPDATE users SET sodu = ? WHERE username = ?");
            $up_user->bind_param("ds", $new_balance, $username);
            $up_user->execute();

            // Cập nhật trạng thái thẻ
            $final_status = 'thanhcong';
            $up_card = $thanhdieudb->prepare("UPDATE ws_history_card SET trangthai = ?, menhgia_thuc = ? WHERE card_id = ?");
            $up_card->bind_param("sii", $final_status, $amount_real, $card_id);
            $up_card->execute();

            writeLog("Thành công: User $username +$money_add (Thực nhận: $amount_real, CK: $chietkhau)");
        }
    } else {
        // THẤT BẠI (Status 2, 3...)
        $up_card = $thanhdieudb->prepare("UPDATE ws_history_card SET trangthai = 'thatbai' WHERE card_id = ?");
        $up_card->bind_param("i", $card_id);
        $up_card->execute();
        writeLog("Thẻ $card_id thất bại. Status: $status");
    }

    echo json_encode(["status" => "success", "message" => "Callback processed"]);

} catch (Exception $e) {
    writeLog("LỖI HỆ THỐNG: " . $e->getMessage());
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}