<?php
define("IN_SITE", true);
date_default_timezone_set('Asia/Ho_Chi_Minh');

class DB {
    private $host = "localhost";
    private $username = "okbillor_okbill";
    private $password = "okbillor_okbill";    
    private $database = "okbillor_okbill"; 
    public $conn;

    public function __construct() {
        $this->conn = new mysqli(
            $this->host, $this->username,
            $this->password, $this->database
        );
        if ($this->conn->connect_error) {
            die("Kết nối CSDL thất bại: " . $this->conn->connect_error);
        }
        $this->conn->set_charset("utf8mb4");
    }

    public function query($sql) {
        return $this->conn->query($sql);
    }

    public function get_row($sql) {
        $result = $this->conn->query($sql);
        return ($result && $result->num_rows > 0) ? $result->fetch_assoc() : null;
    }

    public function num_rows($sql) {
        $result = $this->conn->query($sql);
        return ($result) ? $result->num_rows : 0;
    }

    public function insert($table, $data) {
        $columns = implode("`,`", array_keys($data));
        $values = implode("','", array_map([$this->conn, 'real_escape_string'], array_values($data)));
        $sql = "INSERT INTO `$table` (`$columns`) VALUES ('$values')";
        return $this->conn->query($sql);
    }
}

$TN = new DB();

function check_string($data) {
    return trim(strip_tags($data));
}

function parse_order_id($description) {
    if (preg_match('/thanhtoan(\d+)/i', $description, $matches)) {
        return intval($matches[1]);
    }
    return null;
}

function PlusCredits($userId, $amount, $note, $tranId, $bank = "MBBANK") {
    global $TN;
    $amount = floatval($amount);
    $userId = intval($userId);

    $getUser = $TN->get_row("SELECT * FROM `users` WHERE `user_id` = '$userId'");
    if (!$getUser) return false;

    $username = $getUser['username'];

    $TN->query("UPDATE `users` SET `sodu` = `sodu` + $amount, `tongnap` = `tongnap` + $amount WHERE `user_id` = '$userId'");

    $TN->query("INSERT INTO `ws_history_bank` (`username`, `loai`, `magiaodich`, `sotien`, `noidung`, `thoigian`, `trangthai`) 
                VALUES ('$username', 'Nạp Tự Động', '$tranId', '$amount', '$note', NOW(), 'thanhcong')");

    $TN->query("INSERT INTO `ws_logs` (`username`, `content`, `time`, `action`) 
                VALUES ('$username', 'nạp tiền tự động $bank - Số tiền: ".number_format($amount)."đ', NOW(), 'Nạp Tiền')");

    return true;
}

function curl_get($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

// GỬI THÔNG BÁO TELEGRAM
function send_telegram($message) {
    $bot_token = '8461218897:AAE2aqlmkkhT28cKesjqvMOkQOQ7zSvOeGs'; // ← Thay bằng token bot của bạn
    $chat_id = '-1003014868253';     // ← Thay bằng chat ID của bạn

    $url = "https://api.telegram.org/bot$bot_token/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

// GỌI API MBBANK
$token = "0cc0c1fc1093d03e7ef3dec8c5ba24e2";
$response = curl_get("https://api.vpnfast.vn/historyapimbbank/$token");
$result = json_decode($response, true);

// TẠO CÁC BẢNG CẦN THIẾT
$TN->query("CREATE TABLE IF NOT EXISTS `invoices` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `trans_id` VARCHAR(255) NOT NULL,
    `payment_method` VARCHAR(50) NOT NULL,
    `user_id` INT NOT NULL,
    `description` TEXT,
    `amount` FLOAT NOT NULL,
    `status` INT DEFAULT 1,
    `create_time` INT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$TN->query("CREATE TABLE IF NOT EXISTS `ws_history_bank` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(255),
    `loai` VARCHAR(50),
    `magiaodich` VARCHAR(255),
    `sotien` FLOAT,
    `noidung` TEXT,
    `thoigian` DATETIME,
    `trangthai` VARCHAR(20)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$TN->query("CREATE TABLE IF NOT EXISTS `ws_logs` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(255),
    `content` TEXT,
    `time` DATETIME,
    `action` VARCHAR(50)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

// XỬ LÝ GIAO DỊCH NẠP TIỀN
if (isset($result['TranList']) && is_array($result['TranList'])) {
    foreach ($result['TranList'] as $data) {
        $tranId  = check_string($data['refNo']);
        $comment = check_string($data['description']);
        $amount  = floatval(check_string($data['creditAmount']));
        $user_id = parse_order_id($comment);

        if ($user_id) {
            $getUser = $TN->get_row("SELECT * FROM `users` WHERE `user_id` = '$user_id'");
            if ($getUser) {
                $exists = $TN->num_rows("SELECT * FROM `invoices` WHERE `trans_id` = '$tranId'");
                if ($exists == 0) {
                    $insert = $TN->insert("invoices", [
                        'trans_id'       => $tranId,
                        'payment_method' => "MBBANK",
                        'user_id'        => $user_id,
                        'description'    => $comment,
                        'amount'         => $amount,
                        'status'         => 1,
                        'create_time'    => time()
                    ]);

                    if ($insert) {
                        $bonus = round($amount * 0, 2); // Khuyến mãi 0%
                        $total = $amount + $bonus;

                        PlusCredits($user_id, $total, "Nạp tiền tự động qua MBBANK", $tranId);

                        $formattedAmount = number_format($amount, 0, ',', '.');
                        $formattedBonus  = number_format($bonus, 0, ',', '.');
                        $formattedTotal  = number_format($total, 0, ',', '.');

                        send_telegram(" <b>OKBILL.WTF</b>\nUser ID: <b>$user_id</b>\nSố tiền: <b>$formattedAmount đ</b>\nKhuyến mãi: <b>$formattedBonus đ</b>\nTổng cộng: <b>$formattedTotal đ</b>\nMã GD: <b>$tranId</b>\nTrạng Thái: Thành Công");
                    }
                }
            }
        }
    }
}

// Kiểm tra phản hồi từ API để xác định trạng thái HTTP và thông báo
$domain = $_SERVER['SERVER_NAME'];
$developerName = "Nguyen Thanh Phuc";
$version = "v6.6.0";
$timeNow = date("H:i:s - d/m/Y");

if ($result && isset($result['TranList']) && is_array($result['TranList'])) {
    $httpCode = 200;
    $statusText = "API Hoạt Động Bình Thường!";
    $statusClass = "success";
} else {
    $httpCode = 503;
    $statusText = "API Bank Không Hoạt Động";
    $statusClass = "failure";
}

http_response_code($httpCode);

echo "<!DOCTYPE html>
<html lang='vi'>
<head>
    <meta charset='UTF-8'>
    <title>Kiểm tra API MBBank</title>
    <style>
        body {
            margin: 0; padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(-45deg, #f0f8ff, #e6f7ff, #fefefe, #e0f0ff);
            background-size: 400% 400%;
            animation: bgMove 15s ease infinite;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        @keyframes bgMove {
            0% {background-position: 0% 50%;}
            50% {background-position: 100% 50%;}
            100% {background-position: 0% 50%;}
        }
        .container {
            background-color: #fff;
            padding: 35px 55px;
            border-radius: 14px;
            box-shadow: 0 12px 28px rgba(0,0,0,0.12);
            max-width: 600px;
            width: 90%;
            animation: fadeInUp 1.2s ease forwards;
            opacity: 0;
            transform: translateY(20px);
        }
        @keyframes fadeInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        h1 {
            font-size: 28px;
            margin-bottom: 18px;
            color: #333;
        }
        .status {
            font-weight: 700;
            font-size: 22px;
            margin-bottom: 15px;
            text-align: center;
            padding: 12px 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
            user-select: none;
        }
        .success {
            color: #1e7e34;
            background-color: #d4edda;
            border: 1.5px solid #c3e6cb;
            text-shadow: 0 0 7px #1e7e34aa;
            animation: glowGreen 2.5s ease-in-out infinite alternate;
        }
        .failure {
            color: #721c24;
            background-color: #f8d7da;
            border: 1.5px solid #f5c6cb;
            text-shadow: 0 0 7px #721c24aa;
            animation: glowRed 2.5s ease-in-out infinite alternate;
        }
        @keyframes glowGreen {
            from { text-shadow: 0 0 7px #1e7e34aa; }
            to { text-shadow: 0 0 20px #1e7e34ee; }
        }
        @keyframes glowRed {
            from { text-shadow: 0 0 7px #721c24aa; }
            to { text-shadow: 0 0 20px #721c24ee; }
        }
        .http-code {
            font-size: 20px;
            text-align: center;
            margin-bottom: 20px;
            font-weight: 600;
            color: #444;
        }
        .info {
            font-size: 15px;
            color: #555;
            border-top: 1px solid #ddd;
            padding-top: 15px;
            line-height: 1.6;
        }
        .info span {
            display: block;
            margin-bottom: 6px;
        }
    </style>
</head>
<body>
    <div class='container'>
        <h1>Trạng thái API Nạp Tiền:</h1>
        <div class='status $statusClass'>$statusText</div>
        <div class='http-code'>HTTP Code: $httpCode</div>
        <div class='info'>
            <span><strong>Domain:</strong> $domain</span>
            <span><strong>Powered:</strong> $developerName</span>
            <span><strong>Version:</strong> $version</span>
            <span><strong>Api:</strong> Nạp Tiền Tự Động (Auto Rechange)</span>
            <span><strong>Note:</strong> Nếu Api Hoạt Động! Tiền Sẽ Được Cộng Sau 30s - 5p</span>
        </div>
    </div>
</body>
</html>";
?>
