<?php
define("IN_SITE", true);
date_default_timezone_set('Asia/Ho_Chi_Minh');

class DB {
    private $host = "localhost";
    private $username = "csowkcy_thanhphuc";
    private $password = "csowkcy_thanhphuc";    
    private $database = "csowkcy_thanhphuc"; 
    public $conn;

    public function __construct() {
        $this->conn = new mysqli(
            $this->host, $this->username,
            $this->password, $this->database
        );
        if ($this->conn->connect_error) {
            die("Kết nối CSDL thất bại: " . $this->conn->connect_error);
        }
        $this->conn->set_charset("utf8mb4");
    }

    public function query($sql) {
        return $this->conn->query($sql);
    }

    public function get_row($sql) {
        $result = $this->conn->query($sql);
        return ($result && $result->num_rows > 0) ? $result->fetch_assoc() : null;
    }

    public function num_rows($sql) {
        $result = $this->conn->query($sql);
        return ($result) ? $result->num_rows : 0;
    }

    public function insert($table, $data) {
        $columns = implode("`,`", array_keys($data));
        $escaped_values = array_map([$this->conn, 'real_escape_string'], array_values($data));
        $values = implode("','", $escaped_values);
        $sql = "INSERT INTO `$table` (`$columns`) VALUES ('$values')";
        return $this->conn->query($sql);
    }
}

$TN = new DB();

function check_string($data) {
    return trim(htmlspecialchars($data, ENT_QUOTES, 'UTF-8'));
}

function parse_order_id($description) {
    if (preg_match('/thanhtoan(\d+)/i', $description, $matches)) {
        return intval($matches[1]);
    }
    return null;
}

function send_telegram_notification($message) {
    $botToken = '8461218897:AAE2aqlmkkhT28cKesjqvMOkQOQ7zSvOeGs';
    $chatId = '-1003014868253';
    
    $url = "https://test.thanhphucvn.workers.dev/bot{$botToken}/sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $result = curl_exec($ch);
    curl_close($ch);
    
    return $result;
}

function PlusCredits($userId, $amount, $note, $tranId, $bank = "ACB") {
    global $TN;
    $amount = floatval($amount);
    $userId = intval($userId);

    $getUser = $TN->get_row("SELECT * FROM `users` WHERE `user_id` = '$userId'");
    if (!$getUser) return false;

    $username = $getUser['username'];

    $TN->query("UPDATE `users` SET `sodu` = `sodu` + $amount, `tongnap` = `tongnap` + $amount WHERE `user_id` = '$userId'");

    $TN->query("INSERT INTO `ws_history_bank` (`username`, `loai`, `magiaodich`, `sotien`, `noidung`, `thoigian`, `trangthai`) 
                VALUES ('$username', 'Nạp Tự Động', '$tranId', '$amount', '$note', NOW(), 'thanhcong')");

    $TN->query("INSERT INTO `ws_logs` (`username`, `content`, `time`, `action`) 
                VALUES ('$username', 'nạp tiền tự động $bank - Số tiền: ".number_format($amount)."đ', NOW(), 'Nạp Tiền')");

    $telegramMessage = "<b>[----- LÚA VỀ LÚA VỀ -----]</b>\n\n";
    $telegramMessage .= "Tài khoản:     <b><code>$username</code></b>\n";
    $telegramMessage .= "User ID:       <b><code>$userId</code></b>\n";
    $telegramMessage .= "Kiểu:          <code>$note</code>\n";
    $telegramMessage .= "Thời gian:     <i>" . date('H:i:s d/m/Y') . "</i>\n";
    $telegramMessage .= "Số tiền:       <b><u>" . number_format($amount) . "đ</u></b>\n";
    $telegramMessage .= "Ngân hàng:     <code>$bank</code>\n";
    $telegramMessage .= "Mã Giao Dịch:  <code>$tranId</code>\n";
    $telegramMessage .= "HETHONGBILL.BIZ\n\n";

    $footer = "Có thằng ngu vừa bị lừa nạp " . number_format($amount) . "đ vào tài khoản ngân hàng $bank của Admin nè\nPowered By @SThanhPhucVn";
    $footerFormatted = ucwords($footer);
    $telegramMessage .= "<i>$footerFormatted</i>";

    send_telegram_notification($telegramMessage);
    return true;
}

function curl_get($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

// === TẠO BẢNG ===
$TN->query("CREATE TABLE IF NOT EXISTS `invoices` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `trans_id` VARCHAR(255) NOT NULL,
    `payment_method` VARCHAR(50) NOT NULL,
    `user_id` INT NOT NULL,
    `description` TEXT,
    `amount` FLOAT NOT NULL,
    `status` INT DEFAULT 1,
    `create_time` INT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$TN->query("CREATE TABLE IF NOT EXISTS `ws_history_bank` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(255),
    `loai` VARCHAR(50),
    `magiaodich` VARCHAR(255),
    `sotien` FLOAT,
    `noidung` TEXT,
    `thoigian` DATETIME,
    `trangthai` VARCHAR(20)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$TN->query("CREATE TABLE IF NOT EXISTS `ws_logs` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(255),
    `content` TEXT,
    `time` DATETIME,
    `action` VARCHAR(50)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

// === GỌI API ===
$response = curl_get("https://mmo.thanhdieu.com/bf6a8c7ac586947810f6e1fe8d7e5262");
$result = json_decode($response, true);

$processed_count = 0;
$total_transactions = 0;

if (isset($result['status']) && $result['status'] === 'success' && isset($result['transactions']) && is_array($result['transactions'])) {
    $transactions = $result['transactions'];
    $total_transactions = count($transactions);

    foreach ($transactions as $data) {
        // BỎ ĐIỀU KIỆN TYPE → XỬ LÝ TẤT CẢ GIAO DỊCH
        $tranId     = check_string($data['transactionID'] ?? '');
        $comment    = check_string($data['description'] ?? '');
        $amount     = floatval($data['amount'] ?? 0);
        $user_id    = parse_order_id($comment);

        // Bỏ qua nếu không có user_id hoặc số tiền <= 0
        if (!$user_id || $amount <= 0 || empty($tranId)) continue;

        $getUser = $TN->get_row("SELECT * FROM `users` WHERE `user_id` = '$user_id'");
        if (!$getUser) continue;

        $exists = $TN->num_rows("SELECT * FROM `invoices` WHERE `trans_id` = '$tranId'");
        if ($exists > 0) continue;

        $insert = $TN->insert("invoices", [
            'trans_id'       => $tranId,
            'payment_method' => "ACB",
            'user_id'        => $user_id,
            'description'    => $comment,
            'amount'         => $amount,
            'status'         => 1,
            'create_time'    => time()
        ]);

        if ($insert) {
            PlusCredits($user_id, $amount, "Nạp tiền tự động qua ACB", $tranId);
            $processed_count++;
        }
    }

    // Ghi log hệ thống
    $TN->query("INSERT INTO `ws_logs` (`username`, `content`, `time`, `action`) 
                VALUES ('system', 'Đã xử lý $processed_count / $total_transactions giao dịch từ API ACB', NOW(), 'API SUCCESS')");

    if ($processed_count > 0) {
        $successMessage = "<b>API ACB THÀNH CÔNG</b>\n";
        $successMessage .= "<b>Đã xử lý:</b> $processed_count giao dịch\n";
        $successMessage .= "<b>Tổng GD API:</b> $total_transactions\n";
        $successMessage .= "<b>Thời gian:</b> " . date('H:i:s d/m/Y');
        send_telegram_notification($successMessage);
    }

} else {
    // Xử lý lỗi API
    $errorMsg = "<b>LỖI API ACB</b>\n";
    $errorMsg .= "<b>Status:</b> " . ($result['status'] ?? 'null') . "\n";
    $errorMsg .= "<b>Message:</b> " . ($result['message'] ?? 'Không có phản hồi') . "\n";
    $errorMsg .= "<b>Thời gian:</b> " . date('H:i:s d/m/Y');
    send_telegram_notification($errorMsg);

    $TN->query("INSERT INTO `ws_logs` (`username`, `content`, `time`, `action`) 
                VALUES ('system', 'API ACB lỗi: " . ($result['message'] ?? 'Không phản hồi') . "', NOW(), 'API ERROR')");
}
?>