<?php
define("IN_SITE", true);
date_default_timezone_set('Asia/Ho_Chi_Minh');

class DB {
    private $host = "localhost";
    private $username = "csowkcy_thanhphuc";
    private $password = "csowkcy_thanhphuc";    
    private $database = "csowkcy_thanhphuc"; 
    public $conn;

    public function __construct() {
        $this->conn = new mysqli(
            $this->host, $this->username,
            $this->password, $this->database
        );
        if ($this->conn->connect_error) {
            die("Kết nối CSDL thất bại: " . $this->conn->connect_error);
        }
        $this->conn->set_charset("utf8mb4");
    }

    public function query($sql) {
        return $this->conn->query($sql);
    }

    public function get_row($sql) {
        $result = $this->conn->query($sql);
        return ($result && $result->num_rows > 0) ? $result->fetch_assoc() : null;
    }

    public function num_rows($sql) {
        $result = $this->conn->query($sql);
        return ($result) ? $result->num_rows : 0;
    }

    public function insert($table, $data) {
        $columns = implode("`,`", array_keys($data));
        $values = implode("','", array_map([$this->conn, 'real_escape_string'], array_values($data)));
        $sql = "INSERT INTO `$table` (`$columns`) VALUES ('$values')";
        return $this->conn->query($sql);
    }
}

$TN = new DB();

function check_string($data) {
    return trim(strip_tags($data));
}

function parse_order_id($description) {
    if (preg_match('/thanhtoan(\d+)/i', $description, $matches)) {
        return intval($matches[1]);
    }
    return null;
}

function send_telegram_notification($message) {
    $botToken = '8461218897:AAE2aqlmkkhT28cKesjqvMOkQOQ7zSvOeGs';
    $chatId = '-1003014868253';
    
    $url = "https://test.thanhphucvn.workers.dev/bot{$botToken}/sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    
    return $result;
}

function PlusCredits($userId, $amount, $note, $tranId, $bank = "ACB") {
    global $TN;
    $amount = floatval($amount);
    $userId = intval($userId);

    $getUser = $TN->get_row("SELECT * FROM `users` WHERE `user_id` = '$userId'");
    if (!$getUser) return false;

    $username = $getUser['username'];

    $TN->query("UPDATE `users` SET `sodu` = `sodu` + $amount, `tongnap` = `tongnap` + $amount WHERE `user_id` = '$userId'");

    $TN->query("INSERT INTO `ws_history_bank` (`username`, `loai`, `magiaodich`, `sotien`, `noidung`, `thoigian`, `trangthai`) 
                VALUES ('$username', 'Nạp Tự Động', '$tranId', '$amount', '$note', NOW(), 'thanhcong')");

    $TN->query("INSERT INTO `ws_logs` (`username`, `content`, `time`, `action`) 
                VALUES ('$username', 'nạp tiền tự động $bank - Số tiền: ".number_format($amount)."đ', NOW(), 'Nạp Tiền')");

    $telegramMessage = "<b>[----- LÚA VỀ LÚA VỀ -----]</b>\n\n";
$telegramMessage .= "Tài khoản:     <b><code>$username</code></b>\n";
$telegramMessage .= "User ID:       <b><code>$userId</code></b>\n";
$telegramMessage .= "Kiểu:  <code>$note</code>\n";
$telegramMessage .= "Thời gian:     <i>" . date('H:i:s d/m/Y') . "</i>\n";
$telegramMessage .= "Số tiền:       <b><u>" . number_format($amount) . "đ</u></b>\n";
$telegramMessage .= "Ngân hàng:     <code>$bank</code>\n";
$telegramMessage .= "Mã Giao Dịch:  <code>$tranId</code>\n";
$telegramMessage .= "Trang Thái: Thành Công\n\n";

// Footer: chữ cái đầu viết hoa từng từ
$footer = "Có thằng ngu vừa bị lừa nạp " . number_format($amount) . "đ vào tài khoản ngân hàng $bank của Admin nè\nPowered By t.me/ThanhPhucVn";
$footerFormatted = ucwords($footer);

$telegramMessage .= "<i>$footerFormatted</i>";

    
    send_telegram_notification($telegramMessage);

    return true;
}

function curl_get($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

$token = "b914ade017ac9dda9d5cbfd2ed9ef72c";
$response = curl_get("http://api.vpnfast.vn/historyapiacb/$token");
$result = json_decode($response, true);

$TN->query("CREATE TABLE IF NOT EXISTS `invoices` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `trans_id` VARCHAR(255) NOT NULL,
    `payment_method` VARCHAR(50) NOT NULL,
    `user_id` INT NOT NULL,
    `description` TEXT,
    `amount` FLOAT NOT NULL,
    `status` INT DEFAULT 1,
    `create_time` INT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$TN->query("CREATE TABLE IF NOT EXISTS `ws_history_bank` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(255),
    `loai` VARCHAR(50),
    `magiaodich` VARCHAR(255),
    `sotien` FLOAT,
    `noidung` TEXT,
    `thoigian` DATETIME,
    `trangthai` VARCHAR(20)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

$TN->query("CREATE TABLE IF NOT EXISTS `ws_logs` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(255),
    `content` TEXT,
    `time` DATETIME,
    `action` VARCHAR(50)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

if (isset($result['data']) && is_array($result['data']) && !empty($result['data'])) {
    $processed_count = 0;
    foreach ($result['data'] as $data) {
        $tranId  = check_string($data['transactionNumber']); 
        $comment = check_string($data['description']);
        $amount  = floatval(check_string($data['amount'])); 
        $user_id = parse_order_id($comment);

        if ($user_id) {
            $getUser = $TN->get_row("SELECT * FROM `users` WHERE `user_id` = '$user_id'");
            if ($getUser) {
                $exists = $TN->num_rows("SELECT * FROM `invoices` WHERE `trans_id` = '$tranId'");
                if ($exists == 0) {
                    $insert = $TN->insert("invoices", [
                        'trans_id'       => $tranId,
                        'payment_method' => "ACB",
                        'user_id'        => $user_id,
                        'description'    => $comment,
                        'amount'         => $amount,
                        'status'         => 1,
                        'create_time'    => time()
                    ]);
                    if ($insert) {
                        PlusCredits($user_id, $amount, "Nạp tiền tự động qua ACB", $tranId);
                        $processed_count++;
                    }
                }
            }
        }
    }
    $TN->query("INSERT INTO `ws_logs` (`username`, `content`, `time`, `action`) 
                VALUES ('system', 'Đã xử lý $processed_count giao dịch từ " . count($result['data']) . " giao dịch', NOW(), 'API SUCCESS')");
    
    if ($processed_count > 0) {
        $successMessage = "<b>API ACB THÀNH CÔNG</b>\n";
        $successMessage .= "<b>Đã xử lý:</b> $processed_count giao dịch\n";
        $successMessage .= "<b>Tổng giao dịch:</b> " . count($result['data']) . "\n";
        $successMessage .= "<b>Thời gian:</b> " . date('H:i:s d/m/Y');
        send_telegram_notification($successMessage);
    }
    
} else {
    if (isset($result['codeStatus']) && $result['codeStatus'] != 200) {
        $errorMessage = "<b>LỖI API ACB</b>\n";
        $errorMessage .= "<b>Code:</b> " . $result['codeStatus'] . "\n";
        $errorMessage .= "<b>Message:</b> " . $result['messageStatus'] . "\n";
        $errorMessage .= "<b>Description:</b> " . $result['description'] . "\n";
        $errorMessage .= "<b>Thời gian:</b> " . date('H:i:s d/m/Y');
        send_telegram_notification($errorMessage);
        
        $TN->query("INSERT INTO `ws_logs` (`username`, `content`, `time`, `action`) 
                    VALUES ('system', 'API Error - Code: " . $result['codeStatus'] . " - Message: " . $result['messageStatus'] . "', NOW(), 'API ERROR')");
    } else {
        $errorMessage = "<b>LỖI API ACB</b>\n";
        $errorMessage .= "<b>Lỗi:</b> Không có dữ liệu giao dịch\n";
        $errorMessage .= "<b>Data:</b> " . (isset($result['data']) ? json_encode($result['data']) : 'null') . "\n";
        $errorMessage .= "<b>Thời gian:</b> " . date('H:i:s d/m/Y');
        send_telegram_notification($errorMessage);
        
        $TN->query("INSERT INTO `ws_logs` (`username`, `content`, `time`, `action`) 
                    VALUES ('system', 'Không có dữ liệu giao dịch ACB', NOW(), 'API INFO')");
    }
}
?>