<?php
$options_header = [
    'title' => 'Tạo lệnh truy nã của bộ công an',
    'description' => 'Tạo lệnh truy nã của bộ công an.'
];
?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/head.php'); ?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/nav.php'); ?>

<main>
    <div class="container">
        <div class="flex flex-col md:flex-row gap-4 pb-5">
            <div class="w-full md:w-3/5">
                <fieldset class="relative">
                    <div
                        class="grid grid-cols-1 sm:grid-cols-1 gap-3 nui-card nui-card-rounded-lg nui-card-default relative p-5 md:mx-0 shadow-lg border-none">
                        <legend class="mb-6-none flex flex-col md:flex-row justify-between items-start">
                            <div class="text-left">
                                <p class="nui-heading nui-heading-md nui-weight-bold nui-lead-none">
                                    <i class="ri-file-text-line me-1"></i> Nhập liệu đơn truy nã
                                </p>
                                <span class="nui-text nui-content-xs nui-weight-normal nui-lead-normal text-muted-400">
                                    Hãy nhập đầy đủ thông tin để tạo đơn truy nã của bộ công an.
                                </span>
                            </div>
                        </legend>

                        <form class="hk-truyna hk-refresh-form space-y-3" enctype="multipart/form-data" method="POST" action="/ajax/global/users/ajax-user.php">
                            <input type="hidden" name="action" value="fake-truyna">
                            <input type="hidden" name="loai" value="giay-truyna">

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">1. Tên chủ thể</h3>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="100" for="tenCongTyVietBangTiengViet">Họ Và Tên</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="tenCongTyVietBangTiengViet" id="tenCongTyVietBangTiengViet"
                                                placeholder="Nguyễn Thanh Phúc" value="Nguyễn Thanh Phúc">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="50" for="quocTichDaiDien">Quốc tịch</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="quocTichDaiDien" id="quocTichDaiDien"
                                                    placeholder="Việt Nam" value="Việt Nam">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="gioiTinhDaiDien">Giới tính</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <select name="gioiTinhDaiDien" id="gioiTinhDaiDien" class="nui-input" required>
                                                    <option value="Nam">Nam</option>
                                                    <option value="Nữ">Nữ</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="20" for="sinhNgayDaiDien">Năm Sinh</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="sinhNgayDaiDien" id="sinhNgayDaiDien"
                                                    placeholder="2000" value="2000">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="20" for="danTocDaiDien">Dân tộc</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="danTocDaiDien" id="danTocDaiDien"
                                                    placeholder="Kinh" value="Kinh">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">2. Nơi Cư Trú</h3>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="200" for="noiDangKyHoKhauThuongTru">Nơi đăng ký hộ khẩu thường trú</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="noiDangKyHoKhauThuongTru" id="noiDangKyHoKhauThuongTru"
                                                placeholder="Quận 8, Thành phố Hồ Chí Minh" value="Quận 8, Thành phố Hồ Chí Minh">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="200" for="choOHienTai">Chỗ ở hiện tại</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="choOHienTai" id="choOHienTai"
                                                placeholder="Bình Tân, Thành phố Hồ Chí Minh" value="Bình Tân, Thành phố Hồ Chí Minh">
                                        </div>
                                    </div>
                                </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="150" for="email">Họ Tên Cha</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="email" id="email"
                                                    placeholder="Nguyễn Văn Cha" value="Nguyễn Văn Cha">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="150" for="vonDieuLeBangChu">Họ Tên Mẹ</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="vonDieuLeBangChu" id="vonDieuLeBangChu"
                                                placeholder="Nguyễn Thị Mẹ" value="Nguyễn Thị Mẹ">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                            </div>
                            <div class="mt-auto flex flex-col-reverse text-end md:block md:space-x-3 gap-2 text-nowrap">
                                <button type="button" 
                                        id="demoBtn" class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-muted w-full sm:w-32">
                                        <i class="ri-eye-line me-2"></i>Xem Trước</button>
                                <button type="button" class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-muted w-full sm:w-32 clear-form">
                                    <i class="ri-refresh-line me-2"></i>Làm Mới
                                </button>
                                <button type="submit" class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-primary w-full sm:w-32">
                                    <i class="ri-check-line me-2"></i>Tạo Ngay
                                </button>
                            </div>
                        </form>
                    </div>
                </fieldset>
            </div>

            <div class="w-full card-demo-bill hidden md:block">
                <div class="col-span-6 sm:col-span-3">
                    <div class="router-link-active router-link-exact-active group relative flex w-full flex-col overflow-hidden rounded-2xl kq-bill">
                        <img id="resultImage" src="https://i.postimg.cc/jjJJRdDS/ec7de880-065c-41de-afb0-3a3f281b2cab.png" alt="OkBill.Org" style="max-width: 100%;">
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php require($_SERVER['DOCUMENT_ROOT'].'/include/foot.php'); ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('.hk-truyna');
    const resultImage = document.getElementById('resultImage');

    if (form) {
        const clearFormButton = form.querySelector('.clear-form');
        if (clearFormButton) {
            clearFormButton.addEventListener('click', function() {
                form.reset();
                resultImage.src = ""; 
                document.querySelectorAll('.td-format-date').forEach(input => {
                    input.value = '';
                });
            });
        }

        document.querySelectorAll('.td-format-date').forEach(input => {
            input.addEventListener('input', function() {
                let value = this.value.replace(/\D/g, '');
                let formattedValue = '';

                if (value.length > 0) {
                    formattedValue = value.substring(0, 2);
                    if (value.length >= 3) { formattedValue += '/' + value.substring(2, 4); }
                    if (value.length >= 5) { formattedValue += '/' + value.substring(4, 8); }
                }
                this.value = formattedValue;
            });
            // Trigger input event on load to format initial values if any
            input.dispatchEvent(new Event('input'));
        });
    }
});
</script>
<script>
  if (window.innerWidth > 768) {
    document.getElementById("demoBtn").style.display = "none";
  }
  const style = document.createElement("style");
  style.textContent = `
    .overlay {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: rgba(0,0,0,0.6);
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 9999;
    }
    .popup-box {
      position: relative;
      background: transparent;
      max-width: 80%;
      max-height: 80%;
    }
    .popup-box img {
      max-width: 100%;
      max-height: 100%;
      border-radius: 8px;
      display: block;
    }
    .close-btn {
      position: absolute;
      top: -12px;
      right: -12px;
      background: red;
      color: white;
      border: none;
      border-radius: 50%;
      width: 28px;
      height: 28px;
      cursor: pointer;
      font-weight: bold;
      font-size: 16px;
      line-height: 28px;
      text-align: center;
    }
  `;
  document.head.appendChild(style);

  function showImagePopup(url) {
    const overlay = document.createElement("div");
    overlay.className = "overlay";

    const popup = document.createElement("div");
    popup.className = "popup-box";

    const img = document.createElement("img");
    img.src = url;

    const closeBtn = document.createElement("button");
    closeBtn.className = "close-btn";
    closeBtn.innerText = "×";

    closeBtn.addEventListener("click", () => overlay.remove());

    popup.appendChild(closeBtn);
    popup.appendChild(img);
    overlay.appendChild(popup);
    document.body.appendChild(overlay);
  }

  document.getElementById("demoBtn").addEventListener("click", () => {
    showImagePopup("https://i.postimg.cc/jjJJRdDS/ec7de880-065c-41de-afb0-3a3f281b2cab.png");
  });
</script>