<?php
$options_header = [
    'title' => 'Công cụ nhập liệu Giấy Chứng nhận Đăng ký Hoạt động Chi nhánh',
    'description' => 'Nhập liệu nhanh chóng thông tin Giấy Chứng nhận Đăng ký Hoạt động Chi nhánh để tiết kiệm thời gian.'
];
?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/head.php'); ?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/nav.php'); ?>

<main>
    <div class="container">
        <div class="flex flex-col md:flex-row gap-4 pb-5">
            <div class="w-full md:w-3/5">
                <fieldset class="relative">
                    <div
                        class="grid grid-cols-1 sm:grid-cols-1 gap-3 nui-card nui-card-rounded-lg nui-card-default relative p-5 md:mx-0 shadow-lg border-none">
                        <legend class="mb-6-none flex flex-col md:flex-row justify-between items-start">
                            <div class="text-left">
                                <p class="nui-heading nui-heading-md nui-weight-bold nui-lead-none">
                                    <i class="ri-file-text-line me-1"></i> Nhập liệu Giấy Chứng nhận Đăng ký Hoạt động Chi nhánh
                                </p>
                                <span class="nui-text nui-content-xs nui-weight-normal nui-lead-normal text-muted-400">
                                    Hãy nhập đầy đủ thông tin để tạo file Giấy Chứng nhận Đăng ký Hoạt động Chi nhánh.
                                </span>
                            </div>
                        </legend>

                        <form class="hk-giayphepchinhanh hk-refresh-form space-y-3" enctype="multipart/form-data" method="POST" action="/ajax/global/users/ajax-user.php">
                            <input type="hidden" name="action" value="fake-business-license-1">
                            <input type="hidden" name="loai" value="giay-phep-kinh-doanh-chi-nhanh">

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">Thông tin Chi nhánh</h3>

                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="20" for="maSoChiNhanh">Mã số chi nhánh</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="maSoChiNhanh" id="maSoChiNhanh"
                                                placeholder="1800155244-006" value="1800155244-006">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="20" for="dangKyLanDauNgay">Đăng ký lần đầu ngày (DD/MM/YYYY)</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input td-format-date" name="dangKyLanDauNgay" id="dangKyLanDauNgay"
                                                    placeholder="03/06/2019" value="<?php echo date('d/m/Y'); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                </div>
                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">1. Tên chi nhánh</h3>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="100" for="tenChiNhanh">Tên chi nhánh</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="tenChiNhanh" id="tenChiNhanh"
                                                placeholder="CHI NHÁNH CẤP NƯỚC HƯNG PHÚ - CÔNG TY CỔ PHẦN CẤP THOÁT NƯỚC CẦN THƠ" value="CHI NHÁNH CẤP NƯỚC HƯNG PHÚ - CÔNG TY CỔ PHẦN CẤP THOÁT NƯỚC CẦN THƠ">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="100" for="tenChiNhanhVietBangTiengNuocNgoai">Tên chi nhánh viết bằng tiếng nước ngoài</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="tenChiNhanhVietBangTiengNuocNgoai" id="tenChiNhanhVietBangTiengNuocNgoai"
                                                placeholder="HUNG PHU WS BRANCH - CAN THO WSD JSC

" value="HUNG PHU WS BRANCH - CAN THO WSD JSC

">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="100" for="tenChiNhanhVietTat">Tên chi nhánh viết tắt</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="tenChiNhanhVietTat" id="tenChiNhanhVietTat"
                                                placeholder="CN CẤP NƯỚC HƯNG PHÚ - CTCP CẤP THOÁT NƯỚC CẦN THƠ" value="CN CẤP NƯỚC HƯNG PHÚ - CTCP CẤP THOÁT NƯỚC CẦN THƠ">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">2. Địa chỉ</h3>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="200" for="diaChi">Địa chỉ</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="diaChi" id="diaChi"
                                                placeholder="52A2 Bùi Quang Trinh, KDC Phú An, Phường Phú Thứ, Quận Cái Răng, Thành phố Cần Thơ, Việt Nam" value="52A2 Bùi Quang Trinh, KDC Phú An, Phường Phú Thứ, Quận Cái Răng, Thành phố Cần Thơ, Việt Nam">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
        <label class="nui-input-label" data-limit-text="100" for="thanhPho">Thành phố</label>
        <div class="nui-input-outer">
            <div>
                <input type="text" class="nui-input" name="thanhPho" id="thanhPho"
                    placeholder="CẦN THƠ" value="CẦN THƠ">
            </div>
        </div>
    </div>
</div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="20" for="dienThoai">Điện thoại</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="dienThoai" id="dienThoai"
                                                    placeholder="0329.999.999" value="0329.999.999">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="50" for="fax">Fax</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="fax" id="fax"
                                                    placeholder="024.62739359" value="024.62739359">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="50" for="email">Email</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="email" class="nui-input" name="email" id="email"
                                                    placeholder="cskh@fakebill.com" value="cskh@fakebill.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="50" for="website">Website</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="website" id="website"
                                                    placeholder="https://okbill.gay" value="https://okbill.gay">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">3. Thông tin về người đứng đầu</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="50" for="hoVaTenDaiDien">Họ và tên</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="hoVaTenDaiDien" id="hoVaTenDaiDien"
                                                    placeholder="NGUYỄN THANH PHÚC" value="NGUYỄN THANH PHÚC">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="gioiTinhDaiDien">Giới tính</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <select name="gioiTinhDaiDien" id="gioiTinhDaiDien" class="nui-input" required>
                                                    <option value="Nam" selected>Nam</option>
                                                    <option value="Nữ">Nữ</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="20" for="sinhNgayDaiDien">Sinh ngày (DD/MM/YYYY)</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input td-format-date" name="sinhNgayDaiDien" id="sinhNgayDaiDien"
                                                    placeholder="21/01/1978" value="21/01/1978">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="20" for="danTocDaiDien">Dân tộc</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="danTocDaiDien" id="danTocDaiDien"
                                                    placeholder="Kinh" value="Kinh">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="50" for="quocTichDaiDien">Quốc tịch</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="quocTichDaiDien" id="quocTichDaiDien"
                                                placeholder="Việt Nam" value="Việt Nam">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="50" for="loaiGiayToChungThucCaNhan">Loại giấy tờ chứng thực cá nhân</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="loaiGiayToChungThucCaNhan" id="loaiGiayToChungThucCaNhan"
                                                placeholder="Chứng minh nhân dân" value="Chứng minh nhân dân">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="20" for="soGiayChungThucCaNhan">Số giấy chứng thực cá nhân</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="soGiayChungThucCaNhan" id="soGiayChungThucCaNhan"
                                                placeholder="361897780" value="361897780">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="20" for="ngayCap">Ngày cấp (DD/MM/YYYY)</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input td-format-date" name="ngayCap" id="ngayCap"
                                                    placeholder="14/02/2014" value="14/02/2014">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="50" for="noiCap">Nơi cấp</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input" name="noiCap" id="noiCap"
                                                    placeholder="CA Cần Thơ" value="CA Cần Thơ">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="200" for="noiDangKyHoKhauThuongTru">Nơi đăng ký hộ khẩu thường trú</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="noiDangKyHoKhauThuongTru" id="noiDangKyHoKhauThuongTru"
                                                placeholder="687 Tầm Vu, Phường Hưng Lợi, Quận Ninh Kiều, Thành phố Cần Thơ, Việt Nam" value="687 Tầm Vu, Phường Hưng Lợi, Quận Ninh Kiều, Thành phố Cần Thơ, Việt Nam">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="200" for="choOHienTai">Chỗ ở hiện tại</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="choOHienTai" id="choOHienTai"
                                                placeholder="687 Tầm Vu, Phường Hưng Lợi, Quận Ninh Kiều, Thành phố Cần Thơ, Việt Nam" value="687 Tầm Vu, Phường Hưng Lợi, Quận Ninh Kiều, Thành phố Cần Thơ, Việt Nam">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">4. Hoạt động theo ủy quyền của doanh nghiệp</h3>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="100" for="tenDoanhNghiepMe">Tên doanh nghiệp</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="tenDoanhNghiepMe" id="tenDoanhNghiepMe"
                                                placeholder="CÔNG TY CỔ PHẦN CẤP THOÁT NƯỚC CẦN THƠ" value="CÔNG TY CỔ PHẦN CẤP THOÁT NƯỚC CẦN THƠ">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="20" for="maSoDoanhNghiepMe">Mã số doanh nghiệp</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="maSoDoanhNghiepMe" id="maSoDoanhNghiepMe"
                                                placeholder="1800155244" value="1800155244">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" data-limit-text="200" for="diaChiTruSoChinhDoanhNghiepMe">Địa chỉ trụ sở chính</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="diaChiTruSoChinhDoanhNghiepMe" id="diaChiTruSoChinhDoanhNghiepMe"
                                                placeholder="2A, Nguyễn Trãi, Phường An Hội, Quận Ninh Kiều, Thành phố Cần Thơ, Việt Nam" value="2A, Nguyễn Trãi, Phường An Hội, Quận Ninh Kiều, Thành phố Cần Thơ, Việt Nam">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-auto flex flex-col-reverse text-end md:block md:space-x-3 gap-2 text-nowrap">
                                <button type="button" 
                                        id="demoBtn" class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-muted w-full sm:w-32">
                                        <i class="ri-eye-line me-2"></i>Xem Trước</button>
                                <button type="button" class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-muted w-full sm:w-32 clear-form">
                                    <i class="ri-refresh-line me-2"></i>Làm Mới
                                </button>
                                <button type="submit" class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-primary w-full sm:w-32">
                                    <i class="ri-check-line me-2"></i>Tạo Ngay
                                </button>
                            </div>
                        </form>
                    </div>
                </fieldset>
            </div>

            <div class="w-full card-demo-bill hidden md:block">
                <div class="col-span-6 sm:col-span-3">
                    <div class="router-link-active router-link-exact-active group relative flex w-full flex-col overflow-hidden rounded-2xl kq-bill">
                        <img id="resultImage" src="https://i.postimg.cc/Cx98PHCK/gpcndep.png" alt="Xem trước Giấy Chứng nhận Đăng ký Hoạt động Chi nhánh" style="max-width: 100%;">
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php require($_SERVER['DOCUMENT_ROOT'].'/include/foot.php'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('.hk-giayphepchinhanh');
    const resultImage = document.getElementById('resultImage');

    if (form) {
        const clearFormButton = form.querySelector('.clear-form');
        if (clearFormButton) {
            clearFormButton.addEventListener('click', function() {
                form.reset();
                resultImage.src = "";
                document.querySelectorAll('.td-format-date').forEach(input => {
                    input.value = '';
                });
            });
        }

        document.querySelectorAll('.td-format-date').forEach(input => {
            input.addEventListener('input', function() {
                let value = this.value.replace(/\D/g, '');
                let formattedValue = '';

                if (value.length > 0) {
                    formattedValue = value.substring(0, 2);
                    if (value.length >= 3) { formattedValue += '/' + value.substring(2, 4); }
                    if (value.length >= 5) { formattedValue += '/' + value.substring(4, 8); }
                }
                this.value = formattedValue;
            });
            input.dispatchEvent(new Event('input'));
        });
    }
});
</script>
<script>
  if (window.innerWidth > 768) {
    document.getElementById("demoBtn").style.display = "none";
  }
  const style = document.createElement("style");
  style.textContent = `
    .overlay {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: rgba(0,0,0,0.6);
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 9999;
    }
    .popup-box {
      position: relative;
      background: transparent;
      max-width: 80%;
      max-height: 80%;
    }
    .popup-box img {
      max-width: 100%;
      max-height: 100%;
      border-radius: 8px;
      display: block;
    }
    .close-btn {
      position: absolute;
      top: -12px;
      right: -12px;
      background: red;
      color: white;
      border: none;
      border-radius: 50%;
      width: 28px;
      height: 28px;
      cursor: pointer;
      font-weight: bold;
      font-size: 16px;
      line-height: 28px;
      text-align: center;
    }
  `;
  document.head.appendChild(style);

  function showImagePopup(url) {
    const overlay = document.createElement("div");
    overlay.className = "overlay";

    const popup = document.createElement("div");
    popup.className = "popup-box";

    const img = document.createElement("img");
    img.src = url;

    const closeBtn = document.createElement("button");
    closeBtn.className = "close-btn";
    closeBtn.innerText = "×";

    closeBtn.addEventListener("click", () => overlay.remove());

    popup.appendChild(closeBtn);
    popup.appendChild(img);
    overlay.appendChild(popup);
    document.body.appendChild(overlay);
  }

  document.getElementById("demoBtn").addEventListener("click", () => {
    showImagePopup("https://i.postimg.cc/Cx98PHCK/gpcndep.png");
  });
</script>