<?php
$options_header = [
    'title' => 'Công cụ Fake Giấy Khai Sinh',
    'description' => 'Công cụ Fake Giấy Khai Sinh Nhanh Chóng, Siu Tiện lợi'
];
?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/head.php'); ?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/nav.php'); ?>

<main>
    <div class="container">
        <div class="flex flex-col md:flex-row gap-4 pb-5">
            <div class="w-full md:w-3/5">
                <fieldset class="relative">
                    <div
                        class="grid grid-cols-1 sm:grid-cols-1 gap-3 nui-card nui-card-rounded-lg nui-card-default relative p-5 md:mx-0 shadow-lg border-none">
                        <legend class="mb-6-none flex flex-col md:flex-row justify-between items-start">
                            <div class="text-left">
                                <p class="nui-heading nui-heading-md nui-weight-bold nui-lead-none">
                                    <i class="ri-file-text-line me-1"></i> Fake Giấy Khai Sinh (bản chính)
                                </p>
                                <span class="nui-text nui-content-xs nui-weight-normal nui-lead-normal text-muted-400">
                                    Hãy nhập đầy đủ thông tin để tạo.
                                </span>
                            </div>
                        </legend>

                        <form class="hk-giaykhaisinh-real hk-refresh-form space-y-3" enctype="multipart/form-data" method="POST" action="/ajax/global/users/ajax-user.php">
                            <input type="hidden" name="action" value="fake-birth-certificate-real">
                            <input type="hidden" name="loai" value="giay-khai-sinh">

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">Thông tin hành chính</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="soGiayKhaiSinh">Số Giấy khai sinh</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="soGiayKhaiSinh" id="soGiayKhaiSinh" placeholder="100/2021" value="100/2021"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="quyenSo">Quyển số</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="quyenSo" id="quyenSo" placeholder="01/2021" value="01/2021"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">Thông tin người được khai sinh</h3>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" for="hoVaTenTreEm">Họ và tên</label>
                                    <div class="nui-input-outer">
                                        <div><input type="text" class="nui-input" name="hoVaTenTreEm" id="hoVaTenTreEm" placeholder="NGUYỄN VĂN A" value="NGUYỄN VĂN A"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" data-limit-text="10" for="ngayThangNamSinhTreEm">Ngày, tháng, năm sinh (DD/MM/YYYY)</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <input type="text" class="nui-input td-format-date" name="ngayThangNamSinhTreEm" id="ngayThangNamSinhTreEm"
                                                    placeholder="15/07/2013" value="15/07/2013" required> </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="gioiTinhTreEm">Giới tính</label>
                                        <div class="nui-input-outer">
                                            <div>
                                                <select name="gioiTinhTreEm" id="gioiTinhTreEm" class="nui-input" required>
                                                    <option value="Nam">Nam</option>
                                                    <option value="Nữ">Nữ</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" for="ngayThangNamSinhTreEmChu">Ngày, tháng, năm sinh (Ghi bằng chữ)</label>
                                    <div class="nui-input-outer">
                                        <div>
                                            <input type="text" class="nui-input" name="ngayThangNamSinhTreEmChu" id="ngayThangNamSinhTreEmChu"
                                                placeholder="Ngày mười lăm, tháng bảy, năm hai nghìn không trăm mười ba" 
                                                value="Ngày mười lăm, tháng bảy, năm hai nghìn không trăm mười ba"> </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" for="noiSinhTreEm">Nơi sinh</label>
                                    <div class="nui-input-outer">
                                        <div><input type="text" class="nui-input" name="noiSinhTreEm" id="noiSinhTreEm" placeholder="Bệnh viện Hùng Vương, Thành phố Hồ Chí Minh" value="Bệnh viện Hùng Vương, Thành phố Hồ Chí Minh"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="danTocTreEm">Dân tộc</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="danTocTreEm" id="danTocTreEm" placeholder="Kinh" value="Kinh"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="quocTichTreEm">Quốc tịch</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="quocTichTreEm" id="quocTichTreEm" placeholder="Việt Nam" value="Việt Nam"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">Thông tin cha</h3>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" for="hoVaTenCha">Họ và tên cha</label>
                                    <div class="nui-input-outer">
                                        <div><input type="text" class="nui-input" name="hoVaTenCha" id="hoVaTenCha" placeholder="NGUYỄN VĂN B" value="NGUYỄN VĂN B"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="danTocCha">Dân tộc</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="danTocCha" id="danTocCha" placeholder="Kinh" value="Kinh"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="quocTichCha">Quốc tịch</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="quocTichCha" id="quocTichCha" placeholder="Việt Nam" value="Việt Nam"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="namSinhCha">Năm sinh</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="namSinhCha" id="namSinhCha" placeholder="1999" value="1999"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="noiThuongTruCha">Nơi thường trú</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="noiThuongTruCha" id="noiThuongTruCha" placeholder="Thị trấn Thanh Bình, huyện Bù Đốp, tỉnh Bình Phước" value="Thị trấn Thanh Bình, huyện Bù Đốp, tỉnh Bình Phước"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">Thông tin mẹ</h3>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" for="hoVaTenMe">Họ và tên mẹ</label>
                                    <div class="nui-input-outer">
                                        <div><input type="text" class="nui-input" name="hoVaTenMe" id="hoVaTenMe" placeholder="ĐẶNG THỊ CẢNH" value="ĐẶNG THỊ CẢNH"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="danTocMe">Dân tộc</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="danTocMe" id="danTocMe" placeholder="Kinh" value="Kinh"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="quocTichMe">Quốc tịch</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="quocTichMe" id="quocTichMe" placeholder="Việt Nam" value="Việt Nam"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="namSinhMe">Năm sinh</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="namSinhMe" id="namSinhMe" placeholder="2001" value="2001"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-1">
                                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                        <label class="nui-input-label" for="noiThuongTruMe">Nơi thường trú</label>
                                        <div class="nui-input-outer">
                                            <div><input type="text" class="nui-input" name="noiThuongTruMe" id="noiThuongTruMe" placeholder="Thị trấn Thanh Bình, huyện Bù Đốp, tỉnh Bình Phước" value="Thị trấn Thanh Bình, huyện Bù Đốp, tỉnh Bình Phước"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h3 class="nui-heading nui-heading-sm nui-weight-bold nui-lead-none mt-4 mb-2">Thông tin đăng ký</h3>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" for="noiDangKy">Nơi đăng ký</label>
                                    <div class="nui-input-outer">
                                        <div><input type="text" class="nui-input" name="noiDangKy" id="noiDangKy" placeholder="UBND Thị trấn Thanh Bình, Bù Đốp, Bình Phước" value="UBND Thị trấn Thanh Bình, Bù Đốp, Bình Phước"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" for="ngayThangNamDangKy">Ngày, tháng, năm đăng ký (DD/MM/YYYY)</label>
                                    <div class="nui-input-outer">
                                        <div><input type="text" class="nui-input td-format-date" name="ngayThangNamDangKy" id="ngayThangNamDangKy" placeholder="28/07/2021" value="28/07/2021"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" for="hoVaTenNguoiDiKhaiSinh">Họ và tên người đi khai sinh</label>
                                    <div class="nui-input-outer">
                                        <div><input type="text" class="nui-input" name="hoVaTenNguoiDiKhaiSinh" id="hoVaTenNguoiDiKhaiSinh" placeholder="ĐẶNG THỊ DINH" value="ĐẶNG THỊ DINH"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1 sm:col-span-2">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm">
                                    <label class="nui-input-label" for="quanHeVoiNguoiDuocKhaiSinh">Quan hệ với người được khai sinh</label>
                                    <div class="nui-input-outer">
                                        <div><input type="text" class="nui-input" name="quanHeVoiNguoiDuocKhaiSinh" id="quanHeVoiNguoiDuocKhaiSinh" placeholder="Bà ngoại" value="Bà ngoại"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-auto flex flex-col-reverse text-end md:block md:space-x-3 gap-2 text-nowrap">
                                <button type="button" 
                                        id="demoBtn" class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-muted w-full sm:w-32">
                                        <i class="ri-eye-line me-2"></i>Xem Trước</button>
                                <button type="button" class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-muted w-full sm:w-32 clear-form">
                                    <i class="ri-refresh-line me-2"></i>Làm Mới
                                </button>
                                <button type="submit" class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-primary w-full sm:w-32">
                                    <i class="ri-check-line me-2"></i>Tạo Ngay
                                </button>
                            </div>
                        </form>
                    </div>
                </fieldset>
            </div>

            <div class="w-full card-demo-bill hidden md:block">
                <div class="col-span-6 sm:col-span-3">
                    <div class="router-link-active router-link-exact-active group relative flex w-full flex-col overflow-hidden rounded-2xl kq-bill">
                        <img id="resultImage" src="https://i.postimg.cc/X7Vkd8xS/GKS-taobillgiare-fun-70464.png" alt="Xem trước Giấy Khai Sinh" style="max-width: 100%;">
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php require($_SERVER['DOCUMENT_ROOT'].'/include/foot.php'); ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('.hk-giaykhaisinh-real');  selector
    const resultImage = document.getElementById('resultImage');

    if (form) {
        const clearFormButton = form.querySelector('.clear-form');
        if (clearFormButton) {
            clearFormButton.addEventListener('click', function() {
                form.reset();
                resultImage.src = ""; 
                document.querySelectorAll('.td-format-date').forEach(input => {
                    input.value = '';
                });
                const ngayThangNamSinhTreEmChuInput = document.getElementById('ngayThangNamSinhTreEmChu');
                if (ngayThangNamSinhTreEmChuInput) {
                    ngayThangNamSinhTreEmChuInput.value = '';
                }
            });
        }

        document.querySelectorAll('.td-format-date').forEach(input => {
            input.addEventListener('input', function() {
                let value = this.value.replace(/\D/g, '');
                let formattedValue = '';

                if (value.length > 0) {
                    formattedValue = value.substring(0, 2);
                    if (value.length >= 3) { formattedValue += '/' + value.substring(2, 4); }
                    if (value.length >= 5) { formattedValue += '/' + value.substring(4, 8); }
                }
                this.value = formattedValue;
            });
           
            input.dispatchEvent(new Event('input'));
        });
    }
});
</script>
<script>
  if (window.innerWidth > 768) {
    document.getElementById("demoBtn").style.display = "none";
  }
  const style = document.createElement("style");
  style.textContent = `
    .overlay {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: rgba(0,0,0,0.6);
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 9999;
    }
    .popup-box {
      position: relative;
      background: transparent;
      max-width: 80%;
      max-height: 80%;
    }
    .popup-box img {
      max-width: 100%;
      max-height: 100%;
      border-radius: 8px;
      display: block;
    }
    .close-btn {
      position: absolute;
      top: -12px;
      right: -12px;
      background: red;
      color: white;
      border: none;
      border-radius: 50%;
      width: 28px;
      height: 28px;
      cursor: pointer;
      font-weight: bold;
      font-size: 16px;
      line-height: 28px;
      text-align: center;
    }
  `;
  document.head.appendChild(style);

  function showImagePopup(url) {
    const overlay = document.createElement("div");
    overlay.className = "overlay";

    const popup = document.createElement("div");
    popup.className = "popup-box";

    const img = document.createElement("img");
    img.src = url;

    const closeBtn = document.createElement("button");
    closeBtn.className = "close-btn";
    closeBtn.innerText = "×";

    closeBtn.addEventListener("click", () => overlay.remove());

    popup.appendChild(closeBtn);
    popup.appendChild(img);
    overlay.appendChild(popup);
    document.body.appendChild(overlay);
  }

  document.getElementById("demoBtn").addEventListener("click", () => {
    showImagePopup("https://i.postimg.cc/X7Vkd8xS/GKS-taobillgiare-fun-70464.png");
  });
</script>