<?php $options_header = ['title' => 'Tạo Bill Fake MB Bank Chuyển Khoản']; ?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/head.php'); ?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/nav.php'); ?>

<!-- THÊM CSS CỦA BILLMMO -->
<style>
    /* RESET LAYOUT CŨ */
    .nui-input-wrapper, .nui-select-wrapper, .nui-textarea-wrapper,
    .nui-input-outer, .nui-select-outer, .nui-textarea-outer,
    .nui-input, .nui-select, .nui-textarea,
    .nui-input-label, .nui-select-label, .nui-label {
        all: unset !important;
    }
    
    /* CSS CỦA BILLMMO */
    .row {
        display: flex;
        flex-wrap: wrap;
        margin-right: -0.5rem;
        margin-left: -0.5rem;
    }
    
    .col-12 {
        flex: 0 0 100%;
        max-width: 100%;
        padding-right: 0.5rem;
        padding-left: 0.5rem;
    }
    
    .col-md-6 {
        flex: 0 0 50%;
        max-width: 50%;
        padding-right: 0.5rem;
        padding-left: 0.5rem;
    }
    
    .mb-1 {
        margin-bottom: 1rem !important;
    }
    
    .form-label {
        font-weight: 600;
        color: #d0d2d6;
        margin-bottom: 0.5rem;
        display: block;
        font-size: 0.875rem;
        transition: color 0.15s ease-in-out;
    }
    
    .form-control {
        background-color: #283046 !important;
        border: 1px solid #404656 !important;
        color: #d0d2d6 !important;
        padding: 0.571rem 1rem !important;
        font-size: 1rem !important;
        border-radius: 0.357rem !important;
        width: 100% !important;
        transition: all 0.2s ease-in-out !important;
        font-family: inherit !important;
        line-height: 1.45 !important;
    }
    
    /* PLACEHOLDER MỜ CHO TẤT CẢ Ô TRỐNG */
    .form-control::placeholder {
        color: #b4b7bd !important;
        opacity: 0.6 !important;
        font-weight: 400;
    }
    
    /* KHI FOCUS - PLACEHOLDER MỜ HƠN */
    .form-control:focus::placeholder {
        opacity: 0.4 !important;
    }
    
    /* HIỆU ỨNG HOVER */
    .form-control:hover {
        border-color: #5e50ee !important;
        box-shadow: 0 2px 4px rgba(115, 103, 240, 0.1) !important;
    }
    
    /* HIỆU ỨNG FOCUS */
    .form-control:focus {
        background-color: #283046 !important;
        border-color: #7367f0 !important;
        box-shadow: 0 3px 10px 0 rgba(115, 103, 240, 0.25) !important;
        outline: 0 !important;
        transform: translateY(-1px);
    }
    
    /* KHI CÓ GIÁ TRỊ - CHỮ HIỆN RÕ */
    .form-control:not(:placeholder-shown) {
        color: #d0d2d6 !important;
        font-weight: 500;
    }
    
    .form-select {
        background-color: #283046 !important;
        border: 1px solid #404656 !important;
        color: #b4b7bd !important; /* Màu mờ khi chưa chọn */
        padding: 0.571rem 2.5rem 0.571rem 1rem !important;
        font-size: 1rem !important;
        border-radius: 0.357rem !important;
        width: 100% !important;
        appearance: auto !important;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23b4b7bd' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e") !important;
        background-repeat: no-repeat !important;
        background-position: right 0.75rem center !important;
        background-size: 16px 12px !important;
        transition: all 0.2s ease-in-out !important;
        cursor: pointer !important;
    }
    
    /* SELECT KHI CÓ GIÁ TRỊ */
    .form-select:not([value=""]) {
        color: #d0d2d6 !important; /* Màu rõ khi đã chọn */
    }
    
    /* HIỆU ỨNG HOVER CHO SELECT */
    .form-select:hover {
        border-color: #5e50ee !important;
        box-shadow: 0 2px 4px rgba(115, 103, 240, 0.1) !important;
    }
    
    /* HIỆU ỨNG FOCUS CHO SELECT */
    .form-select:focus {
        border-color: #7367f0 !important;
        box-shadow: 0 3px 10px 0 rgba(115, 103, 240, 0.25) !important;
        outline: 0 !important;
        transform: translateY(-1px);
    }
    
    /* OPTION DEFAULT MỜ */
    .form-select option[value=""] {
        color: #b4b7bd !important;
        opacity: 0.6 !important;
        font-style: italic !important;
    }
    
    /* CÁC OPTION KHÁC RÕ */
    .form-select option:not([value=""]) {
        color: #d0d2d6 !important;
        background-color: #283046 !important;
    }
    
    /* TEXTAREA */
    textarea.form-control {
        min-height: 100px;
        resize: vertical;
        line-height: 1.5 !important;
        padding: 0.8rem 1rem !important;
    }
    
    textarea.form-control:hover {
        border-color: #5e50ee !important;
        box-shadow: 0 2px 4px rgba(115, 103, 240, 0.1) !important;
    }
    
    textarea.form-control:focus {
        border-color: #7367f0 !important;
        box-shadow: 0 3px 10px 0 rgba(115, 103, 240, 0.25) !important;
        outline: 0 !important;
        transform: translateY(-1px);
    }
    
    textarea.form-control::placeholder {
        color: #b4b7bd !important;
        opacity: 0.6 !important;
    }
    
    /* Card styling */
    .card {
        background-color: #283046;
        border: 1px solid #3b4253;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
        transition: box-shadow 0.3s ease-in-out;
    }
    
    .card:hover {
        box-shadow: 0 4px 25px 0 rgba(34, 41, 47, 0.1);
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    /* Layout mới */
    @media (min-width: 768px) {
        .col-md-6 {
            flex: 0 0 50%;
            max-width: 50%;
        }
    }
</style>

<main>
    <div class="container">
        <div class="flex flex-col md:flex-row gap-4 pb-5">
            <div class="w-full md:w-3/4">
                <!-- FORM THEO LAYOUT BILLMMO -->
                <div class="card">
                    <div class="card-body">
                        <form class="hk-mbbank hk-refresh-form" id="bill-form" method="POST" action="/backend/create-bill.php">
                            <!-- CÁC INPUT HIDDEN CẦN THIẾT (GIỮ NGUYÊN) -->
                            <input type="hidden" name="gd" value="15">
                            <input type="hidden" name="kieuchuyen" value="macdinh">
                            <input type="hidden" name="stkchinh" value="">
                            <input type="hidden" name="soduchinh" value="">
                            <input type="hidden" name="chitiet" value="0">
                            <input type="hidden" name="tennguoichuyen" value="">
                            <input type="hidden" name="magiaodich" value="">
                            
                            <div class="row">
                                <!-- Tên tài khoản nguồn - Ô TRỐNG, PLACEHOLDER MỜ -->
                                <div class="col-md-6 col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="name_account_source">Tên tài khoản nguồn</label>
                                        <input type="text" class="form-control" name="name_account_source" id="name_account_source"
                                               placeholder="Nhập tên tài khoản MBBank của bạn" value="">
                                    </div>
                                </div>
                                
                                <!-- Số tài khoản nguồn - Ô TRỐNG, PLACEHOLDER MỜ -->
                                <div class="col-md-6 col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="number_account_source">Số tài khoản nguồn</label>
                                        <input type="text" class="form-control" name="number_account_source" id="number_account_source"
                                               placeholder="Nhập số tài khoản MBBank của bạn" value="">
                                    </div>
                                </div>
                                
                                <!-- Tên người nhận - Ô TRỐNG, PLACEHOLDER MỜ -->
                                <div class="col-md-6 col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="tennguoinhan">Tên Người Nhận</label>
                                        <input type="text" class="form-control" name="tennguoinhan" id="tennguoinhan"
                                               placeholder="Nhập tên người nhận" value="" required>
                                    </div>
                                </div>
                                
                                <!-- Số tài khoản - Ô TRỐNG, PLACEHOLDER MỜ -->
                                <div class="col-md-6 col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="stk">Số Tài Khoản Người Nhận</label>
                                        <input type="text" class="form-control" name="stk" id="stk"
                                               placeholder="Nhập số tài khoản người nhận" value="" required>
                                    </div>
                                </div>
                                
                                <!-- Số tiền - Ô TRỐNG, PLACEHOLDER MỜ -->
                                <div class="col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="sotienchuyen">Số Tiền Chuyển</label>
                                        <input type="text" class="form-control" name="sotienchuyen" id="sotienchuyen"
                                               placeholder="Nhập số tiền cần chuyển" value="" required>
                                    </div>
                                </div>
                                
                                <!-- Ngân hàng - SELECT MỜ KHI CHƯA CHỌN -->
                                <div class="col-md-6 col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="nganhangnhan">Ngân Hàng Nhận</label>
                                        <select class="form-select" name="nganhangnhan" id="nganhangnhan">
                                            <option value="" selected>Chọn ngân hàng</option>
                                            <option value="vietinbank">Vietinbank (CTG)</option>
                                            <option value="techcombank">Techcombank (TCB)</option>
                                            <option value="vietcombank">Vietcombank (VCB)</option>
                                            <option value="acbbank">ACB (Á Châu)</option>
                                            <option value="agribank">Agribank (VBA)</option>
                                            <option value="bidv">BIDV (BIDV)</option>
                                            <option value="sacombank">Sacombank (STB)</option>
                                            <option value="mbbank">MB Bank (MB)</option>
                                            <option value="namabank">Nam Á Bank (Nam A Bank)</option>
                                            <option value="dongabank">Đông Á Bank (DongA Bank)</option>
                                            <option value="ocb">OCB (Oricombank)</option>
                                            <option value="tpbank">TP Bank (TPB)</option>
                                            <option value="vpbank">VP Bank (VPB)</option>
                                            <option value="sgb">Saigonbank (SGB)</option>
                                            <option value="vib">VIB (Ngân hàng Quốc Tế VIB)</option>
                                            <option value="seabank">SeaBank (SeABank)</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <!-- Mã giao dịch - Ô TRỐNG, PLACEHOLDER MỜ -->
                                <div class="col-md-6 col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="trading_code">Mã giao dịch</label>
                                        <input type="text" class="form-control" name="trading_code" id="trading_code"
                                               placeholder="Nhập mã giao dịch" value="">
                                    </div>
                                </div>
                                
                                <!-- Thời gian chuyển - Ô TRỐNG, PLACEHOLDER MỜ -->
                                <div class="col-md-6 col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="thoigianchuyen">Thời Gian Chuyển</label>
                                        <input type="text" class="form-control" name="thoigianchuyen" id="thoigianchuyen"
                                               placeholder="Nhập thời gian chuyển" value="" required>
                                    </div>
                                </div>
                                
                                <!-- Thời gian trên điện thoại - Ô TRỐNG, PLACEHOLDER MỜ -->
                                <div class="col-md-6 col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="thoigiantrendt">Thời Gian Trên ĐT</label>
                                        <input type="text" class="form-control" name="thoigiantrendt" id="thoigiantrendt"
                                               placeholder="Nhập giờ trên điện thoại" value="" required>
                                    </div>
                                </div>
                                
                                <!-- Nội dung - Ô TRỐNG, PLACEHOLDER MỜ -->
                                <div class="col-12">
                                    <div class="mb-1">
                                        <label class="form-label" for="noidungchuyen">Nội Dung Chuyển</label>
                                        <textarea class="form-control" name="noidungchuyen" id="noidungchuyen" rows="3"
                                                  placeholder="Nhập nội dung chuyển khoản" required></textarea>
                                    </div>
                                </div>
                                
                                <!-- VIP Status (GIỮ NGUYÊN) -->
                                <div class="col-12">
                                    <?php include($_SERVER['DOCUMENT_ROOT'].'/function/insert/button/vip.status.php'); ?>
                                </div>
                                
                                <!-- Bill Settings (GIỮ NGUYÊN) -->
                                <div class="col-12">
                                    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/function/insert/modal/bill-setting.php'); ?>
                                </div>
                                
                                <!-- Nút tạo bill (GIỮ NGUYÊN) -->
                                <div class="col-12">
                                    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/function/insert/button/taobill.php'); ?>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Demo bill - DÙNG ẢNH EZ DEMO (GIỮ NGUYÊN) -->
            <div class="w-full md:w-1/4 card-demo-bill">
                <div class="card">
                    <div class="card-body text-center">
                        <h5 class="card-title mb-3">Xem trước bill</h5>
                        <div class="router-link-active router-link-exact-active group relative flex w-full flex-col overflow-hidden rounded-2xl kq-bill">
                            <img src="/public/src/vtd/img/phoi/bill/demo.jpg" alt="Bill MB EZ Demo" class="h-full w-full object-cover object-center rounded">
                        </div>
                        <p class="card-text text-muted mt-3">Bill sẽ hiển thị ở đây sau khi tạo</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- THÊM JS -->
<script>
// GIỮ NGUYÊN TẤT CẢ JAVASCRIPT BACKEND CŨ
document.addEventListener('DOMContentLoaded', function() {
    // Map field mới sang field cũ
    var tradingCodeInput = document.getElementById('trading_code');
    var magiaodichHidden = document.querySelector('input[name="magiaodich"]');
    
    if (tradingCodeInput && magiaodichHidden) {
        tradingCodeInput.addEventListener('input', function() {
            magiaodichHidden.value = this.value;
        });
    }
    
    var nameSourceInput = document.getElementById('name_account_source');
    var tennguoichuyenHidden = document.querySelector('input[name="tennguoichuyen"]');
    
    if (nameSourceInput && tennguoichuyenHidden) {
        nameSourceInput.addEventListener('input', function() {
            tennguoichuyenHidden.value = this.value;
        });
    }
    
    var numberSourceInput = document.getElementById('number_account_source');
    var stkchinhHidden = document.querySelector('input[name="stkchinh"]');
    
    if (numberSourceInput && stkchinhHidden) {
        numberSourceInput.addEventListener('input', function() {
            stkchinhHidden.value = this.value;
        });
    }
    
    // HIỆU ỨNG KHI FOCUS
    var inputs = document.querySelectorAll('.form-control, .form-select');
    inputs.forEach(function(input) {
        input.addEventListener('focus', function() {
            this.parentElement.querySelector('.form-label').style.color = '#7367f0';
        });
        
        input.addEventListener('blur', function() {
            this.parentElement.querySelector('.form-label').style.color = '#d0d2d6';
        });
    });
    
    // Giữ nguyên tất cả JS xử lý cũ
    if (typeof window.initBillForm !== 'undefined') {
        window.initBillForm();
    }
});
</script>

<?php require($_SERVER['DOCUMENT_ROOT'].'/include/foot.php'); ?>