<?php require($_SERVER['DOCUMENT_ROOT'].'/include/head.php'); ?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/nav.php'); ?>
<main>
    <div class="container" bis_skin_checked="1">
        <div class="flex flex-col md:flex-row gap-4 pb-5" bis_skin_checked="1">
            <div class="w-full md:w-3/4" bis_skin_checked="1">
                <form class="hk-bdsd-acb hk-refresh-form space-y-6">
                    <fieldset class="relative">
                        <div class="grid grid-cols-1 sm:grid-cols-1 gap-3 nui-card nui-card-rounded-lg nui-card-default relative p-5 md:mx-0 shadow-lg border-none" bis_skin_checked="1">
                            <legend class="mb-6-none flex flex-col md:flex-row justify-between items-start">
                                <div class="text-left" bis_skin_checked="1">
                                    <p class="nui-heading nui-heading-md nui-weight-bold nui-lead-none">
                                        <i class="ri-bank-fill me-1"></i> Tạo Bill Biến Động ACB
                                    </p>
                                    <span class="nui-text nui-content-xs nui-weight-normal nui-lead-normal text-muted-400">
                                        Hãy nhập đầy đủ thông tin để tạo bill
                                    </span>
                                </div>
                            </legend>
                            <div class="col-span-1" bis_skin_checked="1">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm" bis_skin_checked="1">
                                    <label class="nui-input-label" for="stk">Số Tài Khoản</label>
                                    <div class="nui-input-outer" bis_skin_checked="1">
                                        <div bis_skin_checked="1">
                                            <input type="text" class="nui-input" name="stk" placeholder="Ví dụ: 10042441315" value="10239821021" required="">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div id="bdsd-container" bis_skin_checked="1">
                                <div class="bdsd-block space-y-3" bis_skin_checked="1">
                                    <hr class="separator">
                                    <div class="flex justify-between items-center" bis_skin_checked="1">
                                        <h3 class="nui-heading nui-heading-md nui-weight-bold text-primary-500 nui-lead-none">Biến động 1</h3>
                                        <button type="button" class="nui-button nui-button-sm nui-button-rounded-sm nui-button-danger nui-button-outline remove-bdsd" style="display: none;">Xoá Biến Động</button>
                                    </div>
                                    <div class="col-span-1" bis_skin_checked="1">
                                        <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm" bis_skin_checked="1">
                                            <div class="nui-input-number-wrapper nui-input-number-default nui-input-number-md nui-input-number-rounded-sm grow" bis_skin_checked="1">
                                                <label class="nui-input-label" for="sotiengd[]">Số Tiền Giao Dịch</label>
                                                <div class="nui-input-number-outer" bis_skin_checked="1">
                                                    <input type="text" class="nui-input-number td-format-money" maxlength="30" data-td-msg="Số tiền chuyển phải là một con số!" name="sotiengd[]" placeholder="Ví dụ: 50,000,000" value="50,000,000" required=""><small class="error-message" style="display: none;">Số tiền chuyển phải là một con số!</small>
                                                    <div class="nui-input-number-buttons" bis_skin_checked="1">
                                                        <button type="button" btn="destroy"><i class="ri-close-line"></i></button>
                                                        <button type="button" btn="minus"><i class="ri-subtract-line"></i></button>
                                                        <button type="button" btn="plus"><i class="ri-add-line"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-span-1" bis_skin_checked="1">
                                        <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm" bis_skin_checked="1">
                                            <div class="nui-input-number-wrapper nui-input-number-default nui-input-number-md nui-input-number-rounded-sm grow" bis_skin_checked="1">
                                                <label class="nui-input-label" for="soduchinh[]">Số Dư Chính</label>
                                                <div class="nui-input-number-outer" bis_skin_checked="1">
                                                    <input type="text" class="nui-input-number td-format-money" data-limit-text="30" data-td-msg="Số tiền chuyển phải là một con số!" maxlength="30" name="soduchinh[]" placeholder="Ví dụ: 50,000,000" value="50,000,000" required=""><small class="error-message" style="display: none;">Số tiền chuyển phải là một con số!</small>
                                                    <div class="nui-input-number-buttons" bis_skin_checked="1">
                                                        <button type="button" btn="destroy"><i class="ri-close-line"></i></button>
                                                        <button type="button" btn="minus"><i class="ri-subtract-line"></i></button>
                                                        <button type="button" btn="plus"><i class="ri-add-line"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-span-1" bis_skin_checked="1">
                                        <div class="nui-select-wrapper nui-select-default nui-select-md nui-select-rounded-md" bis_skin_checked="1">
                                            <label class="nui-select-label" for="phuongthuc[]">Hình Thức Biến Động</label>
                                            <div class="nui-select-outer" bis_skin_checked="1">
                                                <select class="nui-select" name="phuongthuc[]">
                                                <option value="chuyentien">Chuyển Tiền</option>
                                                <option value="nhantien">Nhận Tiền</option>
                                                </select>
                                                <div class="nui-select-chevron nui-chevron" bis_skin_checked="1">
                                                    <svg aria-hidden="true" viewBox="0 0 24 24" class="nui-select-chevron-inner">
                                                        <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6">
                                                        </path>
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-span-1" bis_skin_checked="1">
                                        <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm nui-has-icon" bis_skin_checked="1">
                                            <label class="nui-input-label" for="thoigianchuyen[]">Thời
                                                Gian
                                                Chuyển</label>
                                            <div class="nui-input-outer" bis_skin_checked="1">
                                                <input type="text" class="nui-input" name="thoigianchuyen[]" value="00:33 - 21/07/2025" maxlength="19" placeholder="Ví dụ: 00:33 - 21/07/2025" required="">
                                                <div class="nui-input-icon" bis_skin_checked="1">
                                                    <i class="ri-calendar-line"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-span-1" bis_skin_checked="1">
                                        <label class="nui-label text-[0.825rem]" for="noidungchuyen[]">Nội
                                            Dung Chuyển</label>
                                        <div class="nui-textarea-wrapper nui-textarea-default nui-textarea-md nui-textarea-rounded-sm nui-textarea-not-resize" bis_skin_checked="1">
                                            <div class="nui-textarea-outer" bis_skin_checked="1">
                                                <textarea class="nui-textarea" name="noidungchuyen[]" rows="3" maxlength="70" placeholder="Ví dụ: NGUYEN VAN A chuyen tien-210725-00:33:20-956834" required="">NGUYEN VAN A chuyen tien-210725-00:33:20-486469</textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-1" bis_skin_checked="1">
                                <button type="button" id="add-bdsd" class="nui-button nui-button-md nui-button-rounded-sm nui-button-primary nui-button-outline w-full">Thêm Biến Động Mới</button>
                            </div>

                            <div class="col-span-1" bis_skin_checked="1">
                                <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm nui-has-icon" bis_skin_checked="1">
                                    <label class="nui-input-label" for="thoigianchuyen">Thời
                                        Gian
                                        Trên
                                        ĐT </label>
                                    <div class="nui-input-outer" bis_skin_checked="1">
                                        <input type="text" class="nui-input" name="thoigiantrendt" value="00:33" placeholder="Ví dụ: 00:00" required="">
                                        <div class="nui-input-icon" bis_skin_checked="1">
                                            <i class="ri-time-line"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php include($_SERVER['DOCUMENT_ROOT'].'/function/insert/button/vip.status.php');?>
                            <div class="col-span-1">
                                <?php include($_SERVER['DOCUMENT_ROOT'].'/function/insert/modal/bill-setting.php');?>
                            </div>
                            <?php include($_SERVER['DOCUMENT_ROOT'].'/function/insert/button/taobill.php');?>
                        </div>
                    </fieldset>
                </form>
            </div>
            <div class="w-full card-demo-bill hidden md:block" bis_skin_checked="1">
                <div class="col-span-6 sm:col-span-3" bis_skin_checked="1">
                    <div class="router-link-active router-link-exact-active group relative flex w-full flex-col overflow-hidden rounded-2xl kq-bill" bis_skin_checked="1">
                        <img src="https://i.ibb.co/qLMxQ7L1/BDSD-ACB-BIll-GIA-Com-56576.png" data-src="https://i.ibb.co/qLMxQ7L1/BDSD-ACB-BIll-GIA-Com-56576.png" alt="Fake Bill Lavender" class="h-full w-full object-cover object-center lazyloaded">
                        <?php?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/foot.php'); ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const bdsdContainer = document.getElementById('bdsd-container');
    const addBdsdButton = document.getElementById('add-bdsd');

    function formatCurrency(input) {
        let value = input.value.replace(/\D/g, '');
        if (value) {
            value = parseInt(value, 10).toLocaleString('en-US');
        }
        input.value = value;
    }

    function initializeMoneyInputs(container) {
        const moneyInputs = container.querySelectorAll('.td-format-money');
        moneyInputs.forEach(input => {
            if (!input.dataset.moneyFormatInitialized) {
                formatCurrency(input);

                input.addEventListener('input', function() {
                    formatCurrency(this);
                });

                input.addEventListener('blur', function() {
                    formatCurrency(this);
                });
                input.dataset.moneyFormatInitialized = 'true';
            }
        });
    }

    function updateBdsdState() {
        const bdsdBlocks = bdsdContainer.querySelectorAll('.bdsd-block');
        const currentBdsdCount = bdsdBlocks.length;

        bdsdBlocks.forEach((block, index) => {
            const heading = block.querySelector('.nui-heading');
            if (heading) {
                heading.textContent = `Biến động ${index + 1}`;
            }
            const removeButton = block.querySelector('.remove-bdsd');
            if (removeButton) {
                if (currentBdsdCount === 1) {
                    removeButton.style.display = 'none';
                } else {
                    removeButton.style.display = 'block';
                }
            }
            initializeMoneyInputs(block);
        });

        if (currentBdsdCount >= 4) {
            addBdsdButton.style.display = 'none';
        } else {
            addBdsdButton.style.display = 'block';
        }
    }

    addBdsdButton.addEventListener('click', function() {
        const bdsdBlocks = bdsdContainer.querySelectorAll('.bdsd-block');
        if (bdsdBlocks.length < 4) {
            const newBdsdBlock = document.createElement('div');
            newBdsdBlock.classList.add('bdsd-block', 'space-y-3', 'animate-fade-in');

            const now = new Date();
            const hours = String(now.getHours()).padStart(2, '0');
            const minutes = String(now.getMinutes()).padStart(2, '0');
            const day = String(now.getDate()).padStart(2, '0');
            const month = String(now.getMonth() + 1).padStart(2, '0');
            const year = now.getFullYear();
            const currentTime = `${hours}:${minutes} - ${day}/${month}/${year}`;

            const randomSuffix = Math.floor(100000 + Math.random() * 900000);
            const randomContent = `NGUYEN VAN A chuyen tien-${day}${month}${String(year).slice(2)}-${hours}:${minutes}:${String(now.getSeconds()).padStart(2, '0')}-${randomSuffix}`;


            newBdsdBlock.innerHTML = `
                <hr class="separator">
                <div class="flex justify-between items-center" bis_skin_checked="1">
                    <h3 class="nui-heading nui-heading-md nui-weight-bold text-primary-500 nui-lead-none">Biến động ${bdsdBlocks.length + 1}</h3>
                    <button type="button" class="nui-button nui-button-sm nui-button-rounded-sm nui-button-danger nui-button-outline remove-bdsd">Xoá Biến Động</button>
                </div>
                <div class="col-span-1" bis_skin_checked="1">
                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm" bis_skin_checked="1">
                        <div class="nui-input-number-wrapper nui-input-number-default nui-input-number-md nui-input-number-rounded-sm grow" bis_skin_checked="1">
                            <label class="nui-input-label" for="sotiengd[]">Số Tiền Giao Dịch</label>
                            <div class="nui-input-number-outer" bis_skin_checked="1">
                                <input type="text" class="nui-input-number td-format-money" maxlength="30" data-td-msg="Số tiền chuyển phải là một con số!" name="sotiengd[]" placeholder="Ví dụ: 50,000,000" value="0" required=""><small class="error-message" style="display: none;">Số tiền chuyển phải là một con số!</small>
                                <div class="nui-input-number-buttons" bis_skin_checked="1">
                                    <button type="button" btn="destroy"><i class="ri-close-line"></i></button>
                                    <button type="button" btn="minus"><i class="ri-subtract-line"></i></button>
                                    <button type="button" btn="plus"><i class="ri-add-line"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-span-1" bis_skin_checked="1">
                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm" bis_skin_checked="1">
                        <div class="nui-input-number-wrapper nui-input-number-default nui-input-number-md nui-input-number-rounded-sm grow" bis_skin_checked="1">
                            <label class="nui-input-label" for="soduchinh[]">Số Dư Chính</label>
                            <div class="nui-input-number-outer" bis_skin_checked="1">
                                <input type="text" class="nui-input-number td-format-money" data-limit-text="30" data-td-msg="Số tiền chuyển phải là một con số!" maxlength="30" name="soduchinh[]" placeholder="Ví dụ: 50,000,000" value="0" required=""><small class="error-message" style="display: none;">Số tiền chuyển phải là một con số!</small>
                                <div class="nui-input-number-buttons" bis_skin_checked="1">
                                    <button type="button" btn="destroy"><i class="ri-close-line"></i></button>
                                    <button type="button" btn="minus"><i class="ri-subtract-line"></i></button>
                                    <button type="button" btn="plus"><i class="ri-add-line"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-span-1" bis_skin_checked="1">
                    <div class="nui-select-wrapper nui-select-default nui-select-md nui-select-rounded-md" bis_skin_checked="1">
                        <label class="nui-select-label" for="phuongthuc[]">Hình Thức Biến Động</label>
                        <div class="nui-select-outer" bis_skin_checked="1">
                            <select class="nui-select" name="phuongthuc[]">
                                <option value="chuyentien">Chuyển Tiền</option>
                                <option value="nhantien">Nhận Tiền</option>
                            </select>
                            <div class="nui-select-chevron nui-chevron" bis_skin_checked="1">
                                <svg aria-hidden="true" viewBox="0 0 24 24" class="nui-select-chevron-inner">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 6 6 6-6"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-span-1" bis_skin_checked="1">
                    <div class="nui-input-wrapper nui-input-default nui-input-md nui-input-rounded-sm nui-has-icon" bis_skin_checked="1">
                        <label class="nui-input-label" for="thoigianchuyen[]">Thời Gian Chuyển</label>
                        <div class="nui-input-outer" bis_skin_checked="1">
                            <input type="text" class="nui-input" name="thoigianchuyen[]" value="${currentTime}" maxlength="19" placeholder="Ví dụ: 00:33 - 21/07/2025" required="">
                            <div class="nui-input-icon" bis_skin_checked="1">
                                <i class="ri-calendar-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-span-1" bis_skin_checked="1">
                    <label class="nui-label text-[0.825rem]" for="noidungchuyen[]">Nội Dung Chuyển</label>
                    <div class="nui-textarea-wrapper nui-textarea-default nui-textarea-md nui-textarea-rounded-sm nui-textarea-not-resize" bis_skin_checked="1">
                        <div class="nui-textarea-outer" bis_skin_checked="1">
                            <textarea class="nui-textarea" name="noidungchuyen[]" rows="3" maxlength="70" placeholder="Ví dụ: NGUYEN VAN A chuyen tien-210725-00:33:20-956834" required="">${randomContent}</textarea>
                        </div>
                    </div>
                </div>
            `;
            bdsdContainer.appendChild(newBdsdBlock);
            updateBdsdState();
        }
    });

    bdsdContainer.addEventListener('click', function(event) {
        if (event.target.classList.contains('remove-bdsd')) {
            const bdsdBlockToRemove = event.target.closest('.bdsd-block');
            const currentBdsdCount = bdsdContainer.querySelectorAll('.bdsd-block').length;

            if (bdsdBlockToRemove && currentBdsdCount > 1) {
                bdsdBlockToRemove.remove();
                updateBdsdState();
            }
        }
    });

    updateBdsdState();
});
</script>