<?php $options_header = ['title' => 'Trang Thuê Gói Thành Viên VIP']; ?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/head.php'); ?>
<?php require($_SERVER['DOCUMENT_ROOT'].'/include/nav.php'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
:root {
  --primary: #8b5cf6;
  --primary-dark: #1e40af;
  --secondary: #10b981;
  --accent: #f59e0b;
  --danger: #ef4444;
  --dark: #1e293b;
  --darker: #0f172a;
  --light: #f8fafc;
  --gray: #64748b;
  --card-bg: #1e293b;
  --text-primary: #f8fafc;
  --text-secondary: #cbd5e1;
  --border: #334155;
  --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.2), 0 2px 4px -1px rgba(0, 0, 0, 0.12);
  --shadow-hover: 0 10px 15px -3px rgba(0, 0, 0, 0.3), 0 4px 6px -2px rgba(0, 0, 0, 0.2);
}

* {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
  font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
}

.white {
    color: white;
}

.button-tp {
    background-color: #3b82f6;
}

.red {
    color: #ef4444;
}

body {
  background: #0f172a;
  color: var(--text-primary);
  line-height: 1.6;
}

.container {
  width: 100%;
  max-width: 1200px;
  margin: 0 auto;
  padding: 0 1rem;
}

/* Header Styles */
.page-header {
  text-align: center;
  margin: 2rem 0;
}

.page-title {
  font-size: 2.2rem;
  font-weight: 800;
  color: white;
  margin-bottom: 0.5rem;
  position: relative;
  display: inline-block;
  animation: glowText 2s infinite ease-in-out;
}

@keyframes glowText {
  0%   { text-shadow: 0 0 5px var(--primary), 0 0 10px var(--primary); }
  50%  { text-shadow: 0 0 20px var(--primary), 0 0 40px var(--secondary); }
  100% { text-shadow: 0 0 5px var(--primary), 0 0 10px var(--primary); }
}

.page-title::after {
  content: '';
  position: absolute;
  bottom: -8px;
  left: 50%;
  transform: translateX(-50%);
  width: 60px;
  height: 4px;
  background: linear-gradient(90deg, var(--primary), var(--secondary));
  border-radius: 2px;
}

.page-subtitle {
  color: var(--gray);
  font-size: 1.1rem;
  max-width: 600px;
  margin: 0 auto;
}

/* Card Styles */
.card {
  background-color: var(--card-bg);
  border-radius: 12px;
  padding: 1.5rem;
  margin-bottom: 1.5rem;
  box-shadow: var(--shadow);
  transition: all 0.3s ease;
  border: 1px solid var(--border);
}

.card:hover {
  box-shadow: var(--shadow-hover);
  transform: translateY(-3px);
}

.card-header {
  margin-bottom: 1.5rem;
  padding-bottom: 0.75rem;
  border-bottom: 1px solid var(--border);
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.card-title {
  font-size: 1.25rem;
  font-weight: 700;
  color: var(--text-primary);
}

.card-title i {
  margin-right: 0.5rem;
}

/* Grid System */
.grid {
  display: grid;
  gap: 1.5rem;
}

.grid-cols-1 {
  grid-template-columns: repeat(1, 1fr);
}

.grid-cols-2 {
  grid-template-columns: repeat(2, 1fr);
}

.grid-cols-3 {
  grid-template-columns: repeat(3, 1fr);
}

.grid-cols-4 {
  grid-template-columns: repeat(4, 1fr);
}

@media (min-width: 640px) {
  .sm\:grid-cols-2 {
    grid-template-columns: repeat(2, 1fr);
  }
}

@media (min-width: 768px) {
  .md\:grid-cols-2 {
    grid-template-columns: repeat(2, 1fr);
  }
  
  .md\:grid-cols-3 {
    grid-template-columns: repeat(3, 1fr);
  }
  
  .md\:grid-cols-4 {
    grid-template-columns: repeat(4, 1fr);
  }
}

@media (min-width: 1024px) {
  .lg\:grid-cols-3 {
    grid-template-columns: repeat(3, 1fr);
  }
  
  .lg\:grid-cols-4 {
    grid-template-columns: repeat(4, 1fr);
  }
}

/* Plan Cards */
.plans-grid {
  margin: 2rem 0;
}

.plan-card {
  text-align: center;
  padding: 2rem;
  height: 100%;
  display: flex;
  flex-direction: column;
  position: relative;
  overflow: hidden;
  transition: all 0.3s ease;
}

.plan-card.popular {
  border: 2px solid var(--primary);
  transform: scale(1.02);
}

.plan-card.popular::before {
  content: 'OKBILL.ORG';
  position: absolute;
  top: 15px;
  right: -30px;
  background: var(--primary);
  color: white;
  padding: 5px 30px;
  font-size: 12px;
  font-weight: bold;
  transform: rotate(45deg);
}

.plan-icon {
  width: 80px;
  height: 80px;
  margin: 0 auto 1rem;
  display: flex;
  align-items: center;
  justify-content: center;
  background: rgba(37, 99, 235, 0.1);
  border-radius: 16px;
}

.plan-icon img {
  width: 50px;
  height: 50px;
}

.plan-name {
  font-size: 1.5rem;
  font-weight: 700;
  margin-bottom: 0.5rem;
  color: var(--text-primary);
  text-transform: uppercase; 
}

.plan-price {
  font-size: 2rem;
  font-weight: 800;
  margin-bottom: 0.5rem;
  color: var(--primary);
}

.plan-duration {
  color: var(--gray);
  font-size: 0.9rem;
  margin-bottom: 1.5rem;
}

.plan-features {
  list-style: none;
  text-align: left;
  margin-bottom: 2rem;
  flex-grow: 1;
}

.plan-feature {
  display: flex;
  align-items: center;
  margin-bottom: 0.75rem;
  color: var(--text-secondary);
}

.plan-feature i {
  color: var(--primary);
  margin-right: 0.5rem;
  font-size: 1.1rem;
}

/* Button Styles */
.btn {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  padding: 0.75rem 1.5rem;
  border-radius: 8px;
  font-weight: 600;
  transition: all 0.3s ease;
  border: none;
  cursor: pointer;
  text-decoration: none;
}

.btn-primary {
  background: var(--primary);
  color: white;
}

.btn-primary:hover {
  background: var(--primary-dark);
  transform: translateY(-2px);
}

.btn-secondary {
  background: transparent;
  color: var(--primary);
  border: 1px solid var(--primary);
}

.btn-secondary:hover {
  background: var(--primary);
  color: white;
}

.btn-icon {
  margin-right: 0.5rem;
}

/* Utilities */
.text-center { text-align: center; }
.mb-2 { margin-bottom: 0.5rem; }
.mb-4 { margin-bottom: 1rem; }
.mb-6 { margin-bottom: 1.5rem; }
.mt-6 { margin-top: 1.5rem; }

/* Responsive adjustments */
@media (max-width: 768px) {
  .plan-card.popular {
    transform: scale(1);
  }
  
  .plan-card.popular::before {
    top: 10px;
    right: -35px;
    font-size: 10px;
    padding: 4px 35px;
  }
}

.glow {
    text-shadow: 0 0 5px #fff,
               0 0 10px #fff,
               0 0 20px #fff;
}

.glow-blue {
    text-shadow: 0 0 1px #2563eb,
               0 0 2px #2563eb,
               0 0 4px #2563eb;
}
</style>

<main class="container">
  <!-- Page Header -->
  <div class="page-header">
    <h1 class="page-title">THUÊ GÓI VIP</h1>
    <p class="page-subtitle">Nâng cấp tài khoản để trải nghiệm các tính năng cao cấp và tiết kiệm chi phí</p>
  </div>

  <!-- Plans Section -->
  <div class="plans-grid grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    <?php 
    $OoO = $thanhdieudb->query("SELECT * FROM ws_dsgoi");
    if ($OoO->num_rows > 0) 
    {
        $userPlan = $plans->TD('tengoi', $taikhoan) ?? null;
        while ($data = $OoO->fetch_assoc()) 
        {
            $ds = new DanhSachGoi($data, $userPlan); 
            $isPopular = stripos($ds->tengoi, 'vip') !== false || stripos($ds->tengoi, 'pro') !== false;
            
            $discountNoteVip10 = '';
            if ($ds->id == 10) {
                $discountNoteVip10 = '<div class="text-red-500 font-semibold">🔥 Đang giảm giá 50%</div>';
            }
            
            $discountNoteVip11 = '';
            if ($ds->id == 11) {
                $discountNoteVip11 = '<div class="text-red-500 font-semibold">🔥 Đang giảm giá 80%</div>';
            }
            
            $discountNoteVip12 = '';
            if ($ds->id == 12) {
                $discountNoteVip12 = '<div class="text-red-500 font-semibold">🔥 Đang giảm giá 90%</div>';
            }
            // ===== THIẾT BỊ ĐĂNG NHẬP =====
            $ThietBiVip = '';
            if (in_array($ds->id, [2, 4, 6, 8, 10])) {
                $ThietBiVip = '<div class="text-red-500 font-semibold">Tối đa 5 thiết bị</div>';
            }
            
            $ThietBiVipMax = '';
            if (in_array($ds->id, [12])) {
                $ThietBiVipMax = '<div class="text-red-500 font-semibold">Không giới hạn thiết bị</div>';
            }
            
            $ThietBi = '';
                if (in_array($ds->id, [1, 3, 5, 7, 9, 11])) {
                $ThietBi = '<div class="text-red-500 font-semibold">Tối đa 2 thiết bị</div>';
            }
        ?>
        <div class="card plan-card <?= $isPopular ? 'popular' : '' ?>">
            <div class="plan-icon">
                <i class="fa-solid fa-crown glow"></i>
            </div>
            <h3 class="plan-name"><?=$ds->tengoi?></h3>
            <div>
  <span class="plan-price"><?=FormatNumber::TD($ds->giagoi)?>đ</span>
  <span class="plan-duration"> / <?=FormatHsdGoi(FormatNumber::PREG($ds->hansudung))?></span>
</div>
            <?=$discountNoteVip10?>
            <?=$discountNoteVip11?>
            <?=$discountNoteVip12?>
            <ul class="plan-features">
                <!--
                <li class="plan-feature">
                    <i class="fas fa-check-circle"></i>
                    <span>Ưu tiên hỗ trợ 24/7</span>
                </li>
                -->
                <li class="plan-feature">
                    <i class="fas fa-check-circle"></i>
                    <span>Không watermark</span>
                </li>
                <li class="plan-feature">
                    <i class="fas fa-check-circle"></i>
                    <span><?=$ds->gioihanbill?></span>
                </li>
                <li class="plan-feature">
                    <i class="fas fa-check-circle"></i>
                    <span>Fake được giấy tờ</span>
                </li>
                <li class="plan-feature">
                    <i class="fas fa-check-circle"></i>
                    <span><?=$ThietBi?><?=$ThietBiVip?><?=$ThietBiVipMax?></span>
                </li>
                <li class="plan-feature">
                    <i class="fas fa-check-circle"></i>
                    <span>Hạn sử dụng: <?=$ds->hansudung?></span>
                </li>
            </ul>
            <div class="mt-auto">
                <?= $ds->render() ?>
            </div>
        </div>   
        <?php
        } ?>
    <?php 
    } else { ?>
    <div class="col-span-3">
        <div class="card text-center">
            <div class="plan-icon mx-auto">
                <i class="fas fa-store-slash" style="font-size: 3rem; color: #64748b;"></i>
            </div>
            <h3 class="plan-name">Chưa Mở Shop Thuê Gói</h3>
            <p class="text-muted-500">Xin lỗi vì sự bất tiện, có vẻ như chủ sở hữu trang web vẫn chưa triển khai chức năng thuê gói.</p>
        </div>
    </div>
    <?php } ?>
  </div>

  <!-- Features Section -->
  <div class="grid grid-cols-2 md:grid-cols-2 lg:grid-cols-4 gap-6 mt-12">
    <div class="card text-center">
        <div class="plan-icon mx-auto">
            <i class="fas fa-shield-alt glow-blue" style="font-size: 2.5rem; color: var(--primary);"></i>
        </div>
        <h4 class="plan-name">Bảo Mật Cao</h4>
        <p class="text-muted-500">Dữ liệu được mã hóa và bảo vệ an toàn</p>
    </div>
    
    <div class="card text-center">
        <div class="plan-icon mx-auto">
            <i class="fas fa-bolt glow-blue" style="font-size: 2.5rem; color: var(--primary);"></i>
        </div>
        <h4 class="plan-name">Tốc Độ Cao</h4>
        <p class="text-muted-500">Xử lý nhanh chóng, không phải chờ đợi</p>
    </div>
    
    <div class="card text-center">
        <div class="plan-icon mx-auto">
            <i class="fas fa-headset glow-blue" style="font-size: 2.5rem; color: var(--primary);"></i>
        </div>
        <h4 class="plan-name">Hỗ Trợ 24/7</h4>
        <p class="text-muted-500">Đội ngũ hỗ trợ luôn sẵn sàng giúp bạn</p>
    </div>
    
    <div class="card text-center">
        <div class="plan-icon mx-auto">
            <i class="fas fa-sync glow-blue" style="font-size: 2.5rem; color: var(--primary);"></i>
        </div>
        <h4 class="plan-name">Cập Nhật</h4>
        <p class="text-muted-500">Thường xuyên cập nhật các bill mới</p>
    </div>
  </div>
</main><!--
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>swal ( "Thông Báo!" ,  "Vip 1 Có Thể Dùng Mọi Dịch Vụ." ,  "info" )</script> -->

<?php require($_SERVER['DOCUMENT_ROOT'].'/include/foot.php'); ?>