<?php $options_header = ['title' => 'Nạp Tiền Vào Tài Khoản']; ?>
<?php require_once($_SERVER['DOCUMENT_ROOT'] . '/include/head.php'); ?>
<?php require_once($_SERVER['DOCUMENT_ROOT'] . '/include/nav.php'); ?>
<?php
$notification = null;
$show_success_banner = false;

if (isset($_POST['submit'])) {
    if (!isset($_POST['telco']) || !isset($_POST['amount']) || !isset($_POST['serial']) || !isset($_POST['code'])) {
        $notification = ['type' => 'error', 'message' => 'Bạn cần nhập đầy đủ thông tin'];
    } else {

        $request_id = rand(100000000, 999999999);
        $command = 'charging';
        $url = 'https://nappay.vn/chargingws/v2';
        $partner_id = '5054215337';
        $partner_key = '98b3a88be64650680afa11e077c4b00a';
        $username = $user['username'];
        global $thanhdieudb;
        
        $stmt = $thanhdieudb->prepare("INSERT INTO ws_history_card (request_id, taikhoan, loaithe, mathe, seriel, menhgia, trangthai) VALUES (?, ?, ?, ?, ?, ?, 'choxuly')");
        $stmt->bind_param(
            "issssi",
            $request_id,
            $username,
            $_POST['telco'],
            $_POST['code'],
            $_POST['serial'],
            $_POST['amount']
            );
        $stmt->execute();

        $dataPost = array();
        $dataPost['request_id'] = $request_id;
        $dataPost['code'] = $_POST['code'];
        $dataPost['partner_id'] = $partner_id;
        $dataPost['serial'] = $_POST['serial'];
        $dataPost['telco'] = $_POST['telco'];
        $dataPost['command'] = $command;
        ksort($dataPost);
        $code = $_POST['code'];
        $serial = $_POST['serial'];
        $sign = $partner_key . $code . $serial;

        $mysign = md5($sign);

        $dataPost['amount'] = $_POST['amount'];
        $dataPost['sign'] = $mysign;

        $data = http_build_query($dataPost);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        $actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        curl_setopt($ch, CURLOPT_REFERER, $actual_link);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);

        $obj = json_decode($result);

        // Cập nhật trạng thái trong database dựa trên kết quả API
        $trangthai = 'choxuly'; // mặc định
        $notification_type = 'info';
        
        if ($obj->status == 99) {
            $notification_message = 'THẺ CÀO ĐANG ĐỢI DUYỆT';
            $notification_type = 'success';
            $trangthai = 'choduyet';
            $show_success_banner = true;
        } elseif ($obj->status == 1) {
            $notification_message = 'Thành công';
            $notification_type = 'success';
            $trangthai = 'thanhcong';
            $show_success_banner = true;
        } elseif ($obj->status == 2) {
            $notification_message = 'Thành công nhưng sai mệnh giá';
            $notification_type = 'warning';
            $trangthai = 'saimenhgia';
        } elseif ($obj->status == 3) {
            $notification_message = 'Thẻ sai hoặc lỗi, vui lòng kiểm tra lại!';
            $notification_type = 'error';
            $trangthai = 'thatbai';
        } elseif ($obj->status == 4) {
            $notification_message = 'Bảo trì';
            $notification_type = 'info';
            $trangthai = 'baotri';
        } else {
            $notification_message = 'Lỗi';
            $notification_type = 'error';
            $trangthai = 'loi';
        }
        
        // Update trạng thái trong database
        $update_stmt = $thanhdieudb->prepare("UPDATE ws_history_card SET trangthai = ? WHERE request_id = ?");
        $update_stmt->bind_param("si", $trangthai, $request_id);
        $update_stmt->execute();
        $update_stmt->close();
        
        $notification = ['type' => $notification_type, 'message' => $notification_message];
    }
}

// Lấy lịch sử thẻ từ database - CẬP NHẬT ĐỂ HIỂN THỊ ĐÚNG TRẠNG THÁI
$history = [];
if (isset($user['username'])) {
    $username = $user['username'];
    $stmt = $thanhdieudb->prepare("SELECT * FROM ws_history_card WHERE taikhoan = ? ORDER BY thoigian DESC LIMIT 20");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    $history = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}
?>
<div class="content-wrapper wt-show-log">
    <div class="flex-grow-1 container-p-y container-fluid">
        <div class="row g-4">
            <!-- Main Form Card -->
            <div class="col-lg-8">
                <div class="main-card">
                    <!-- Header -->
                    <div class="section-head">
                        <div>
                            <p class="eyebrow">Nạp tiền • Thẻ cào</p>
                            <h3 class="section-title">Gửi thẻ cào vào ví <span>EZBILL.TOKYO</span></h3>
                            <p class="section-subtitle">Nhập thông tin thẻ, hệ thống kiểm tra tự động và cộng tiền ngay khi thành công.</p>
                        </div>
                        <a href="https://t.me/Ezboyaaa" target="_blank" class="support-chip">
                            <i class="ri-customer-service-2-fill"></i>
                            <span>Hỗ trợ Telegram</span>
                        </a>
                    </div>
                 
                 <!-- Banner thành công -->
                 <?php if ($show_success_banner): ?>
                 <div class="success-banner">
                     <div class="success-content">
                         <div class="success-icon">
                             <i class="ri-checkbox-circle-fill"></i>
                         </div>
                         <div class="success-message">
                             <h5>Thẻ đã được gửi thành công!</h5>
                             <p>Hệ thống đang xử lý thẻ của bạn. Vui lòng đợi 5-10s sau đó tải lại trang để xem trạng thái cập nhật.</p>
                         </div>
                     </div>
                 </div>
                 <?php endif; ?>
                 
                 <!-- Form -->
                    <form class="user-charging-card charging-form" method="POST" action="">
                        <div class="form-grid">
                            <div class="form-group">
                                <label class="form-label">
                                    <i class="ri-credit-card-2-fill"></i>
                                    <span>Loại thẻ <span class="required">*</span></span>
                                </label>
                                <div class="select-wrapper">
                                    <select class="form-select-modern" name="telco" id="telco" required>
                                        <option value="" selected disabled>Chọn loại thẻ</option>
                                        <option value="VIETTEL">Viettel</option>
                                        <option value="VIETTELAUTO">Viettel Auto</option>
                                        <option value="MOBIFONE">Mobifone</option>
                                        <option value="MOBIFONEAUTO">Mobifone Auto</option>
                                        <option value="VINAPHONE">Vinaphone</option>
                                        <option value="VINAPHONEAUTO">Vinaphone Auto</option>
                                        <option value="GATE">Gate</option>
                                        <option value="ZING">Zing</option>
                                        <option value="MEGACARD">Megacard</option>
                                        <option value="BIT">BIT</option>
                                        <option value="GARENA">Garena</option>
                                    </select>
                                    <i class="ri-arrow-down-s-line select-arrow"></i>
                                </div>
                            </div>
                        <div class="form-group">
                            <label class="form-label">
                                <i class="ri-money-dollar-circle-fill"></i>
                                <span>Mệnh giá <span class="required">*</span></span>
                            </label>
                            <div class="select-wrapper">
                                <select class="form-select-modern" name="amount" id="amount" required>
                                    <option value="">Chọn mệnh giá</option>
                                    <option value="10000">10.000</option>
                                    <option value="20000">20.000</option>
                                    <option value="30000">30.000</option>
                                    <option value="50000">50.000</option>
                                    <option value="100000">100.000</option>
                                    <option value="200000">200.000</option>
                                    <option value="300000">300.000</option>
                                    <option value="500000">500.000</option>
                                    <option value="1000000">1.000.000</option>
                                </select>
                                <i class="ri-arrow-down-s-line select-arrow"></i>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">
                                <i class="ri-barcode-fill"></i>
                                <span>Số seri <span class="required">*</span></span>
                            </label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="ri-barcode-line"></i>
                                </div>
                                    <input type="text" class="form-input" name="serial" id="serial" placeholder="Nhập số serial" required>
                                    <button type="button" class="input-action" onclick="pasteFromClipboard('serial')" title="Dán">
                                        <i class="ri-clipboard-line"></i>
                                    </button>
                            </div>
                            <small class="form-hint">
                                <i class="ri-information-line"></i>
                                Số serial in trên thẻ cào
                            </small>
                        </div>
                        <div class="form-group">
                            <label class="form-label">
                                <i class="ri-lock-password-fill"></i>
                                <span>Mã thẻ <span class="required">*</span></span>
                            </label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="ri-lock-password-line"></i>
                                </div>
                                    <input type="text" class="form-input" name="code" id="code" placeholder="Nhập mã thẻ" required>
                                    <button type="button" class="input-action" onclick="pasteFromClipboard('code')" title="Dán">
                                        <i class="ri-clipboard-line"></i>
                                    </button>
                            </div>
                            <small class="form-hint">
                                <i class="ri-information-line"></i>
                                Mã thẻ dưới lớp bạc
                            </small>
                        </div>
                    </div>
                        <input type="hidden" name="action" value="user-charging-card">
                            <button type="submit" class="submit-button" name="submit">
                                <span class="button-content">
                                    <i class="ri-send-plane-fill"></i>
                                    <span>Gửi thẻ cào</span>
                                </span>
                                <span class="button-loader" style="display: none;">
                                    <i class="ri-loader-4-line animate-spin"></i>
                                    <span>Đang xử lý...</span>
                                </span>
                            </button>
                    </form>
                </div>
            </div>
            <div class="history-section mt-5">
            <div class="history-header">
                <div class="d-flex align-items-center">
                    <div class="history-icon">
                        <i class="ri-history-fill"></i>
                            </div>
                    <div>
                        <h5 class="history-title">Lịch sử nạp tiền</h5>
                        <p class="history-subtitle">Xem lại các giao dịch nạp thẻ của bạn</p>
                            </div>
                    </div>
                </div>
            <div class="history-table-wrapper">
                <table class="history-table">
                            <thead>
                                <tr>
                                    <th class="text-center">STT</th>
                            <th>Loại thẻ</th>
                            <th>Seri</th>
                            <th>Mã thẻ</th>
                            <th class="text-end">Mệnh giá</th>
                            <th>Thời gian</th>
                            <th class="text-center">Trạng thái</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($history)): ?>
                                    <tr>
                                        <td colspan="7" class="empty-state">
                                            <div class="empty-content">
                                                <div class="empty-icon">
                                                    <i class="ri-inbox-line"></i>
                                                </div>
                                                <h6 class="empty-title">Chưa có lịch sử</h6>
                                                <p class="empty-text">Bạn chưa thực hiện giao dịch nạp thẻ nào</p>
                                            </div>
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($history as $index => $item): ?>
                                    <tr>
                                        <td class="text-center"><?php echo $index + 1; ?></td>
                                        <td><?php echo htmlspecialchars($item['loaithe']); ?></td>
                                        <td><?php echo htmlspecialchars($item['seriel']); ?></td>
                                        <td><?php echo htmlspecialchars($item['mathe']); ?></td>
                                        <td class="text-end"><?php echo number_format($item['menhgia']); ?> đ</td>
                                        <td><?php echo date('d/m/Y H:i:s', strtotime($item['thoigian'])); ?></td>
                                        <td class="text-center">
                                            <?php
                                            $status_class = '';
                                            switch($item['trangthai']) {
                                                case 'thanhcong':
                                                    $status_class = 'status-success';
                                                    $status_text = 'Thành công';
                                                    break;
                                                case 'thatbai':
                                                case 'loi':
                                                    $status_class = 'status-error';
                                                    $status_text = 'Thất bại';
                                                    break;
                                                case 'choxuly':
                                                    $status_class = 'status-warning';
                                                    $status_text = 'Đang xử lý';
                                                    break;
                                                case 'choduyet':
                                                    $status_class = 'status-warning';
                                                    $status_text = 'Chờ duyệt';
                                                    break;
                                                case 'saimenhgia':
                                                    $status_class = 'status-info';
                                                    $status_text = 'Sai mệnh giá';
                                                    break;
                                                case 'baotri':
                                                    $status_class = 'status-info';
                                                    $status_text = 'Bảo trì';
                                                    break;
                                                default:
                                                    $status_class = 'status-info';
                                                    $status_text = $item['trangthai'];
                                            }
                                            ?>
                                            <span class="status-badge <?php echo $status_class; ?>">
                                                <?php echo $status_text; ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Notification Container -->
<div id="notification-container" class="notification-container"></div>

<style>
        /* THÊM CSS cho banner và status badges */
        .success-banner {
            background: linear-gradient(135deg, rgba(34, 197, 94, 0.15) 0%, rgba(34, 197, 94, 0.05) 100%);
            border: 1px solid rgba(34, 197, 94, 0.2);
            border-radius: 16px;
            padding: 1.25rem 1.5rem;
            margin-bottom: 1.5rem;
            animation: slideDown 0.4s ease-out;
        }
        
        .success-content {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .success-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        
        .success-icon i {
            font-size: 1.5rem;
            color: white;
        }
        
        .success-message {
            flex: 1;
        }
        
        .success-message h5 {
            font-size: 1.1rem;
            font-weight: 700;
            color: #22c55e;
            margin: 0 0 0.25rem 0;
        }
        
        .success-message p {
            font-size: 0.95rem;
            color: #86efac;
            margin: 0;
        }
        
        .status-badge {
            display: inline-block;
            padding: 0.35rem 0.75rem;
            border-radius: 8px;
            font-size: 0.8125rem;
            font-weight: 600;
            text-align: center;
        }
        
        .status-success {
            background: rgba(34, 197, 94, 0.15);
            color: #22c55e;
            border: 1px solid rgba(34, 197, 94, 0.2);
        }
        
        .status-error {
            background: rgba(239, 68, 68, 0.15);
            color: #ef4444;
            border: 1px solid rgba(239, 68, 68, 0.2);
        }
        
        .status-warning {
            background: rgba(245, 158, 11, 0.15);
            color: #f59e0b;
            border: 1px solid rgba(245, 158, 11, 0.2);
        }
        
        .status-info {
            background: rgba(59, 130, 246, 0.15);
            color: #3b82f6;
            border: 1px solid rgba(59, 130, 246, 0.2);
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        :root {
            --td-purple: #854fff;
            --td-purple-dark: #6d28d9;
            --td-purple-light: rgba(133, 79, 255, 0.15);
            --td-bg-dark: #0f172a;
            --td-card-dark: #16223f;
            --td-card-darker: #131d34;
            --td-border-dark: rgba(133, 79, 255, 0.18);
        }
        /* Page Background */
        .content-wrapper {
            background: radial-gradient(circle at top, rgba(133, 79, 255, 0.16), transparent 55%), linear-gradient(180deg, #0c1024 0%, #0f172a 100%) !important;
            min-height: 100vh;
        }

        .container-fluid {
            background: transparent !important;
        }

        .eyebrow {
            color: #9ca3af;
            text-transform: uppercase;
            letter-spacing: 0.08em;
            font-weight: 700;
            font-size: 0.72rem;
            margin: 0 0 0.25rem 0;
        }

        .section-head {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            gap: 1rem;
            margin-bottom: 1.25rem;
        }

        .section-title {
            color: #e2e8f0;
            font-size: 1.5rem;
            font-weight: 700;
            margin: 0 0 0.35rem 0;
        }

        .section-title span {
            color: #a855f7;
        }

        .section-subtitle {
            color: #94a3b8;
            margin: 0;
            font-size: 0.95rem;
        }

        .support-chip {
            display: inline-flex;
            align-items: center;
            gap: 0.4rem;
            padding: 0.6rem 0.9rem;
            border-radius: 12px;
            background: rgba(133, 79, 255, 0.15);
            color: #c4d4ff;
            text-decoration: none;
            font-weight: 600;
            border: 1px solid rgba(133, 79, 255, 0.2);
        }

        /* Main Card */
        .main-card {
            background: linear-gradient(180deg, var(--td-card-dark) 0%, var(--td-card-darker) 100%);
            border-radius: 24px;
            padding: 2rem;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.45);
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.04);
        }

        .main-card:hover {
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
        }

        /* Form */
        .charging-form {
            margin-top: 1rem;
        }

        .form-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1.25rem;
            margin-bottom: 1.5rem;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-weight: 600;
            color: #E2E8F0;
            margin-bottom: 0.75rem;
            font-size: 0.9375rem;
        }

        .form-label i {
            color: #8b5cf6;
            font-size: 1.125rem;
        }

        .required {
            color: #ef4444;
        }

        .select-wrapper {
            position: relative;
        }

        .form-select-modern {
            width: 100%;
            padding: 0.875rem 1rem 0.875rem 1rem;
            border: 1px solid rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            font-size: 0.9375rem;
            background: rgba(15, 23, 42, 0.6);
            color: #f8fafc;
            transition: all 0.3s ease;
            appearance: none;
            cursor: pointer;
        }

        .form-select-modern:focus {
            outline: none;
            border-color: rgba(133, 79, 255, 0.45);
            box-shadow: 0 0 0 4px rgba(133, 79, 255, 0.15);
            background: rgba(13, 20, 37, 0.9);
        }

        .select-arrow {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #64748b;
            pointer-events: none;
            font-size: 1.25rem;
        }

        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }

        .input-icon {
            position: absolute;
            left: 1rem;
            color: #94a3b8;
            z-index: 1;
        }

        .form-input {
            width: 100%;
            padding: 0.875rem 3.5rem 0.875rem 3rem;
            border: 1px solid rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            font-size: 0.9375rem;
            background: rgba(15, 23, 42, 0.6);
            transition: all 0.3s ease;
            color: #f8fafc;
        }

        .form-input:focus {
            outline: none;
            border-color: rgba(133, 79, 255, 0.45);
            box-shadow: 0 0 0 4px rgba(133, 79, 255, 0.15);
            background: rgba(13, 20, 37, 0.9);
        }

        .input-action {
            position: absolute;
            right: 0.75rem;
            width: 36px;
            height: 36px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(133, 79, 255, 0.25);
            border: none;
            border-radius: 8px;
            color: var(--td-purple);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .input-action:hover {
            background: #8b5cf6;
            color: white;
            transform: scale(1.05);
        }

        .form-hint {
            display: flex;
            align-items: center;
            gap: 0.25rem;
            margin-top: 0.35rem;
            font-size: 0.8125rem;
            color: #8f9bb3;
        }

        .form-hint i {
            font-size: 0.875rem;
        }

        /* Submit Button */
        .submit-button {
            width: 100%;
            padding: 1rem;
            background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
            color: white;
            border: none;
            border-radius: 14px;
            font-size: 1.0625rem;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            letter-spacing: 0.01em;
        }

        .submit-button:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(139, 92, 246, 0.4);
        }

        .submit-button:active:not(:disabled) {
            transform: translateY(0);
        }

        .submit-button:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }

        .button-content, .button-loader {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        /* History Section */
        .history-section {
            background: linear-gradient(180deg, var(--td-card-dark) 0%, var(--td-card-darker) 100%);
            border-radius: 24px;
            padding: 2rem;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.45);
            border: 1px solid rgba(255, 255, 255, 0.04);
            margin-top: 2rem;
        }

        .history-header {
            margin-bottom: 1.5rem;
        }

        .history-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            box-shadow: 0 4px 12px rgba(139, 92, 246, 0.3);
        }

        .history-icon i {
            font-size: 1.5rem;
            color: white;
        }

        .history-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: #e2e8f0;
            margin: 0 0 0.25rem 0;
        }

        .history-subtitle {
            font-size: 0.9rem;
            color: #94a3b8;
            margin: 0;
        }

        .history-table-wrapper {
            overflow-x: auto;
        }

        .history-table {
            width: 100%;
            border-collapse: collapse;
        }

        .history-table thead {
            background: rgba(255, 255, 255, 0.02);
        }

        .history-table th {
            padding: 1rem;
            text-align: left;
            font-weight: 600;
            color: #94a3b8;
            font-size: 0.875rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.06);
            vertical-align: middle;
        }

        .history-table tbody tr {
            border-bottom: 1px solid rgba(255, 255, 255, 0.04);
            transition: all 0.2s ease;
        }

        .history-table tbody tr:hover {
            background: rgba(255, 255, 255, 0.02);
        }

        .history-table td {
            padding: 1rem;
            color: #E2E8F0;
            font-size: 0.9375rem;
            vertical-align: middle;
        }

        .empty-state {
            padding: 4rem 2rem !important;
        }

        .empty-content {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
        }

        .empty-icon {
            width: 64px;
            height: 64px;
            background: rgba(139, 92, 246, 0.1);
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1rem;
        }

        .empty-icon i {
            font-size: 2rem;
            color: #8b5cf6;
        }

        .empty-title {
            font-size: 1rem;
            font-weight: 600;
            color: #e2e8f0;
            margin: 0 0 0.5rem 0;
        }

        .empty-text {
            font-size: 0.875rem;
            color: #94a3b8;
            margin: 0;
        }

        /* Notification System */
        .notification-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            display: flex;
            flex-direction: column;
            gap: 12px;
            max-width: 420px;
        }

        .notification-toast {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            border-radius: 16px;
            padding: 1.25rem 1.5rem;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.6), 0 0 0 1px rgba(255, 255, 255, 0.08);
            display: flex;
            align-items: center;
            gap: 1rem;
            animation: slideInRight 0.4s cubic-bezier(0.16, 1, 0.3, 1);
            border-left: 4px solid;
            backdrop-filter: blur(10px);
            min-width: 350px;
        }

        .notification-toast.hiding {
            animation: slideOutRight 0.3s ease-out forwards;
        }

        .notification-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .notification-icon i {
            font-size: 1.5rem;
            color: white;
        }

        .notification-content {
            flex: 1;
        }

        .notification-title {
            font-weight: 700;
            font-size: 1rem;
            margin: 0 0 0.25rem 0;
            color: #f8fafc;
        }

        .notification-message {
            font-size: 0.9rem;
            margin: 0;
            color: #cbd5e1;
        }

        .notification-close {
            background: rgba(255, 255, 255, 0.08);
            border: none;
            width: 32px;
            height: 32px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.2s ease;
            flex-shrink: 0;
            color: #94a3b8;
        }

        .notification-close:hover {
            background: rgba(255, 255, 255, 0.15);
            color: #f8fafc;
        }

        /* Success */
        .notification-toast.success {
            border-left-color: #10b981;
        }

        .notification-toast.success .notification-icon {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        }

        /* Error */
        .notification-toast.error {
            border-left-color: #ef4444;
        }

        .notification-toast.error .notification-icon {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        }

        /* Warning */
        .notification-toast.warning {
            border-left-color: #f59e0b;
        }

        .notification-toast.warning .notification-icon {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        }

        /* Info */
        .notification-toast.info {
            border-left-color: #3b82f6;
        }

        .notification-toast.info .notification-icon {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        }

        /* Animations */
        @keyframes slideInRight {
            from {
                transform: translateX(400px);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        @keyframes slideOutRight {
            from {
                transform: translateX(0);
                opacity: 1;
            }
            to {
                transform: translateX(400px);
                opacity: 0;
            }
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .animate-spin {
            animation: spin 1s linear infinite;
        }

        /* Responsive */
        @media (max-width: 991px) {
            .form-grid {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .main-card,
            .history-section {
                padding: 1.5rem;
            }

            .notification-container {
                left: 10px;
                right: 10px;
                max-width: none;
            }

            .notification-toast {
                min-width: auto;
            }
        }
    </style>

    <script>
    function pasteFromClipboard(fieldId) {
        const field = document.getElementById(fieldId);
        if (!field) return;
        
        if (navigator.clipboard && navigator.clipboard.readText) {
            navigator.clipboard.readText()
                .then(function(text) {
                    field.value = text;
                    field.focus();
                })
                .catch(function() {
                    // Không làm gì
                });
        }
    }

    function showNotification(type, message, title) {
        const container = document.getElementById('notification-container');
        if (!container) return;

        const icons = {
            success: 'ri-checkbox-circle-fill',
            error: 'ri-close-circle-fill',
            warning: 'ri-error-warning-fill',
            info: 'ri-information-fill'
        };

        const titles = {
            success: title || 'Thành công!',
            error: title || 'Lỗi!',
            warning: title || 'Cảnh báo!',
            info: title || 'Thông tin'
        };

        const toast = document.createElement('div');
        toast.className = `notification-toast ${type}`;
        toast.innerHTML = `
            <div class="notification-icon">
                <i class="${icons[type]}"></i>
            </div>
            <div class="notification-content">
                <div class="notification-title">${titles[type]}</div>
                <div class="notification-message">${message}</div>
            </div>
            <button class="notification-close" onclick="this.parentElement.remove()">
                <i class="ri-close-line"></i>
            </button>
        `;

        container.appendChild(toast);

        setTimeout(() => {
            toast.classList.add('hiding');
            setTimeout(() => toast.remove(), 300);
        }, 5000);
    }

    <?php if ($notification): ?>
    document.addEventListener('DOMContentLoaded', function() {
        showNotification('<?php echo $notification['type']; ?>', '<?php echo addslashes($notification['message']); ?>');
    });
    <?php endif; ?>
    </script>

    <?php require_once($_SERVER['DOCUMENT_ROOT'] . '/include/foot.php'); ?>