<?php 
$options_header = ['title' => 'Kiểm Tra Chủ Tài Khoản']; 
require($_SERVER['DOCUMENT_ROOT'].'/include/head.php'); 
require($_SERVER['DOCUMENT_ROOT'].'/include/nav.php'); 
?>
<?php if(!$isLogin->check()){die('<meta http-equiv="refresh"content="0; url=/oauth/dang-nhap?redirect='.urlencode($actual_link).'">');}?>
<main>
    <div class="mx-auto w-full max-w-6xl-none pb-4">
        <div class="mb-8 flex flex-col justify-between md:flex-row md:items-center">
            <div class="ltablet:max-w-full flex max-w-[425px] flex-col items-center gap-4 text-center md:flex-row md:text-left lg:max-w-full">
                <div class="nui-avatar nui-avatar-lg nui-avatar-rounded-full">
                    <div class="nui-avatar-inner">
                        <img src="/<?=__IMG__?>/icon/front-pages/badgesroll.gif" class="nui-avatar-img nui-avatar-rounded-full">
                    </div>
                </div>
                <div>
                    <h2 class="nui-heading nui-heading-xl nui-weight-light nui-lead-tight text-muted-800 dark:text-white">
                        <span class="font-bold">Tra Cứu STK Ngân Hàng</span>
                    </h2>
                    <p class="nui-paragraph nui-paragraph-md nui-weight-normal nui-lead-normal">
                        <span class="text-muted-500"> Kiểm Tra Tên Chủ Tài Khoản Ngân Hàng Qua STK</span>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <div class="md:flex items-center justify-center thanhdieu-refresh">
        <!-- Form tra cứu -->
        <div class="rounded-2xl shadow-md p-6 w-full max-w-lg" 
             style="background-color:#1e293b;" 
             data-dark-bg="#7b53dc">
            <form id="lookupForm" class="hk-check-stk flex flex-col gap-7">
                <h1 class="text-white-700 text-center text-base">🔎 Check Thông Tin Tài Khoản Ngân Hàng</h1>
                <div>
                    <label for="account" class="block text-sm font-medium text-white-700 dark:text-white-300">
                        Nhập Số Tài Khoản
                    </label>
                    <input type="text" id="account" name="account" 
                           style="border:1px solid #343360; background-color:#374151; color:#f1f5f9;"
                           class="mt-1 block w-full rounded-xl px-3 py-2 text-sm shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" 
                           placeholder="VD: 780380" required>
                </div>
                <div>
                    <label for="bank" class="block text-sm font-medium text-white-700 dark:text-white-300">
                        Chọn Ngân Hàng
                    </label>
                    <select id="bank" name="bank" 
                            style="border:1px solid #343360; background-color:#374151; color:#f1f5f9;"
                            class="mt-1 block w-full rounded-xl px-3 py-2 text-sm shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                        <option value="">-- Chọn ngân hàng --</option>
                        <option value="VCB">Vietcombank - Ngân hàng TMCP Ngoại Thương Việt Nam</option>
                        <option value="ACB">ACB - Ngân hàng TMCP Á Châu</option>
                        <option value="TCB">Techcombank - Ngân hàng TMCP Kỹ thương Việt Nam</option>
                        <option value="MB">MBBank - Ngân hàng TMCP Quân đội</option>
                        <option value="ABB">ABB - Ngân hàng TMCP An Bình</option>
                        <option value="BAB">BAB - Ngân hàng TMCP Bắc Á</option>
                        <option value="BIDV">BIDV - Ngân hàng TMCP Đầu tư và Phát triển Việt Nam</option>
                        <option value="BVB">BVB - Ngân hàng TMCP Bảo Việt</option>
                        <option value="CAKE">CAKE - TMCP Việt Nam Thịnh Vượng - Ngân hàng số CAKE by VPBank</option>
                        <option value="CBB">CBB - Ngân hàng Thương mại TNHH MTV Xây dựng Việt Nam</option>
                        <option value="CIMB">CIMB - Ngân hàng TNHH MTV CIMB Việt Nam</option>
                        <option value="COOPB">COOPB - Ngân hàng Hợp tác xã Việt Nam</option>
                        <option value="DAB">VikkiBank - Ngân hàng TNHH MTV Số Vikki</option>
                        <option value="DBS">DBS - DBS Bank Ltd - Chi nhánh Thành phố Hồ Chí Minh</option>
                        <option value="EIB">Eximbank - Ngân hàng TMCP Xuất Nhập khẩu Việt Nam</option>
                        <option value="GPB">GPBank - Ngân hàng Thương mại TNHH MTV Dầu Khí Toàn Cầu</option>
                        <option value="HDB">HDBank - Ngân hàng TMCP Phát triển Thành phố Hồ Chí Minh</option>
                        <option value="HLB">HLB - Ngân hàng TNHH MTV Hong Leong Việt Nam</option>
                        <option value="HSBC">HSBC - Ngân hàng TNHH MTV HSBC</option>
                        <option value="IBKHCM">Ngân hàng Công nghiệp Hàn Quốc - Chi nhánh TP. Hồ Chí Minh</option>
                        <option value="IBKHN">Ngân hàng Công nghiệp Hàn Quốc - Chi nhánh Hà Nội</option>
                        <option value="IVB">IVB - Ngân hàng TNHH Indovina</option>
                        <option value="KLB">KienLong Bank - Ngân hàng TMCP Kiên Long</option>
                        <option value="LIO">LioBank - Ngân hàng số Liobank</option>
                        <option value="LPB">LPBank - Ngân hàng TMCP Lộc Phát Việt Nam</option>
                        <option value="MBV">Oceanbank - Ngân hàng TNHH MTV Việt Nam Hiện Đại</option>
                        <option value="MSB">MSB - Ngân hàng TMCP Hàng Hải</option>
                        <option value="NAB">NamABank - Ngân hàng TMCP Nam Á</option>
                        <option value="NCB">NCB - Ngân hàng TMCP Quốc Dân</option>
                        <option value="OCB">OCB - Ngân hàng TMCP Phương Đông</option>
                        <option value="PBVN">PBVN - Ngân hàng TNHH MTV Public Việt Nam</option>
                        <option value="PGB">PGB - Ngân hàng TMCP Xăng dầu Petrolimex</option>
                        <option value="PVCB">PVCB - Ngân hàng TMCP Đại Chúng Việt Nam</option>
                        <option value="SCB">Sacombank - Ngân hàng TMCP Sài Gòn Thương Tín</option>
                        <option value="SEAB">SEABank - Ngân hàng TMCP Đông Nam Á</option>
                        <option value="SGB">SaigonBank - Ngân hàng TMCP Sài Gòn Công Thương</option>
                        <option value="SGCB">SCB - Ngân hàng TMCP Sài Gòn</option>
                        <option value="SHB">SHB - Ngân hàng TMCP Sài Gòn - Hà Nội</option>
                        <option value="TIMO">TIMO - Ngân hàng số Timo</option>
                        <option value="TPB">TPB - Ngân hàng TMCP Tiên Phong</option>
                        <option value="VAB">VAB - Ngân hàng TMCP Việt Á</option>
                        <option value="VARB">Agribank - Ngân hàng Nông nghiệp và Phát triển Nông thôn Việt Nam</option>
                        <option value="VB">VietBank - Ngân hàng TMCP Việt Nam Thương Tín"</option>
                        <option value="VCCB">VCCB - Ngân hàng TMCP Bản Việt</option>
                        <option value="VTB">VietinBank - Ngân hàng TMCP Công thương Việt Nam</option>
                        <option value="VIB">VIB - Ngân hàng TMCP Quốc tế Việt Nam</option>
                        <option value="VPB">VPB - Ngân hàng TMCP Việt Nam Thịnh Vượng</option>
                        <option value="WOO">Woori - Ngân hàng TNHH MTV Woori Việt Nam</option>
                    </select>
                </div>
                <input type="hidden" name="action" value="check-stk">
                <button type="submit"
                                    class="nui-button nui-button-md nui-button-rounded-md nui-button-solid nui-button-primary w-full ">
                                    <i class="ri-check-line me-2"></i>Thuê Ngay (5,000đ)
                                </button>
            </form>

            <!-- Kết quả tra cứu -->
            <div id="lookupResult" class="mt-4 hidden">
                <div class="p-4 rounded-xl" style="background-color:#374151;">
                    <p class="text-sm text-white-600 mb-2">Kết quả:</p>
                    <div class="space-y-1 text-gray-800">
                        <p><span class="font-semibold" style="color: white">Ngân hàng:</span> <span style="color: red" id="resultBank"></span></p>
                        <p><span class="font-semibold" style="color: white">Số tài khoản:</span> <span style="color: red" id="resultAccount"></span></p>
                        <p><span class="font-semibold" style="color: white">Chủ tài khoản:</span> <span style="color: red" id="resultOwner"></span></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
document.getElementById("lookupForm").addEventListener("submit", function(e) {
    e.preventDefault();

    const account = document.getElementById("account").value.trim();
    const bank    = document.getElementById("bank").value;
    const resultBox = document.getElementById("lookupResult");

    const resultBank    = document.getElementById("resultBank");
    const resultAccount = document.getElementById("resultAccount");
    const resultOwner   = document.getElementById("resultOwner");

    if (!account || !bank) {
        alert("Vui lòng nhập đầy đủ số tài khoản và chọn ngân hàng!");
        return;
    }

    fetch("../api-check-stk.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify({
            bank: bank,
            account: account
        })
    })
    .then(res => res.json())
    .then(data => {
        console.log(data);

        // Chờ 7 giây rồi mới hiển thị kết quả
        setTimeout(() => {
            if (data.success && data.code === 200 && data.data) {
                resultBank.textContent    = data.data.bank;
                resultAccount.textContent = data.data.account;
                resultOwner.textContent   = data.data.ownerName;
            } else {
                resultBank.textContent    = "-";
                resultAccount.textContent = "-";
                resultOwner.textContent   = data.msg || "Không tìm thấy thông tin!";
            }
            resultBox.classList.remove("hidden"); // chỉ hiện khung sau 7s
        }, 8000);
    })
    .catch(err => {
        setTimeout(() => {
            resultBank.textContent    = "-";
            resultAccount.textContent = "-";
            resultOwner.textContent   = "Có lỗi khi gọi API!";
            resultBox.classList.remove("hidden");
        }, 8000);
        console.error("API error:", err);
    });
});
</script>


<?php require($_SERVER['DOCUMENT_ROOT'].'/include/foot.php'); ?>
