<?php
/**
 * @author Vương Thanh Diệu
 */
require_once __DIR__.'/Controller.php';
header('Content-Type: application/json');

class UserListController extends BaseController
{    
    public function getUsers()
    {
        $offset = ($this->page - 1) * $this->limit;
        $where = $this->buildWhere('users', ['username', 'user_id']);
        if (empty($where)) 
        {
            $where = "1=1";
        }
        $lavender = "SELECT 
            user_id,
            username,
            email,
            avatar,
            rank,
            banned,
            oauth_type,
            ngaythamgia,
            IFNULL(sodu, 0) as sodu,
            IFNULL(tongnap, 0) as tongnap,
            IFNULL(tongtieu, 0) as tongtieu,
            IFNULL(hoahong, 0) as hoahong
        FROM users 
        WHERE {$where}
        ORDER BY user_id DESC
        LIMIT ?, ?";

        $result = $this->execute_prepared_query($lavender, "ii", $offset, $this->limit);
        if (!$result) 
        {
            $this->res('error', 'Failed to retrieve users.');
            return;
        }
        $count_query = "SELECT COUNT(*) as total FROM users WHERE {$where}";
        $total_result = $this->execute_prepared_query($count_query);
        if (!$total_result) 
        {
            $this->res('error', 'Failed to count users.');
            return;
        }
        $total_row = $total_result->fetch_assoc();
        mysqli_free_result($total_result);

        $users = [];
        $usernames = [];

        while ($row = $result->fetch_assoc()) 
        {
            if ($row['tongnap'] > 0) {
                $row['tongnap'] = FormatNumber::TD($row['tongnap']);
            }
            if ($row['tongtieu'] > 0) {
                $row['tongtieu'] = FormatNumber::TD($row['tongtieu']);
            }
            if ($row['hoahong'] > 0) {
                $row['hoahong'] = FormatNumber::TD($row['hoahong']);
            }
            if ($row['ngaythamgia'] > 0) {
                $row['ngaythamgia'] = FormatTime::TD($row['ngaythamgia'],1);
            }
            if (empty($row['avatar']) || valid_url($row['avatar'])) 
            {
                $row['avatar'] = '#a103fc';
            }
            $row['plans'] = null;
            
            $usernames[] = $row['username'];
            $users[$row['username']] = $row;
        }
        mysqli_free_result($result);
        if (!empty($usernames)) 
        {
            $placeholders = str_repeat('?,', count($usernames) - 1) . '?';
            $types = str_repeat('s', count($usernames));
            $plans_query = "SELECT taikhoan, tengoi 
                           FROM ws_plans 
                           WHERE taikhoan IN ($placeholders)";
            $plans_result = $this->execute_prepared_query($plans_query, $types, ...$usernames);
            if ($plans_result) {
                while ($row = $plans_result->fetch_assoc()) 
                {
                    if (isset($users[$row['taikhoan']])) 
                    {
                        $users[$row['taikhoan']]['plans'] = $row['tengoi'] ?: null;
                    }
                }
                mysqli_free_result($plans_result);
            }
        }
        foreach ($users as &$user) {
            if (!isset($user['plans']) || empty($user['plans'])) 
            {
                $user['plans'] = null;
            }
        }
        $this->res('success', 'Thành công', 
        [
            'users' => array_values($users),
            'pagination' => [
                'total_users' => (int) $total_row['total'],
                'total_pages' => ceil($total_row['total'] / $this->limit),
                'per_page' => $this->limit,
                'current_page' => $this->page,
            ],
        ]);
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'GET') 
{
    $controller = new UserListController();
    $controller->getUsers();
} else {
    die(JSON_FORMATTER([
        'status' => 'error',
        'msg' => 'Method not allowed',
    ]));
} 