<?php
/**
 * @author Vương Thanh Diệu
 */
require_once __DIR__.'/Controller.php';
header('Content-Type: application/json');
class PlanListController extends BaseController
{
    public function getPlans()
    {
        $offset = ($this->page - 1) * $this->limit;
        $lavender = "SELECT p.plans_id, 
            p.taikhoan,
            p.tengoi,
            p.giatien,
            p.ngaymua,
            p.ngayhethan,
            p.trangthai,
            u.avatar
        FROM (
            SELECT plans_id, taikhoan, tengoi, giatien, ngaymua, ngayhethan, trangthai
            FROM ws_plans
            WHERE ".$this->buildWhere('ws_plans', ['taikhoan', 'tengoi'])."
            ORDER BY ngaymua DESC
            LIMIT ?, ?
        ) AS p
        LEFT JOIN users u ON p.taikhoan = u.username";
        $result = $this->execute_prepared_query($lavender, "ii", $offset, $this->limit);
        if (!$result) 
        {
            $this->res('error', 'Failed to retrieve plans.');
        }
        $count_query = "SELECT COUNT(*) as total FROM ws_plans WHERE ".$this->buildWhere('ws_plans', ['taikhoan', 'tengoi']);
        $total_result = $this->execute_prepared_query($count_query);
        if (!$total_result) 
        {
            $this->res('error', 'Failed to count plans.');
        }
        $total_row = $total_result->fetch_assoc();
        $plans = [];
        while ($row = $result->fetch_assoc()) 
        {
            if (empty($row['avatar']) || valid_url($row['avatar'])) 
            {
                $row['avatar'] = '#ffe81c';
            }
            $plans[] = 
            [
                'plans_id' => $row['plans_id'],
                'username' => THANHDIEU($row['taikhoan']),
                'tengoi' => strtoupper($row['tengoi']),
                'giatien' => FormatNumber::TD($row['giatien'], 2),
                'ngaymua' => FormatTime::TD($row['ngaymua'], 1),
                'ngayhethan' => FormatTime::TD($row['ngayhethan'], 1),
                'trangthai' => $row['trangthai'],
                'avatar' => $row['avatar'],
            ];
        }
        mysqli_free_result($result);
        mysqli_free_result($total_result);
        $this->res('success', 'Thành công', 
        [
            'plans' => $plans,
            'pagination' => [
                'total_plans' => (int) $total_row['total'],
                'total_pages' => ceil($total_row['total'] / $this->limit),
                'per_page' => $this->limit,
                'current_page' => $this->page,
            ],
        ]);
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'GET') 
{
    $controller = new PlanListController();
    $controller->getPlans();
} else {
    die(JSON_FORMATTER([
        'status' => 'error',
        'msg' => 'Method not allowed',
    ]));
} 