<?php
/**
 * @author Vương Thanh Diệu
 */
require_once __DIR__.'/Controller.php';
header('Content-Type: application/json');
class LogListController extends BaseController
{    
    public function getLogs()
    {
        $offset = ($this->page - 1) * $this->limit;
        $lavender = "SELECT l.log_id, 
            l.username,
            l.content,
            l.time,
            l.action,
            u.avatar
        FROM (
            SELECT log_id, username, content, time, action
            FROM ws_logs
            WHERE ".$this->buildWhere('ws_logs', ['username', 'content', 'action'])."
            ORDER BY log_id DESC
            LIMIT ?, ?
        ) AS l
        LEFT JOIN users u ON l.username = u.username";
        $result = $this->execute_prepared_query($lavender, "ii", $offset, $this->limit);
        if (!$result) 
        {
            $this->res('error', 'Failed to retrieve logs.');
        }
        $count_query = "SELECT COUNT(*) as total FROM ws_logs WHERE ".$this->buildWhere('ws_logs', ['username', 'content', 'action']);
        $total_result = $this->execute_prepared_query($count_query);
        if (!$total_result) 
        {
            $this->res('error', 'Failed to count logs.');
        }
        $total_row = $total_result->fetch_assoc();
        $logs = [];
        while ($row = $result->fetch_assoc()) 
        {
            if (empty($row['avatar']) || valid_url($row['avatar'])) 
            {
                $row['avatar'] = '#ffe81c';
            }
            
            $logs[] = 
            [
                'log_id' => $row['log_id'],
                'username' => THANHDIEU($row['username']),
                'content' => THANHDIEU($row['content']),
                'time' => FormatTime::TD($row['time'], 1),
                'action' => $row['action'],
                'avatar' => $row['avatar'],
            ];
        }
        mysqli_free_result($result);
        mysqli_free_result($total_result);
        $this->res('success', 'Thành công', 
        [
            'logs' => $logs,
            'pagination' => [
                'total_logs' => (int) $total_row['total'],
                'total_pages' => ceil($total_row['total'] / $this->limit),
                'per_page' => $this->limit,
                'current_page' => $this->page,
            ],
        ]);
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'GET') 
{
    $controller = new LogListController();
    $controller->getLogs();
} else {
    die(JSON_FORMATTER([
        'status' => 'error',
        'msg' => 'Method not allowed',
    ]));
} 