<?php
/**
 * @author Vương Thanh Diệu
 */
require_once __DIR__.'/Controller.php';
header('Content-Type: application/json');
class DeviceListController extends BaseController
{
    public function getDevices()
    {
        $offset = ($this->page - 1) * $this->limit;
        $lavender = "SELECT d.username,
            d.ua,
            d.os,
            d.ip,
            d.browser,
            d.created_at,
            d.updated_at,
            u.avatar
        FROM (
            SELECT username, ua, os, ip, browser, created_at, updated_at
            FROM ws_devices
            WHERE ".$this->buildWhere('ws_devices', ['username', 'os', 'browser', 'ip'])."
            ORDER BY username DESC
            LIMIT ?, ?
        ) AS d
        LEFT JOIN users u ON d.username = u.username";
        $result = $this->execute_prepared_query($lavender, "ii", $offset, $this->limit);
        if (!$result) 
        {
            $this->res('error', 'Failed to retrieve device list.');
        }
        $count_query = "SELECT COUNT(*) as total FROM ws_devices WHERE ".$this->buildWhere('ws_devices', ['username', 'os', 'browser', 'ip']);
        $total_result = $this->execute_prepared_query($count_query);
        if (!$total_result) 
        {
            $this->res('error', 'Failed to count devices.');
        }
        $total_row = $total_result->fetch_assoc();
        $devices = [];
        while ($row = $result->fetch_assoc()) 
        {
            if (empty($row['avatar']) || valid_url($row['avatar'])) 
            {
                $row['avatar'] = '#6576ff';
            }            
            $devices[] = 
            [
                'username' => THANHDIEU($row['username']),
                'ua' => $row['ua'],
                'os' => $row['os'],
                'ip' => $row['ip'],
                'browser' => $row['browser'],
                'created_at' => FormatTime::TD($row['created_at'],1), 
                'updated_at' => FormatTime::TD($row['updated_at'],1), 
                'avatar' => $row['avatar'],
            ];
        }
        mysqli_free_result($result);
        mysqli_free_result($total_result);
        $this->res('success', 'Thành công', 
        [
            'devices' => $devices,
            'pagination' => 
            [
                'total_devices' => (int) $total_row['total'],
                'total_pages' => ceil($total_row['total'] / $this->limit),
                'per_page' => $this->limit,
                'current_page' => $this->page,
            ],
        ]);
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') 
{
    $controller = new DeviceListController();
    $controller->getDevices();
} 
else 
{
    die(JSON_FORMATTER([
        'status' => 'error',
        'msg' => 'Method not allowed',
    ]));
} 