<?php
/**
 * @author Vương Thanh Diệu
 */
require_once __DIR__.'/Controller.php';
header('Content-Type: application/json');
class DeleteDeviceController extends BaseController
{
    public function deleteDevice()
    {
        $username = isset($_POST['username']) ? $_POST['username'] : '';
        
        if (empty($username)) {
            $this->res('error', 'Username is required');
        }
        
        // First check if the device exists
        $check_query = "SELECT username FROM ws_devices WHERE username = ?";
        $check_result = $this->execute_prepared_query($check_query, "s", $username);
        
        if (!$check_result || $check_result->num_rows == 0) {
            $this->res('error', 'Device not found for this user');
        }
        
        // Delete the device
        $delete_query = "DELETE FROM ws_devices WHERE username = ?";
        $delete_result = $this->execute_prepared_query($delete_query, "s", $username);
        
        if (!$delete_result) {
            $this->res('error', 'Failed to delete device');
        }
        
        // Log the action
        $current_time = date('Y-m-d H:i:s');
        $log_query = "INSERT INTO ws_logs (username, content, time, action) VALUES (?, ?, ?, ?)";
        $content = "Admin {$this->user['username']} đã xoá thiết bị đăng nhập của người dùng {$username}";
        $action = "Xoá Thiết Bị";
        $this->execute_prepared_query($log_query, "ssss", $username, $content, $current_time, $action);
        
        $this->res('success', 'Xoá thiết bị thành công');
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'deleteDevice') 
{
    $controller = new DeleteDeviceController();
    $controller->deleteDevice();
} 
else 
{
    die(JSON_FORMATTER([
        'status' => 'error',
        'msg' => 'Method not allowed',
    ]));
} 