<?php
/**
 * @author Vương Thanh Diệu
 */
require_once __DIR__.'/Controller.php';
header('Content-Type: application/json');
class BillListController extends BaseController
{    
    public function getBills()
    {
        $offset = ($this->page - 1) * $this->limit;
        $lavender="SELECT b.fakebill_id, 
            b.username,
            b.namebill,
            b.time,
            b.image,
            b.type,
            u.avatar
        FROM (
            SELECT fakebill_id, username, namebill, time, image, type
            FROM ws_history_fakebill
            WHERE ".$this->buildWhere('ws_history_fakebill', ['username', 'namebill'])."
            ORDER BY time DESC
            LIMIT ?, ?
        ) AS b
        LEFT JOIN users u ON b.username = u.username";
        $result = $this->execute_prepared_query($lavender, "ii", $offset, $this->limit);
        if (!$result) 
        {
            $this->res('error', 'Failed to retrieve bills.');
        }
        $count_query = "SELECT COUNT(*) as total FROM ws_history_fakebill WHERE ".$this->buildWhere('ws_history_fakebill', ['username', 'namebill']);
        $total_result = $this->execute_prepared_query($count_query);
        if (!$total_result) 
        {
            $this->res('error', 'Failed to count bills.');
        }
        $total_row = $total_result->fetch_assoc();
        $bills = [];
        while ($row = $result->fetch_assoc()) 
        {
            if (empty($row['avatar']) || valid_url($row['avatar'])) 
            {
                $row['avatar'] = '#ffe81c';
            }
            $bills[] = 
            [
                'fakebill_id' => $row['fakebill_id'],
                'username' => THANHDIEU($row['username']),
                'namebill' => THANHDIEU($row['namebill']),
                'time' => FormatTime::TD($row['time'],1),
                'image' => $row['image'],
                'type' => $row['type'],
                'avatar' => $row['avatar']
            ];
        }
        mysqli_free_result($result);
        mysqli_free_result($total_result);
        $this->res('success', 'Thành công', 
        [
            'bills' => $bills,
            'pagination' => 
            [
                'total_bills' => (int) $total_row['total'],
                'total_pages' => ceil($total_row['total'] / $this->limit),
                'per_page' => $this->limit,
                'current_page' => $this->page,
            ],
        ]);
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'GET') 
{
    $controller = new BillListController();
    $controller->getBills();
} else {
    die(JSON_FORMATTER([
        'status' => 'error',
        'msg' => 'Method not allowed',
    ]));
} 