<?php
/**
 * @author Vương Thanh Diệu
 */
require_once __DIR__.'/Controller.php';
header('Content-Type: application/json');
class BankListController extends BaseController
{
    public function getBank()
    {
        $offset = ($this->page - 1) * $this->limit;
        $lavender = "SELECT b.magiaodich, 
            b.username,
            b.loai,
            b.sotien,
            b.noidung,
            b.thoigian,
            b.trangthai,
            u.avatar
        FROM (
            SELECT magiaodich, username, loai, sotien, noidung, thoigian, trangthai
            FROM ws_history_bank
            WHERE ".$this->buildWhere('ws_history_bank', ['magiaodich', 'username', 'loai', 'noidung'])."
            ORDER BY thoigian DESC
            LIMIT ?, ?
        ) AS b
        LEFT JOIN users u ON b.username = u.username";
        $result = $this->execute_prepared_query($lavender, "ii", $offset, $this->limit);
        if (!$result) 
        {
            $this->res('error', 'Failed to retrieve bank history.');
        }
        $count_query = "SELECT COUNT(*) as total FROM ws_history_bank WHERE ".$this->buildWhere('ws_history_bank', ['magiaodich', 'username', 'loai', 'noidung']);
        $total_result = $this->execute_prepared_query($count_query);
        if (!$total_result) 
        {
            $this->res('error', 'Failed to count bank history.');
        }
        $total_row = $total_result->fetch_assoc();
        $banks = [];
        while ($row = $result->fetch_assoc()) 
        {
            if (empty($row['avatar']) || valid_url($row['avatar'])) 
            {
                $row['avatar'] = '#ffe81c';
            }
            $banks[] = 
            [
                'magiaodich' => $row['magiaodich'],
                'username' => THANHDIEU($row['username']),
                'loai' => THANHDIEU($row['loai']),
                'sotien' => FormatNumber::TD($row['sotien']),
                'noidung' => THANHDIEU($row['noidung']),
                'thoigian' => FormatTime::TD($row['thoigian'],1),
                'trangthai' => $row['trangthai'],
                'avatar' => $row['avatar'],
            ];
        }
        mysqli_free_result($result);
        mysqli_free_result($total_result);
        $this->res('success', 'Thành công', 
        [
            'banks' => $banks,
            'pagination' => 
            [
                'total_banks' => (int) $total_row['total'],
                'total_pages' => ceil($total_row['total'] / $this->limit),
                'per_page' => $this->limit,
                'current_page' => $this->page,
            ],
        ]);
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'GET') 
{
    $controller = new BankListController();
    $controller->getBank();
} else {
    die(JSON_FORMATTER([
        'status' => 'error',
        'msg' => 'Method not allowed',
    ]));
} 