<?php
/**
 * @author Vương Thanh Diệu
 */
require_once $_SERVER['DOCUMENT_ROOT'].'/config/database.php';
class BaseController extends DatabaseConnection
{
    protected $user;
    protected $page;
    protected $limit;
    protected $search;
    public function __construct()
    {
        if (!isset($GLOBALS['user']['rank']) || $GLOBALS['user']['rank'] !== 'admin') 
        {
            $this->res('error', 'Unauthorized access denied.');
        }
        $this->user = $GLOBALS['user'];
        $this->page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $requested_limit = isset($_GET['limit']) ? (int) $_GET['limit'] : 10;
        $this->limit = min(max($requested_limit, 1), 50);
        $this->search = isset($_GET['search']) ? $_GET['search'] : '';
    }
    public function res($status, $msg = '', $data = null)
    {
        die(JSON_FORMATTER([
            'status' => $status,
            'msg' => $msg,
            'data' => $data ? $data : -1,
        ]));
    }
    protected function buildWhere($table, $fields)
    {
        if (empty($this->search)) 
        {
            return "1=1";
        }
        $conditions = [];
        foreach ($fields as $field) 
        {
            $escaped = mysqli_real_escape_string(self::ThanhDieuDB(), $this->search);
            $conditions[] = "$table.$field LIKE '%{$escaped}%'";
        }
        return "(".implode(" OR ", $conditions).")";
    }
    protected function checkConnection()
    {
        if (!mysqli_ping(self::ThanhDieuDB())) 
        {
            self::ThanhDieuDB();
        }
    }
    protected function execute_prepared_query($query, $types = null, ...$params)
    {
        $this->checkConnection();
        $vtd = mysqli_prepare(self::ThanhDieuDB(), $query);
        
        if (!$vtd) 
        {
            return false;
        }

        if ($types && !empty($params)) 
        {
            mysqli_stmt_bind_param($vtd, $types, ...$params);
        }

        if (!mysqli_stmt_execute($vtd)) 
        {
            mysqli_stmt_close($vtd);
            return false;
        }

        $result = mysqli_stmt_get_result($vtd);
        mysqli_stmt_close($vtd);
        
        return $result;
    }
} 