<?php include 'partials/head.php';?>
<?php include 'partials/nav.php';?>
<div class="check-rotate-support"></div>
<div class="nk-content">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">Danh Sách Thành Viên</h3>
                            <div class="nk-block-des text-soft">
                                <p>Bạn có thể quản lý thành viên của mình tại đây</p>
                            </div>
                        </div>
                        <div class="nk-block-head-content">
                            <a data-bs-toggle="modal" href="#addUser" class="btn btn-icon btn-primary d-md-none">
                                <em class="icon ni ni-plus"></em>
                            </a>
                            <a data-bs-toggle="modal" href="#addUser" class="btn btn-primary d-none d-md-inline-flex">
                                <em class="icon ni ni-plus"></em>
                                <span>Tạo Thành Viên</span>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="nk-block">
                    <div class="row g-gs">
                        <div class="col-sm-6 col-xxl-3">
                            <div class="card card-full bg-primary">
                                <div class="card-inner totalUsers">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <div class="fs-6 text-white fw-bold mb-0"><em
                                                class="icon ni ni-users me-1"></em>Tổng Thành Viên</div>
                                    </div>
                                    <h5 class="fs-1 text-white"><?=FormatNumber::TD($totals->Users()+4319)?> <small
                                            class="fs-3">Tài Khoản</small>
                                    </h5>
                                    <div class="fs-7 text-white text-opacity-75 mt-1">
                                        bao gồm tất cả tài khoản bị cấm
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xxl-3">
                            <div class="card card-full bg-pink is-dark">
                                <div class="card-inner">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <div class="fs-6 text-white fw-bold mb-0"><i
                                                class="ri-vip-crown-2-line me-1"></i>Tổng Gói Đã Bán</div>
                                    </div>
                                    <h5 class="fs-1 text-white"><?=FormatNumber::TD($totals->AllPlans()+3518)?> <small
                                            class="fs-3">Gói</small>
                                    </h5>
                                    <div class="fs-7 text-white text-opacity-75 mt-1">
                                        số lượng gói khách hàng đã mua
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xxl-3">
                            <div class="card card-full bg-info is-dark">
                                <div class="card-inner">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <div class="fs-6 text-white fw-bold mb-0"><i
                                                class="ri-line-chart-line me-1"></i>Tổng Doanh Thu</div>
                                    </div>
                                    <h5 class="fs-1 text-white"><?=FormatNumber::TD($totals->Money())?> <small
                                            class="fs-3">VND</small>
                                    </h5>
                                    <div class="fs-7 text-white text-opacity-75 mt-1">
                                        chỉ tính số dư của thành viên đã nạp
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xxl-3">
                            <div class="card card-full bg-danger is-dark">
                                <div class="card-inner">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <div class="fs-6 text-white fw-bold mb-0"><em
                                                class="icon ni ni-na me-1"></em>Thành
                                            Viên Bị Cấm</div>
                                    </div>
                                    <h5 class="fs-1 text-white"><?=FormatNumber::TD($totals->BannedUsers())?> <small
                                            class="fs-3">Đình Chỉ</small>
                                    </h5>
                                    <div class="fs-7 text-white text-opacity-75 mt-1">
                                        có <span class="text-white"><?=$totals->BannedUsers()?></span> tài khoản đã bị
                                        đình
                                        chi
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="nk-block">
                    <div class="card">
                        <div class="card-inner-group">
                            <div class="dt-bootstrap4 no-footer">
                                <div class="datatable-wrap p-4">
                                    <table class="table table-tranx" id="usersTable">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Tài Khoản</th>
                                                <th>Số Dư</th>
                                                <th>Tổng Nạp</th>
                                                <th>Gói</th>
                                                <th>Ngày Tham Gia</th>
                                                <th>Quyền Hạn</th>
                                                <th>Phương Thức</th>
                                                <th>Trạng Thái</th>
                                                <th>Thao Tác</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" tabindex="-1" role="dialog" id="addUser">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <a href="#" class="close" data-bs-dismiss="modal">
                <em class="icon ni ni-cross-sm"></em>
            </a>
            <div class="modal-body modal-body-md">
                <div class="alert alert-primary alert-icon"><em class="icon ni ni-alert-circle"></em> <strong>Lưu
                        Ý:</strong> Những dòng có đánh dấu (<b class="fw-bold text-danger">*</b>) là bắt buộc phải nhập,
                    tên tài khoản chỉ là duy nhất, và không thể sửa đổi sau này<br /><br />
                    Phần quyền hạn, đối tác sẽ không có đủ quyền can thiệp vào các phần quan trọng của trang admin, ví
                    dụ cài đặt, sửa thành viên v.v.v</div>
                <h5 class="modal-title"><span class="text-success"><em class="icon ni ni-user-add"></em></span>&ensp;Tạo
                    Thành Viên Mới</h5>
                <form id="TaoThanhVien" method="post" class="mt-4 is-alter form-validate">
                    <input type="hidden" name="TaoThanhVien" value="true">
                    <div class="row g-gs">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label" for="username">Tài Khoản (<b
                                        class="fw-bold text-danger">*</b>)</label>
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" data-msg="Không được bỏ trống tài khoản"
                                        name="username" placeholder="Tên tài khoản" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label" for="password">Mật Khẩu (<b
                                        class="fw-bold text-danger">*</b>)</label>
                                <div class="form-control-wrap">
                                    <input type="password" class="form-control" data-msg="Không được bỏ trống mật khẩu"
                                        name="password" placeholder="Mật khẩu" required autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label" for="access_key">Access Key (<b
                                        class="fw-bold text-danger">*</b>)</label>
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" data-msg="Không được bỏ trống access key"
                                        name="access_key" value="<?=WsRandomString::Key(36)?>" placeholder="Access Key"
                                        readonly>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Quyền Hạn (<b class="fw-bold text-danger">*</b>)</label>
                                <div class="form-control-wrap">
                                    <select class="form-select js-select2" name="quyenhan"
                                        data-msg="Không được bỏ trống quyền hạn"
                                        data-placeholder="--- CHỌN QUYỀN HẠN ---" required="">
                                        <option value="">--- CHỌN QUYỀN HẠN ---</option>
                                        <option value="members">Thành Viên</option>
                                        <option value="leader">Lãnh Đạo</option>
                                        <option value="admin">Quản Trị Viên</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                <li>
                                    <button type="submit" class="btn btn-primary"><em
                                            class="icon ni ni-check-circle"></em>&ensp;Tạo Ngay</button>
                                </li>
                                <li>
                                    <a href="#" data-bs-dismiss="modal" class="link link-light"
                                        data-bs-dismiss="modal">Huỷ Bỏ</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', () => {
    if ($.fn.DataTable.isDataTable('#usersTable')) {
        $('#usersTable').DataTable().destroy();
    }
    const dataTable = $('#usersTable').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        ajax: {
            url: '/api/admin/handler?action=userList',
            type: 'GET',
            data: function(d) {
                return {
                    page: Math.floor(d.start / d.length) + 1,
                    limit: d.length,
                    search: d.search.value
                };
            },
            dataFilter: function(data) {
                let json = JSON.parse(data);
                json.recordsTotal = json.data.pagination.total_users;
                json.recordsFiltered = json.data.pagination.total_users;
                json.data = json.data.users;
                return JSON.stringify(json);
            }
        },
        dom: '<"row justify-between g-2"<"col-7 col-sm-4 text-left"f><"col-5 col-sm-8 text-right"<"datatable-filter"<"d-flex justify-content-end g-2"l>>>><"datatable-wrap my-3"t><"row align-items-center"<"col-7 col-sm-12 col-md-9"p><"col-5 col-sm-12 col-md-3 text-end text-md-right"i>>',
        columns: [
            { 
                data: 'user_id',
                className: 'nk-tb-col'
            },
            { 
                data: null,
                className: 'nk-tb-col',
                render: function(data) {
                    const Username = window.THANHDIEU ? window.THANHDIEU(data.username) : data.username;
                    return `
                        <div class="user-card">
                            <div class="user-avatar" style="background-color:${data.avatar}">
                                <span>${Username.charAt(0).toUpperCase()}</span>
                            </div>
                            <div class="user-info">
                                <span class="tb-lead text-white">
                                    ${data.email}
                                </span>
                                <span class="sub-text fs-12px">@${Username}</span>
                            </div>
                        </div>`;
                }
            },
            { 
                data: 'sodu',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="tb-amount text-muted">${window.FormatNumber ? window.FormatNumber.TD(data) : data} <span class="currency">VNĐ</span></span>`;
                }
            },
            { 
                data: 'tongnap',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="tb-amount text-muted">${ window.FormatNumber ? window.FormatNumber.TD(data) : data} <span class="currency">VNĐ</span></span>`;
                }
            },
            { 
                data: 'plans',
                className: 'nk-tb-col',
                render: function(data) {
                    return data 
                        ? `<b class="text-success fs-12px"><em class="icon text-success ni ni-check-circle"></em>&ensp;${data.toUpperCase()}</b>`
                        : `<b class="text-danger fs-12px"><em class="icon text-danger ni ni-cross-circle"></em>&ensp;Free</b>`;
                }
            },
            { 
                data: 'ngaythamgia',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="text-muted">${window.FormatTime ? window.FormatTime.TD(data) : data}</span>`;
                }
            },
            { 
                data: 'rank',
                className: 'nk-tb-col',
                render: function(data) {
                    return getRank(data);
                }
            },
            { 
                data: 'oauth_type',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="badge rounded-pill ${data.toLowerCase() === 'google' ? 'bg-warning' : 'bg-primary'}">
                        ${data.charAt(0).toUpperCase() + data.slice(1)}
                </span>`;
                }
            },
            { 
                data: 'banned',
                className: 'nk-tb-col',
                render: function(data) {
                    return data == 0 
                        ? '<span class="badge tb-status badge-dim bg-success">Hoạt Động</span>'
                        : '<span class="badge tb-status badge-dim bg-danger">Đình Chỉ</span>';
                }
            },
            { 
                data: null,
                className: 'nk-tb-col nk-tb-col-tools',
                orderable: false,
                render: function(data) {
                    return `
                        <ul class="nk-tb-actions gx-1">
                            <li>
                                <div class="drodown">
                                    <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-bs-toggle="dropdown">
                                        <em class="icon ni ni-more-h"></em>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <ul class="link-list-opt no-bdr">
                                            <li><a href="edit/${data.user_id}"><em class="icon ni ni-edit"></em><span>Sửa Tài Khoản</span></a></li>
                                            <li class="divider"></li>
                                            <li>
                                                <a href="#" id="banned-users-${data.user_id}" class="banned-users" data-user-id="${data.user_id}">
                                                    <em class="icon ni ni-na"></em>
                                                    <span>${data.banned == 0 ? 'Khoá Tài Khoản' : 'Mở Khoá Tài Khoản'}</span>
                                                </a>
                                            </li>
                                            <li class="divider"></li>
                                            <li>
                                                <a href="#" class="delete-account" data-username="${data.username}">
                                                    <em class="icon ni ni-trash-alt"></em>
                                                    <span>Xoá Tài Khoản</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </li>
                        </ul>`;
                }
            }
        ],
        language: {
            search: "",
            searchPlaceholder: "Tìm kiếm thành viên...",
            lengthMenu: "Hiện&ensp;_MENU_&ensp;bản ghi",
            info: "Hiển thị _START_ đến _END_ của _TOTAL_ bản ghi",
            infoEmpty: "Hiển thị 0 đến 0 của 0 bản ghi",
            infoFiltered: "(được lọc từ _MAX_ bản ghi)",
            paginate: {
                first: "Tiếp theo",
                previous: "Trước đó",
                next: "Tiếp theo",
                last: "Trước đó"
            },
            loadingRecords: "Chưa có dữ liệu",
            emptyTable: "Không tìm thấy kết quả",
            zeroRecords: "Không tìm thấy kết quả"
        },
        pageLength: 10,
        ordering: true,
        order: [[0, 'desc']]
    });

    let searchTimeout;
    $('.dataTables_filter input').off('keyup.DT input.DT');
    $('.dataTables_filter input').on('keyup', function() {
        clearTimeout(searchTimeout);
        const $this = $(this);
        searchTimeout = setTimeout(() => {
            $('.td-loader').show();
            dataTable.search($this.val()).draw();
        }, 400);
    });
    $('#usersTable').on('preXhr.dt', function(e, settings, data) {
        if (!$(document.activeElement).hasClass('dataTables_filter')) {
            $('.td-loader').show();
        }
    }).on('xhr.dt', function() {
        $('.td-loader').hide();
    });

    function getRank(rank) {
        switch(rank) {
            case 'admin':
                return '<span class="badge rounded-pill bg-primary">Quản Trị Viên</span>';
            case 'leader':
                return '<span class="badge rounded-pill bg-info">Lãnh Đạo</span>';
            default:
                return '<span class="badge rounded-pill bg-secondary">Thành Viên</span>';
        }
    }
});
</script>
<?php include 'partials/foot.php'; ?>