<?php require_once('partials/head.php');?>
<?php require_once('partials/nav.php');?>
<div class="check-rotate-support"></div>
<div class="nk-content">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-sm">
                    <div class="nk-block-between">
                        <div class="nk-block-head-content">
                            <h3 class="nk-block-title page-title">Lịch Sử Mua Gói</h3>
                            <div class="nk-block-des text-soft">
                                <p>+ Hiện có <?=$totals->Plans()?> gói chưa hết hạn sử dụng.</p>
                            </div>
                        </div>
                        <div class="toggle-wrap nk-block-tools-toggle">
                            <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1" data-target="pageMenu">
                                <em class="icon ni ni-more-v"></em>
                            </a>
                            <div class="toggle-expand-content" data-content="pageMenu">
                                <ul class="nk-block-tools g-3">
                                    <li class="nk-block-tools-opt">
                                        <a data-bs-toggle="modal" href="#add-all-expirad" class="btn btn-primary add-all-expirad">
                                            <em class="icon ni ni-plus"></em>
                                            <span>Cộng All HSD</span>
                                        </a>
                                    </li>
                                    <li class="nk-block-tools-opt">
                                        <a href="#truncate-all-history-plan" class="btn btn-danger truncate-history-plans">
                                            <em class="icon ni ni-trash"></em>
                                            <span>Xoá All Gói</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="nk-block">
                    <div class="card">
                        <div class="card-inner-group">
                            <div class="card-inner p-4">
                                <table class="nk-tb-list nk-tb-ulist" data-auto-responsive="true" id="planTable">
                                    <thead>
                                        <tr class="nk-tb-item nk-tb-head text-nowrap">
                                            <th class="nk-tb-col sorting">
                                                <span class="sub-text">ID</span>
                                            </th>
                                            <th class="nk-tb-col sorting">
                                                <span class="sub-text">Tài Khoản</span>
                                            </th>
                                            <th class="nk-tb-col tb-col-md sorting">
                                                <span class="sub-text">Tên Gói</span>
                                            </th>
                                            <th class="nk-tb-col tb-col-lg sorting">
                                                <span class="sub-text">Giá Tiền</span>
                                            </th>
                                            <th class="nk-tb-col tb-col-md sorting">
                                                <span class="sub-text">Ngày Mua</span>
                                            </th>
                                            <th class="nk-tb-col tb-col-md sorting">
                                                <span class="sub-text">Ngày Hết Hạn</span>
                                            </th>
                                            <th class="nk-tb-col tb-col-md sorting">
                                                <span class="sub-text">Trạng Thái</span>
                                            </th>
                                            <th class="nk-tb-col tb-col-md sorting">
                                                <span class="sub-text">Thao Tác</span>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="add-all-expirad">
    <div class="modal-dialog modal-dialog-center" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cộng Thêm Hạn Sử Dụng</h5>
                <a href="#close" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross-sm"></em>
                </a>
            </div>
            <div class="modal-body">
                <form class="form-validate is-alter set-expiration-all-plan">
                    <input type="hidden" name="action" value="set-expiration-all-plan">
                    <div class="form-group">
                        <div class="form-control-wrap">
                            <select class="form-select js-select2" data-search="off" name="hansudung" data-ui="clean">
                                <?php for ($i = 1; $i <= 20; $i++) { ?>
                                <option value='<?=$i?>'>Cộng thêm <?=$i?> ngày cho tất cả user vip</option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-sm btn-primary">
                            <em class="icon ni ni-check-circle-cut"></em>&nbsp;Cập Nhật
                        </button>
                    </div>
                </form>
            </div>
            <div class="modal-footer bg-light">
                <span class="sub-text">Made by <b>ThanhDieuTV</b></span>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    if ($.fn.DataTable.isDataTable('#planTable')) {
        $('#planTable').DataTable().destroy();
    }
    const dataTable = $('#planTable').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        ajax: {
            url: '/api/admin/handler?action=planList',
            type: 'GET',
            data: function(d) {
                return {
                    page: Math.floor(d.start / d.length) + 1,
                    limit: d.length,
                    search: d.search.value
                };
            },
            dataFilter: function(data) {
                let json = JSON.parse(data);
                json.recordsTotal = json.data.pagination.total_plans;
                json.recordsFiltered = json.data.pagination.total_plans;
                json.data = json.data.plans;
                return JSON.stringify(json);
            }
        },
        dom: '<"row justify-between g-2"<"col-7 col-sm-4 text-left"f><"col-5 col-sm-8 text-right"<"datatable-filter"<"d-flex justify-content-end g-2"l>>>><"datatable-wrap my-3"t><"row align-items-center"<"col-7 col-sm-12 col-md-9"p><"col-5 col-sm-12 col-md-3 text-end text-md-right"i>>',
        columns: [
            { 
                data: 'plans_id',
                className: 'nk-tb-col',
                render: function(data) {
                    return `#${data}`;
                }
            },
            { 
                data: null,
                className: 'nk-tb-col',
                render: function(data) {
                    const Username = window.THANHDIEU ? window.THANHDIEU(data.username) : data.username;
                    const avatarStyle = data.avatar.startsWith('#') ? 
                        `background-color: ${data.avatar}` : 
                        `background-image: url('/${data.avatar}')`;
                    
                    return `
                        <div class="user-card">
                            <div class="user-avatar" style="${avatarStyle}">
                                ${data.avatar.startsWith('#') ? Username.charAt(0).toUpperCase() : ''}
                            </div>
                            <div class="user-info">
                                <span class="tb-lead text-white">${Username}</span>
                                <span class="sub-text fs-12px">@${Username}</span>
                            </div>
                        </div>`;
                }
            },
            { 
                data: 'tengoi',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="badge badge-dim bg-primary">${data}</span>`;
                }
            },
            { 
                data: 'giatien',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="fs-12px badge badge-dim bg-info">${data}đ</span>`;
                }
            },
            { 
                data: 'ngaymua',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="fs-12px badge bg-secondary">${data}</span>`;
                }
            },
            { 
                data: 'ngayhethan',
                className: 'nk-tb-col',
                render: function(data) {
                    return `<span class="fs-12px badge bg-secondary">${data}</span>`;
                }
            },
            { 
                data: 'trangthai',
                className: 'nk-tb-col',
                render: function(data) {
                    const status = data == 1 ? 'Hoạt Động' : (data == 2 ? 'Tạm Khoá' : 'Đã Hết Hạn');
                    const bgClass = data == 1 ? 'bg-outline-success' : (data == 2 ? 'bg-outline-warning' : 'bg-outline-danger');
                    return `<span class="badge badge-dim rounded-pill tb-status ${bgClass}">${status}</span>`;
                }
            },
            { 
                data: null,
                className: 'nk-tb-col',
                render: function(data) {
                    let buttons = '';
                    if (data.trangthai !== 0) {
                        const lockClass = data.trangthai == 1 ? 'bg-warning' : 'bg-secondary';
                        const lockIcon = data.trangthai == 1 ? 'lock-2-line' : 'lock-unlock-line';
                        const lockText = data.trangthai == 1 ? 'Khoá' : 'Mở Khoá';
                        
                        buttons += `<a href="#" data-plan-id="${data.plans_id}" class="fs-12px badge banned-plan ${lockClass}">
                            <i class="ri-${lockIcon} me-1"></i>${lockText}
                        </a>&ensp;`;
                    }
                    buttons += `<a href="#" data-plan-id="${data.plans_id}" class="fs-12px badge bg-danger delete-plan">
                        <i class="ri-close-line me-1"></i>Xoá
                    </a>`;
                    return buttons;
                }
            }
        ],
        language: {
            search: "",
            searchPlaceholder: "Tìm kiếm gói...",
            lengthMenu: "Hiện&ensp;_MENU_&ensp;bản ghi",
            info: "Hiển thị _START_ đến _END_ của _TOTAL_ bản ghi",
            infoEmpty: "Hiển thị 0 đến 0 của 0 bản ghi",
            infoFiltered: "(được lọc từ _MAX_ bản ghi)",
            paginate: {
                first: "Tiếp theo",
                previous: "Trước đó",
                next: "Tiếp theo",
                last: "Trước đó"
            },
            loadingRecords: "Chưa có dữ liệu",
            processing: '<div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div>',
            emptyTable: "Không tìm thấy kết quả",
            zeroRecords: "Không tìm thấy kết quả"
        },
        pageLength: 10,
        ordering: true,
        order: [[4, 'desc']]
    });
    let searchTimeout;
    $('.dataTables_filter input').off('keyup.DT input.DT');
    $('.dataTables_filter input').on('keyup', function() {
        clearTimeout(searchTimeout);
        const $this = $(this);
        searchTimeout = setTimeout(() => {
            $('.td-loader').show();
            dataTable.search($this.val()).draw();
        }, 400);
    });
    $('#planTable').on('preXhr.dt', function(e, settings, data) {
        if (!$(document.activeElement).hasClass('dataTables_filter')) {
            $('.td-loader').show();
        }
    }).on('xhr.dt', function() {
        $('.td-loader').hide();
    });
    function initializeHandlers() {
        $('.banned-plan').click(function(e) {
            e.preventDefault();
            // const planId = $(this).data('plan-id');
        });
        $('.delete-plan').click(function(e) {
            e.preventDefault();
            // const planId = $(this).data('plan-id');
        });
    }
    initializeHandlers();
    dataTable.on('draw', initializeHandlers);
});
</script>

<?php require_once('partials/foot.php'); ?>